/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Claims;
import com.vmware.xenon.common.ColorLogFormatter;
import com.vmware.xenon.common.CommandLineArgumentParser;
import com.vmware.xenon.common.FactoryService;
import com.vmware.xenon.common.FileUtils;
import com.vmware.xenon.common.LogFormatter;
import com.vmware.xenon.common.NodeSelectorService;
import com.vmware.xenon.common.NodeSelectorState;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.ReflectionUtils;
import com.vmware.xenon.common.RequestRouter;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceClient;
import com.vmware.xenon.common.ServiceConfigUpdateRequest;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.ServiceDocumentQueryResult;
import com.vmware.xenon.common.ServiceErrorResponse;
import com.vmware.xenon.common.ServiceHostMaintenanceTracker;
import com.vmware.xenon.common.ServiceMaintenanceRequest;
import com.vmware.xenon.common.ServiceRequestListener;
import com.vmware.xenon.common.ServiceRequestSender;
import com.vmware.xenon.common.ServiceStats;
import com.vmware.xenon.common.ServiceSubscriptionState;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.SystemHostInfo;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.WebSocketService;
import com.vmware.xenon.common.http.netty.NettyHttpListener;
import com.vmware.xenon.common.http.netty.NettyHttpServiceClient;
import com.vmware.xenon.common.jwt.Signer;
import com.vmware.xenon.common.jwt.Verifier;
import com.vmware.xenon.services.common.AuthCredentialsFactoryService;
import com.vmware.xenon.services.common.AuthorizationContextService;
import com.vmware.xenon.services.common.ConsistentHashingNodeSelectorService;
import com.vmware.xenon.services.common.FileContentService;
import com.vmware.xenon.services.common.GuestUserService;
import com.vmware.xenon.services.common.LuceneBlobIndexService;
import com.vmware.xenon.services.common.LuceneDocumentIndexService;
import com.vmware.xenon.services.common.LuceneLocalQueryTaskFactoryService;
import com.vmware.xenon.services.common.LuceneQueryTaskFactoryService;
import com.vmware.xenon.services.common.NodeGroupFactoryService;
import com.vmware.xenon.services.common.NodeGroupService;
import com.vmware.xenon.services.common.NodeSelectorSynchronizationService;
import com.vmware.xenon.services.common.NodeState;
import com.vmware.xenon.services.common.ODataQueryService;
import com.vmware.xenon.services.common.OperationIndexService;
import com.vmware.xenon.services.common.ProcessFactoryService;
import com.vmware.xenon.services.common.QueryFilter;
import com.vmware.xenon.services.common.ReliableSubscriptionService;
import com.vmware.xenon.services.common.ResourceGroupFactoryService;
import com.vmware.xenon.services.common.RoleFactoryService;
import com.vmware.xenon.services.common.ServiceContextIndexService;
import com.vmware.xenon.services.common.ServiceHostLogService;
import com.vmware.xenon.services.common.ServiceHostManagementService;
import com.vmware.xenon.services.common.ServiceUriPaths;
import com.vmware.xenon.services.common.SystemUserService;
import com.vmware.xenon.services.common.TenantFactoryService;
import com.vmware.xenon.services.common.TransactionFactoryService;
import com.vmware.xenon.services.common.UpdateIndexRequest;
import com.vmware.xenon.services.common.UserFactoryService;
import com.vmware.xenon.services.common.UserGroupFactoryService;
import com.vmware.xenon.services.common.authn.BasicAuthenticationService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class ServiceHost
implements ServiceRequestSender {
    public static final String UI_DIRECTORY_NAME = "ui";
    private static final LogFormatter LOG_FORMATTER = new LogFormatter();
    private static final LogFormatter COLOR_LOG_FORMATTER = new ColorLogFormatter();
    public static final String SERVICE_HOST_STATE_FILE = "serviceHostState.json";
    public static final Double DEFAULT_PCT_MEMORY_LIMIT = 0.49;
    public static final Double DEFAULT_PCT_MEMORY_LIMIT_DOCUMENT_INDEX = 0.3;
    public static final Double DEFAULT_PCT_MEMORY_LIMIT_BLOB_INDEX = 0.1;
    public static final Double DEFAULT_PCT_MEMORY_LIMIT_SERVICE_CONTEXT_INDEX = 0.1;
    public static final String LOCAL_HOST = "127.0.0.1";
    public static final String LOOPBACK_ADDRESS = "127.0.0.1";
    public static final String DEFAULT_BIND_ADDRESS = "127.0.0.1";
    public static final int PORT_VALUE_HTTP_DEFAULT = 8000;
    public static final int PORT_VALUE_LISTENER_DISABLED = -1;
    public static final int DEFAULT_PORT = 8000;
    public static final String ALL_INTERFACES = "0.0.0.0";
    public static final String ROOT_PATH = "";
    public static final String SERVICE_URI_SUFFIX_STATS = "/stats";
    public static final String SERVICE_URI_SUFFIX_SUBSCRIPTIONS = "/subscriptions";
    public static final String SERVICE_URI_SUFFIX_AVAILABLE = "/available";
    public static final String SERVICE_URI_SUFFIX_CONFIG = "/config";
    public static final String SERVICE_URI_SUFFIX_TEMPLATE = "/template";
    public static final String SERVICE_URI_SUFFIX_UI = "/ui";
    public static final String SERVICE_URI_SUFFIX_REPLICATION = "/replication";
    public static final String DCP_ENVIRONMENT_VAR_PREFIX = "XENON_";
    public static final String GIT_COMMIT_PROPERTIES_RESOURCE_NAME = "xenon.git.properties";
    public static final String GIT_COMMIT_SOURCE_PROPERTY_PREFIX = "git.commit";
    public static final String GIT_COMMIT_SOURCE_PROPERTY_COMMIT_ID = "git.commit.id";
    public static final String GIT_COMMIT_SOURCE_PROPERTY_COMMIT_TIME = "git.commit.time";
    public static final String[] RESERVED_SERVICE_URI_PATHS = new String[]{"/available", "/replication", "/stats", "/subscriptions", "/ui", "/config", "/template"};
    static final Path DEFAULT_TMPDIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    static final Path DEFAULT_SANDBOX = DEFAULT_TMPDIR.resolve("xenon");
    static final Path DEFAULT_RESOURCE_SANDBOX_DIR = Paths.get("resources", new String[0]);
    public static final int DEFAULT_SERVICE_STATE_COST_BYTES = 4096;
    public static final int DEFAULT_SERVICE_INSTANCE_COST_BYTES = 4096;
    private static final long ONE_MINUTE_IN_MICROS = TimeUnit.MINUTES.toMicros(1L);
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private FileHandler handler;
    private Map<String, Operation.AuthorizationContext> authorizationContextCache = new ConcurrentHashMap<String, Operation.AuthorizationContext>();
    private final Map<String, ServiceDocumentDescription> descriptionCache = new HashMap<String, ServiceDocumentDescription>();
    private final ServiceDocumentDescription.Builder descriptionBuilder = ServiceDocumentDescription.Builder.create();
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private final ConcurrentSkipListMap<String, Service> attachedServices = new ConcurrentSkipListMap();
    private final ConcurrentSkipListMap<String, Service> attachedNamespaceServices = new ConcurrentSkipListMap();
    private final ConcurrentSkipListSet<String> coreServices = new ConcurrentSkipListSet();
    private ConcurrentSkipListMap<String, Class<? extends Service>> privilegedServiceTypes = new ConcurrentSkipListMap();
    private final ConcurrentSkipListMap<String, Long> synchronizationTimes = new ConcurrentSkipListMap();
    private final ConcurrentSkipListMap<String, Long> synchronizationRequiredServices = new ConcurrentSkipListMap();
    private final ConcurrentSkipListMap<String, Long> synchronizationActiveServices = new ConcurrentSkipListMap();
    private final ConcurrentSkipListMap<String, NodeGroupService.NodeGroupState> pendingNodeSelectorsForFactorySynch = new ConcurrentSkipListMap();
    private final SortedSet<Operation> pendingStartOperations = ServiceHost.createOperationSet();
    private final Map<String, SortedSet<Operation>> pendingServiceAvailableCompletions = new ConcurrentSkipListMap<String, SortedSet<Operation>>();
    private final SortedSet<Operation> pendingOperationsForRetry = ServiceHost.createOperationSet();
    private ServiceHostState state;
    private Service documentIndexService;
    private Service authorizationService;
    private Service transactionService;
    private SystemHostInfo info = new SystemHostInfo();
    private ServiceClient client;
    private ServiceRequestListener httpListener;
    private ServiceRequestListener httpsListener;
    private URI documentIndexServiceUri;
    private URI authorizationServiceUri;
    private URI transactionServiceUri;
    private ScheduledFuture<?> maintenanceTask;
    private final ConcurrentSkipListMap<String, ServiceDocument> cachedServiceStates = new ConcurrentSkipListMap();
    private ConcurrentSkipListSet<String> serviceFactoriesUnderMemoryPressure = new ConcurrentSkipListSet();
    private ConcurrentSkipListMap<String, Service> pendingPauseServices = new ConcurrentSkipListMap();
    private final ServiceHostMaintenanceTracker maintenanceHelper = ServiceHostMaintenanceTracker.create(this);
    private String logPrefix;
    private URI cachedUri;
    private Signer tokenSigner;
    private Verifier tokenVerifier;
    private Operation.AuthorizationContext systemAuthorizationContext;
    private Operation.AuthorizationContext guestAuthorizationContext;

    private static ConcurrentSkipListSet<Operation> createOperationSet() {
        return new ConcurrentSkipListSet<Operation>(new Comparator<Operation>(){

            @Override
            public int compare(Operation o1, Operation o2) {
                return Long.compare(o1.getExpirationMicrosUtc(), o2.getExpirationMicrosUtc());
            }
        });
    }

    public static int findListenPort() {
        int port = 0;
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            socket.setReuseAddress(true);
            port = socket.getLocalPort();
            Logger.getAnonymousLogger().info("port candidate:" + port);
        }
        catch (Throwable e) {
            Logger.getAnonymousLogger().severe(e.toString());
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {}
        }
        return port;
    }

    protected ServiceHost() {
        this.state = new ServiceHostState();
        this.state.id = UUID.randomUUID().toString();
    }

    public ServiceHost initialize(String[] args) throws Throwable {
        Arguments hostArgs = new Arguments();
        this.initialize(args, hostArgs);
        return this;
    }

    protected ServiceHost initialize(String[] args, Arguments hostArgs) throws Throwable {
        CommandLineArgumentParser.parse(hostArgs, args);
        CommandLineArgumentParser.parse(COLOR_LOG_FORMATTER, args);
        this.initialize(hostArgs);
        this.setProcessOwner(true);
        return this;
    }

    public ServiceHost initialize(Arguments args) throws Throwable {
        URI u;
        this.setSystemProperties();
        Path sandbox = args.sandbox.resolve(Integer.toString(args.port));
        URI storageSandbox = sandbox.toFile().toURI();
        if (!Files.exists(sandbox, new LinkOption[0])) {
            Files.createDirectories(sandbox, new FileAttribute[0]);
        }
        if (args.publicUri != null && (!(u = new URI(args.publicUri)).isAbsolute() || u.getHost() == null || u.getHost().isEmpty())) {
            throw new IllegalArgumentException("publicUri should be a non empty absolute URI");
        }
        if (args.bindAddress != null && args.bindAddress.equals(ROOT_PATH)) {
            throw new IllegalArgumentException("bindAddress should be a non empty valid IP address");
        }
        if (args.port < 0) {
            throw new IllegalArgumentException("port: negative values not allowed");
        }
        if (this.state == null) {
            throw new IllegalStateException();
        }
        File s = new File(storageSandbox);
        if (!s.exists()) {
            throw new IllegalArgumentException("storageSandbox directory does not exist: " + storageSandbox);
        }
        this.state.storageSandboxFileReference = storageSandbox;
        this.loadState(storageSandbox, s);
        this.initializeStateFromArguments(s, args);
        LuceneDocumentIndexService documentIndexService = new LuceneDocumentIndexService();
        this.setDocumentIndexingService(documentIndexService);
        this.state.codeProperties = FileUtils.readPropertiesFromResource(this.getClass(), GIT_COMMIT_PROPERTIES_RESOURCE_NAME);
        this.updateSystemInfo(false);
        this.tokenSigner = new Signer("dcp-secret".getBytes("UTF-8"));
        this.tokenVerifier = new Verifier("dcp-secret".getBytes("UTF-8"));
        if (this.getServiceMemoryLimitMB(ROOT_PATH, ServiceHostState.MemoryLimitType.EXACT) == null) {
            this.setServiceMemoryLimit(ROOT_PATH, DEFAULT_PCT_MEMORY_LIMIT);
        }
        if (this.getServiceMemoryLimitMB("/core/document-index", ServiceHostState.MemoryLimitType.EXACT) == null) {
            this.setServiceMemoryLimit("/core/document-index", DEFAULT_PCT_MEMORY_LIMIT_DOCUMENT_INDEX);
        }
        if (this.getServiceMemoryLimitMB(ServiceUriPaths.CORE_BLOB_INDEX, ServiceHostState.MemoryLimitType.EXACT) == null) {
            this.setServiceMemoryLimit(ServiceUriPaths.CORE_BLOB_INDEX, DEFAULT_PCT_MEMORY_LIMIT_BLOB_INDEX);
        }
        if (this.getServiceMemoryLimitMB("/core/service-context-index", ServiceHostState.MemoryLimitType.EXACT) == null) {
            this.setServiceMemoryLimit("/core/service-context-index", DEFAULT_PCT_MEMORY_LIMIT_SERVICE_CONTEXT_INDEX);
        }
        return this;
    }

    private void initializeStateFromArguments(File s, Arguments args) throws URISyntaxException {
        if (args.resourceSandbox != null) {
            File resDir = args.resourceSandbox.toFile();
            if (resDir.exists()) {
                this.state.resourceSandboxFileReference = resDir.toURI();
            } else {
                this.log(Level.WARNING, "Resource sandbox does not exist: %s", args.resourceSandbox);
            }
        }
        this.state.httpPort = args.port;
        this.state.httpsPort = args.securePort;
        this.state.sslClientAuthMode = args.sslClientAuthMode;
        if (args.keyFile != null) {
            this.state.privateKeyFileReference = args.keyFile.toUri();
            this.state.privateKeyPassphrase = args.keyPassphrase;
        }
        if (args.certificateFile != null) {
            this.state.certificateFileReference = args.certificateFile.toUri();
        }
        if (args.id != null) {
            this.state.id = args.id;
        }
        this.state.peerSynchronizationTimeLimitSeconds = args.perFactoryPeerSynchronizationLimitSeconds;
        this.state.isPeerSynchronizationEnabled = args.isPeerSynchronizationEnabled;
        this.state.isAuthorizationEnabled = args.isAuthorizationEnabled;
        File hostStateFile = new File(s, SERVICE_HOST_STATE_FILE);
        String errorFmt = hostStateFile.getPath() + " conflicts with command line argument %s. Argument: %s, in file: %s";
        String argumentName = "bindAddress";
        if (args.bindAddress != null && this.state.bindAddress != null && !args.bindAddress.equals(this.state.bindAddress)) {
            this.log(Level.WARNING, errorFmt, argumentName, args.bindAddress, this.state.bindAddress);
        }
        this.setBindAddress(args.bindAddress);
        if (args.publicUri != null) {
            this.setPublicUri(new URI(args.publicUri));
        }
        this.state.initialPeerNodes = args.peerNodes;
    }

    protected void configureLogging(File storageSandboxDir) throws IOException {
        String logConfigFile = System.getProperty("java.util.logging.config.file");
        String logConfigClass = System.getProperty("java.util.logging.config.class");
        if (logConfigFile == null && logConfigClass == null) {
            File logFile = new File(storageSandboxDir, this.getClass().getSimpleName() + "." + this.getPort() + ".%g.log");
            this.handler = new FileHandler(logFile.getAbsolutePath(), 0xA00000, 1);
            this.handler.setFormatter(LOG_FORMATTER);
            this.logger.getParent().addHandler(this.handler);
            String path = logFile.toString().replace("%g", "0");
            ServiceHostLogService.setProcessLogFile(path);
        }
        this.configureLoggerFormatter(this.logger);
        this.logPrefix = this.getClass().getSimpleName() + ":" + this.getPort();
    }

    protected void configureLoggerFormatter(Logger logger) {
        for (Handler h : logger.getParent().getHandlers()) {
            if (h instanceof ConsoleHandler) {
                h.setFormatter(COLOR_LOG_FORMATTER);
                continue;
            }
            h.setFormatter(LOG_FORMATTER);
        }
    }

    protected void removeLogging() {
        if (this.handler != null) {
            this.logger.getParent().removeHandler(this.handler);
            this.handler.close();
            this.handler = null;
        }
    }

    private void loadState(URI storageSandbox, File s) throws IOException, InterruptedException {
        File hostStateFile = new File(s, SERVICE_HOST_STATE_FILE);
        if (hostStateFile.exists()) {
            CountDownLatch l = new CountDownLatch(1);
            FileUtils.readFileAndComplete(Operation.createGet(null).setCompletion((o, e) -> {
                if (e != null) {
                    this.log(Level.WARNING, "Failure loading state from %s: %s", hostStateFile, Utils.toString(e));
                    l.countDown();
                    return;
                }
                try {
                    ServiceHostState fileState = o.getBody(ServiceHostState.class);
                    if (fileState.id == null) {
                        this.log(Level.WARNING, "Invalid state from %s: %s", hostStateFile, Utils.toJsonHtml(fileState));
                        l.countDown();
                        return;
                    }
                    fileState.isStarted = this.state.isStarted;
                    fileState.isStopping = this.state.isStopping;
                    if (fileState.maintenanceIntervalMicros < Service.MIN_MAINTENANCE_INTERVAL_MICROS) {
                        fileState.maintenanceIntervalMicros = Service.MIN_MAINTENANCE_INTERVAL_MICROS;
                    }
                    this.state = fileState;
                    l.countDown();
                }
                catch (Throwable ex) {
                    this.log(Level.WARNING, "Invalid state from %s: %s", hostStateFile, Utils.toJsonHtml(o.getBodyRaw()));
                    l.countDown();
                    return;
                }
            }), hostStateFile);
            l.await();
        }
    }

    private void saveState() throws IOException, InterruptedException {
        this.saveState(new File(this.state.storageSandboxFileReference));
    }

    private void saveState(File sandboxDir) throws IOException, InterruptedException {
        File hostStateFile = new File(sandboxDir, SERVICE_HOST_STATE_FILE);
        this.state.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
        byte[] serializedState = Utils.toJsonHtml(this.state).getBytes("UTF-8");
        Files.write(hostStateFile.toPath(), serializedState, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public String toString() {
        return String.format("[%n isStarted: %s%n httpPort: %d%n httpsPort: %d%n id: %s%n attached services: %d%n]", this.isStarted(), this.state.httpPort, this.state.httpsPort, this.state.id, this.attachedServices.size());
    }

    public boolean isStarted() {
        return this.state.isStarted;
    }

    public boolean isStopping() {
        return this.state.isStopping;
    }

    public boolean isServiceStateCaching() {
        return this.state.isServiceStateCaching;
    }

    public ServiceHost setServiceStateCaching(boolean enable) {
        this.state.isServiceStateCaching = enable;
        return this;
    }

    public int getPort() {
        return this.state.httpPort;
    }

    public ServiceHost setPort(int port) {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        this.state.httpPort = port;
        if (this.httpListener != null) {
            try {
                this.httpListener.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.httpListener = null;
        }
        return this;
    }

    public boolean isAuthorizationEnabled() {
        return this.state.isAuthorizationEnabled;
    }

    public void setAuthorizationEnabled(boolean isAuthorizationEnabled) {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        this.state.isAuthorizationEnabled = isAuthorizationEnabled;
    }

    public boolean isPeerSynchronizationEnabled() {
        return this.state.isPeerSynchronizationEnabled;
    }

    public void setPeerSynchronizationEnabled(boolean enabled) {
        this.state.isPeerSynchronizationEnabled = enabled;
    }

    public int getPeerSynchronizationTimeLimitSeconds() {
        return this.state.peerSynchronizationTimeLimitSeconds;
    }

    public void setPeerSynchronizationTimeLimitSeconds(int seconds) {
        this.state.peerSynchronizationTimeLimitSeconds = seconds;
    }

    public int getSecurePort() {
        return this.state.httpsPort;
    }

    public ServiceHost setSecurePort(int port) {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        this.state.httpsPort = port;
        if (this.httpsListener != null) {
            try {
                this.httpsListener.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.httpsListener = null;
        }
        return this;
    }

    public ServiceHost setPrivateKeyFileReference(URI fileReference) {
        this.state.privateKeyFileReference = fileReference;
        return this;
    }

    public ServiceHost setPrivateKeyPassphrase(String privateKeyPassphrase) {
        this.state.privateKeyPassphrase = privateKeyPassphrase;
        return this;
    }

    public ServiceHost setCertificateFileReference(URI fileReference) {
        this.state.certificateFileReference = fileReference;
        return this;
    }

    public ServiceHost setBindAddress(String address) {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started");
        }
        if (address == null) {
            throw new IllegalArgumentException("address is required");
        }
        this.state.bindAddress = address;
        if (this.info.ipAddresses.isEmpty() || !this.info.ipAddresses.get(0).equals(address)) {
            this.info.ipAddresses.clear();
            this.getSystemInfo();
        }
        this.clearUriAndLogPrefix();
        return this;
    }

    public ServiceHost setPublicUri(URI publicUri) {
        this.state.publicUri = publicUri;
        this.clearUriAndLogPrefix();
        return this;
    }

    public URI getStorageSandbox() {
        return this.state.storageSandboxFileReference;
    }

    public ServiceHost setMaintenanceIntervalMicros(long micros) {
        if (micros <= 0L) {
            throw new IllegalArgumentException("micros: zero or negative value not allowed");
        }
        if (micros < Service.MIN_MAINTENANCE_INTERVAL_MICROS) {
            this.log(Level.WARNING, "Maintenance interval %d is less than the minimum interval %d, reducing to min interval", micros, Service.MIN_MAINTENANCE_INTERVAL_MICROS);
            micros = Service.MIN_MAINTENANCE_INTERVAL_MICROS;
        }
        for (Service s : this.attachedServices.values()) {
            if (s.getProcessingStage() == Service.ProcessingStage.STOPPED || s.getMaintenanceIntervalMicros() == 0L || s.getMaintenanceIntervalMicros() >= micros) continue;
            String error = String.format("Service %s has a small maintenance interval %d than new interval %d", s.getSelfLink(), s.getMaintenanceIntervalMicros(), micros);
            this.log(Level.WARNING, error, new Object[0]);
        }
        this.state.maintenanceIntervalMicros = micros;
        ScheduledFuture<?> task = this.maintenanceTask;
        if (task == null) {
            return this;
        }
        task.cancel(true);
        this.scheduleMaintenance();
        return this;
    }

    public String getId() {
        return this.state.id;
    }

    public long getOperationTimeoutMicros() {
        return this.state.operationTimeoutMicros;
    }

    public ServiceHostState getState() {
        ServiceHostState s = Utils.clone(this.state);
        s.systemInfo = this.getSystemInfo();
        return s;
    }

    public URI getDocumentIndexServiceUri() {
        if (this.documentIndexService == null) {
            return null;
        }
        if (this.documentIndexServiceUri != null) {
            return this.documentIndexServiceUri;
        }
        this.documentIndexServiceUri = this.documentIndexService.getUri();
        return this.documentIndexServiceUri;
    }

    public URI getAuthorizationServiceUri() {
        if (this.authorizationService == null) {
            return null;
        }
        if (this.authorizationServiceUri != null) {
            return this.authorizationServiceUri;
        }
        this.authorizationServiceUri = this.authorizationService.getUri();
        return this.authorizationServiceUri;
    }

    public URI getTransactionServiceUri() {
        if (this.transactionService == null) {
            return null;
        }
        if (this.transactionServiceUri != null) {
            return this.transactionServiceUri;
        }
        this.transactionServiceUri = this.transactionService.getUri();
        return this.transactionServiceUri;
    }

    public ServiceHost setDocumentIndexingService(Service service) {
        if (this.state.isStarted) {
            throw new IllegalStateException("Host is started");
        }
        this.documentIndexService = service;
        return this;
    }

    public ServiceHost setAuthorizationService(Service service) {
        if (this.state.isStarted) {
            throw new IllegalStateException("Host is started");
        }
        this.authorizationService = service;
        return this;
    }

    public ServiceHost setTransactionService(Service service) {
        this.transactionService = service;
        return this;
    }

    protected ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    protected ExecutorService getExecutor() {
        return this.executor;
    }

    public ExecutorService allocateExecutor(Service s) {
        return this.allocateExecutor(s, Utils.DEFAULT_THREAD_COUNT);
    }

    public ExecutorService allocateExecutor(final Service s, int threadCount) {
        return Executors.newFixedThreadPool(threadCount, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, s.getUri() + "/" + Utils.getNowMicrosUtc());
            }
        });
    }

    public ServiceHost start() throws Throwable {
        return this.startImpl();
    }

    private void setSystemProperties() throws Throwable {
        Properties props = System.getProperties();
        String preferIPv4 = "java.net.preferIPv4Stack";
        if (props.getProperty("java.net.preferIPv4Stack") == null) {
            props.setProperty("java.net.preferIPv4Stack", "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceHost startImpl() throws Throwable {
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            if (this.isStarted()) {
                return this;
            }
            this.state.isStarted = true;
            this.state.isStopping = false;
        }
        if (this.isAuthorizationEnabled() && this.authorizationService == null) {
            this.authorizationService = new AuthorizationContextService();
        }
        this.executor = Executors.newWorkStealingPool(Utils.DEFAULT_THREAD_COUNT);
        this.scheduledExecutor = Executors.newScheduledThreadPool(Utils.DEFAULT_THREAD_COUNT, r -> new Thread(r, this.getUri().toString() + "/scheduled/" + this.state.id));
        if (this.getPort() != -1) {
            if (this.httpListener == null) {
                this.httpListener = new NettyHttpListener(this);
            }
            this.httpListener.start(this.getPort(), this.state.bindAddress);
        }
        if ((this.state.certificateFileReference != null || this.state.privateKeyFileReference != null) && this.httpsListener == null) {
            this.httpsListener = new NettyHttpListener(this);
        }
        if (this.httpsListener != null) {
            if (!this.httpsListener.isSSLConfigured()) {
                this.httpsListener.setSSLContextFiles(this.state.certificateFileReference, this.state.privateKeyFileReference, this.state.privateKeyPassphrase);
            }
            this.httpsListener.start(this.getSecurePort(), this.state.bindAddress);
        }
        if (this.state.httpPort == 0) {
            this.state.httpPort = this.httpListener.getPort();
        }
        if (this.state.httpsPort == 0 && this.httpsListener != null) {
            this.state.httpsPort = this.httpsListener.getPort();
        }
        this.saveState();
        this.documentIndexServiceUri = UriUtils.updateUriPort(this.documentIndexServiceUri, this.state.httpPort);
        this.authorizationServiceUri = UriUtils.updateUriPort(this.authorizationServiceUri, this.state.httpPort);
        this.transactionServiceUri = UriUtils.updateUriPort(this.transactionServiceUri, this.state.httpPort);
        this.configureLogging(new File(this.getStorageSandbox()));
        String commitID = (String)this.state.codeProperties.get(GIT_COMMIT_SOURCE_PROPERTY_COMMIT_ID);
        if (commitID == null) {
            throw new IllegalStateException("CommitID code property not found!");
        }
        commitID = commitID.substring(0, 8);
        String userAgent = ServiceHost.class.getSimpleName() + "/" + commitID;
        if (this.client == null) {
            this.client = NettyHttpServiceClient.create(userAgent, this.executor, this.scheduledExecutor, this);
            SSLContext clientContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            clientContext.init(null, trustManagerFactory.getTrustManagers(), null);
            this.client.setSSLContext(clientContext);
        }
        Operation.AuthorizationContext ctx = OperationContext.getAuthorizationContext();
        OperationContext.setAuthorizationContext(this.getSystemAuthorizationContext());
        this.client.start();
        OperationContext.setAuthorizationContext(ctx);
        this.scheduleMaintenance();
        this.clearUriAndLogPrefix();
        this.log(Level.INFO, "%s listening on %s", userAgent, this.getPublicUri());
        return this;
    }

    public void startDefaultCoreServicesSynchronously() throws Throwable {
        if (this.findService(ServiceHostManagementService.SELF_LINK) != null) {
            throw new IllegalStateException("Already started");
        }
        this.addPrivilegedService(ServiceHostManagementService.class);
        this.addPrivilegedService(OperationIndexService.class);
        this.addPrivilegedService(LuceneBlobIndexService.class);
        this.addPrivilegedService(BasicAuthenticationService.class);
        Operation.AuthorizationContext ctx = OperationContext.getAuthorizationContext();
        OperationContext.setAuthorizationContext(this.getSystemAuthorizationContext());
        if (this.authorizationService != null) {
            this.addPrivilegedService(this.authorizationService.getClass());
            this.startCoreServicesSynchronously(this.authorizationService);
        }
        List<URI> peers = this.getInitialPeerHosts();
        this.startDefaultReplicationAndNodeGroupServices();
        ArrayList<Service> coreServices = new ArrayList<Service>();
        coreServices.add(new ServiceHostManagementService());
        coreServices.add(new ProcessFactoryService());
        coreServices.add(new ServiceContextIndexService());
        coreServices.add(new LuceneBlobIndexService());
        coreServices.add(new ODataQueryService());
        if (this.documentIndexService != null) {
            this.addPrivilegedService(this.documentIndexService.getClass());
            coreServices.add(this.documentIndexService);
            if (this.documentIndexService instanceof LuceneDocumentIndexService) {
                coreServices.add(new LuceneQueryTaskFactoryService());
                coreServices.add(new LuceneLocalQueryTaskFactoryService());
            }
        }
        coreServices.add(new AuthCredentialsFactoryService());
        coreServices.add(new UserGroupFactoryService());
        coreServices.add(new ResourceGroupFactoryService());
        coreServices.add(new RoleFactoryService());
        coreServices.add(new UserFactoryService());
        coreServices.add(new SystemUserService());
        coreServices.add(new GuestUserService());
        coreServices.add(new TenantFactoryService());
        coreServices.add(new BasicAuthenticationService());
        TransactionFactoryService transactionFactoryService = new TransactionFactoryService();
        coreServices.add(transactionFactoryService);
        Service[] coreServiceArray = new Service[coreServices.size()];
        coreServices.toArray(coreServiceArray);
        this.startCoreServicesSynchronously(coreServiceArray);
        this.transactionService = transactionFactoryService;
        this.startService(Operation.createPost(UriUtils.buildUri(this, "/core/management/process-log")), new ServiceHostLogService(ServiceHostLogService.getDefaultProcessLogName()));
        this.startService(Operation.createPost(UriUtils.buildUri(this, "/core/management/go-dcp-process-log")), new ServiceHostLogService(ServiceHostLogService.getDefaultGoDcpProcessLogName()));
        this.startService(Operation.createPost(UriUtils.buildUri(this, "/core/management/system-log")), new ServiceHostLogService(ServiceHostLogService.DEFAULT_SYSTEM_LOG_NAME));
        WebSocketService webSocketService = new WebSocketService(null, null);
        webSocketService.setHost(this);
        this.startUiFileContentServices(webSocketService);
        OperationContext.setAuthorizationContext(ctx);
        this.schedule(() -> this.joinPeers(peers, "/core/node-groups/default"), this.state.maintenanceIntervalMicros, TimeUnit.MICROSECONDS);
    }

    public List<URI> getInitialPeerHosts() {
        return this.normalizePeerNodeList(this.state.initialPeerNodes);
    }

    public Path copyResourceToSandbox(URL url, Path resourcePath) throws URISyntaxException {
        File sandbox = new File(this.getStorageSandbox());
        Path outputPath = sandbox.toPath().resolve(DEFAULT_RESOURCE_SANDBOX_DIR).resolve(resourcePath);
        if (url.getProtocol().equals("file")) {
            this.log(Level.FINE, "Using resource %s", url.getPath());
            URI uri = url.toURI();
            return Paths.get(uri);
        }
        try {
            this.log(Level.FINE, "Copying resource %s to %s", url, outputPath);
            Path parent = outputPath.getParent();
            if (parent == null) {
                throw new IOException("No parent for output path: " + outputPath);
            }
            Files.createDirectories(parent, new FileAttribute[0]);
            InputStream is = url.openStream();
            Files.copy(is, outputPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.log(Level.WARNING, "Unable to copy resource %s to %s: %s", url, outputPath, e.toString());
            return null;
        }
        return outputPath;
    }

    private void startUiFileContentServices(Service s) throws Throwable {
        Map<Object, Object> pathToURIPath = new HashMap();
        ServiceDocumentDescription sdd = s.getDocumentTemplate().documentDescription;
        try {
            if (sdd != null && sdd.userInterfaceResourcePath != null) {
                String customPathResources = s.getDocumentTemplate().documentDescription.userInterfaceResourcePath;
                pathToURIPath = this.discoverUiResources(Paths.get(customPathResources, new String[0]), s, true);
            } else {
                Path baseResourcePath = Utils.getServiceUiResourcePath(s);
                pathToURIPath = this.discoverUiResources(baseResourcePath, s, false);
            }
        }
        catch (Throwable e) {
            this.log(Level.WARNING, "Error enumerating UI resources for %s: %s", s.getSelfLink(), Utils.toString(e));
        }
        if (pathToURIPath.isEmpty()) {
            this.log(Level.WARNING, "No custom UI resources found for %s", s.getClass().getName());
            return;
        }
        for (Map.Entry<Object, Object> e : pathToURIPath.entrySet()) {
            Operation post = Operation.createPost(UriUtils.buildUri(this, (String)e.getValue())).setAuthorizationContext(this.getSystemAuthorizationContext());
            FileContentService fcs = new FileContentService(((Path)e.getKey()).toFile());
            this.startService(post, fcs);
        }
    }

    private Map<Path, String> discoverUiResources(Path path, Service s, boolean hasCustomResources) throws Throwable {
        HashMap<Path, String> pathToURIPath = new HashMap<Path, String>();
        Path baseUriPath = !hasCustomResources ? Paths.get("/user-interface/resources", Utils.buildServicePath(s.getClass())) : Paths.get("/user-interface/resources", path.toString());
        String prefix = path.toString().replace('\\', '/');
        if (this.state.resourceSandboxFileReference != null) {
            this.discoverFileResources(s, pathToURIPath, baseUriPath, prefix);
        }
        if (pathToURIPath.isEmpty()) {
            this.discoverJarResources(path, s, pathToURIPath, baseUriPath, prefix);
        }
        return pathToURIPath;
    }

    private void discoverJarResources(Path path, Service s, Map<Path, String> pathToURIPath, Path baseUriPath, String prefix) throws URISyntaxException, IOException {
        for (FileUtils.ResourceEntry entry : FileUtils.findResources(s.getClass(), prefix)) {
            Path resourcePath = path.resolve(entry.suffix);
            Path uriPath = baseUriPath.resolve(entry.suffix);
            Path outputPath = this.copyResourceToSandbox(entry.url, resourcePath);
            if (outputPath == null) {
                s.toggleOption(Service.ServiceOption.HTML_USER_INTERFACE, false);
                continue;
            }
            pathToURIPath.put(outputPath, uriPath.toString().replace('\\', '/'));
        }
    }

    private void discoverFileResources(Service s, Map<Path, String> pathToURIPath, Path baseUriPath, String prefix) {
        File rootDir = new File(new File(this.state.resourceSandboxFileReference), prefix);
        if (!rootDir.exists()) {
            this.log(Level.INFO, "Resource directory not found: %s", rootDir.toString());
            return;
        }
        String basePath = baseUriPath.toString();
        String serviceName = s.getClass().getSimpleName();
        List<File> resources = FileUtils.findFiles(rootDir.toPath(), new HashSet<String>(), false);
        for (File f : resources) {
            String subPath = f.getAbsolutePath();
            subPath = subPath.substring(subPath.indexOf(serviceName));
            subPath = subPath.replace(serviceName, ROOT_PATH);
            Path uriPath = Paths.get(basePath, subPath);
            pathToURIPath.put(f.toPath(), uriPath.toString().replace('\\', '/'));
        }
        if (pathToURIPath.isEmpty()) {
            this.log(Level.INFO, "No resources found in directory: %s", rootDir.toString());
        }
    }

    private void startDefaultReplicationAndNodeGroupServices() throws Throwable {
        this.startCoreServicesSynchronously(new NodeGroupFactoryService());
        Throwable[] error = new Throwable[1];
        CountDownLatch c = new CountDownLatch(1);
        Operation.CompletionHandler comp = (o, e) -> {
            if (e != null) {
                error[0] = e;
                this.log(Level.SEVERE, "Node group failed start: %s:", e.toString());
                this.stop();
                c.countDown();
                return;
            }
            this.log(Level.FINE, "started %s", o.getUri().getPath());
            this.coreServices.add(o.getUri().getPath());
            c.countDown();
        };
        this.log(Level.FINE, "starting %s", "/core/node-groups/default");
        this.registerForServiceAvailability(comp, "/core/node-groups/default");
        Operation post = NodeGroupFactoryService.createNodeGroupPostOp(this, "default").setReferer(UriUtils.buildUri(this, ROOT_PATH));
        post.setAuthorizationContext(this.getSystemAuthorizationContext());
        this.sendRequest(post);
        if (!c.await(this.getState().operationTimeoutMicros, TimeUnit.MICROSECONDS)) {
            throw new TimeoutException();
        }
        if (error[0] != null) {
            throw error[0];
        }
        ArrayList<Operation> startNodeSelectorPosts = new ArrayList<Operation>();
        ArrayList<Service> nodeSelectorServices = new ArrayList<Service>();
        Operation startPost = Operation.createPost(UriUtils.buildUri(this, "/core/node-selectors/default"));
        startNodeSelectorPosts.add(startPost);
        nodeSelectorServices.add(new ConsistentHashingNodeSelectorService());
        startPost = Operation.createPost(UriUtils.buildUri(this, "/core/node-selectors/sha1-hash-3x"));
        NodeSelectorState initialState = new NodeSelectorState();
        initialState.nodeGroupLink = "/core/node-groups/default";
        initialState.replicationFactor = 3L;
        startPost.setBody(initialState);
        startNodeSelectorPosts.add(startPost);
        nodeSelectorServices.add(new ConsistentHashingNodeSelectorService());
        this.startCoreServicesSynchronously(startNodeSelectorPosts, nodeSelectorServices);
    }

    public void joinPeers(List<URI> peers, String nodeGroupUriPath) {
        if (peers == null) {
            return;
        }
        try {
            for (URI peerNodeBaseUri : peers) {
                URI localNodeGroupUri = UriUtils.buildUri(this, nodeGroupUriPath);
                NodeGroupService.JoinPeerRequest joinBody = NodeGroupService.JoinPeerRequest.create(UriUtils.extendUri(peerNodeBaseUri, nodeGroupUriPath), null);
                this.sendJoinPeerRequest(joinBody, localNodeGroupUri);
            }
        }
        catch (Throwable e) {
            this.log(Level.WARNING, "%s", Utils.toString(e));
        }
    }

    private List<URI> normalizePeerNodeList(String[] peers) {
        ArrayList<URI> peerList = new ArrayList<URI>();
        if (peers == null || peers.length == 0) {
            return peerList;
        }
        for (String peer : peers) {
            URI peerNodeBaseUri;
            if (!peer.startsWith("http")) {
                peerNodeBaseUri = UriUtils.buildUri(peer, 8000, ROOT_PATH, null);
            } else {
                try {
                    peerNodeBaseUri = new URI(peer);
                }
                catch (URISyntaxException e) {
                    this.log(Level.SEVERE, "Invalid peer uri:%s", peer);
                    continue;
                }
            }
            if (this.checkAndSetPreferredAddress(peerNodeBaseUri.getHost()) && peerNodeBaseUri.getPort() == this.getPort()) {
                this.log(Level.INFO, "Skipping peer %s, its us", peerNodeBaseUri);
                continue;
            }
            peerList.add(peerNodeBaseUri);
        }
        return peerList;
    }

    private void sendJoinPeerRequest(NodeGroupService.JoinPeerRequest joinBody, URI localNodeGroupUri) {
        Operation peerRequestOp = Operation.createPost(localNodeGroupUri).setReferer(UriUtils.buildUri(this, ROOT_PATH)).setBody(joinBody).setCompletion((o, e) -> {
            if (e == null) {
                return;
            }
            if (e != null) {
                this.log(Level.WARNING, "Failure from local node group for join to: %s: %s", joinBody.memberGroupReference, e.toString());
            }
        });
        peerRequestOp.setAuthorizationContext(this.getSystemAuthorizationContext());
        this.sendRequest(peerRequestOp);
    }

    protected void startFactoryServicesSynchronously(Service ... services) throws Throwable {
        ArrayList<Operation> posts = new ArrayList<Operation>();
        for (Service s : services) {
            if (!(s instanceof FactoryService)) {
                String message = String.format("Service %s is not a FactoryService", s.getClass().getSimpleName());
                throw new IllegalArgumentException(message);
            }
            URI u = null;
            if (ReflectionUtils.hasField(s.getClass(), "SELF_LINK")) {
                u = UriUtils.buildUri(this, s.getClass());
            } else {
                Class<?> childClass = ((FactoryService)s).createServiceInstance().getClass();
                if (ReflectionUtils.hasField(childClass, "FACTORY_LINK")) {
                    u = UriUtils.buildFactoryUri(this, childClass);
                }
                if (u == null) {
                    String message = String.format("%s field not found in class %s and %s field not found in class %s", "SELF_LINK", s.getClass().getSimpleName(), "FACTORY_LINK", childClass.getSimpleName());
                    throw new IllegalArgumentException(message);
                }
            }
            Operation startPost = Operation.createPost(u);
            posts.add(startPost);
        }
        this.startCoreServicesSynchronously(posts, Arrays.asList(services));
    }

    protected void startCoreServicesSynchronously(Service ... services) throws Throwable {
        ArrayList<Operation> posts = new ArrayList<Operation>();
        for (Service s : services) {
            URI u = UriUtils.buildUri(this, s.getClass());
            Operation startPost = Operation.createPost(u);
            posts.add(startPost);
        }
        this.startCoreServicesSynchronously(posts, Arrays.asList(services));
    }

    protected void startCoreServicesSynchronously(List<Operation> startPosts, List<Service> services) throws Throwable {
        CountDownLatch l = new CountDownLatch(services.size());
        Throwable[] failure = new Throwable[1];
        StringBuilder sb = new StringBuilder();
        Operation.CompletionHandler h = (o, e) -> {
            try {
                if (e != null) {
                    failure[0] = e;
                    this.log(Level.SEVERE, "Service %s failed start: %s", o.getUri(), e);
                    return;
                }
                this.log(Level.FINE, "started %s", o.getUri().getPath());
                this.coreServices.add(o.getUri().getPath());
            }
            finally {
                l.countDown();
            }
        };
        int index = 0;
        Operation.AuthorizationContext originalContext = OperationContext.getAuthorizationContext();
        OperationContext.setAuthorizationContext(this.getSystemAuthorizationContext());
        for (Service s : services) {
            Operation startPost = startPosts.get(index++);
            startPost.setCompletion(h);
            startPost.setAuthorizationContext(this.getSystemAuthorizationContext());
            sb.append(startPost.getUri().toString()).append("\r\n");
            this.log(Level.FINE, "starting %s", startPost.getUri());
            this.startService(startPost, s);
        }
        if (!l.await(this.state.operationTimeoutMicros, TimeUnit.MICROSECONDS)) {
            this.log(Level.SEVERE, "One of the core services failed start: %s", sb.toString(), new TimeoutException());
        }
        OperationContext.setAuthorizationContext(originalContext);
        if (failure[0] != null) {
            throw failure[0];
        }
    }

    protected void setAuthorizationContext(Operation.AuthorizationContext context) {
        OperationContext.setAuthorizationContext(context);
    }

    public URI startSubscriptionService(Operation subscribe, Consumer<Operation> notificationConsumer) {
        return this.startSubscriptionService(subscribe, notificationConsumer, ServiceSubscriptionState.ServiceSubscriber.create(false));
    }

    public URI startReliableSubscriptionService(Operation subscribe, Consumer<Operation> notificationConsumer) {
        ServiceSubscriptionState.ServiceSubscriber sr = ServiceSubscriptionState.ServiceSubscriber.create(false).setUsePublicUri(true);
        ReliableSubscriptionService notificationTarget = ReliableSubscriptionService.create(subscribe, sr, notificationConsumer);
        return this.startSubscriptionService(subscribe, notificationTarget, sr);
    }

    public URI startSubscriptionService(Operation subscribe, final Consumer<Operation> notificationConsumer, ServiceSubscriptionState.ServiceSubscriber request) {
        if (subscribe == null) {
            throw new IllegalArgumentException("subcribe operation is required");
        }
        if (notificationConsumer == null) {
            subscribe.fail(new IllegalArgumentException("notificationConsumer is required"));
            return null;
        }
        if (request.notificationLimit != null && request.notificationLimit.compareTo(0L) <= 0) {
            subscribe.fail(new IllegalArgumentException("notificationCount must be greater than zero"));
            return null;
        }
        StatelessService notificationTarget = new StatelessService(){

            @Override
            public void handleRequest(Operation op) {
                if (!op.isNotification()) {
                    super.handleRequest(op);
                    return;
                }
                notificationConsumer.accept(op);
            }
        };
        return this.startSubscriptionService(subscribe, notificationTarget, request);
    }

    public URI startSubscriptionService(Operation subscribe, Service notificationTarget, ServiceSubscriptionState.ServiceSubscriber request) {
        URI subscriptionUri;
        if (subscribe == null) {
            throw new IllegalArgumentException("subscribe operation is required");
        }
        if (subscribe.getUri() == null) {
            subscribe.fail(new IllegalArgumentException("subscribe URI is required"));
            return null;
        }
        if (!subscribe.getUri().getPath().endsWith(SERVICE_URI_SUFFIX_SUBSCRIPTIONS)) {
            subscribe.setUri(UriUtils.extendUri(subscribe.getUri(), SERVICE_URI_SUFFIX_SUBSCRIPTIONS));
        }
        if (notificationTarget.getProcessingStage().ordinal() > Service.ProcessingStage.AVAILABLE.ordinal()) {
            subscribe.fail(new IllegalArgumentException("subscription notification target cannot be reused"));
            return null;
        }
        String notificationTargetSelfLink = notificationTarget.getSelfLink();
        if (notificationTarget.getProcessingStage() == Service.ProcessingStage.AVAILABLE) {
            subscriptionUri = request.usePublicUri ? UriUtils.buildPublicUri(notificationTarget.getHost(), notificationTargetSelfLink) : notificationTarget.getUri();
        } else {
            if (notificationTargetSelfLink == null) {
                notificationTargetSelfLink = UUID.randomUUID().toString();
            }
            subscriptionUri = request.usePublicUri ? UriUtils.buildPublicUri(this, notificationTargetSelfLink) : UriUtils.buildUri(this, notificationTargetSelfLink);
        }
        if (request.documentExpirationTimeMicros != 0L) {
            long delta = request.documentExpirationTimeMicros - Utils.getNowMicrosUtc();
            if (delta <= 0L) {
                this.log(Level.WARNING, "Expiration time is in the past: %d", request.documentExpirationTimeMicros);
                subscribe.fail(new CancellationException("Subscription has already expired"));
                return null;
            }
            this.schedule(() -> this.sendRequest(Operation.createDelete(UriUtils.buildUri(this, notificationTarget.getSelfLink()))), delta, TimeUnit.MICROSECONDS);
        }
        request.reference = subscriptionUri;
        subscribe.setBody(request);
        Operation post = Operation.createPost(subscriptionUri).setAuthorizationContext(this.getSystemAuthorizationContext()).setCompletion((o, e) -> {
            if (e != null) {
                subscribe.fail(e);
                return;
            }
            this.sendRequest(subscribe);
        });
        if (notificationTarget.getProcessingStage() == Service.ProcessingStage.CREATED) {
            this.startService(post, notificationTarget);
        } else {
            post.complete();
        }
        return subscriptionUri;
    }

    public void stopSubscriptionService(Operation unsubscribe, URI notificationTarget) {
        if (unsubscribe == null) {
            throw new IllegalArgumentException("unsubscribe operation is required");
        }
        if (unsubscribe.getUri() == null) {
            unsubscribe.fail(new IllegalArgumentException("unsubscribe URI is required"));
            return;
        }
        if (!unsubscribe.getUri().getPath().endsWith(SERVICE_URI_SUFFIX_SUBSCRIPTIONS)) {
            unsubscribe.setUri(UriUtils.extendUri(unsubscribe.getUri(), SERVICE_URI_SUFFIX_SUBSCRIPTIONS));
        }
        unsubscribe.setAction(Service.Action.DELETE);
        ServiceSubscriptionState.ServiceSubscriber unSubscribeBody = new ServiceSubscriptionState.ServiceSubscriber();
        unSubscribeBody.reference = notificationTarget;
        this.sendRequest(unsubscribe.setBody(unSubscribeBody).nestCompletion((deleteOp, deleteEx) -> {
            if (deleteEx != null) {
                unsubscribe.fail(new IllegalStateException("Deletion of notification callback failed"));
                return;
            }
            unsubscribe.complete();
        }));
        this.sendRequest(Operation.createDelete(notificationTarget).setReferer(unsubscribe.getReferer()).setCompletion((deleteOp, deleteEx) -> {
            if (deleteEx != null) {
                this.log(Level.WARNING, "Deletion of notification subscriber failed", new Object[0]);
            }
        }));
    }

    public static boolean isServiceStartingOrAvailable(Service.ProcessingStage stage) {
        return stage.ordinal() >= Service.ProcessingStage.INITIALIZING.ordinal() && stage.ordinal() <= Service.ProcessingStage.AVAILABLE.ordinal();
    }

    public static boolean isServiceStarting(Service.ProcessingStage stage) {
        return stage.ordinal() >= Service.ProcessingStage.CREATED.ordinal() && stage.ordinal() < Service.ProcessingStage.AVAILABLE.ordinal();
    }

    private boolean isServiceStarting(Service service, String path) {
        if (service != null) {
            return ServiceHost.isServiceStarting(service.getProcessingStage());
        }
        if (path != null) {
            return false;
        }
        throw new IllegalArgumentException("service or path is required");
    }

    public ServiceHost startService(Operation post, Service service) {
        if (service == null) {
            throw new IllegalArgumentException("service is required");
        }
        if (this.isStopping()) {
            post.fail(new IllegalStateException("ServiceHost not started"));
            return this;
        }
        Service.ProcessingStage stage = service.getProcessingStage();
        if (ServiceHost.isServiceStartingOrAvailable(stage)) {
            post.complete();
            return this;
        }
        if (service.getProcessingStage() == Service.ProcessingStage.STOPPED) {
            this.log(Level.INFO, "Restarting service %s (%s)", service.getClass().getSimpleName(), post.getUri());
        }
        if (post.getUri() == null) {
            post.setUri(UriUtils.buildUri(this, service.getClass()));
        }
        if (post.getReferer() == null) {
            post.setReferer(post.getUri());
        }
        service.setHost(this);
        URI serviceUri = post.getUri().normalize();
        String servicePath = UriUtils.normalizeUriPath(serviceUri.getPath());
        if (service.getSelfLink() == null) {
            service.setSelfLink(servicePath);
        }
        if (post.getExpirationMicrosUtc() == 0L) {
            post.setExpiration(this.state.operationTimeoutMicros + Utils.getNowMicrosUtc());
        }
        if (ServiceHost.isHelperServicePath(servicePath)) {
            if (!service.hasOption(Service.ServiceOption.UTILITY)) {
                post.fail(new IllegalStateException("Service is using an utility URI path but has not enabled " + (Object)((Object)Service.ServiceOption.UTILITY)));
                return this;
            }
        } else if (this.checkIfServiceExistsAndAttach(service, servicePath, post)) {
            return this;
        }
        service.setProcessingStage(Service.ProcessingStage.CREATED);
        post.nestCompletion((o, e) -> {
            this.pendingStartOperations.remove(post);
            if (e == null) {
                post.complete();
                return;
            }
            this.stopService(service);
            post.fail(e);
            this.processPendingServiceAvailableOperations(service, e);
        });
        this.pendingStartOperations.add(post);
        if (!this.validateServiceOptions(service, post)) {
            return this;
        }
        if (this.isAuthorizationEnabled() && post.getAuthorizationContext() == null) {
            this.populateAuthorizationContext(post);
        }
        this.processServiceStart(Service.ProcessingStage.INITIALIZING, service, post, post.hasBody());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPendingServiceAvailableOperations(Service s, Throwable e) {
        if (!this.isStopping() && e != null) {
            this.log(Level.WARNING, "Service %s failed start: %s", s.getSelfLink(), e.toString());
        }
        SortedSet<Operation> ops = null;
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            ops = this.pendingServiceAvailableCompletions.remove(s.getSelfLink());
            if (ops == null || ops.isEmpty()) {
                return;
            }
        }
        if (e != null) {
            this.log(Level.INFO, "Retrying %d operations waiting on failed start for %s", ops.size(), s.getSelfLink());
        }
        for (Operation op : ops) {
            this.run(() -> {
                if (op.getUri() == null) {
                    op.setUri(s.getUri());
                }
                if (e != null && op.hasPragmaDirective("xn-post-to-put")) {
                    this.restoreActionOnChildServiceToPostOnFactory(s.getSelfLink(), op);
                }
                op.complete();
            });
        }
    }

    private void restoreActionOnChildServiceToPostOnFactory(String link, Operation op) {
        this.log(Level.INFO, "Changing URI for (id:%d) %s from %s to factory", new Object[]{op.getId(), op.getAction(), link});
        op.removePragmaDirective("xn-post-to-put");
        String factoryPath = UriUtils.getParentPath(link);
        op.setUri(UriUtils.buildUri(this, factoryPath));
        op.setAction(Service.Action.POST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfServiceExistsAndAttach(Service service, String servicePath, Operation post) {
        boolean isCreateOrSynchRequest = post.hasPragmaDirective("xn-created") || post.hasPragmaDirective("xn-synch");
        Service existing = null;
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            existing = this.attachedServices.get(servicePath);
            if (existing != null && isCreateOrSynchRequest && existing.getProcessingStage() == Service.ProcessingStage.STOPPED) {
                existing = null;
            }
            if (existing == null) {
                this.attachedServices.put(servicePath, service);
                if (service.hasOption(Service.ServiceOption.URI_NAMESPACE_OWNER)) {
                    this.attachedNamespaceServices.put(servicePath, service);
                }
                if (service.hasOption(Service.ServiceOption.REPLICATION) && service.hasOption(Service.ServiceOption.FACTORY)) {
                    this.synchronizationRequiredServices.put(servicePath, 0L);
                }
                ++this.state.serviceCount;
                return false;
            }
        }
        boolean isIdempotent = service.hasOption(Service.ServiceOption.IDEMPOTENT_POST);
        if (!isIdempotent) {
            Service parent = this.findService(UriUtils.getParentPath(servicePath));
            boolean bl = isIdempotent = parent != null && parent.hasOption(Service.ServiceOption.IDEMPOTENT_POST);
        }
        if (!isIdempotent) {
            post.setStatusCode(409).fail(new ServiceAlreadyStartedException(servicePath, existing.getProcessingStage()));
            return true;
        }
        if (!isCreateOrSynchRequest) {
            post.complete();
            return true;
        }
        if (existing.getProcessingStage() != Service.ProcessingStage.AVAILABLE) {
            this.restoreActionOnChildServiceToPostOnFactory(servicePath, post);
            this.log(Level.INFO, "Retrying (%d) POST to idempotent %s in stage %s", new Object[]{post.getId(), servicePath, existing.getProcessingStage()});
            this.schedule(() -> this.handleRequest(null, post), this.getMaintenanceIntervalMicros(), TimeUnit.MICROSECONDS);
            return true;
        }
        this.log(Level.INFO, "Converting (%d) POST to PUT for idempotent %s in stage %s", new Object[]{post.getId(), servicePath, existing.getProcessingStage()});
        post.setAction(Service.Action.PUT);
        post.addPragmaDirective("xn-post-to-put");
        this.handleRequest(null, post);
        return true;
    }

    private boolean validateServiceOptions(Service service, Operation post) {
        for (Service.ServiceOption o : service.getOptions()) {
            String error = Utils.validateServiceOption(service.getOptions(), o);
            if (error == null) continue;
            this.log(Level.WARNING, error, new Object[0]);
            post.fail(new IllegalArgumentException(error));
            return false;
        }
        if (service.getMaintenanceIntervalMicros() > 0L && service.getMaintenanceIntervalMicros() < this.getMaintenanceIntervalMicros()) {
            this.log(Level.WARNING, "Service maint. interval %d is less than host interval %d, reducing host interval", service.getMaintenanceIntervalMicros(), this.getMaintenanceIntervalMicros());
            this.setMaintenanceIntervalMicros(service.getMaintenanceIntervalMicros());
        }
        return true;
    }

    public static boolean isServiceIndexed(Service s) {
        return s.hasOption(Service.ServiceOption.PERSISTENCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processServiceStart(Service.ProcessingStage next, Service s, Operation post, boolean hasClientSuppliedInitialState) {
        if (next == s.getProcessingStage()) {
            post.complete();
            return;
        }
        if (this.isStopping()) {
            post.fail(new CancellationException());
            return;
        }
        if (s.getProcessingStage() == Service.ProcessingStage.STOPPED) {
            post.fail(new CancellationException());
            return;
        }
        try {
            s.setProcessingStage(next);
            switch (next) {
                case INITIALIZING: {
                    Service.ProcessingStage nextStage = ServiceHost.isServiceIndexed(s) ? Service.ProcessingStage.LOADING_INITIAL_STATE : Service.ProcessingStage.SYNCHRONIZING;
                    this.buildDocumentDescription(s);
                    if (post.hasBody()) {
                        ServiceDocument d = post.getBody(s.getStateType());
                        d.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
                    }
                    if (this.isAuthorizationEnabled() && this.authorizationService != null && this.authorizationService.getProcessingStage() == Service.ProcessingStage.AVAILABLE) {
                        post.nestCompletion(op -> this.processServiceStart(nextStage, s, post, hasClientSuppliedInitialState));
                        this.queueOrScheduleRequest(this.authorizationService, post);
                        break;
                    }
                    this.processServiceStart(nextStage, s, post, hasClientSuppliedInitialState);
                    break;
                }
                case LOADING_INITIAL_STATE: {
                    if (ServiceHost.isServiceIndexed(s) && !post.isFromReplication()) {
                        this.loadInitialServiceState(s, post, Service.ProcessingStage.SYNCHRONIZING, hasClientSuppliedInitialState);
                        break;
                    }
                    this.processServiceStart(Service.ProcessingStage.SYNCHRONIZING, s, post, hasClientSuppliedInitialState);
                    break;
                }
                case SYNCHRONIZING: {
                    Service.ProcessingStage nxt;
                    boolean doCreate = post.hasPragmaDirective("xn-created");
                    Service.ProcessingStage processingStage = nxt = doCreate ? Service.ProcessingStage.EXECUTING_CREATE_HANDLER : Service.ProcessingStage.EXECUTING_START_HANDLER;
                    if (s.hasOption(Service.ServiceOption.FACTORY) || !s.hasOption(Service.ServiceOption.REPLICATION)) {
                        this.processServiceStart(nxt, s, post, hasClientSuppliedInitialState);
                        break;
                    }
                    post.nestCompletion(o -> {
                        boolean hasInitialState = hasClientSuppliedInitialState;
                        if (o.getLinkedState() != null) {
                            hasInitialState = true;
                        }
                        this.processServiceStart(nxt, s, post, hasInitialState);
                    });
                    this.selectServiceOwnerAndSynchState(s, post);
                    break;
                }
                case EXECUTING_CREATE_HANDLER: {
                    post.nestCompletion(o -> this.processServiceStart(Service.ProcessingStage.EXECUTING_START_HANDLER, s, post, hasClientSuppliedInitialState));
                    if (!this.isDocumentOwner(s)) {
                        post.complete();
                        break;
                    }
                    if (post.isFromReplication()) {
                        post.complete();
                        break;
                    }
                    OperationContext opCtx = this.extractAndApplyContext(post);
                    try {
                        s.adjustStat("createCount", 1.0);
                        s.handleCreate(post);
                        break;
                    }
                    catch (Throwable e) {
                        this.handleUncaughtException(s, post, e);
                        return;
                    }
                    finally {
                        OperationContext.restoreOperationContext(opCtx);
                    }
                }
                case EXECUTING_START_HANDLER: {
                    ServiceDocument stateFromDocumentStore;
                    Long version = null;
                    if (post.hasBody() && (stateFromDocumentStore = post.getLinkedState()) != null) {
                        version = stateFromDocumentStore.documentVersion;
                        post.linkState(null);
                    }
                    Long finalVersion = version;
                    post.nestCompletion(o -> {
                        ServiceDocument document = null;
                        this.normalizeInitialServiceState(s, post, finalVersion);
                        if (post.hasBody()) {
                            document = post.getBody(s.getStateType());
                        } else {
                            document = new ServiceDocument();
                            document.documentSelfLink = s.getSelfLink();
                        }
                        if (!this.isAuthorized(s, document, post)) {
                            post.fail(403);
                            return;
                        }
                        this.processServiceStart(Service.ProcessingStage.INDEXING_INITIAL_STATE, s, post, hasClientSuppliedInitialState);
                    });
                    if (!this.isDocumentOwner(s)) {
                        post.complete();
                        break;
                    }
                    OperationContext opCtx = this.extractAndApplyContext(post);
                    try {
                        s.handleStart(post);
                        break;
                    }
                    catch (Throwable e) {
                        this.handleUncaughtException(s, post, e);
                        return;
                    }
                    finally {
                        OperationContext.restoreOperationContext(opCtx);
                    }
                }
                case INDEXING_INITIAL_STATE: {
                    boolean needsIndexing = false;
                    if (ServiceHost.isServiceIndexed(s) && !s.hasOption(Service.ServiceOption.FACTORY) && (post.isSynchronize() || hasClientSuppliedInitialState)) {
                        needsIndexing = true;
                    }
                    post.nestCompletion(o -> this.processServiceStart(Service.ProcessingStage.AVAILABLE, s, post, hasClientSuppliedInitialState));
                    if (!post.hasBody() || !needsIndexing) {
                        post.complete();
                        break;
                    }
                    this.saveServiceState(s, post, (ServiceDocument)post.getBodyRaw());
                    break;
                }
                case AVAILABLE: {
                    if (s.getProcessingStage() == Service.ProcessingStage.STOPPED) {
                        post.complete();
                        return;
                    }
                    if (s.hasOption(Service.ServiceOption.HTML_USER_INTERFACE)) {
                        this.startUiFileContentServices(s);
                    }
                    if (s.hasOption(Service.ServiceOption.PERIODIC_MAINTENANCE)) {
                        this.maintenanceHelper.schedule(s);
                    }
                    s.setProcessingStage(Service.ProcessingStage.AVAILABLE);
                    this.log(Level.FINEST, "Started %s", s.getSelfLink());
                    post.complete();
                    if (!s.hasOption(Service.ServiceOption.DOCUMENT_OWNER)) break;
                    this.scheduleServiceOptionToggleMaintenance(s.getSelfLink(), EnumSet.of(Service.ServiceOption.DOCUMENT_OWNER), null);
                    break;
                }
            }
        }
        catch (Throwable e) {
            this.log(Level.SEVERE, "Unhandled error: %s", Utils.toString(e));
            post.fail(e);
        }
    }

    private OperationContext extractAndApplyContext(Operation post) {
        OperationContext opCtx = OperationContext.getOperationContext();
        String contextId = post.getContextId();
        if (contextId != null) {
            OperationContext.setContextId(contextId);
        }
        OperationContext.setAuthorizationContext(post.getAuthorizationContext());
        return opCtx;
    }

    boolean isDocumentOwner(Service s) {
        return !s.hasOption(Service.ServiceOption.OWNER_SELECTION) || s.hasOption(Service.ServiceOption.DOCUMENT_OWNER);
    }

    void normalizeInitialServiceState(Service s, Operation post, Long finalVersion) {
        if (!post.hasBody()) {
            return;
        }
        Object body = post.getBodyRaw();
        ServiceDocument initialState = s.setInitialState(Utils.toJson(body), finalVersion);
        initialState.documentSelfLink = s.getSelfLink();
        initialState.documentKind = Utils.buildKind(initialState.getClass());
        initialState.documentAuthPrincipalLink = post.getAuthorizationContext() != null ? post.getAuthorizationContext().getClaims().getSubject() : null;
        post.setBody(initialState);
        if (!s.hasOption(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING)) {
            initialState = Utils.clone(initialState);
        }
        this.cacheServiceState(s, initialState, null);
    }

    public void scheduleNodeGroupChangeMaintenance(String nodeSelectorPath) {
        long now = Utils.getNowMicrosUtc();
        this.log(Level.INFO, "%s %d", nodeSelectorPath, now);
        this.synchronizationTimes.put(nodeSelectorPath, now);
        this.scheduleNodeGroupChangeMaintenance(nodeSelectorPath, null);
    }

    private void scheduleNodeGroupChangeMaintenance(String nodeSelectorPath, Operation op) {
        OperationContext.setAuthorizationContext(this.getSystemAuthorizationContext());
        if (nodeSelectorPath == null) {
            throw new IllegalArgumentException("nodeGroupPath is required");
        }
        NodeSelectorService nss = this.findNodeSelectorService(nodeSelectorPath, Operation.createGet(null));
        if (nss == null) {
            throw new IllegalArgumentException("Node selector not found: " + nodeSelectorPath);
        }
        String ngPath = nss.getNodeGroup();
        Operation get = Operation.createGet(UriUtils.buildUri(this, ngPath)).setReferer(this.getUri()).setCompletion((o, e) -> {
            if (e != null) {
                this.log(Level.WARNING, "Failure getting node group state: %s", e.toString());
                if (op != null) {
                    op.fail(e);
                }
                return;
            }
            NodeGroupService.NodeGroupState ngs = o.getBody(NodeGroupService.NodeGroupState.class);
            this.pendingNodeSelectorsForFactorySynch.put(nodeSelectorPath, ngs);
            if (op != null) {
                op.complete();
            }
        });
        this.sendRequest(get);
    }

    void startOrSynchService(Operation post, Service child, NodeGroupService.NodeGroupState ngs) {
        String path = post.getUri().getPath();
        Service s = this.findService(path);
        boolean skipSynch = false;
        if (ngs != null) {
            NodeState self = ngs.nodes.get(this.getId());
            if (self.membershipQuorum == 1 && ngs.nodes.size() == 1) {
                skipSynch = true;
            }
        } else {
            skipSynch = true;
        }
        if (s == null) {
            post.addPragmaDirective("xn-check-version");
            this.startService(post, child);
            return;
        }
        if (skipSynch) {
            post.complete();
            return;
        }
        Operation synchPut = Operation.createPut(post.getUri()).setBody(new ServiceDocument()).addPragmaDirective("xn-no-fwd").setReplicationDisabled(true).addPragmaDirective("xn-synch").setReferer(post.getReferer()).setCompletion((o, e) -> {
            if (e != null) {
                post.setStatusCode(o.getStatusCode()).setBodyNoCloning(o.getBodyRaw()).fail(e);
                return;
            }
            post.complete();
        });
        this.sendRequest(synchPut);
    }

    void selectServiceOwnerAndSynchState(Service s, Operation op) {
        Operation.CompletionHandler c = (o, e) -> {
            if (e != null) {
                this.log(Level.WARNING, "Failure partitioning %s: %s", op.getUri(), e.toString());
                op.fail(e);
                return;
            }
            NodeSelectorService.SelectOwnerResponse rsp = o.getBody(NodeSelectorService.SelectOwnerResponse.class);
            if (op.isFromReplication()) {
                if (op.isCommit()) {
                    s.toggleOption(Service.ServiceOption.DOCUMENT_OWNER, rsp.isLocalHostOwner);
                }
                op.complete();
                return;
            }
            if (ServiceHost.isServiceCreate(op)) {
                s.toggleOption(Service.ServiceOption.DOCUMENT_OWNER, rsp.isLocalHostOwner);
                op.complete();
                return;
            }
            this.synchronizeWithPeers(s, op, rsp);
        };
        Operation selectOwnerOp = Operation.createPost(null).setExpiration(op.getExpirationMicrosUtc()).setCompletion(c);
        this.selectOwner(s.getPeerNodeSelectorPath(), s.getSelfLink(), selectOwnerOp);
    }

    private void synchronizeWithPeers(Service s, Operation op, NodeSelectorService.SelectOwnerResponse rsp) {
        NodeSelectorSynchronizationService.SynchronizePeersRequest t = NodeSelectorSynchronizationService.SynchronizePeersRequest.create();
        t.stateDescription = this.buildDocumentDescription(s);
        t.wasOwner = s.hasOption(Service.ServiceOption.DOCUMENT_OWNER);
        t.isOwner = rsp.isLocalHostOwner;
        t.ownerNodeReference = rsp.ownerNodeReference;
        t.ownerNodeId = rsp.ownerNodeId;
        s.toggleOption(Service.ServiceOption.DOCUMENT_OWNER, t.isOwner);
        t.options = s.getOptions();
        t.state = op.hasBody() ? op.getBody(s.getStateType()) : null;
        t.factoryLink = UriUtils.getParentPath(s.getSelfLink());
        if (t.factoryLink == null || t.factoryLink.isEmpty()) {
            String error = String.format("Factory not found for %s.If the service is not created through a factory it should not set %s", new Object[]{s.getSelfLink(), Service.ServiceOption.OWNER_SELECTION});
            op.fail(new IllegalStateException(error));
            return;
        }
        if (t.state == null) {
            ServiceDocument template = null;
            try {
                template = s.getStateType().newInstance();
            }
            catch (Throwable e2) {
                this.log(Level.SEVERE, "Could not create instance state type: %s", e2.toString());
                op.fail(e2);
                return;
            }
            template.documentSelfLink = s.getSelfLink();
            template.documentEpoch = 0L;
            template.documentVersion = -1L;
            t.state = template;
        }
        Operation.CompletionHandler c = (o, e) -> {
            ServiceDocument selectedState = null;
            if (this.isStopping()) {
                op.fail(new CancellationException());
                return;
            }
            if (e != null) {
                op.fail(e);
                return;
            }
            if (!o.hasBody()) {
                op.complete();
                return;
            }
            selectedState = o.getBody(s.getStateType());
            if (ServiceDocument.isDeleted(selectedState)) {
                op.fail(new IllegalStateException("Document marked deleted by peers: " + s.getSelfLink()));
                selectedState.documentSelfLink = s.getSelfLink();
                selectedState.documentUpdateAction = Service.Action.DELETE.toString();
                this.saveServiceState(s, Operation.createDelete(UriUtils.buildUri(this, s.getSelfLink())).setReferer(s.getUri()), selectedState);
                return;
            }
            op.addPragmaDirective("xn-synch");
            op.setBodyNoCloning(selectedState).complete();
        };
        URI synchServiceForGroup = UriUtils.extendUri(UriUtils.buildUri(this, s.getPeerNodeSelectorPath()), "synch");
        Operation synchPost = Operation.createPost(synchServiceForGroup).setBodyNoCloning(t).setReferer(s.getUri()).setCompletion(c);
        this.sendRequest(synchPost);
    }

    void loadServiceState(Service s, Operation op) {
        ServiceDocument state = this.getCachedServiceState(s.getSelfLink());
        if (state != null && !s.hasOption(Service.ServiceOption.CONCURRENT_UPDATE_HANDLING)) {
            state = Utils.clone(state);
        }
        if (state != null || !ServiceHost.isServiceIndexed(s)) {
            if (!this.isAuthorized(s, state, op)) {
                op.fail(403);
                return;
            }
            if (state != null) {
                op.linkState(state);
            }
            op.complete();
            return;
        }
        if (s.hasOption(Service.ServiceOption.INSTRUMENTATION)) {
            s.adjustStat("stateCacheMissCount", 1.0);
        }
        URI u = UriUtils.buildDocumentQueryUri(this, s.getSelfLink(), false, true, s.getOptions());
        Operation loadGet = Operation.createGet(u).setReferer(op.getReferer()).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            if (!o.hasBody()) {
                op.setStatusCode(404).fail(new IllegalStateException("Unable to locate service state in index for " + s.getSelfLink()));
                return;
            }
            ServiceDocument st = o.getBody(s.getStateType());
            if (!this.isAuthorized(s, st, op)) {
                op.fail(403);
                return;
            }
            op.linkState(st).complete();
        });
        Service indexService = this.documentIndexService;
        if (indexService == null) {
            op.fail(new CancellationException());
            return;
        }
        this.documentIndexService.handleRequest(loadGet);
    }

    public boolean isAuthorized(Service service, ServiceDocument document, Operation op) {
        if (!this.isAuthorizationEnabled()) {
            return true;
        }
        Operation.AuthorizationContext ctx = op.getAuthorizationContext();
        if (ctx == null) {
            return false;
        }
        if (ctx.isSystemUser()) {
            return true;
        }
        if (document == null) {
            Class<? extends ServiceDocument> clazz = service.getStateType();
            try {
                document = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.log(Level.SEVERE, "Unable to instantiate %s: %s", clazz.toString(), e.toString());
                return false;
            }
            document.documentSelfLink = service.getSelfLink();
            document.documentKind = Utils.buildKind(clazz);
        }
        ServiceDocumentDescription documentDescription = this.buildDocumentDescription(service);
        QueryFilter queryFilter = ctx.getResourceQueryFilter(op.getAction());
        return queryFilter != null && queryFilter.evaluate(document, documentDescription);
    }

    void loadInitialServiceState(Service s, Operation serviceStartPost, Service.ProcessingStage next, boolean hasClientSuppliedState) {
        URI u = UriUtils.buildDocumentQueryUri(this, serviceStartPost.getUri().getPath(), false, true, s.getOptions());
        Operation loadGet = Operation.createGet(u).setReferer(serviceStartPost.getReferer()).setCompletion((indexQueryOperation, e) -> this.handleLoadInitialStateCompletion(s, serviceStartPost, next, hasClientSuppliedState, indexQueryOperation, e));
        this.sendRequest(loadGet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheServiceState(Service s, ServiceDocument st, Operation op) {
        Object rsp;
        if (op != null && op.hasBody() && (rsp = op.getBodyRaw()).getClass().equals(st.getClass())) {
            ServiceDocument r = (ServiceDocument)rsp;
            st.copyTo(r);
        }
        if (!this.state.isServiceStateCaching && ServiceHost.isServiceIndexed(s)) {
            return;
        }
        if (op != null && op.getAction() == Service.Action.DELETE) {
            return;
        }
        String string = s.getSelfLink();
        synchronized (string) {
            ServiceDocument cachedState = this.cachedServiceStates.put(s.getSelfLink(), st);
            if (cachedState != null && cachedState.documentVersion > st.documentVersion) {
                this.cachedServiceStates.put(s.getSelfLink(), cachedState);
            }
        }
    }

    private void handleLoadInitialStateCompletion(Service s, Operation serviceStartPost, Service.ProcessingStage next, boolean hasClientSuppliedState, Operation indexQueryOperation, Throwable e) {
        if (e != null) {
            if (!this.isStopping()) {
                this.log(Level.SEVERE, "Error loading state for service %s: %s", serviceStartPost.getUri(), Utils.toString(e));
            }
            serviceStartPost.fail(e);
            return;
        }
        ServiceDocument stateFromStore = null;
        if (indexQueryOperation.hasBody()) {
            stateFromStore = indexQueryOperation.getBody(s.getStateType());
            serviceStartPost.linkState(stateFromStore);
        }
        if (!this.checkServiceExistsOrDeleted(s, stateFromStore, serviceStartPost)) {
            serviceStartPost.setStatusCode(409).fail(new IllegalStateException("Service already exists or previously deleted: " + stateFromStore.documentSelfLink + ":" + stateFromStore.documentUpdateAction));
            return;
        }
        if (s.hasOption(Service.ServiceOption.ON_DEMAND_LOAD) && !hasClientSuppliedState && stateFromStore == null) {
            serviceStartPost.setStatusCode(404).fail(new IllegalStateException("Service not found: " + s.getSelfLink()));
            return;
        }
        if (hasClientSuppliedState && stateFromStore != null) {
            ++stateFromStore.documentVersion;
        } else if (stateFromStore != null && stateFromStore.documentSelfLink != null) {
            serviceStartPost.setBody(stateFromStore);
        }
        this.processServiceStart(next, s, serviceStartPost, hasClientSuppliedState);
    }

    private boolean checkServiceExistsOrDeleted(Service s, ServiceDocument stateFromStore, Operation serviceStartPost) {
        if (!serviceStartPost.hasPragmaDirective("xn-check-version")) {
            return true;
        }
        if (serviceStartPost.hasPragmaDirective("xn-force-index-update")) {
            return true;
        }
        if (stateFromStore == null) {
            return true;
        }
        boolean isDeleted = ServiceDocument.isDeleted(stateFromStore);
        if (!serviceStartPost.hasBody()) {
            return !isDeleted;
        }
        ServiceDocument initState = (ServiceDocument)serviceStartPost.getBodyRaw();
        if (isDeleted) {
            if (stateFromStore.documentVersion < initState.documentVersion) {
                return true;
            }
            this.log(Level.WARNING, " (%d) Attempt to start deleted service %s.Version: %d, in body: %d (%s)", serviceStartPost.getId(), stateFromStore.documentSelfLink, stateFromStore.documentVersion, initState.documentVersion, serviceStartPost.getRequestHeader("pragma"));
            return false;
        }
        if (!s.hasOption(Service.ServiceOption.IDEMPOTENT_POST)) {
            this.log(Level.WARNING, "Attempt to start existing service %s.Version: %d, in body: %d", stateFromStore.documentSelfLink, stateFromStore.documentVersion, initState.documentVersion);
            return false;
        }
        return true;
    }

    public void stopService(Service service) {
        if (service == null) {
            throw new IllegalArgumentException("service is required");
        }
        this.stopService(service.getSelfLink());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopService(String path) {
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            Service existing = this.attachedServices.remove(path);
            if (existing == null) {
                path = UriUtils.normalizeUriPath(path);
                existing = this.attachedServices.remove(path);
            }
            if (existing != null) {
                existing.setProcessingStage(Service.ProcessingStage.STOPPED);
                if (existing.hasOption(Service.ServiceOption.URI_NAMESPACE_OWNER)) {
                    this.attachedNamespaceServices.remove(path);
                }
            }
            this.synchronizationActiveServices.remove(path);
            this.synchronizationRequiredServices.remove(path);
            this.pendingPauseServices.remove(path);
            this.clearCachedServiceState(path);
            --this.state.serviceCount;
        }
    }

    protected Service findService(String uriPath) {
        return this.findService(uriPath, true);
    }

    protected Service findService(String uriPath, boolean doExactMatch) {
        Service s = this.attachedServices.get(uriPath);
        if (s != null) {
            return s;
        }
        s = this.attachedServices.get(UriUtils.normalizeUriPath(uriPath));
        if (s != null) {
            return s;
        }
        if (ServiceHost.isHelperServicePath(uriPath)) {
            return this.findHelperService(uriPath);
        }
        if (!doExactMatch) {
            s = this.findNamespaceOwnerService(uriPath);
        }
        return s;
    }

    private Service findNamespaceOwnerService(String uriPath) {
        int charsNotMatched = Integer.MAX_VALUE;
        int uriPathLength = uriPath.length();
        Service candidate = null;
        for (Map.Entry<String, Service> e : this.attachedNamespaceServices.entrySet()) {
            int notMatchedCount;
            if (!uriPath.startsWith(e.getKey()) || (notMatchedCount = uriPathLength - e.getKey().length()) >= charsNotMatched) continue;
            candidate = e.getValue();
            charsNotMatched = notMatchedCount;
        }
        if (candidate != null) {
            return candidate;
        }
        if (uriPath.startsWith("/core/ui/default")) {
            return this.attachedServices.get("/core/ui/default");
        }
        return null;
    }

    Service findHelperService(String uriPath) {
        int i = uriPath.indexOf("/ui/");
        String subPath = i > 0 ? uriPath.substring(0, i) : uriPath.substring(0, uriPath.lastIndexOf("/"));
        Service s = this.attachedServices.get(subPath);
        if (s == null) {
            return null;
        }
        return s.getUtilityService(uriPath);
    }

    public boolean handleRequest(Operation inboundOp) {
        return this.handleRequest(null, inboundOp);
    }

    public boolean handleRequest(Service service, Operation inboundOp) {
        if (inboundOp == null && service != null) {
            inboundOp = service.dequeueRequest();
        }
        if (inboundOp == null) {
            return true;
        }
        if (inboundOp.getUri().getPort() != this.state.httpPort && inboundOp.getUri().getPort() != this.state.httpsPort) {
            return false;
        }
        if (!"127.0.0.1".equals(inboundOp.getUri().getHost()) && !UriUtils.isHostEqual(this, inboundOp.getUri())) {
            return false;
        }
        if (inboundOp.hasPragmaDirective("xn-rpl")) {
            inboundOp.setFromReplication(true).setTargetReplicated(true);
        }
        if (!this.state.isStarted) {
            ServiceHost.failRequest(inboundOp, 404, new IllegalStateException("Service host not started"));
            return true;
        }
        if (this.isAuthorizationEnabled()) {
            if (inboundOp.getAuthorizationContext() == null) {
                this.populateAuthorizationContext(inboundOp);
            }
            if (this.authorizationService != null) {
                inboundOp.nestCompletion(op -> this.handleRequestWithAuthContext(service, (Operation)op));
                this.queueOrScheduleRequest(this.authorizationService, inboundOp);
                return true;
            }
        }
        this.handleRequestWithAuthContext(service, inboundOp);
        return true;
    }

    private void handleRequestWithAuthContext(Service service, Operation inboundOp) {
        String path;
        if (service == null) {
            path = inboundOp.getUri().getPath();
            if (path == null) {
                this.failRequestServiceNotFound(inboundOp);
                return;
            }
            service = this.findService(path, false);
        } else {
            path = service.getSelfLink();
        }
        Service pendingStopService = this.pendingPauseServices.remove(path);
        if (pendingStopService != null) {
            service = pendingStopService;
        }
        if (this.queueRequestUntilServiceAvailable(inboundOp, service, path)) {
            return;
        }
        if (this.queueOrForwardRequest(service, path, inboundOp)) {
            return;
        }
        if (service == null) {
            this.failRequestServiceNotFound(inboundOp);
            return;
        }
        this.traceOperation(inboundOp);
        if (this.isAuthorizationEnabled()) {
            Service sFinal = service;
            inboundOp.nestCompletion(o -> this.queueOrScheduleRequest(sFinal, inboundOp));
            service.authorizeRequest(inboundOp);
            return;
        }
        this.queueOrScheduleRequest(service, inboundOp);
    }

    Operation.AuthorizationContext getAuthorizationContext(Operation op) {
        String token = op.getRequestHeader("x-xenon-auth-token");
        if (token == null) {
            Map<String, String> cookies = op.getCookies();
            if (cookies == null) {
                return null;
            }
            token = cookies.get("xenon-auth-cookie");
        }
        if (token == null) {
            return null;
        }
        Operation.AuthorizationContext ctx = this.authorizationContextCache.get(token);
        try {
            Claims claims = null;
            claims = ctx == null ? this.getTokenVerifier().verify(token, Claims.class) : ctx.getClaims();
            if (claims == null) {
                this.log(Level.INFO, "Request to %s has no claims found with token: %s", op.getUri().getPath(), token);
                return null;
            }
            Long expirationTime = claims.getExpirationTime();
            if (expirationTime != null && expirationTime <= Utils.getNowMicrosUtc()) {
                this.authorizationContextCache.remove(token);
                return null;
            }
            if (ctx != null) {
                return ctx;
            }
            Operation.AuthorizationContext.Builder b = Operation.AuthorizationContext.Builder.create();
            b.setClaims(claims);
            b.setToken(token);
            ctx = b.getResult();
            this.authorizationContextCache.put(token, ctx);
            return ctx;
        }
        catch (Verifier.TokenException | GeneralSecurityException e) {
            this.log(Level.INFO, "Error verifying token: %s", e);
            return null;
        }
    }

    private void failRequestServiceNotFound(Operation inboundOp) {
        ServiceHost.failRequest(inboundOp, 404, new ServiceNotFoundException());
    }

    private boolean queueOrForwardRequest(Service s, String path, Operation op) {
        if (s == null && op.isFromReplication()) {
            if (op.getAction() == Service.Action.DELETE) {
                op.complete();
            } else {
                this.failRequestServiceNotFound(op);
            }
            return true;
        }
        Service parent = null;
        EnumSet<Service.ServiceOption> options = null;
        if (s != null) {
            options = s.getOptions();
            if (options == null) {
                return false;
            }
            if (options.contains((Object)Service.ServiceOption.UTILITY)) {
                parent = this.findService(path = UriUtils.getParentPath(path));
                if (parent == null) {
                    this.failRequestServiceNotFound(op);
                    return true;
                }
                options = parent.getOptions();
            }
            if (options == null || !options.contains((Object)Service.ServiceOption.OWNER_SELECTION) || options.contains((Object)Service.ServiceOption.FACTORY)) {
                return false;
            }
        } else {
            String factoryPath;
            if (ServiceHost.isHelperServicePath(path)) {
                path = UriUtils.getParentPath(path);
            }
            if ((factoryPath = UriUtils.getParentPath(path)) == null) {
                this.failRequestServiceNotFound(op);
                return true;
            }
            parent = this.findService(factoryPath);
            if (parent == null) {
                this.failRequestServiceNotFound(op);
                return true;
            }
            options = parent.getOptions();
            if (options == null || !options.contains((Object)Service.ServiceOption.FACTORY) || !options.contains((Object)Service.ServiceOption.REPLICATION)) {
                return false;
            }
        }
        if (op.isForwardingDisabled()) {
            return false;
        }
        String nodeSelectorPath = parent != null ? parent.getPeerNodeSelectorPath() : s.getPeerNodeSelectorPath();
        op.setStatusCode(200);
        String servicePath = path;
        Operation.CompletionHandler ch = (o, e) -> {
            if (e != null) {
                this.log(Level.SEVERE, "Owner selection failed for service %s, op %d. Error: %s", op.getUri().getPath(), op.getId(), e.toString());
                op.setRetryCount(0).fail(e);
                this.run(() -> this.handleRequest(s, null));
                return;
            }
            NodeSelectorService.SelectOwnerResponse rsp = o.getBody(NodeSelectorService.SelectOwnerResponse.class);
            if (op.isFromReplication()) {
                ServiceDocument body = op.getBody(s.getStateType());
                if (!rsp.ownerNodeId.equals(body.documentOwner)) {
                    this.failRequestOwnerMismatch(op, rsp.ownerNodeId, body);
                    return;
                }
                this.queueOrScheduleRequest(s, op);
                return;
            }
            Operation.CompletionHandler fc = (fo, fe) -> {
                if (fe != null) {
                    this.retryOrFailRequest(op, fo, fe);
                    return;
                }
                op.setStatusCode(fo.getStatusCode());
                if (fo.hasBody()) {
                    op.setBodyNoCloning(fo.getBodyRaw());
                }
                op.transferResponseHeadersFrom(fo);
                op.complete();
            };
            Operation forwardOp = op.clone().setCompletion(fc);
            if (rsp.isLocalHostOwner) {
                if (s == null) {
                    this.queueOrFailRequestForServiceNotFoundOnOwner(servicePath, op);
                    return;
                }
                this.queueOrScheduleRequest(s, forwardOp);
                return;
            }
            if (op.hasPragmaDirective("xn-fwd")) {
                this.failRequestOwnerMismatch(op, op.getUri().getPath(), null);
                return;
            }
            if (op.hasPragmaDirective("xn-rpl")) {
                this.failRequestOwnerMismatch(op, op.getUri().getPath(), null);
                return;
            }
            forwardOp.setUri(NodeSelectorService.SelectOwnerResponse.buildUriToOwner(rsp, op));
            forwardOp.addPragmaDirective("xn-fwd");
            forwardOp.removeRequestCallbackLocation();
            this.sendRequest(forwardOp);
        };
        Operation selectOwnerOp = Operation.createPost(null).setExpiration(op.getExpirationMicrosUtc()).setCompletion(ch);
        this.selectOwner(nodeSelectorPath, path, selectOwnerOp);
        return true;
    }

    private void queueOrFailRequestForServiceNotFoundOnOwner(String path, Operation op) {
        if (op.getAction() == Service.Action.DELETE) {
            op.complete();
            return;
        }
        if (this.checkAndResumePausedService(op)) {
            return;
        }
        boolean doNotQueue = op.hasPragmaDirective("xn-no-queuing");
        String userAgent = op.getRequestHeader("user-agent");
        if (userAgent == null) {
            userAgent = op.getRequestHeader("user-agent".toLowerCase());
        }
        if (!(op.isForwarded() || op.isFromReplication() || userAgent == null || userAgent.contains(ServiceHost.class.getSimpleName()))) {
            doNotQueue = true;
        }
        if (doNotQueue) {
            this.failRequestServiceNotFound(op);
            return;
        }
        this.log(Level.INFO, "Registering for %s to become available on owner (%s)", path, this.getId());
        op.nestCompletion(avop -> this.handleRequest(null, op));
        this.registerForServiceAvailability(op, path);
    }

    void failRequestOwnerMismatch(Operation op, String id, ServiceDocument body) {
        String owner = body != null ? body.documentOwner : ROOT_PATH;
        op.setStatusCode(409);
        IllegalStateException e = new IllegalStateException(String.format("Owner in body: %s, computed locally: %s", owner, id));
        ServiceErrorResponse rsp = ServiceErrorResponse.create(e, op.getStatusCode(), EnumSet.of(ServiceErrorResponse.ErrorDetail.SHOULD_RETRY));
        op.fail(e, rsp);
    }

    public void failRequestActionNotSupported(Operation request) {
        request.setStatusCode(405).fail(new IllegalArgumentException("Action not supported: " + (Object)((Object)request.getAction())));
    }

    void failRequestLimitExceeded(Operation request) {
        request.addResponseHeader("retry-after", "1");
        request.setStatusCode(503).fail(new CancellationException("queue limit exceeded"));
    }

    private void failForwardRequest(Operation op, Operation fo, Throwable fe) {
        op.setStatusCode(fo.getStatusCode());
        op.setBodyNoCloning(fo.getBodyRaw()).fail(fe);
    }

    private void retryOrFailRequest(Operation op, Operation fo, Throwable fe) {
        ServiceErrorResponse rsp;
        boolean shouldRetry = false;
        if (fo.hasBody() && (rsp = fo.clone().getBody(ServiceErrorResponse.class)) != null && rsp.details != null) {
            shouldRetry = rsp.details.contains((Object)ServiceErrorResponse.ErrorDetail.SHOULD_RETRY);
        }
        if (op.hasPragmaDirective("xn-fwd")) {
            shouldRetry = false;
        }
        if (shouldRetry) {
            this.pendingOperationsForRetry.add(op);
            return;
        }
        if (op.getExpirationMicrosUtc() < Utils.getNowMicrosUtc()) {
            op.setBodyNoCloning(fo.getBodyRaw()).fail(new TimeoutException());
            return;
        }
        this.failForwardRequest(op, fo, fe);
    }

    boolean queueRequestUntilServiceAvailable(Operation inboundOp, Service s, String path) {
        Service factoryService;
        if (s != null && s.getProcessingStage() == Service.ProcessingStage.AVAILABLE) {
            return false;
        }
        if (ServiceHost.isHelperServicePath(path)) {
            path = UriUtils.getParentPath(path);
        }
        boolean waitForService = this.isServiceStarting(s, path);
        String factoryPath = UriUtils.getParentPath(path);
        if (factoryPath != null && !waitForService && (factoryService = this.findService(factoryPath)) != null) {
            if (factoryService.hasOption(Service.ServiceOption.FACTORY)) {
                waitForService = this.isServiceStarting(factoryService, factoryPath);
            }
            if (!waitForService && factoryService.hasOption(Service.ServiceOption.PERSISTENCE) && this.checkAndResumePausedService(inboundOp)) {
                return true;
            }
        }
        if (inboundOp.hasPragmaDirective("xn-queue") || inboundOp.isForwardingDisabled()) {
            waitForService = true;
        }
        if (waitForService || inboundOp.isFromReplication()) {
            if (inboundOp.getAction() == Service.Action.DELETE) {
                return false;
            }
            if (this.isStopping()) {
                return false;
            }
            Level l = inboundOp.isFromReplication() ? Level.FINE : Level.INFO;
            this.log(l, "registering for %s (%s) to become available", path, factoryPath);
            inboundOp.nestCompletion(o -> {
                inboundOp.setTargetReplicated(false);
                this.handleRequest(null, inboundOp);
            });
            this.registerForServiceAvailability(inboundOp, path);
            return true;
        }
        return false;
    }

    private static void failRequest(Operation request, int statusCode, Throwable e) {
        request.setStatusCode(statusCode);
        ServiceErrorResponse r = Utils.toServiceErrorResponse(e);
        r.statusCode = statusCode;
        if (e instanceof ServiceNotFoundException) {
            r.stackTrace = null;
        }
        request.setContentType("application/json").fail(e, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueOrScheduleRequest(Service s, Operation op) {
        boolean processRequest = true;
        try {
            if (this.applyRequestRateLimit(op)) {
                processRequest = false;
                return;
            }
            Service.ProcessingStage stage = s.getProcessingStage();
            if (stage == Service.ProcessingStage.AVAILABLE) {
                return;
            }
            if (op.getAction() == Service.Action.DELETE) {
                return;
            }
            if (stage == Service.ProcessingStage.PAUSED) {
                if (this.checkAndResumePausedService(op)) {
                    processRequest = false;
                    return;
                }
                stage = s.getProcessingStage();
                if (stage == Service.ProcessingStage.AVAILABLE) {
                    return;
                }
            }
            processRequest = false;
            if (stage == Service.ProcessingStage.STOPPED) {
                if (op.hasPragmaDirective("xn-post-to-put")) {
                    this.restoreActionOnChildServiceToPostOnFactory(s.getSelfLink(), op);
                    this.handleRequest(null, op);
                    return;
                }
                op.setStatusCode(404);
            }
            op.fail(new CancellationException("Service not available, in stage:" + (Object)((Object)stage)));
        }
        finally {
            if (!processRequest) {
                return;
            }
            if (!s.queueRequest(op)) {
                this.executor.execute(() -> {
                    OperationContext.setContextId(op.getContextId());
                    OperationContext.setAuthorizationContext(op.getAuthorizationContext());
                    try {
                        s.handleRequest(op);
                    }
                    catch (Throwable e) {
                        this.handleUncaughtException(s, op, e);
                    }
                    OperationContext.setAuthorizationContext(null);
                    OperationContext.setContextId(null);
                });
            }
        }
    }

    private boolean applyRequestRateLimit(Operation op) {
        if (this.state.requestRateLimits.isEmpty()) {
            return false;
        }
        Operation.AuthorizationContext authCtx = op.getAuthorizationContext();
        if (authCtx == null) {
            return false;
        }
        Claims claims = authCtx.getClaims();
        if (claims == null) {
            return false;
        }
        String subject = claims.getSubject();
        if (subject == null) {
            return false;
        }
        RequestRateInfo rateInfo = this.state.requestRateLimits.get(subject);
        if (rateInfo == null) {
            return false;
        }
        double count = rateInfo.count.incrementAndGet();
        long now = Utils.getNowMicrosUtc();
        long delta = now - rateInfo.startTimeMicros;
        double deltaInSeconds = (double)delta / 1000000.0;
        if (delta < this.getMaintenanceIntervalMicros()) {
            return false;
        }
        double requestsPerSec = count / deltaInSeconds;
        if (requestsPerSec > rateInfo.limit) {
            this.failRequestLimitExceeded(op);
            return true;
        }
        return false;
    }

    private void handleUncaughtException(Service s, Operation op, Throwable e) {
        if (!Utils.isValidationError(e)) {
            this.log(Level.SEVERE, "Uncaught exception in service %s: %s", s.getUri(), Utils.toString(e));
        } else if (this.logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "Validation Error in service %s: %s", s.getUri(), Utils.toString(e));
        }
        op.fail(e);
    }

    @Override
    public void sendRequest(Operation op) {
        this.prepareRequest(op);
        this.traceOperation(op);
        if (this.isStopping()) {
            op.fail(new CancellationException("host is stopping"));
            return;
        }
        ServiceClient c = this.client;
        if (c == null) {
            op.fail(new CancellationException("host is stopped"));
            return;
        }
        c.send(op);
    }

    private void traceOperation(Operation op) {
        if (this.getOperationTracingLevel().intValue() == Level.OFF.intValue()) {
            return;
        }
        if (this.state.operationTracingLinkExclusionList.contains(op.getUri().getPath())) {
            return;
        }
        for (String excludedPath : this.state.operationTracingLinkExclusionList) {
            if (!op.getUri().getPath().startsWith(excludedPath)) continue;
            return;
        }
        Operation.SerializedOperation tracingOp = Operation.SerializedOperation.create(op);
        this.sendRequest(Operation.createPost(UriUtils.buildUri(this, OperationIndexService.class)).setReferer(this.getUri()).setBodyNoCloning(tracingOp));
    }

    private void prepareRequest(Operation op) {
        if (op.getUri() == null) {
            throw new IllegalArgumentException("URI is required");
        }
        if (op.getUri().getPort() != this.state.httpPort && op.getUri().getPort() != this.state.httpsPort) {
            op.forceRemote();
        }
        if (op.getExpirationMicrosUtc() == 0L) {
            op.setExpiration(Utils.getNowMicrosUtc() + this.state.operationTimeoutMicros);
        }
        if (op.getCompletion() == null) {
            op.setCompletion((o, e) -> {
                if (e == null) {
                    return;
                }
                this.log(Level.WARNING, "%s (ctx id:%s) to %s, from %s failed: %s", new Object[]{o.getAction(), o.getContextId(), o.getUri(), o.getReferer(), e.getMessage()});
            });
        }
    }

    public void sendRequestWithCallback(Operation op) {
        this.client.sendWithCallback(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HashSet<Service> servicesToClose = null;
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            if (!this.state.isStarted || this.state.isStopping) {
                return;
            }
            this.state.isStopping = true;
            servicesToClose = new HashSet<Service>(this.attachedServices.values());
            this.pendingPauseServices.clear();
            this.synchronizationRequiredServices.clear();
            this.synchronizationActiveServices.clear();
        }
        this.stopAndClearPendingQueues();
        ScheduledFuture<?> task = this.maintenanceTask;
        if (task != null) {
            task.cancel(false);
            this.maintenanceTask = null;
        }
        List<Service> privilegedServiceInstances = this.stopServices(servicesToClose);
        this.stopPrivilegedServices(privilegedServiceInstances);
        this.stopCoreServices();
        this.synchronizationTimes.clear();
        this.attachedServices.clear();
        this.attachedNamespaceServices.clear();
        this.maintenanceHelper.close();
        this.state.isStarted = false;
        this.removeLogging();
        try {
            this.httpListener.stop();
            this.httpListener = null;
            if (this.httpsListener != null) {
                this.httpsListener.stop();
                this.httpsListener = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.client.stop();
            this.client = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    private List<Service> stopServices(Set<Service> servicesToClose) {
        int servicesToCloseCount = servicesToClose.size() - this.coreServices.size();
        CountDownLatch latch = new CountDownLatch(servicesToCloseCount);
        Operation.CompletionHandler removeServiceCompletion = (o, e) -> {
            this.attachedServices.remove(o.getUri().getPath());
            latch.countDown();
        };
        this.setAuthorizationContext(this.getSystemAuthorizationContext());
        ArrayList<Service> privilegedServiceInstances = new ArrayList<Service>();
        for (Service s : servicesToClose) {
            if (this.coreServices.contains(s.getSelfLink())) continue;
            if (this.privilegedServiceTypes.containsKey(s.getClass().getName())) {
                privilegedServiceInstances.add(s);
                removeServiceCompletion.handle(Operation.createDelete(s.getUri()), null);
                continue;
            }
            this.sendServiceStop(removeServiceCompletion, s);
        }
        this.log(Level.INFO, "Waiting for DELETE from %d services", servicesToCloseCount);
        this.waitForServiceStop(latch);
        this.log(Level.INFO, "All non core services stopped", servicesToCloseCount);
        return privilegedServiceInstances;
    }

    private void stopPrivilegedServices(List<Service> privilegedServiceInstances) {
        if (privilegedServiceInstances.size() == 0) {
            return;
        }
        int servicesToCloseCount = privilegedServiceInstances.size();
        CountDownLatch pLatch = new CountDownLatch(servicesToCloseCount);
        Operation.CompletionHandler pc = (o, e) -> pLatch.countDown();
        for (Service p : privilegedServiceInstances) {
            this.sendServiceStop(pc, p);
        }
        this.log(Level.INFO, "Waiting for DELETE from %d privileged services", servicesToCloseCount);
        this.waitForServiceStop(pLatch);
        this.log(Level.INFO, "All privileged services stopped", new Object[0]);
    }

    private void stopCoreServices() {
        int coreServiceCount = this.coreServices.size();
        CountDownLatch cLatch = new CountDownLatch(coreServiceCount);
        Operation.CompletionHandler c = (o, e) -> cLatch.countDown();
        for (String coreServiceLink : this.coreServices) {
            Service coreService = this.attachedServices.get(coreServiceLink);
            if (coreService == null || coreService instanceof ServiceHostManagementService) {
                c.handle(null, null);
                continue;
            }
            this.sendServiceStop(c, coreService);
        }
        this.log(Level.INFO, "Waiting for DELETE from %d core services", coreServiceCount);
        this.coreServices.clear();
        this.waitForServiceStop(cLatch);
        this.log(Level.INFO, "All core services stopped", new Object[0]);
    }

    private void stopAndClearPendingQueues() {
        for (Operation operation : this.pendingOperationsForRetry) {
            operation.fail(new CancellationException());
        }
        this.pendingOperationsForRetry.clear();
        for (Operation operation : this.pendingStartOperations) {
            operation.fail(new CancellationException());
        }
        this.pendingStartOperations.clear();
        for (SortedSet sortedSet : this.pendingServiceAvailableCompletions.values()) {
            for (Operation op : sortedSet) {
                op.fail(new CancellationException());
            }
        }
        this.pendingServiceAvailableCompletions.clear();
    }

    private void waitForServiceStop(CountDownLatch latch) {
        try {
            boolean isTimeout;
            boolean bl = isTimeout = !latch.await(this.state.maintenanceIntervalMicros * 5L, TimeUnit.MICROSECONDS);
            if (isTimeout) {
                this.log(Level.INFO, "Timeout waiting for service stop", new Object[0]);
                for (String l : this.attachedServices.keySet()) {
                    if (this.coreServices.contains(l)) continue;
                    this.log(Level.WARNING, "%s did not complete DELETE", l);
                }
            }
        }
        catch (Throwable e) {
            this.log(Level.INFO, "%s", e.toString());
        }
    }

    private void sendServiceStop(Operation.CompletionHandler removeServiceCompletion, Service s) {
        Operation delete = Operation.createDelete(s.getUri()).addPragmaDirective("xn-no-index-update").setReplicationDisabled(true).setCompletion(removeServiceCompletion).setReferer(UriUtils.buildUri(this, ROOT_PATH));
        try {
            this.queueOrScheduleRequest(s, delete);
        }
        catch (Throwable e) {
            this.log(Level.WARNING, Utils.toString(e), new Object[0]);
            removeServiceCompletion.handle(delete, e);
        }
    }

    public static boolean isServiceCreate(Operation op) {
        return op.getAction() == Service.Action.POST && op.hasPragmaDirective("xn-created");
    }

    public static boolean isServiceStop(Operation op) {
        return op.getAction() == Service.Action.DELETE && op.hasPragmaDirective("xn-no-index-update");
    }

    public static boolean isForServiceNamespace(Service s, Operation op) {
        return s.hasOption(Service.ServiceOption.URI_NAMESPACE_OWNER) && !op.getUri().getPath().equals(s.getSelfLink());
    }

    public static boolean isHelperServicePath(String serviceUriPath) {
        if (serviceUriPath.endsWith(SERVICE_URI_SUFFIX_REPLICATION)) {
            return true;
        }
        if (serviceUriPath.endsWith(SERVICE_URI_SUFFIX_STATS)) {
            return true;
        }
        if (serviceUriPath.endsWith(SERVICE_URI_SUFFIX_CONFIG)) {
            return true;
        }
        if (serviceUriPath.endsWith(SERVICE_URI_SUFFIX_SUBSCRIPTIONS)) {
            return true;
        }
        if (serviceUriPath.endsWith(SERVICE_URI_SUFFIX_TEMPLATE)) {
            return true;
        }
        if (serviceUriPath.endsWith(SERVICE_URI_SUFFIX_UI)) {
            return true;
        }
        if (!serviceUriPath.startsWith("/user-interface/resources") && !serviceUriPath.startsWith("/core/ui") && serviceUriPath.indexOf("/ui/") > 0) {
            return true;
        }
        return serviceUriPath.endsWith(SERVICE_URI_SUFFIX_AVAILABLE);
    }

    public ServiceHost toggleDebuggingMode(boolean enable) {
        Level newLevel = enable ? Level.FINE : Level.INFO;
        this.setLoggingLevel(newLevel);
        this.setOperationTimeOutMicros(enable ? TimeUnit.MINUTES.toMicros(10L) : ServiceHostState.DEFAULT_OPERATION_TIMEOUT_MICROS);
        return this;
    }

    public ServiceHost setLoggingLevel(Level newLevel) {
        this.logger.setLevel(newLevel);
        for (Handler h : this.logger.getParent().getHandlers()) {
            h.setLevel(newLevel);
        }
        return this;
    }

    public ServiceHost setOperationTracingLevel(Level newLevel) {
        this.state.operationTracingLevel = newLevel.toString();
        return this;
    }

    public Level getOperationTracingLevel() {
        return this.state.operationTracingLevel == null ? Level.OFF : Level.parse(this.state.operationTracingLevel);
    }

    public void log(Level level, String fmt, Object ... args) {
        this.log(level, 3, fmt, args);
    }

    protected void log(Level level, Integer nestingLevel, String fmt, Object ... args) {
        if (this.logPrefix == null) {
            this.logPrefix = this.getPublicUri().toString();
        }
        Utils.log(this.logger, nestingLevel, this.logPrefix, level, fmt, args);
    }

    public void registerForServiceAvailability(Operation.CompletionHandler completion, String ... servicePaths) {
        if (servicePaths == null || servicePaths.length == 0) {
            throw new IllegalArgumentException("selfLinks are required");
        }
        Operation op = Operation.createPost(null).setCompletion(completion).setExpiration(this.getOperationTimeoutMicros() + Utils.getNowMicrosUtc());
        this.registerForServiceAvailability(op, servicePaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerForServiceAvailability(Operation opTemplate, String ... servicePaths) {
        boolean doOpClone = servicePaths.length > 1;
        String[] clonedLinks = Arrays.copyOf(servicePaths, servicePaths.length);
        String[] stringArray = this.state;
        synchronized (this.state) {
            for (int i = 0; i < clonedLinks.length; ++i) {
                String link = clonedLinks[i];
                Service s = this.findService(link);
                if (s != null && s.getProcessingStage() == Service.ProcessingStage.AVAILABLE) continue;
                SortedSet<Operation> pendingOps = this.pendingServiceAvailableCompletions.get(link);
                if (pendingOps == null) {
                    pendingOps = ServiceHost.createOperationSet();
                    this.pendingServiceAvailableCompletions.put(link, pendingOps);
                }
                pendingOps.add(doOpClone ? opTemplate.clone() : opTemplate);
                clonedLinks[i] = null;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            for (String link : clonedLinks) {
                if (link == null) continue;
                this.run(() -> {
                    Operation o = opTemplate;
                    if (doOpClone) {
                        o = opTemplate.clone().setUri(UriUtils.buildUri(this, link));
                    }
                    if (o.getUri() == null) {
                        o.setUri(UriUtils.buildUri(this, link));
                    }
                    o.complete();
                });
            }
            return;
        }
    }

    public ServiceHost setRequestRateLimit(String key, double operationsPerSecond) {
        RequestRateInfo ri = new RequestRateInfo();
        ri.limit = operationsPerSecond;
        ri.startTimeMicros = Utils.getNowMicrosUtc();
        this.state.requestRateLimits.put(key, ri);
        return this;
    }

    public ServiceHost setServiceMemoryLimit(String servicePath, double percentOfTotal) {
        if (servicePath == null) {
            throw new IllegalArgumentException("servicePath is required");
        }
        if (!servicePath.equals(ROOT_PATH) && this.isStarted()) {
            throw new IllegalStateException("Service memory limit can only be changed before host start");
        }
        if (percentOfTotal >= 1.0 || percentOfTotal <= 0.0) {
            throw new IllegalArgumentException("percentOfTotal must be within 0.0 and 1.0 exclusive");
        }
        double total = percentOfTotal;
        for (Map.Entry<String, Double> e : this.state.relativeMemoryLimits.entrySet()) {
            if (e.getKey().equals(servicePath)) continue;
            total += e.getValue().doubleValue();
        }
        if (total >= 1.0) {
            throw new IllegalStateException("Total memory limit, across all services exceeds 1.0: " + Utils.toJsonHtml(this.state.relativeMemoryLimits));
        }
        this.state.relativeMemoryLimits.put(servicePath, percentOfTotal);
        return this;
    }

    public Long getServiceMemoryLimitMB(String servicePath, ServiceHostState.MemoryLimitType limitType) {
        Double limitAsPercentTotalMemory = this.state.relativeMemoryLimits.get(servicePath);
        if (limitAsPercentTotalMemory == null) {
            return null;
        }
        long maxMemoryMB = Runtime.getRuntime().maxMemory();
        long exactLimitMB = (long)((double)(maxMemoryMB /= 0x100000L) * limitAsPercentTotalMemory);
        switch (limitType) {
            case LOW_WATERMARK: {
                return exactLimitMB / 4L;
            }
            case HIGH_WATERMARK: {
                return exactLimitMB * 3L / 4L;
            }
        }
        return exactLimitMB;
    }

    public Service.ProcessingStage getServiceStage(String servicePath) {
        Service s = this.findService(servicePath);
        if (s == null) {
            return null;
        }
        return s.getProcessingStage();
    }

    public boolean checkServiceAvailable(String servicePath) {
        Service s = this.findService(servicePath, true);
        if (s == null) {
            return false;
        }
        return s.getProcessingStage() == Service.ProcessingStage.AVAILABLE;
    }

    public SystemHostInfo getSystemInfo() {
        if (!this.info.properties.isEmpty() && !this.info.ipAddresses.isEmpty()) {
            return Utils.clone(this.info);
        }
        return this.updateSystemInfo(true);
    }

    public SystemHostInfo updateSystemInfo(boolean enumerateNetworkInterfaces) {
        Runtime r = Runtime.getRuntime();
        this.info.availableProcessorCount = r.availableProcessors();
        this.info.freeMemoryByteCount = r.freeMemory();
        this.info.totalMemoryByteCount = r.totalMemory();
        this.info.maxMemoryByteCount = r.maxMemory();
        this.info.osName = Utils.getOsName(this.info);
        this.info.osFamily = Utils.determineOsFamily(this.info.osName);
        try {
            URI sandbox = this.getStorageSandbox();
            if (sandbox == null) {
                throw new RuntimeException("Sandbox not set");
            }
            File file = new File(sandbox);
            this.info.freeDiskByteCount = file.getFreeSpace();
            this.info.usableDiskByteCount = file.getUsableSpace();
            this.info.totalDiskByteCount = file.getTotalSpace();
        }
        catch (Throwable e) {
            this.log(Level.WARNING, "Exception getting disk usage: %s", Utils.toString(e));
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String k = entry.getKey().toString();
            String v = entry.getValue().toString();
            this.info.properties.put(k, v);
        }
        for (Map.Entry<Object, Object> entry : System.getenv().entrySet()) {
            this.info.environmentVariables.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (!enumerateNetworkInterfaces) {
            return Utils.clone(this.info);
        }
        ArrayList<String> ipAddresses = new ArrayList<String>();
        ipAddresses.add("127.0.0.1");
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface ni = enumeration.nextElement();
                if (ni.isLoopback() || ni.isPointToPoint() || !ni.isUp()) continue;
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress addr = e.nextElement();
                    String host = Utils.getNormalizedHostAddress(this.info, addr);
                    ipAddresses.add(host);
                }
            }
            Collections.reverse(ipAddresses);
            if (this.state.bindAddress != null && !ALL_INTERFACES.equals(this.state.bindAddress)) {
                ipAddresses.remove(this.state.bindAddress);
                ipAddresses.add(0, this.state.bindAddress);
            }
            this.info.ipAddresses = ipAddresses;
        }
        catch (Throwable throwable) {
            this.log(Level.SEVERE, "Failure: %s", Utils.toString(throwable));
        }
        if (this.info.ipAddresses.isEmpty()) {
            this.log(Level.WARNING, "No IP or network interfaces detected. Adding loopback address", new Object[0]);
            this.info.ipAddresses.add("127.0.0.1");
        }
        return Utils.clone(this.info);
    }

    private boolean checkAndSetPreferredAddress(String address) {
        address = this.normalizeAddress(address);
        ArrayList<String> ipAddresses = new ArrayList<String>(this.info.ipAddresses);
        for (int i = 0; i < ipAddresses.size(); ++i) {
            if (!address.equals(ipAddresses.get(i))) continue;
            if (i == 0) break;
            String oldPreferred = (String)ipAddresses.get(0);
            ipAddresses.set(i, oldPreferred);
            ipAddresses.set(0, address);
            this.log(Level.INFO, "Swapped preferred address to %s from %s", address, oldPreferred);
            this.info.ipAddresses = ipAddresses;
            this.clearUriAndLogPrefix();
            return true;
        }
        return address.equals(ipAddresses.get(0));
    }

    private void clearUriAndLogPrefix() {
        this.cachedUri = null;
        this.logPrefix = null;
    }

    private String normalizeAddress(String address) {
        if (address.length() > 2 && address.startsWith("[") && address.endsWith("]")) {
            return address.substring(1, address.length() - 1);
        }
        return address;
    }

    public void run(Runnable task) {
        if (this.executor.isShutdown()) {
            throw new IllegalStateException("Stopped");
        }
        Operation.AuthorizationContext origContext = OperationContext.getAuthorizationContext();
        this.executor.execute(() -> {
            OperationContext.setAuthorizationContext(origContext);
            this.executeRunnableSafe(task);
        });
    }

    public void run(ExecutorService executor, Runnable task) {
        if (executor == null || task == null) {
            throw new IllegalStateException("Valid executor/task must be provided");
        }
        if (executor.isShutdown()) {
            throw new IllegalStateException("Stopped");
        }
        Operation.AuthorizationContext origContext = OperationContext.getAuthorizationContext();
        executor.execute(() -> {
            OperationContext.setAuthorizationContext(origContext);
            this.executeRunnableSafe(task);
        });
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        if (this.isStopping()) {
            throw new IllegalStateException("Stopped");
        }
        if (this.scheduledExecutor.isShutdown()) {
            throw new IllegalStateException("Stopped");
        }
        Operation.AuthorizationContext origContext = OperationContext.getAuthorizationContext();
        return this.scheduledExecutor.schedule(() -> {
            OperationContext.setAuthorizationContext(origContext);
            this.executeRunnableSafe(task);
        }, delay, unit);
    }

    private void executeRunnableSafe(Runnable task) {
        try {
            task.run();
        }
        catch (Throwable e) {
            this.log(Level.SEVERE, "Unhandled exception executing task: %s", Utils.toString(e));
        }
    }

    private void scheduleMaintenance() {
        Runnable r = () -> {
            this.state.lastMaintenanceTimeUtcMicros = Utils.getNowMicrosUtc();
            this.performMaintenanceStage(Operation.createPost(this.getUri()), MaintenanceStage.UTILS);
        };
        this.maintenanceTask = this.schedule(r, this.getMaintenanceIntervalMicros(), TimeUnit.MICROSECONDS);
    }

    private void performMaintenanceStage(Operation post, MaintenanceStage stage) {
        try {
            long now = Utils.getNowMicrosUtc();
            long deadline = this.state.lastMaintenanceTimeUtcMicros + this.state.maintenanceIntervalMicros;
            switch (stage) {
                case UTILS: {
                    Utils.performMaintenance();
                    stage = MaintenanceStage.MEMORY;
                    break;
                }
                case MEMORY: {
                    this.applyMemoryLimit(deadline);
                    stage = MaintenanceStage.IO;
                    break;
                }
                case IO: {
                    this.performIOMaintenance(post, now, MaintenanceStage.NODE_SELECTORS);
                    return;
                }
                case NODE_SELECTORS: {
                    this.performNodeSelectorChangeMaintenance(post, now, MaintenanceStage.SERVICE, true);
                    return;
                }
                case SERVICE: {
                    this.maintenanceHelper.performMaintenance(post, deadline);
                    stage = null;
                    break;
                }
                default: {
                    stage = null;
                }
            }
            if (stage == null) {
                post.complete();
                this.scheduleMaintenance();
                return;
            }
            this.performMaintenanceStage(post, stage);
        }
        catch (Throwable e) {
            this.log(Level.SEVERE, "Uncaught exception: %s", e.toString());
            post.fail(e);
        }
    }

    private void performIOMaintenance(Operation post, long now, MaintenanceStage nextStage) {
        try {
            ServiceRequestListener sl;
            ServiceRequestListener l;
            this.performPendingOperationMaintenance();
            for (RequestRateInfo rri : this.state.requestRateLimits.values()) {
                if (now - rri.startTimeMicros < ONE_MINUTE_IN_MICROS) {
                    return;
                }
                rri.startTimeMicros = now;
                rri.count.set(0);
            }
            int expected = 0;
            ServiceClient c = this.getClient();
            if (c != null) {
                ++expected;
            }
            if ((l = this.getListener()) != null) {
                ++expected;
            }
            if ((sl = this.getSecureListener()) != null) {
                ++expected;
            }
            AtomicInteger pending = new AtomicInteger(expected);
            Operation.CompletionHandler ch = (o, e) -> {
                int r = pending.decrementAndGet();
                if (r != 0) {
                    return;
                }
                this.performMaintenanceStage(post, nextStage);
            };
            if (c != null) {
                c.handleMaintenance(Operation.createPost(null).setCompletion(ch));
            }
            if (l != null) {
                l.handleMaintenance(Operation.createPost(null).setCompletion(ch));
            }
            if (sl != null) {
                sl.handleMaintenance(Operation.createPost(null).setCompletion(ch));
            }
        }
        catch (Throwable e2) {
            this.log(Level.WARNING, "Exception: %s", Utils.toString(e2));
            this.performMaintenanceStage(post, nextStage);
        }
    }

    private void performPendingOperationMaintenance() {
        long now = Utils.getNowMicrosUtc();
        Iterator<Operation> startOpsIt = this.pendingStartOperations.iterator();
        this.checkOperationExpiration(now, startOpsIt);
        for (SortedSet<Operation> ops : this.pendingServiceAvailableCompletions.values()) {
            Iterator<Operation> it = ops.iterator();
            this.checkOperationExpiration(now, it);
        }
        Iterator it = this.pendingOperationsForRetry.iterator();
        while (it.hasNext()) {
            Operation o = (Operation)it.next();
            if (this.isStopping()) {
                o.fail(new CancellationException());
                return;
            }
            it.remove();
            this.handleRequest(null, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performNodeSelectorChangeMaintenance(Operation post, long now, MaintenanceStage nextStage, boolean isCheckRequired) {
        if (isCheckRequired && this.checkAndScheduleNodeSelectorSynch(post, nextStage)) {
            return;
        }
        try {
            Iterator<Map.Entry<String, NodeGroupService.NodeGroupState>> it = this.pendingNodeSelectorsForFactorySynch.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, NodeGroupService.NodeGroupState> e = it.next();
                it.remove();
                this.performNodeSelectorChangeMaintenance(e);
            }
        }
        finally {
            this.performMaintenanceStage(post, nextStage);
        }
    }

    private boolean checkAndScheduleNodeSelectorSynch(Operation post, MaintenanceStage nextStage) {
        boolean hasSynchOccuredAtLeastOnce = false;
        for (Long l : this.synchronizationTimes.values()) {
            if (l == null || l <= 0L) continue;
            hasSynchOccuredAtLeastOnce = true;
        }
        if (!hasSynchOccuredAtLeastOnce) {
            return false;
        }
        HashSet<String> selectorPathsToSynch = new HashSet<String>();
        for (Map.Entry<String, Long> entry : this.synchronizationRequiredServices.entrySet()) {
            String selectorPath;
            Long selectorSynchTime;
            Long lastSynchTime = entry.getValue();
            String link = entry.getKey();
            Service s = this.findService(link, true);
            if (s == null || s.getProcessingStage() != Service.ProcessingStage.AVAILABLE || (selectorSynchTime = this.synchronizationTimes.get(selectorPath = s.getPeerNodeSelectorPath())) == null || lastSynchTime >= selectorSynchTime) continue;
            this.log(Level.FINE, "Service %s started at %d, last synch at %d", link, lastSynchTime, selectorSynchTime);
            selectorPathsToSynch.add(s.getPeerNodeSelectorPath());
        }
        if (selectorPathsToSynch.isEmpty()) {
            return false;
        }
        AtomicInteger atomicInteger = new AtomicInteger(selectorPathsToSynch.size());
        Operation.CompletionHandler completionHandler = (o, e) -> {
            if (e != null) {
                this.log(Level.WARNING, "skipping synchronization, error: %s", Utils.toString(e));
                this.performMaintenanceStage(post, nextStage);
                return;
            }
            int r = pending.decrementAndGet();
            if (r != 0) {
                return;
            }
            this.performNodeSelectorChangeMaintenance(post, Utils.getNowMicrosUtc(), nextStage, false);
        };
        for (String path : selectorPathsToSynch) {
            Operation synch = Operation.createPost(this.getUri()).setCompletion(completionHandler);
            this.scheduleNodeGroupChangeMaintenance(path, synch);
        }
        return true;
    }

    private void performNodeSelectorChangeMaintenance(Map.Entry<String, NodeGroupService.NodeGroupState> entry) {
        String link;
        String nodeSelectorPath = entry.getKey();
        Long selectorSynchTime = this.synchronizationTimes.get(nodeSelectorPath);
        NodeGroupService.NodeGroupState ngs = entry.getValue();
        long now = Utils.getNowMicrosUtc();
        for (Map.Entry<String, Long> en : this.synchronizationActiveServices.entrySet()) {
            link = en.getKey();
            Service s = this.findService(link, true);
            if (s == null) continue;
            long delta = now - en.getValue();
            boolean shouldLog = false;
            if (delta > this.state.operationTimeoutMicros) {
                s.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
                s.adjustStat("maintenanceForNodeGroupDelayedCount", 1.0);
                ServiceStats.ServiceStat st = s.getStat("maintenanceForNodeGroupDelayedCount");
                if (st != null && st.latestValue % 10.0 == 0.0) {
                    shouldLog = true;
                }
            }
            long deltaSeconds = TimeUnit.MICROSECONDS.toSeconds(delta);
            if (shouldLog) {
                this.log(Level.WARNING, "Service %s has been synchronizing for %d seconds", link, deltaSeconds);
            }
            if ((long)this.state.peerSynchronizationTimeLimitSeconds >= deltaSeconds) continue;
            this.log(Level.WARNING, "Service %s has exceeded synchronization limit of %d", link, this.state.peerSynchronizationTimeLimitSeconds);
            this.synchronizationActiveServices.remove(link);
        }
        for (Map.Entry<String, Long> en : this.synchronizationRequiredServices.entrySet()) {
            String serviceSelectorPath;
            Service s;
            now = Utils.getNowMicrosUtc();
            if (this.isStopping()) {
                return;
            }
            link = en.getKey();
            Long lastSynchTime = en.getValue();
            if (lastSynchTime >= selectorSynchTime || (s = this.findService(link, true)) == null || !s.hasOption(Service.ServiceOption.FACTORY) || !s.hasOption(Service.ServiceOption.REPLICATION) || !nodeSelectorPath.equals(serviceSelectorPath = s.getPeerNodeSelectorPath())) continue;
            Operation maintOp = Operation.createPost(s.getUri()).setCompletion((o, e) -> {
                this.synchronizationActiveServices.remove(link);
                if (e != null) {
                    this.log(Level.WARNING, "Node group change maintenance failed for %s: %s", s.getSelfLink(), e.getMessage());
                }
                this.log(Level.FINE, "Synch done for selector %s, service %s", nodeSelectorPath, s.getSelfLink());
            });
            this.synchronizationRequiredServices.put(link, now);
            this.synchronizationActiveServices.put(link, now);
            ServiceMaintenanceRequest body = ServiceMaintenanceRequest.create();
            body.reasons.add(ServiceMaintenanceRequest.MaintenanceReason.NODE_GROUP_CHANGE);
            body.nodeGroupState = ngs;
            maintOp.setBodyNoCloning(body);
            long n = now;
            this.run(() -> {
                OperationContext.setAuthorizationContext(this.getSystemAuthorizationContext());
                this.log(Level.FINE, " Synchronizing %s (last:%d, sl: %d now:%d)", link, lastSynchTime, selectorSynchTime, n);
                s.adjustStat("maintenanceForNodeGroupChangeCount", 1.0);
                s.handleMaintenance(maintOp);
            });
        }
    }

    private void checkOperationExpiration(long now, Iterator<Operation> iterator) {
        Operation op;
        while (iterator.hasNext() && (op = iterator.next()) != null && op.getExpirationMicrosUtc() <= now) {
            iterator.remove();
            this.run(() -> op.fail(new TimeoutException(op.toString())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMemoryLimit(long deadlineMicros) {
        long memoryLimitLowMB = this.getServiceMemoryLimitMB(ROOT_PATH, ServiceHostState.MemoryLimitType.HIGH_WATERMARK);
        long memoryInUseMB = this.state.serviceCount * 4096L;
        boolean shouldPause = memoryLimitLowMB <= (memoryInUseMB /= 0x100000L);
        int pauseServiceCount = 0;
        for (Service service : this.attachedServices.values()) {
            String factoryPath;
            if (service.hasOption(Service.ServiceOption.FACTORY) || !ServiceHost.isServiceIndexed(service)) continue;
            ServiceDocument s = this.cachedServiceStates.get(service.getSelfLink());
            if (s != null) {
                if (this.state.serviceCacheClearDelayMicros + s.documentUpdateTimeMicros < Utils.getNowMicrosUtc()) {
                    this.clearCachedServiceState(service.getSelfLink());
                }
                if (this.state.lastMaintenanceTimeUtcMicros - s.documentUpdateTimeMicros < service.getMaintenanceIntervalMicros() * 2L) continue;
            }
            if (service.hasOption(Service.ServiceOption.PERIODIC_MAINTENANCE) || !shouldPause || !service.hasOption(Service.ServiceOption.FACTORY_ITEM) || this.isServiceStarting(service, service.getSelfLink())) continue;
            Service existing = this.pendingPauseServices.put(service.getSelfLink(), service);
            if (existing == null) {
                ++pauseServiceCount;
            }
            if ((factoryPath = UriUtils.getParentPath(service.getSelfLink())) != null) {
                this.serviceFactoriesUnderMemoryPressure.add(factoryPath);
            }
            if (deadlineMicros >= Utils.getNowMicrosUtc()) continue;
            break;
        }
        if (pauseServiceCount == 0) {
            return;
        }
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            this.state.serviceCount = this.attachedServices.size();
        }
        this.pauseServices();
    }

    boolean checkAndResumePausedService(Operation inboundOp) {
        String key = inboundOp.getUri().getPath();
        if (ServiceHost.isHelperServicePath(key)) {
            key = UriUtils.getParentPath(key);
        }
        String factoryPath = UriUtils.getParentPath(key);
        Service factoryService = null;
        if (factoryPath != null) {
            factoryService = this.findService(factoryPath);
        }
        if (factoryService != null && !this.serviceFactoriesUnderMemoryPressure.contains(factoryPath) && !factoryService.hasOption(Service.ServiceOption.ON_DEMAND_LOAD)) {
            return false;
        }
        String path = key;
        if (factoryService == null) {
            this.failRequestServiceNotFound(inboundOp);
            return true;
        }
        if (this.isStopping() && inboundOp.hasPragmaDirective("xn-no-index-update") && inboundOp.getAction() == Service.Action.DELETE) {
            inboundOp.complete();
            return true;
        }
        if (inboundOp.hasPragmaDirective("xn-check-index")) {
            Service service = this.pendingPauseServices.remove(path);
            if (service != null) {
                this.log(Level.INFO, "Aborting service pause for %s", path);
                this.resumeService(path, service);
                return false;
            }
            if (inboundOp.getExpirationMicrosUtc() < Utils.getNowMicrosUtc()) {
                this.log(Level.WARNING, "Request to %s has expired", path);
                return false;
            }
            if (this.isStopping()) {
                return false;
            }
            service = this.attachedServices.get(path);
            if (service != null && service.getProcessingStage() == Service.ProcessingStage.PAUSED) {
                this.log(Level.INFO, "Service attached, but paused, aborting pause for %s", path);
                this.resumeService(path, service);
                return false;
            }
            inboundOp.removePragmaDirective("xn-check-index");
            long pendingPauseCount = this.pendingPauseServices.size();
            if (pendingPauseCount == 0L) {
                if (inboundOp.hasPragmaDirective("xn-no-queuing")) {
                    return false;
                }
                return this.checkAndOnDemandStartService(inboundOp, factoryService);
            }
            this.schedule(() -> {
                this.log(Level.INFO, "Retrying index lookup for %s, pending pause: %d", path, pendingPauseCount);
                this.checkAndResumePausedService(inboundOp);
            }, 1L, TimeUnit.SECONDS);
            return true;
        }
        inboundOp.addPragmaDirective("xn-check-index");
        Operation query = ServiceContextIndexService.createGet(this, path).setCompletion((o, e) -> {
            if (e != null) {
                this.log(Level.WARNING, "Failure checking if service paused: " + Utils.toString(e), new Object[0]);
                this.handleRequest(null, inboundOp);
                return;
            }
            if (!o.hasBody()) {
                this.handleRequest(null, inboundOp);
                return;
            }
            Service resumedService = (Service)o.getBodyRaw();
            this.resumeService(path, resumedService);
            this.handleRequest(null, inboundOp);
        });
        this.sendRequest(query.setReferer(this.getUri()));
        return true;
    }

    private boolean checkAndOnDemandStartService(Operation inboundOp, Service parentService) {
        Service childService;
        String link = inboundOp.getUri().getPath();
        if (!parentService.hasOption(Service.ServiceOption.FACTORY)) {
            this.failRequestServiceNotFound(inboundOp);
            return true;
        }
        if (!parentService.hasOption(Service.ServiceOption.ON_DEMAND_LOAD)) {
            inboundOp.addPragmaDirective("xn-no-queuing");
            return false;
        }
        FactoryService factoryService = (FactoryService)parentService;
        Operation onDemandPost = Operation.createPost(inboundOp.getUri());
        Operation.CompletionHandler c = (o, e) -> {
            if (e != null) {
                inboundOp.setBodyNoCloning(o.getBodyRaw()).setStatusCode(o.getStatusCode());
                inboundOp.fail(e);
                return;
            }
            this.handleRequest(null, inboundOp);
        };
        onDemandPost.addPragmaDirective("xn-check-index").addPragmaDirective("xn-check-version").setReferer(inboundOp.getReferer()).setExpiration(inboundOp.getExpirationMicrosUtc()).setReplicationDisabled(true).setCompletion(c);
        this.log(Level.FINE, "On demand service start of %s", link);
        try {
            childService = factoryService.createServiceInstance();
        }
        catch (Throwable e1) {
            inboundOp.fail(e1);
            return true;
        }
        this.startService(onDemandPost, childService);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeService(String path, Service resumedService) {
        if (this.isStopping()) {
            return;
        }
        resumedService.setHost(this);
        resumedService.setProcessingStage(Service.ProcessingStage.AVAILABLE);
        ServiceHostState serviceHostState = this.state;
        synchronized (serviceHostState) {
            if (!this.attachedServices.containsKey(path)) {
                this.attachedServices.put(path, resumedService);
                ++this.state.serviceCount;
            }
        }
    }

    private void pauseServices() {
        if (this.isStopping()) {
            return;
        }
        int servicePauseCount = 0;
        for (Service s : this.pendingPauseServices.values()) {
            if (s.getProcessingStage() != Service.ProcessingStage.AVAILABLE) continue;
            try {
                s.setProcessingStage(Service.ProcessingStage.PAUSED);
            }
            catch (Throwable e2) {
                this.log(Level.INFO, "Failure setting stage to %s for %s: %s", new Object[]{Service.ProcessingStage.PAUSED, s.getSelfLink(), e2.getMessage()});
                continue;
            }
            ++servicePauseCount;
            String path = s.getSelfLink();
            this.sendRequest(ServiceContextIndexService.createPost(this, path, s).setReferer(this.getUri()).setCompletion((o, e) -> {
                if (e != null && !this.isStopping()) {
                    this.log(Level.WARNING, "Failure indexing service for pause: %s", Utils.toString(e));
                    this.resumeService(path, s);
                    return;
                }
                Service serviceEntry = this.pendingPauseServices.remove(path);
                if (serviceEntry == null && !this.isStopping()) {
                    this.log(Level.INFO, "aborting pause for %s", path);
                    this.resumeService(path, s);
                    this.processPendingServiceAvailableOperations(s, null);
                    return;
                }
                ServiceHostState serviceHostState = this.state;
                synchronized (serviceHostState) {
                    if (null != this.attachedServices.remove(path)) {
                        --this.state.serviceCount;
                    }
                }
            }));
        }
        this.log(Level.INFO, "Paused %d services, attached: %d", servicePauseCount, this.state.serviceCount);
    }

    private ServiceDocument getCachedServiceState(String servicePath) {
        ServiceDocument state = this.cachedServiceStates.get(servicePath);
        if (state == null) {
            return null;
        }
        if (state.documentExpirationTimeMicros > 0L && state.documentExpirationTimeMicros < Utils.getNowMicrosUtc()) {
            this.clearCachedServiceState(servicePath);
            return null;
        }
        return state;
    }

    private void clearCachedServiceState(String servicePath) {
        this.cachedServiceStates.remove(servicePath);
        Service s = this.attachedServices.get(servicePath);
        if (s == null) {
            return;
        }
        s.adjustStat("stateCacheClearCount", 1.0);
    }

    public ServiceHost setOperationTimeOutMicros(long timeoutMicros) {
        this.state.operationTimeoutMicros = timeoutMicros;
        return this;
    }

    public ServiceHost setServiceCacheClearDelayMicros(long delayMicros) {
        this.state.serviceCacheClearDelayMicros = delayMicros;
        return this;
    }

    public long getServiceCacheClearDelayMicros() {
        return this.state.serviceCacheClearDelayMicros;
    }

    public ServiceHost setProcessOwner(boolean isOwner) {
        this.state.isProcessOwner = isOwner;
        return this;
    }

    public boolean isProcessOwner() {
        return this.state.isProcessOwner;
    }

    public void setListener(ServiceRequestListener listener) {
        if (this.isStarted() || this.httpListener != null) {
            throw new IllegalStateException("Already started");
        }
        this.httpListener = listener;
    }

    public ServiceRequestListener getSecureListener() {
        return this.httpsListener;
    }

    public void setSecureListener(ServiceRequestListener listener) {
        if (this.isStarted() || this.httpsListener != null) {
            throw new IllegalStateException("Already started");
        }
        this.httpsListener = listener;
    }

    public ServiceRequestListener getListener() {
        return this.httpListener;
    }

    public ServiceClient getClient() {
        return this.client;
    }

    public void setClient(ServiceClient client) {
        this.client = client;
    }

    public long getMaintenanceIntervalMicros() {
        return this.state.maintenanceIntervalMicros;
    }

    void saveServiceState(Service s, Operation op, ServiceDocument state) {
        if (state == null) {
            op.fail(new IllegalArgumentException("linkedState is required"));
            return;
        }
        if (!op.isFromReplication()) {
            String string = state.documentAuthPrincipalLink = op.getAuthorizationContext() != null ? op.getAuthorizationContext().getClaims().getSubject() : null;
        }
        if (this.transactionService != null) {
            state.documentTransactionId = op.getTransactionId();
        }
        state.documentUpdateAction = op.getAction().toString();
        if (!ServiceHost.isServiceIndexed(s)) {
            this.cacheServiceState(s, state, op);
            op.complete();
            return;
        }
        Service indexService = this.documentIndexService;
        if (indexService == null) {
            op.fail(new IllegalStateException("document index service is required"));
            return;
        }
        UpdateIndexRequest body = new UpdateIndexRequest();
        body.document = state;
        body.description = this.buildDocumentDescription(s);
        try {
            this.cacheServiceState(s, state, op);
        }
        catch (Throwable e1) {
            op.fail(e1);
            return;
        }
        Operation post = Operation.createPost(indexService.getUri()).setBodyNoCloning(body).setCompletion((o, e) -> {
            if (e != null) {
                this.clearCachedServiceState(s.getSelfLink());
                op.fail(e);
                return;
            }
            op.complete();
        });
        indexService.handleRequest(post);
    }

    private NodeSelectorService findNodeSelectorService(String path, Operation request) {
        Service s;
        if (path == null) {
            path = "/core/node-selectors/default";
        }
        if ((s = this.findService(path)) == null) {
            request.fail(new ServiceNotFoundException());
            return null;
        }
        if (!(s instanceof NodeSelectorService)) {
            String msg = String.format("path '%s' (%s) is not a node selector service", path, s.getClass().getName());
            request.fail(new IllegalArgumentException(msg));
            return null;
        }
        return (NodeSelectorService)s;
    }

    public void broadcastRequest(String selectorPath, boolean excludeThisHost, Operation request) {
        this.broadcastRequest(selectorPath, null, excludeThisHost, request);
    }

    public void broadcastRequest(String selectorPath, String key, boolean excludeThisHost, Operation request) {
        if (this.isStopping()) {
            request.fail(new CancellationException());
            return;
        }
        if (selectorPath == null) {
            throw new IllegalArgumentException("selectorPath is required");
        }
        if (request == null) {
            throw new IllegalArgumentException("request is required");
        }
        this.prepareRequest(request);
        NodeSelectorService nss = this.findNodeSelectorService(selectorPath, request);
        if (nss == null) {
            return;
        }
        NodeSelectorService.SelectAndForwardRequest req = new NodeSelectorService.SelectAndForwardRequest();
        req.options = EnumSet.of(NodeSelectorService.SelectAndForwardRequest.ForwardingOption.BROADCAST);
        if (excludeThisHost) {
            req.options.add(NodeSelectorService.SelectAndForwardRequest.ForwardingOption.EXCLUDE_ENTRY_NODE);
        }
        req.key = key;
        req.targetPath = request.getUri().getPath();
        req.targetQuery = request.getUri().getQuery();
        nss.selectAndForward(request, req);
    }

    public void selectOwner(String selectorPath, String key, Operation op) {
        if (this.isStopping()) {
            op.fail(new CancellationException());
            return;
        }
        NodeSelectorService.SelectAndForwardRequest body = new NodeSelectorService.SelectAndForwardRequest();
        body.key = key;
        NodeSelectorService nss = this.findNodeSelectorService(selectorPath, op);
        if (nss == null) {
            return;
        }
        nss.selectAndForward(op, body);
    }

    public void forwardRequest(String groupPath, Operation request) {
        this.forwardRequest(groupPath, null, request);
    }

    public void forwardRequest(String selectorPath, String key, Operation request) {
        if (this.isStopping()) {
            request.fail(new CancellationException());
            return;
        }
        NodeSelectorService nss = this.findNodeSelectorService(selectorPath, request);
        if (nss == null) {
            return;
        }
        this.prepareRequest(request);
        NodeSelectorService.SelectAndForwardRequest body = new NodeSelectorService.SelectAndForwardRequest();
        body.targetPath = request.getUri().getPath();
        body.targetQuery = request.getUri().getQuery();
        body.key = key;
        body.options = EnumSet.of(NodeSelectorService.SelectAndForwardRequest.ForwardingOption.UNICAST);
        nss.selectAndForward(request, body);
    }

    public void replicateRequest(EnumSet<Service.ServiceOption> serviceOptions, ServiceDocument state, String selectorPath, String selectionKey, Operation op) {
        if (this.isStopping()) {
            op.fail(new CancellationException());
            return;
        }
        if (state == null) {
            op.fail(new IllegalStateException("state is required"));
            return;
        }
        NodeSelectorService nss = this.findNodeSelectorService(selectorPath, op);
        if (nss == null) {
            return;
        }
        state.documentOwner = this.getId();
        NodeSelectorService.SelectAndForwardRequest req = new NodeSelectorService.SelectAndForwardRequest();
        req.key = selectionKey;
        req.targetPath = op.getUri().getPath();
        req.targetQuery = op.getUri().getQuery();
        req.options = EnumSet.of(NodeSelectorService.SelectAndForwardRequest.ForwardingOption.BROADCAST, NodeSelectorService.SelectAndForwardRequest.ForwardingOption.REPLICATE);
        req.serviceOptions = serviceOptions;
        req.linkedState = state;
        nss.selectAndForward(op, req);
    }

    public void queryServiceUris(String servicePath, Operation get) {
        ServiceDocumentQueryResult r = new ServiceDocumentQueryResult();
        boolean doPrefixMatch = servicePath.endsWith("*");
        servicePath = servicePath.replace("*", ROOT_PATH);
        for (Service s : this.attachedServices.values()) {
            if (s.getProcessingStage() != Service.ProcessingStage.AVAILABLE || s.hasOption(Service.ServiceOption.UTILITY)) continue;
            String path = s.getSelfLink();
            if (doPrefixMatch ? !path.startsWith(servicePath) : !path.equals(servicePath)) continue;
            r.documentLinks.add(path);
        }
        r.documentOwner = this.getId();
        get.setBodyNoCloning(r).complete();
    }

    public void queryServiceUris(EnumSet<Service.ServiceOption> options, boolean matchAllOptions, Operation get) {
        ServiceDocumentQueryResult r = new ServiceDocumentQueryResult();
        block0: for (Service s : this.attachedServices.values()) {
            if (s.getProcessingStage() != Service.ProcessingStage.AVAILABLE || s.hasOption(Service.ServiceOption.UTILITY)) continue;
            String servicePath = s.getSelfLink();
            if (matchAllOptions) {
                boolean hasAllOptions = true;
                for (Service.ServiceOption option : options) {
                    if (option == null || s.hasOption(option)) continue;
                    hasAllOptions = false;
                    break;
                }
                if (!hasAllOptions) continue;
                r.documentLinks.add(servicePath);
                continue;
            }
            for (Service.ServiceOption option : options) {
                if (option == null || !s.hasOption(option)) continue;
                r.documentLinks.add(servicePath);
                continue block0;
            }
        }
        r.documentOwner = this.getId();
        get.setBodyNoCloning(r).complete();
    }

    ServiceDocumentDescription buildDocumentDescription(String servicePath) {
        Service s = this.findService(servicePath);
        if (s == null) {
            return null;
        }
        return this.buildDocumentDescription(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceDocumentDescription buildDocumentDescription(Service s) {
        Class<? extends ServiceDocument> serviceStateClass = s.getStateType();
        if (serviceStateClass == null) {
            return null;
        }
        String serviceTypeName = s.getClass().getCanonicalName();
        Map<String, ServiceDocumentDescription> map = this.descriptionCache;
        synchronized (map) {
            ServiceDocumentDescription desc = this.descriptionCache.get(serviceTypeName);
            if (desc != null) {
                return desc;
            }
            desc = this.descriptionBuilder.buildDescription(serviceStateClass, s.getOptions(), RequestRouter.findRequestRouter(s.getOperationProcessingChain()));
            this.descriptionCache.put(serviceTypeName, desc);
            ServiceDocumentDescription augmentedDesc = s.getDocumentTemplate().documentDescription;
            if (augmentedDesc != null) {
                desc = augmentedDesc;
            }
            this.descriptionCache.put(serviceTypeName, desc);
            return desc;
        }
    }

    public URI getPublicUri() {
        if (this.state.publicUri == null) {
            return this.getUri();
        }
        return this.state.publicUri;
    }

    public URI getUri() {
        if (this.cachedUri == null) {
            boolean isSecureConnectionOnly = this.getCurrentHttpScheme() == HttpScheme.HTTPS_ONLY;
            String scheme = isSecureConnectionOnly ? "https" : "http";
            int port = isSecureConnectionOnly ? this.getSecurePort() : this.getPort();
            this.cachedUri = UriUtils.buildUri(scheme, this.getPreferredAddress(), port, ROOT_PATH, null);
        }
        return this.cachedUri;
    }

    public URI getSecureUri() {
        return UriUtils.buildUri("https", this.getUri().getHost(), this.getSecurePort(), ROOT_PATH, null);
    }

    public String getPreferredAddress() {
        if (this.info == null || this.info.ipAddresses == null || this.info.ipAddresses.isEmpty()) {
            return this.state.bindAddress == null ? "127.0.0.1" : this.state.bindAddress;
        }
        return this.info.ipAddresses.get(0);
    }

    protected Signer getTokenSigner() {
        return this.tokenSigner;
    }

    protected Verifier getTokenVerifier() {
        return this.tokenVerifier;
    }

    public void cacheAuthorizationContext(Service s, String token, Operation.AuthorizationContext ctx) {
        if (!this.isPrivilegedService(s)) {
            throw new RuntimeException("Service not allowed to cache authorization token");
        }
        this.authorizationContextCache.put(token, ctx);
    }

    public Operation.AuthorizationContext getAuthorizationContext(Service s, String token) {
        if (!this.isPrivilegedService(s)) {
            throw new RuntimeException("Service not allowed to retrieve authorization token");
        }
        return this.authorizationContextCache.get(token);
    }

    private void populateAuthorizationContext(Operation op) {
        Operation.AuthorizationContext ctx = this.getAuthorizationContext(op);
        if (ctx == null) {
            ctx = this.getGuestAuthorizationContext();
        }
        op.setAuthorizationContext(ctx);
    }

    private Operation.AuthorizationContext createAuthorizationContext(String userLink) {
        String token;
        Claims.Builder cb = new Claims.Builder();
        cb.setIssuer("dcp");
        cb.setSubject(userLink);
        Calendar cal = Calendar.getInstance();
        cal.set(9999, 11, 31);
        cb.setExpirationTime(TimeUnit.MILLISECONDS.toMicros(cal.getTimeInMillis()));
        Claims claims = (Claims)cb.getResult();
        try {
            token = this.getTokenSigner().sign(claims);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        Operation.AuthorizationContext.Builder ab = Operation.AuthorizationContext.Builder.create();
        ab.setClaims(claims);
        ab.setToken(token);
        ab.setPropagateToClient(false);
        return ab.getResult();
    }

    protected Operation.AuthorizationContext getSystemAuthorizationContext() {
        Operation.AuthorizationContext ctx = this.systemAuthorizationContext;
        if (ctx == null) {
            this.systemAuthorizationContext = ctx = this.createAuthorizationContext(SystemUserService.SELF_LINK);
        }
        return ctx;
    }

    protected Operation.AuthorizationContext getGuestAuthorizationContext() {
        Operation.AuthorizationContext ctx = this.guestAuthorizationContext;
        if (ctx == null) {
            this.guestAuthorizationContext = ctx = this.createAuthorizationContext(GuestUserService.SELF_LINK);
        }
        return ctx;
    }

    protected void addPrivilegedService(Class<? extends Service> serviceType) {
        this.privilegedServiceTypes.put(serviceType.getName(), serviceType);
    }

    protected boolean isPrivilegedService(Service service) {
        boolean result = false;
        for (Class<? extends Service> privilegedService : this.privilegedServiceTypes.values()) {
            if (!service.getClass().equals(privilegedService)) continue;
            result = true;
            break;
        }
        return result;
    }

    void scheduleServiceOptionToggleMaintenance(String path, EnumSet<Service.ServiceOption> newOptions, EnumSet<Service.ServiceOption> removedOptions) {
        Service s = this.findService(path);
        if (s == null || s.getProcessingStage() == Service.ProcessingStage.STOPPED) {
            return;
        }
        ServiceMaintenanceRequest body = ServiceMaintenanceRequest.create();
        body.reasons.add(ServiceMaintenanceRequest.MaintenanceReason.SERVICE_OPTION_TOGGLE);
        if (newOptions != null && newOptions.contains((Object)Service.ServiceOption.DOCUMENT_OWNER)) {
            body.reasons.add(ServiceMaintenanceRequest.MaintenanceReason.NODE_GROUP_CHANGE);
        }
        if (removedOptions != null && removedOptions.contains((Object)Service.ServiceOption.DOCUMENT_OWNER)) {
            body.reasons.add(ServiceMaintenanceRequest.MaintenanceReason.NODE_GROUP_CHANGE);
        }
        if (body.reasons.contains((Object)ServiceMaintenanceRequest.MaintenanceReason.NODE_GROUP_CHANGE)) {
            s.adjustStat("maintenanceForNodeGroupChangeCount", 1.0);
        }
        body.configUpdate = new ServiceConfigUpdateRequest();
        body.configUpdate.addOptions = newOptions;
        body.configUpdate.removeOptions = removedOptions;
        this.run(() -> {
            OperationContext.setAuthorizationContext(this.getSystemAuthorizationContext());
            s.handleMaintenance(Operation.createPost(s.getUri()).setBody(body));
        });
    }

    protected HttpScheme getCurrentHttpScheme() {
        boolean isListeningHttps;
        boolean isListeningHttp = this.httpListener != null && this.httpListener.isListening();
        boolean bl = isListeningHttps = this.httpsListener != null && this.httpsListener.isListening();
        if (!isListeningHttp && !isListeningHttps) {
            return HttpScheme.NONE;
        }
        if (isListeningHttp && isListeningHttps) {
            return HttpScheme.HTTP_AND_HTTPS;
        }
        return isListeningHttp ? HttpScheme.HTTP_ONLY : HttpScheme.HTTPS_ONLY;
    }

    private static enum MaintenanceStage {
        UTILS,
        MEMORY,
        IO,
        NODE_SELECTORS,
        SERVICE;

    }

    public static enum HttpScheme {
        HTTP_ONLY,
        HTTPS_ONLY,
        HTTP_AND_HTTPS,
        NONE;

    }

    public static class ServiceHostState
    extends ServiceDocument {
        public static final long DEFAULT_MAINTENANCE_INTERVAL_MICROS = TimeUnit.SECONDS.toMicros(1L);
        public static final long DEFAULT_OPERATION_TIMEOUT_MICROS = TimeUnit.SECONDS.toMicros(60L);
        public String bindAddress;
        public int httpPort;
        public int httpsPort;
        public URI publicUri;
        public long maintenanceIntervalMicros = DEFAULT_MAINTENANCE_INTERVAL_MICROS;
        public long operationTimeoutMicros = DEFAULT_OPERATION_TIMEOUT_MICROS;
        public long serviceCacheClearDelayMicros = DEFAULT_OPERATION_TIMEOUT_MICROS;
        public String operationTracingLevel;
        public SslClientAuthMode sslClientAuthMode;
        public URI storageSandboxFileReference;
        public URI resourceSandboxFileReference;
        public URI privateKeyFileReference;
        public String privateKeyPassphrase;
        public URI certificateFileReference;
        public URI documentIndexReference;
        public URI authorizationServiceReference;
        public URI transactionServiceReference;
        public String id;
        public boolean isPeerSynchronizationEnabled;
        public int peerSynchronizationTimeLimitSeconds;
        public boolean isAuthorizationEnabled;
        public transient boolean isStarted;
        public transient boolean isStopping;
        public SystemHostInfo systemInfo;
        public long lastMaintenanceTimeUtcMicros;
        public boolean isProcessOwner;
        public boolean isServiceStateCaching = true;
        public Properties codeProperties;
        public long serviceCount;
        public Map<String, Double> relativeMemoryLimits = new ConcurrentSkipListMap<String, Double>();
        public Map<String, RequestRateInfo> requestRateLimits = new ConcurrentSkipListMap<String, RequestRateInfo>();
        private transient TreeSet<String> operationTracingLinkExclusionList = new TreeSet<String>(Arrays.asList("/core/node-groups", "/core/ui/default", "/core/node-groups/default", "/core/node-selectors/default", "/core/document-index", "/core/operation-index", ServiceUriPaths.CORE_QUERY_TASKS));
        public String[] initialPeerNodes;

        public static enum SslClientAuthMode {
            NONE,
            WANT,
            NEED;

        }

        public static enum MemoryLimitType {
            LOW_WATERMARK,
            HIGH_WATERMARK,
            EXACT;

        }
    }

    public static class RequestRateInfo {
        public double limit;
        public AtomicInteger count = new AtomicInteger();
        public long startTimeMicros;
    }

    public static class Arguments {
        public int port = 8000;
        public int securePort;
        public ServiceHostState.SslClientAuthMode sslClientAuthMode = ServiceHostState.SslClientAuthMode.NONE;
        public Path keyFile;
        public String keyPassphrase;
        public Path certificateFile;
        public Path sandbox = DEFAULT_SANDBOX;
        public String bindAddress = "127.0.0.1";
        public String publicUri;
        public String[] peerNodes;
        public String id;
        public int perFactoryPeerSynchronizationLimitSeconds = (int)TimeUnit.MINUTES.toSeconds(10L);
        public boolean isPeerSynchronizationEnabled = true;
        public boolean isAuthorizationEnabled = false;
        public Path resourceSandbox;
    }

    public static class ServiceNotFoundException
    extends IllegalStateException {
        private static final long serialVersionUID = 663670123267539178L;
    }

    public static class ServiceAlreadyStartedException
    extends IllegalStateException {
        private static final long serialVersionUID = -1444810129515584386L;

        public ServiceAlreadyStartedException(String servicePath) {
            super("Service already started: " + servicePath);
        }

        public ServiceAlreadyStartedException(String servicePath, Service.ProcessingStage stage) {
            super("Service already started: " + servicePath + " stage: " + (Object)((Object)stage));
        }
    }
}

