/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.ODataQueryVisitor;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.ServiceDocumentDescription;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.services.common.QueryTask;

public class ODataUtils {
    public static QueryTask toQuery(Operation op) {
        String oDataFilterParam = UriUtils.getODataFilterParamValue(op.getUri());
        if (oDataFilterParam == null) {
            op.fail(new IllegalArgumentException("filter is required: " + op.getUri().getQuery()));
            return null;
        }
        QueryTask.Query q = new ODataQueryVisitor().toQuery(oDataFilterParam);
        Integer top = UriUtils.getODataTopParamValue(op.getUri());
        Integer skip = UriUtils.getODataSkipParamValue(op.getUri());
        UriUtils.ODataOrderByTuple orderBy = UriUtils.getODataOrderByParamValue(op.getUri());
        QueryTask task = new QueryTask();
        task.setDirect(true);
        task.querySpec = new QueryTask.QuerySpecification();
        task.querySpec.query.addBooleanClause(q);
        task.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
        if (orderBy != null) {
            task.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.SORT);
            task.querySpec.sortOrder = orderBy.order == UriUtils.ODataOrder.ASC ? QueryTask.QuerySpecification.SortOrder.ASC : QueryTask.QuerySpecification.SortOrder.DESC;
            task.querySpec.sortTerm = new QueryTask.QueryTerm();
            task.querySpec.sortTerm.propertyType = ServiceDocumentDescription.TypeName.STRING;
            task.querySpec.sortTerm.propertyName = orderBy.propertyName;
        }
        if (top != null) {
            task.querySpec.options.add(QueryTask.QuerySpecification.QueryOption.TOP_RESULTS);
            task.querySpec.resultLimit = top;
        }
        if (skip != null) {
            op.fail(new IllegalArgumentException("$skip is not supported"));
            return null;
        }
        if (q == null) {
            op.fail(new IllegalArgumentException("$filter is required" + op.getUri().getQuery()));
            return null;
        }
        return task;
    }
}

