/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.FileUtils;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.LuceneDocumentIndexService;
import com.vmware.xenon.services.common.OperationIndexService;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;

public class ServiceHostManagementService
extends StatefulService {
    public static final String SELF_LINK = UriUtils.buildUriPath("/core/management");

    public ServiceHostManagementService() {
        super(ServiceHost.ServiceHostState.class);
        super.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
    }

    @Override
    public void handleGet(Operation get) {
        this.getHost().updateSystemInfo(false);
        ServiceHost.ServiceHostState s = this.getHost().getState();
        s.documentSelfLink = this.getSelfLink();
        s.documentKind = Utils.buildKind(ServiceHost.ServiceHostState.class);
        s.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
        get.setBody(s).complete();
    }

    @Override
    public void handlePatch(Operation patch) {
        try {
            if (!patch.hasBody()) {
                throw new IllegalArgumentException("empty body");
            }
            patch.setStatusCode(304);
            ConfigureOperationTracingRequest tr = patch.getBody(ConfigureOperationTracingRequest.class);
            if (tr.kind.equals(ConfigureOperationTracingRequest.KIND)) {
                this.handleOperationTracingRequest(tr, patch);
                return;
            }
            BackupRequest br = patch.getBody(BackupRequest.class);
            if (br.kind.equals(BackupRequest.KIND)) {
                this.handleBackupRequest(br, patch);
                return;
            }
            RestoreRequest rr = patch.getBody(RestoreRequest.class);
            if (rr.kind.equals(RestoreRequest.KIND)) {
                this.handleRestoreRequest(rr, patch);
                return;
            }
            SynchronizeWithPeersRequest sr = patch.getBody(SynchronizeWithPeersRequest.class);
            if (sr.kind.equals(SynchronizeWithPeersRequest.KIND)) {
                this.handleSynchronizeWithPeersRequest(sr, patch);
                return;
            }
            throw new IllegalArgumentException("unknown request");
        }
        catch (Throwable t) {
            patch.fail(t);
            return;
        }
    }

    @Override
    public void handleDelete(Operation delete) {
        this.logInfo("Received shutdown request from %s", delete.getReferer());
        boolean isProcessOwner = this.getHost().isProcessOwner();
        delete.setStatusCode(202);
        delete.complete();
        this.getHost().stop();
        if (isProcessOwner) {
            System.exit(0);
        }
    }

    private void handleSynchronizeWithPeersRequest(SynchronizeWithPeersRequest rr, Operation patch) {
        if (rr.nodeSelectorPath == null) {
            patch.fail(new IllegalArgumentException("nodeSelectorPath is required"));
            return;
        }
        if (this.getHost().getServiceStage(rr.nodeSelectorPath) == null) {
            patch.fail(new IllegalArgumentException(rr.nodeSelectorPath + " is not started on this host"));
            return;
        }
        this.getHost().scheduleNodeGroupChangeMaintenance(rr.nodeSelectorPath);
        patch.complete();
    }

    private void handleOperationTracingRequest(ConfigureOperationTracingRequest req, Operation op) throws Throwable {
        URI operationTracingServiceUri = UriUtils.buildUri(this.getHost(), "/core/operation-index");
        Operation.CompletionHandler serviceCompletion = (o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            boolean start = req.enable == OperationTracingEnable.START;
            this.logInfo("%s %s", start ? "Started" : "Stopped", operationTracingServiceUri.toString());
            this.getHost().setOperationTracingLevel(start ? Level.ALL : Level.OFF);
            op.complete();
        };
        if (req.enable == OperationTracingEnable.START) {
            OperationIndexService operationService = new OperationIndexService();
            this.getHost().startService(Operation.createPost(operationTracingServiceUri).setCompletion(serviceCompletion), operationService);
        } else {
            this.sendRequest(Operation.createDelete(operationTracingServiceUri).setCompletion(serviceCompletion));
        }
    }

    private void handleBackupRequest(BackupRequest req, Operation op) {
        URI indexServiceUri = UriUtils.buildUri(this.getHost(), "/core/document-index");
        LuceneDocumentIndexService.BackupRequest luceneBackup = new LuceneDocumentIndexService.BackupRequest();
        luceneBackup.documentKind = LuceneDocumentIndexService.BackupRequest.KIND;
        Operation.CompletionHandler c = (o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            LuceneDocumentIndexService.BackupRequest r = o.getBody(LuceneDocumentIndexService.BackupRequest.class);
            op.nestCompletion((ox, ex) -> {
                if (ex != null) {
                    op.fail(ex);
                    return;
                }
                File f = new File(r.backupFile);
                if (!f.delete()) {
                    ox.fail(new IllegalStateException("failed to delete backup file" + r.backupFile.toString()));
                }
                ox.complete();
            });
            try {
                this.uploadFile(op, r.backupFile, req);
            }
            catch (Exception ex2) {
                op.fail(ex2);
            }
        };
        this.sendRequest(Operation.createPatch(indexServiceUri).setBody(luceneBackup).setCompletion(c));
    }

    private void uploadFile(Operation op, URI file, BackupRequest req) throws Exception {
        File f = new File(file);
        Operation post = Operation.createPost(req.destination).setReferer(op.getReferer()).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            op.complete();
        });
        FileUtils.putFile(this.getHost().getClient(), post, f);
    }

    private void handleRestoreRequest(RestoreRequest req, Operation op) {
        URI indexServiceUri = UriUtils.buildUri(this.getHost(), "/core/document-index");
        try {
            File fileToDownload = File.createTempFile("restore-" + Utils.getNowMicrosUtc(), ".zip", null);
            URI backupFileUri = fileToDownload.toURI();
            Operation.CompletionHandler c = (o, e) -> {
                if (e != null) {
                    op.fail(e);
                    return;
                }
                LuceneDocumentIndexService.RestoreRequest luceneRestore = new LuceneDocumentIndexService.RestoreRequest();
                luceneRestore.documentKind = LuceneDocumentIndexService.RestoreRequest.KIND;
                luceneRestore.backupFile = backupFileUri;
                op.nestCompletion((ox, ex) -> {
                    if (ex != null) {
                        op.fail(ex);
                        return;
                    }
                    File f = new File(luceneRestore.backupFile);
                    if (!f.delete()) {
                        ox.fail(new IllegalStateException("failed to delete backup file" + luceneRestore.backupFile.toString()));
                    }
                    ox.complete();
                });
                this.sendRequest(Operation.createPatch(indexServiceUri).setBody(luceneRestore).setCompletion((ox, ex) -> {
                    if (ex != null) {
                        op.fail(ex);
                        return;
                    }
                    op.complete();
                }));
            };
            Operation downloadFileOp = Operation.createGet(req.destination).setReferer(op.getReferer()).setCompletion(c);
            FileUtils.getFile(this.getHost().getClient(), downloadFileOp, fileToDownload);
        }
        catch (IOException e2) {
            op.fail(e2);
        }
    }

    public static class RestoreRequest {
        public static final String KIND = Utils.buildKind(RestoreRequest.class);
        public String Bearer;
        public URI destination;
        public String kind;
    }

    public static class BackupRequest {
        public static final String KIND = Utils.buildKind(BackupRequest.class);
        public String Bearer;
        public URI destination;
        public String kind;
    }

    public static class ConfigureOperationTracingRequest {
        public static final String KIND = Utils.buildKind(ConfigureOperationTracingRequest.class);
        public OperationTracingEnable enable = OperationTracingEnable.START;
        public String kind;
    }

    public static class SynchronizeWithPeersRequest {
        public static final String KIND = Utils.buildKind(SynchronizeWithPeersRequest.class);
        public String nodeSelectorPath;
        public String kind;

        public static SynchronizeWithPeersRequest create(String path) {
            SynchronizeWithPeersRequest r = new SynchronizeWithPeersRequest();
            r.kind = KIND;
            r.nodeSelectorPath = path;
            return r;
        }
    }

    public static enum OperationTracingEnable {
        START,
        STOP;

    }
}

