/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.ProcessState;
import java.io.File;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class ProcessService
extends StatefulService {
    static final String STAT_NAME_START_COUNT = "startCount";
    static final String STAT_NAME_START_DELAY_MILLIS = "startDelayMillis";
    static final long MAX_START_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(120L);
    static final long STABLE_THRESHOLD_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    static final int LINES = 100;
    private long startDelayExp = 0L;
    private long startDelayMillis = 0L;
    private Process process;
    private int processExitStatus;
    private long processStartTimeMillis;
    private long processStopTimeMillis;

    public ProcessService() {
        super(ProcessState.class);
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
        super.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
    }

    protected boolean stopProcess() {
        if (this.process == null) {
            return false;
        }
        if (this.process.isAlive()) {
            this.process.destroyForcibly();
            while (this.process.isAlive()) {
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.processExitStatus = this.process.exitValue();
        this.processStopTimeMillis = new Date().getTime();
        this.process = null;
        return true;
    }

    protected void startProcess(Operation op, ProcessState state) {
        if (this.stopProcess()) {
            if (this.processStopTimeMillis - this.processStartTimeMillis >= STABLE_THRESHOLD_MILLIS) {
                this.startDelayExp = 0L;
            }
            this.startDelayMillis = TimeUnit.SECONDS.toMillis((int)Math.pow(2.0, this.startDelayExp) - 1);
            if (this.startDelayMillis < MAX_START_DELAY_MILLIS) {
                ++this.startDelayExp;
            } else {
                this.startDelayMillis = MAX_START_DELAY_MILLIS;
            }
            if (state.logLink != null && !state.logLink.isEmpty()) {
                Operation getLog = Operation.createGet(UriUtils.buildUri(this.getHost(), state.logLink, "lineCount=100")).setCompletion((o, e) -> {
                    if (e != null) {
                        this.logWarning("Unable to get logs: %s", e.getMessage());
                        return;
                    }
                    String json = Utils.toJsonHtml(o.getBodyRaw());
                    this.logInfo("%s", json);
                });
                this.sendRequest(getLog);
            }
            this.setStat(STAT_NAME_START_DELAY_MILLIS, (double)this.startDelayMillis);
            this.logWarning("Process %s exited with status %d, restarting in %ds", state.arguments[0], this.processExitStatus, TimeUnit.MILLISECONDS.toSeconds(this.startDelayMillis));
        }
        if (new Date().getTime() < this.processStopTimeMillis + this.startDelayMillis) {
            op.complete();
            return;
        }
        this.logInfo("Starting %s", state.arguments[0]);
        this.adjustStat(STAT_NAME_START_COUNT, 1.0);
        ProcessBuilder pb = new ProcessBuilder(state.arguments);
        if (state.logFile != null) {
            File file = new File(state.logFile);
            pb.redirectErrorStream(true);
            pb.redirectOutput(ProcessBuilder.Redirect.appendTo(file));
        }
        try {
            this.process = pb.start();
            this.processStartTimeMillis = new Date().getTime();
        }
        catch (Throwable e2) {
            this.logWarning("Failure starting %s (%s)", state.arguments[0], e2.toString());
            op.fail(e2);
            return;
        }
        op.complete();
    }

    @Override
    public void handleStart(Operation op) {
        ProcessState state = op.getBody(ProcessState.class);
        if (state.arguments.length == 0) {
            op.fail(new IllegalArgumentException("No arguments specified"));
            return;
        }
        if (!state.isRestartRequired) {
            this.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, false);
        }
        this.startProcess(op, state);
    }

    @Override
    public void handleDelete(Operation op) {
        this.stopProcess();
        op.complete();
    }

    @Override
    public void handleMaintenance(Operation op) {
        if (this.process != null && this.process.isAlive()) {
            op.complete();
            return;
        }
        this.sendRequest(Operation.createGet(this.getUri()).setCompletion((o, e) -> {
            if (e != null) {
                op.fail(e);
                return;
            }
            ProcessState state = o.getBody(ProcessState.class);
            this.startProcess(op, state);
        }));
    }
}

