/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.ODataQueryVisitor;
import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.services.common.QueryTask;
import com.vmware.xenon.services.common.ServiceUriPaths;
import java.net.URI;
import java.util.EnumSet;

public class ODataQueryService
extends StatelessService {
    public static String SELF_LINK = ServiceUriPaths.ODATA_QUERIES;

    @Override
    public void handleGet(Operation op) {
        try {
            QueryTask.Query q = this.getQuery(op.getUri());
            QueryTask task = new QueryTask();
            task.setDirect(true);
            task.querySpec = new QueryTask.QuerySpecification();
            task.querySpec.query = q;
            task.querySpec.options = EnumSet.of(QueryTask.QuerySpecification.QueryOption.EXPAND_CONTENT);
            this.sendRequest(Operation.createPost(this, ServiceUriPaths.CORE_QUERY_TASKS).setBody(task).setCompletion((o, e) -> {
                if (e != null) {
                    op.fail(e);
                    return;
                }
                op.setBody(o.getBodyRaw());
                op.complete();
            }));
        }
        catch (Exception e2) {
            op.fail(e2);
        }
    }

    private QueryTask.Query getQuery(URI uri) throws Exception {
        String oDataFilterParam = UriUtils.getODataFilterParamValue(uri);
        if (oDataFilterParam == null) {
            throw new IllegalArgumentException("$filter query not found");
        }
        return new ODataQueryVisitor().toQuery(oDataFilterParam);
    }
}

