/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.services.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceDocument;
import com.vmware.xenon.common.StatefulService;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.services.common.NodeGroupUtils;
import com.vmware.xenon.services.common.NodeState;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class NodeGroupService
extends StatefulService {
    private static final String STAT_NAME_REFERER_SEGMENT = ".referer.";
    public static final int MIN_PEER_GOSSIP_COUNT = 10;
    public static final String STAT_NAME_RESTARTING_SERVICES_COUNT = "restartingServicesCount";
    public static final String STAT_NAME_RESTARTING_SERVICES_FAILURE_COUNT = "restartingServicesFailureCount";

    public NodeGroupService() {
        super(NodeGroupState.class);
        super.toggleOption(Service.ServiceOption.INSTRUMENTATION, true);
        super.toggleOption(Service.ServiceOption.PERIODIC_MAINTENANCE, true);
    }

    @Override
    public void handleStart(Operation startPost) {
        NodeGroupState initState = null;
        initState = startPost.hasBody() ? startPost.getBody(NodeGroupState.class) : new NodeGroupState();
        initState.documentOwner = this.getHost().getId();
        if (initState.config == null) {
            initState.config = new NodeGroupConfig();
        }
        NodeState self = initState.nodes.get(this.getHost().getId());
        self = this.buildLocalNodeState(self);
        if (!this.validateNodeOptions(startPost, self.options)) {
            return;
        }
        initState.nodes.put(self.id, self);
        startPost.setBody(initState).complete();
    }

    @Override
    public void handleGet(Operation get) {
        NodeGroupState state = (NodeGroupState)this.getState(get);
        get.setBodyNoCloning(state).complete();
    }

    @Override
    public void handlePatch(Operation patch) {
        NodeGroupState body = this.getBody(patch);
        if (body == null) {
            patch.fail(new IllegalArgumentException("body of type NodeGroupState is required"));
            return;
        }
        NodeGroupState localState = (NodeGroupState)this.getState(patch);
        if (body.config == null && body.nodes.isEmpty()) {
            UpdateQuorumRequest bd = patch.getBody(UpdateQuorumRequest.class);
            if (UpdateQuorumRequest.KIND.equals(bd.kind)) {
                this.handleUpdateQuorumPatch(patch, localState);
                return;
            }
            patch.fail(new IllegalArgumentException("nodes or config are required"));
            return;
        }
        if (body.config != null && body.nodes.isEmpty()) {
            localState.config = body.config;
            patch.complete();
            return;
        }
        this.adjustStat((Object)((Object)patch.getAction()) + STAT_NAME_REFERER_SEGMENT + body.documentOwner, 1.0);
        EnumSet<NodeGroupChange> changes = EnumSet.noneOf(NodeGroupChange.class);
        this.mergeRemoteAndLocalMembership(localState, body, changes);
        patch.setNotificationDisabled(changes.isEmpty());
        localState.documentOwner = this.getHost().getId();
        NodeState localNodeState = localState.nodes.get(this.getHost().getId());
        localNodeState.groupReference = UriUtils.buildPublicUri(this.getHost(), this.getSelfLink());
        patch.setBody(localState).complete();
        if (localState.nodes.size() < Math.max(localNodeState.membershipQuorum, localNodeState.synchQuorum)) {
            return;
        }
        if (!NodeGroupUtils.isMembershipSettled(this.getHost(), this.getHost().getMaintenanceIntervalMicros(), localState)) {
            return;
        }
        if (localNodeState.status == NodeState.NodeStatus.AVAILABLE) {
            return;
        }
        localNodeState.status = NodeState.NodeStatus.AVAILABLE;
        this.sendAvailableSelfPatch(localNodeState);
    }

    private void handleUpdateQuorumPatch(Operation patch, NodeGroupState localState) {
        UpdateQuorumRequest bd = patch.getBody(UpdateQuorumRequest.class);
        NodeState self = localState.nodes.get(this.getHost().getId());
        this.logInfo("Updating self quorum from %d to %d, isGroupUpdate:%s", self.membershipQuorum, bd.membershipQuorum, bd.isGroupUpdate);
        self.membershipQuorum = bd.membershipQuorum;
        ++self.documentVersion;
        localState.membershipUpdateTimeMicros = self.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
        if (!bd.isGroupUpdate) {
            patch.setBodyNoCloning(localState).complete();
            return;
        }
        bd.isGroupUpdate = false;
        int failureThreshold = (localState.nodes.size() - 1) / 2;
        AtomicInteger pending = new AtomicInteger(localState.nodes.size());
        AtomicInteger failures = new AtomicInteger();
        Operation.CompletionHandler c = (o, e) -> {
            int p;
            if (e != null) {
                this.logWarning("Node %s failed quorum update: %s", o.getUri(), e.toString());
                failures.incrementAndGet();
            }
            if ((p = pending.decrementAndGet()) != 0) {
                return;
            }
            if (failures.get() > failureThreshold) {
                patch.fail(new IllegalStateException("Majority of nodes failed request"));
            } else {
                patch.setBodyNoCloning(localState).complete();
            }
        };
        for (NodeState node : localState.nodes.values()) {
            if (!NodeState.isAvailable(node, this.getHost().getId(), true)) {
                c.handle(null, null);
                continue;
            }
            node.membershipQuorum = bd.membershipQuorum;
            ++node.documentVersion;
            node.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
            Operation p = Operation.createPatch(node.groupReference).setBody(bd).setCompletion(c);
            this.sendRequest(p);
        }
    }

    @Override
    public void handlePost(Operation post) {
        if (!post.hasBody()) {
            post.fail(new IllegalArgumentException("body is required"));
            return;
        }
        CheckConvergenceRequest cr = post.getBody(CheckConvergenceRequest.class);
        if (CheckConvergenceRequest.KIND.equals(cr.kind)) {
            this.handleCheckConvergencePost(post, cr);
            return;
        }
        JoinPeerRequest joinBody = post.getBody(JoinPeerRequest.class);
        if (joinBody != null && joinBody.memberGroupReference != null) {
            this.handleJoinPost(joinBody, post, (NodeGroupState)this.getState(post), null);
            return;
        }
        NodeState body = post.getBody(NodeState.class);
        if (body.id == null) {
            post.fail(new IllegalArgumentException("id is required"));
            return;
        }
        this.adjustStat((Object)((Object)post.getAction()) + STAT_NAME_REFERER_SEGMENT + body.id, 1.0);
        boolean isLocalNode = body.id.equals(this.getHost().getId());
        if (body.groupReference == null) {
            post.fail(new IllegalArgumentException("groupReference is required"));
            return;
        }
        if (isLocalNode) {
            this.buildLocalNodeState(body);
        } else {
            body.documentSelfLink = UriUtils.buildUriPath(this.getSelfLink(), body.id);
        }
        NodeGroupState localState = (NodeGroupState)this.getState(post);
        localState.nodes.put(body.id, body);
        post.setBody(body).complete();
    }

    private void handleCheckConvergencePost(Operation post, CheckConvergenceRequest body) {
        NodeGroupState localState = (NodeGroupState)this.getState(post);
        CheckConvergenceResponse rsp = new CheckConvergenceResponse();
        rsp.isConverged = localState.membershipUpdateTimeMicros == body.membershipUpdateTimeMicros;
        post.setBody(rsp).complete();
    }

    private void handleJoinPost(JoinPeerRequest joinBody, Operation joinOp, NodeGroupState localState, NodeGroupState remotePeerState) {
        if (UriUtils.isHostEqual(this.getHost(), joinBody.memberGroupReference)) {
            this.logInfo("Skipping self join", new Object[0]);
            joinOp.complete();
            return;
        }
        NodeState self = localState.nodes.get(this.getHost().getId());
        if (joinOp != null) {
            self.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
            ++self.documentVersion;
            self.synchQuorum = 2;
            if (joinBody.synchQuorum != null) {
                self.synchQuorum = Math.max(self.synchQuorum, joinBody.synchQuorum);
            }
            if (joinBody.localNodeOptions != null) {
                if (!this.validateNodeOptions(joinOp, joinBody.localNodeOptions)) {
                    return;
                }
                self.options = joinBody.localNodeOptions;
            }
            localState.membershipUpdateTimeMicros = self.documentUpdateTimeMicros;
            joinOp.complete();
        }
        if (remotePeerState == null) {
            this.sendRequest(Operation.createGet(joinBody.memberGroupReference).setCompletion((o, e) -> {
                if (e != null) {
                    this.logWarning("Failure getting peer %s state:%s", o.getUri(), e.toString());
                    return;
                }
                NodeGroupState remoteState = this.getBody(o);
                this.handleJoinPost(joinBody, null, localState, remoteState);
            }));
            return;
        }
        this.sendRequest(Operation.createPatch(this.getUri()).setBody(remotePeerState));
        this.logInfo("Synch quorum: %d. Sending POST to insert self (%s) to peer %s", self.synchQuorum, self.groupReference, joinBody.memberGroupReference);
        Operation insertSelfToPeer = Operation.createPost(joinBody.memberGroupReference).setBody(self).setCompletion((o, e) -> {
            if (e != null) {
                this.logSevere("Insert POST to %s failed", o.getUri());
                return;
            }
        });
        this.sendRequest(insertSelfToPeer);
    }

    private boolean validateNodeOptions(Operation joinOp, EnumSet<NodeState.NodeOption> options) {
        if (options.isEmpty()) {
            joinOp.fail(new IllegalArgumentException("at least one option must be specified"));
            return false;
        }
        if (options.contains((Object)NodeState.NodeOption.OBSERVER) && options.contains((Object)NodeState.NodeOption.PEER)) {
            joinOp.fail(new IllegalArgumentException(String.format("%s and %s are mutually exclusive", new Object[]{NodeState.NodeOption.OBSERVER, NodeState.NodeOption.PEER})));
            return false;
        }
        return true;
    }

    private void sendAvailableSelfPatch(NodeState local) {
        NodeGroupState body = new NodeGroupState();
        body.config = null;
        body.documentOwner = this.getHost().getId();
        body.documentSelfLink = UriUtils.buildUriPath(this.getSelfLink(), body.documentOwner);
        local.status = NodeState.NodeStatus.AVAILABLE;
        body.nodes.put(local.id, local);
        this.sendRequest(Operation.createPatch(this.getUri()).setBody(body));
    }

    private NodeState buildLocalNodeState(NodeState body) {
        if (body == null) {
            body = new NodeState();
        }
        body.id = this.getHost().getId();
        body.status = NodeState.NodeStatus.SYNCHRONIZING;
        body.groupReference = UriUtils.buildPublicUri(this.getHost(), this.getSelfLink());
        body.documentSelfLink = UriUtils.buildUriPath(this.getSelfLink(), body.id);
        body.documentKind = Utils.buildKind(NodeState.class);
        body.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
        return body;
    }

    @Override
    public void handleMaintenance(Operation op) {
        this.sendRequest(Operation.createGet(this.getUri()).setCompletion((o, e) -> this.performGroupMaintenance(op, o, e)));
    }

    private void performGroupMaintenance(Operation maint, Operation get, Throwable getEx) {
        if (getEx != null) {
            this.logWarning("Failure getting state: %s", getEx.toString());
            maint.complete();
            return;
        }
        if (!get.hasBody()) {
            maint.complete();
            return;
        }
        NodeGroupState localState = get.getBody(NodeGroupState.class);
        if (localState == null || localState.nodes == null) {
            maint.complete();
            return;
        }
        if (localState.nodes.size() <= 1) {
            maint.complete();
            return;
        }
        if (this.getHost().isStopping()) {
            maint.complete();
            return;
        }
        int peersToProbe = (int)Math.log10(localState.nodes.size() - 1);
        peersToProbe = Math.max(peersToProbe, 10);
        peersToProbe = Math.min(localState.nodes.size() - 1, peersToProbe);
        AtomicInteger remaining = new AtomicInteger(peersToProbe);
        NodeState[] randomizedPeers = this.shuffleGroupMembers(localState);
        NodeState localNode = localState.nodes.get(this.getHost().getId());
        localNode.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
        localNode.groupReference = UriUtils.buildPublicUri(this.getHost(), this.getSelfLink());
        localState.documentOwner = this.getHost().getId();
        NodeGroupState patchBody = new NodeGroupState();
        patchBody.documentOwner = this.getHost().getId();
        patchBody.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
        int probeCount = 0;
        for (NodeState peer : randomizedPeers) {
            if (peer == null || peer.id.equals(this.getHost().getId())) continue;
            NodeState remotePeer = peer;
            URI peerUri = peer.groupReference;
            Operation.CompletionHandler ch = (o, e) -> this.handleGossipPatchCompletion(maint, o, e, localState, patchBody, remaining, remotePeer);
            Operation patch = Operation.createPatch(peerUri).setBody(localState).setRetryCount(0).setExpiration(Utils.getNowMicrosUtc() + this.getHost().getOperationTimeoutMicros() / 2L).forceRemote().setCompletion(ch);
            if (peer.groupReference.equals(localNode.groupReference) && peer.status != NodeState.NodeStatus.REPLACED) {
                peer.status = NodeState.NodeStatus.REPLACED;
                peer.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
                ++peer.documentVersion;
                ch.handle(null, null);
            } else {
                this.sendRequest(patch);
            }
            if (++probeCount >= peersToProbe) break;
        }
        if (probeCount == 0) {
            maint.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleGossipPatchCompletion(Operation maint, Operation patch, Throwable e, NodeGroupState localState, NodeGroupState patchBody, AtomicInteger remaining, NodeState remotePeer) {
        try {
            if (patch == null) {
                return;
            }
            long updateTime = localState.membershipUpdateTimeMicros;
            if (e != null) {
                long l = updateTime = remotePeer.status != NodeState.NodeStatus.UNAVAILABLE ? Utils.getNowMicrosUtc() : updateTime;
                if (remotePeer.status != NodeState.NodeStatus.UNAVAILABLE) {
                    remotePeer.documentUpdateTimeMicros = Utils.getNowMicrosUtc();
                    ++remotePeer.documentVersion;
                }
                remotePeer.status = NodeState.NodeStatus.UNAVAILABLE;
            } else {
                NodeGroupState peerState = this.getBody(patch);
                if (peerState.documentOwner.equals(remotePeer.id)) {
                    NodeState remotePeerStateFromRsp = peerState.nodes.get(remotePeer.id);
                    if (remotePeerStateFromRsp.documentVersion > remotePeer.documentVersion) {
                        remotePeer = remotePeerStateFromRsp;
                    }
                } else if (remotePeer.status != NodeState.NodeStatus.REPLACED) {
                    this.logWarning("Peer address %s has changed to id %s from %s", patch.getUri(), peerState.documentOwner, remotePeer.id);
                    remotePeer.status = NodeState.NodeStatus.REPLACED;
                    ++remotePeer.documentVersion;
                    updateTime = Utils.getNowMicrosUtc();
                }
                updateTime = Math.max(updateTime, peerState.membershipUpdateTimeMicros);
            }
            NodeGroupState nodeGroupState = patchBody;
            synchronized (nodeGroupState) {
                patchBody.nodes.put(remotePeer.id, remotePeer);
                patchBody.membershipUpdateTimeMicros = Math.max(updateTime, patchBody.membershipUpdateTimeMicros);
            }
        }
        finally {
            int r = remaining.decrementAndGet();
            if (r != 0) {
                return;
            }
            this.sendRequest(Operation.createPatch(this.getUri()).setBody(patchBody));
            maint.complete();
        }
    }

    private void mergeRemoteAndLocalMembership(NodeGroupState localState, NodeGroupState remotePeerState, EnumSet<NodeGroupChange> changes) {
        if (localState == null) {
            return;
        }
        boolean isSelfPatch = remotePeerState.documentOwner.equals(this.getHost().getId());
        long now = Utils.getNowMicrosUtc();
        NodeState selfEntry = localState.nodes.get(this.getHost().getId());
        for (NodeState nodeState : remotePeerState.nodes.values()) {
            boolean needsUpdate;
            NodeState l = localState.nodes.get(nodeState.id);
            boolean isLocalNode = nodeState.id.equals(this.getHost().getId());
            if (!isSelfPatch && isLocalNode) {
                if (nodeState.status == l.status) continue;
                this.logWarning("Peer %s is reporting us as %s, current status: %s", new Object[]{remotePeerState.documentOwner, nodeState.status, l.status});
                if (nodeState.documentVersion <= l.documentVersion) continue;
                l.documentVersion = nodeState.documentVersion;
                l.documentUpdateTimeMicros = now;
                changes.add(NodeGroupChange.SELF_CHANGE);
                continue;
            }
            if (l == null) {
                boolean hasExpired = nodeState.documentExpirationTimeMicros > 0L && nodeState.documentExpirationTimeMicros < now;
                if (hasExpired || NodeState.isUnAvailable(nodeState)) continue;
                if (!isLocalNode) {
                    this.logInfo("Adding new peer %s (%s), status %s", new Object[]{nodeState.id, nodeState.groupReference, nodeState.status});
                }
                localState.nodes.put(nodeState.id, nodeState);
                changes.add(NodeGroupChange.PEER_ADDED);
                continue;
            }
            boolean bl = needsUpdate = l.status != nodeState.status;
            if (needsUpdate) {
                changes.add(NodeGroupChange.PEER_STATUS_CHANGE);
            }
            if (isSelfPatch && isLocalNode && needsUpdate) {
                nodeState.documentVersion = Math.max(nodeState.documentVersion, l.documentVersion) + 1L;
            }
            if (nodeState.documentVersion < l.documentVersion) {
                this.logInfo("v:%d - q:%d, v:%d - q:%d , %s - %s (local:%s %d)", l.documentVersion, l.membershipQuorum, nodeState.documentVersion, nodeState.membershipQuorum, l.id, remotePeerState.documentOwner, this.getHost().getId(), selfEntry.documentVersion);
                continue;
            }
            if (nodeState.documentVersion == l.documentVersion && needsUpdate && nodeState.documentUpdateTimeMicros < l.documentUpdateTimeMicros) {
                this.logWarning("Ignoring update for %s from peer %s. Local status: %s, remote status: %s", new Object[]{nodeState.id, remotePeerState.documentOwner, l.status, nodeState.status});
                continue;
            }
            if (nodeState.status == NodeState.NodeStatus.UNAVAILABLE && l.documentExpirationTimeMicros == 0L && nodeState.documentExpirationTimeMicros == 0L) {
                nodeState.documentExpirationTimeMicros = Utils.getNowMicrosUtc() + localState.config.nodeRemovalDelayMicros;
                this.logInfo("Set expiration at %d for unavailable node %s(%s)", nodeState.documentExpirationTimeMicros, nodeState.id, nodeState.groupReference);
                changes.add(NodeGroupChange.PEER_STATUS_CHANGE);
                needsUpdate = true;
            }
            if (nodeState.status == NodeState.NodeStatus.UNAVAILABLE && needsUpdate) {
                ++nodeState.documentVersion;
            }
            localState.nodes.put(nodeState.id, nodeState);
        }
        ArrayList<String> missingNodes = new ArrayList<String>();
        for (NodeState l : localState.nodes.values()) {
            NodeState r = remotePeerState.nodes.get(l.id);
            if (!NodeState.isUnAvailable(l) || l.id.equals(this.getHost().getId())) continue;
            long expirationMicros = l.documentExpirationTimeMicros;
            if (r != null) {
                expirationMicros = Math.max(l.documentExpirationTimeMicros, r.documentExpirationTimeMicros);
            }
            if (expirationMicros <= 0L || now <= expirationMicros) continue;
            changes.add(NodeGroupChange.PEER_STATUS_CHANGE);
            this.logInfo("Removing expired unavailable node %s(%s)", l.id, l.groupReference);
            missingNodes.add(l.id);
        }
        for (String id : missingNodes) {
            localState.nodes.remove(id);
        }
        boolean bl = !changes.isEmpty();
        localState.membershipUpdateTimeMicros = Math.max(remotePeerState.membershipUpdateTimeMicros, bl ? now : localState.membershipUpdateTimeMicros);
        if (bl) {
            this.logInfo("State updated, merge with %s, self %s, %d", remotePeerState.documentOwner, localState.documentOwner, localState.membershipUpdateTimeMicros);
        }
    }

    public NodeState[] shuffleGroupMembers(NodeGroupState localState) {
        NodeState[] randomizedPeers = new NodeState[localState.nodes.size()];
        localState.nodes.values().toArray(randomizedPeers);
        Random random = new Random();
        for (int i = randomizedPeers.length - 1; i > 0; --i) {
            int index = random.nextInt(i + 1);
            NodeState t = randomizedPeers[index];
            randomizedPeers[index] = randomizedPeers[i];
            randomizedPeers[i] = t;
        }
        return randomizedPeers;
    }

    NodeGroupState getBody(Operation o) {
        if (!o.hasBody()) {
            return new NodeGroupState();
        }
        NodeGroupState rsp = o.getBody(NodeGroupState.class);
        if (rsp != null && rsp.nodes == null) {
            rsp.nodes = new HashMap<String, NodeState>();
        }
        return rsp;
    }

    public static class NodeGroupState
    extends ServiceDocument {
        public NodeGroupConfig config;
        public Map<String, NodeState> nodes = new ConcurrentSkipListMap<String, NodeState>();
        public long membershipUpdateTimeMicros;
    }

    public static class NodeGroupConfig {
        public static final long DEFAULT_NODE_REMOVAL_DELAY_MICROS = TimeUnit.HOURS.toMicros(1L);
        public long nodeRemovalDelayMicros = DEFAULT_NODE_REMOVAL_DELAY_MICROS;
        public long stableGroupMaintenanceIntervalCount = 5L;
    }

    public static class UpdateQuorumRequest {
        public static final String KIND = Utils.buildKind(UpdateQuorumRequest.class);
        public boolean isGroupUpdate;
        public int membershipQuorum;
        public String kind;

        public static UpdateQuorumRequest create(boolean isGroupUpdate, int quorum) {
            UpdateQuorumRequest r = new UpdateQuorumRequest();
            r.isGroupUpdate = isGroupUpdate;
            r.membershipQuorum = quorum;
            r.kind = KIND;
            return r;
        }
    }

    public static class JoinPeerRequest {
        public static final String KIND = Utils.buildKind(JoinPeerRequest.class);
        public URI memberGroupReference;
        public EnumSet<NodeState.NodeOption> localNodeOptions;
        public Integer synchQuorum;
        public String kind;

        public static JoinPeerRequest create(URI peerToJoin, Integer synchQuorum) {
            JoinPeerRequest r = new JoinPeerRequest();
            r.memberGroupReference = peerToJoin;
            r.synchQuorum = synchQuorum;
            r.kind = KIND;
            return r;
        }
    }

    public static class CheckConvergenceResponse {
        public boolean isConverged;
    }

    public static class CheckConvergenceRequest {
        public static final String KIND = Utils.buildKind(CheckConvergenceRequest.class);
        public long membershipUpdateTimeMicros;
        public String kind;

        public static CheckConvergenceRequest create(long membershipUpdateTime) {
            CheckConvergenceRequest r = new CheckConvergenceRequest();
            r.membershipUpdateTimeMicros = membershipUpdateTime;
            r.kind = KIND;
            return r;
        }
    }

    private static enum NodeGroupChange {
        PEER_ADDED,
        PEER_STATUS_CHANGE,
        SELF_CHANGE;

    }
}

