/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.OperationContext;
import com.vmware.xenon.common.Service;
import com.vmware.xenon.common.ServiceHost;
import com.vmware.xenon.common.ServiceSubscriptionState;
import com.vmware.xenon.common.UriUtils;
import com.vmware.xenon.common.Utils;
import com.vmware.xenon.common.WebSocketService;
import com.vmware.xenon.common.http.netty.CookieJar;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;

public class NettyWebSocketRequestHandler
extends SimpleChannelInboundHandler<Object> {
    private WebSocketServerHandshaker handshaker;
    private final ConcurrentMap<URI, Set<String>> serviceSubscriptions = new ConcurrentHashMap<URI, Set<String>>();
    private final ConcurrentMap<URI, WebSocketService> webSocketServices = new ConcurrentHashMap<URI, WebSocketService>();
    private ServiceHost host;
    private String handshakePath;
    private String servicePrefix;
    private String authToken;

    public NettyWebSocketRequestHandler(ServiceHost host, String socketHandshakePath, String servicePrefix) {
        this.host = host;
        this.handshakePath = socketHandshakePath;
        this.servicePrefix = servicePrefix;
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest nettyRequest = (FullHttpRequest)msg;
            return nettyRequest.uri().contentEquals(this.handshakePath);
        }
        return msg instanceof WebSocketFrame;
    }

    protected void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest nettyRequest = (FullHttpRequest)msg;
            this.performWebsocketHandshake(ctx, nettyRequest);
            return;
        }
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof CloseWebSocketFrame) {
                this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
                return;
            }
            if (frame instanceof PingWebSocketFrame) {
                ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content().retain()));
                return;
            }
            if (!(frame instanceof TextWebSocketFrame)) {
                this.handshaker.close(ctx.channel(), new CloseWebSocketFrame(1003, String.format("%s frame types not supported", frame.getClass().getName())));
                return;
            }
            if (this.authToken != null) {
                Operation dummyOp = new Operation();
                dummyOp.addRequestHeader("x-xenon-auth-token", this.authToken);
                dummyOp.setUri(UriUtils.buildUri(this.host, "/core/ws-endpoint"));
                OperationContext.setAuthorizationContext(this.host, dummyOp);
            }
            String frameText = ((TextWebSocketFrame)frame).text();
            this.host.run(() -> this.processWebSocketFrame(ctx, frameText));
            return;
        }
    }

    private void performWebsocketHandshake(final ChannelHandlerContext ctx, FullHttpRequest nettyRequest) {
        WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(this.handshakePath, null, false);
        this.handshaker = factory.newHandshaker((HttpRequest)nettyRequest);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            String cookie;
            DefaultChannelPromise promise = new DefaultChannelPromise(ctx.channel());
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        ctx.channel().close();
                    }
                    ctx.channel().closeFuture().addListener(f -> {
                        for (Map.Entry e : NettyWebSocketRequestHandler.this.serviceSubscriptions.entrySet()) {
                            WebSocketService svc = (WebSocketService)NettyWebSocketRequestHandler.this.webSocketServices.get(e.getKey());
                            if (svc != null) {
                                NettyWebSocketRequestHandler.this.deleteServiceSubscriptions(svc);
                            }
                            NettyWebSocketRequestHandler.this.host.stopService(svc);
                        }
                    });
                }
            });
            DefaultHttpHeaders responseHeaders = new DefaultHttpHeaders();
            CharSequence token = (CharSequence)nettyRequest.headers().get((Object)"x-xenon-auth-token", null);
            if (token == null && (cookie = (String)responseHeaders.getAndRemoveAndConvert((Object)HttpHeaderNames.COOKIE)) != null) {
                token = CookieJar.decodeCookies(cookie).get("dcp-auth-cookie");
            }
            this.authToken = token == null ? null : token.toString();
            this.handshaker.handshake(ctx.channel(), nettyRequest, (HttpHeaders)responseHeaders, (ChannelPromise)promise);
        }
    }

    private void deleteServiceSubscriptions(WebSocketService service) {
        Set subscriptions = (Set)this.serviceSubscriptions.remove(service.getUri());
        ServiceSubscriptionState.ServiceSubscriber body = new ServiceSubscriptionState.ServiceSubscriber();
        body.reference = service.getUri();
        for (String unsubscribeFrom : subscriptions) {
            this.host.sendRequest(Operation.createDelete(service, unsubscribeFrom).setBody(body).setReferer(service.getUri()));
        }
    }

    private void processWebSocketFrame(ChannelHandlerContext ctx, String text) {
        String body;
        int requestIdSep = text.indexOf("\r\n");
        if (requestIdSep < 0) {
            this.handshaker.close(ctx.channel(), new CloseWebSocketFrame(1003, "Malformed frame"));
            return;
        }
        String requestId = text.substring(0, requestIdSep);
        int requestLineSep = text.indexOf("\r\n", requestIdSep + "\r\n".length());
        if (requestLineSep < 0) {
            requestLineSep = text.length();
            body = "";
        } else {
            body = text.substring(requestLineSep + "\r\n".length());
        }
        String requestLine = text.substring(requestIdSep + "\r\n".length(), requestLineSep);
        int methodSep = requestLine.indexOf(" ");
        if (methodSep < 0) {
            this.handshaker.close(ctx.channel(), new CloseWebSocketFrame(1003, "Malformed frame"));
            return;
        }
        String method = requestLine.substring(0, methodSep);
        String path = requestLine.substring(methodSep + 1);
        try {
            if (method.equals("DELETE")) {
                if (path.startsWith(this.servicePrefix)) {
                    URI serviceToDelete = UriUtils.buildPublicUri(this.host, path);
                    WebSocketService removed = (WebSocketService)this.webSocketServices.remove(serviceToDelete);
                    if (removed != null) {
                        this.deleteServiceSubscriptions(removed);
                        this.host.stopService(removed);
                        ctx.writeAndFlush((Object)new TextWebSocketFrame("200 " + requestId));
                    } else {
                        ctx.writeAndFlush((Object)new TextWebSocketFrame("404 " + requestId));
                    }
                    return;
                }
                if (path.endsWith("/subscriptions")) {
                    ServiceSubscriptionState.ServiceSubscriber state = Utils.fromJson(body, ServiceSubscriptionState.ServiceSubscriber.class);
                    WebSocketService service = (WebSocketService)this.webSocketServices.get(state.reference);
                    this.host.sendRequest(Operation.createDelete(service, path).setBody(body).setReferer(service.getUri()).setCompletion((completedOp, failure) -> {
                        ctx.writeAndFlush((Object)new TextWebSocketFrame(completedOp.getStatusCode() + " " + requestId));
                        Utils.atomicGetOrCreate(this.serviceSubscriptions, service.getUri(), ConcurrentSkipListSet::new).remove(path);
                    }));
                    return;
                }
                ctx.writeAndFlush((Object)new TextWebSocketFrame(Integer.toString(404) + " " + requestId));
                return;
            }
            if (method.equals(Service.Action.POST.toString())) {
                if (path.equals(this.servicePrefix)) {
                    URI wsServiceUri = this.buildWsServiceUri(UUID.randomUUID().toString());
                    CreateServiceResponse response = new CreateServiceResponse();
                    response.uri = wsServiceUri.toString();
                    WebSocketService webSocketService = new WebSocketService(ctx, wsServiceUri);
                    this.host.startService(Operation.createPost(wsServiceUri).setCompletion((o, t) -> {
                        if (t != null) {
                            ctx.writeAndFlush((Object)new TextWebSocketFrame(Integer.toString(500) + " " + requestId + "\r\n" + Utils.toJson(t)));
                        } else {
                            ctx.writeAndFlush((Object)new TextWebSocketFrame(Integer.toString(202) + " " + requestId + "\r\n" + Utils.toJson(response)));
                        }
                    }), webSocketService);
                    this.webSocketServices.put(wsServiceUri, webSocketService);
                    return;
                }
                if (path.endsWith("/subscriptions")) {
                    ServiceSubscriptionState.ServiceSubscriber state = Utils.fromJson(body, ServiceSubscriptionState.ServiceSubscriber.class);
                    WebSocketService service = (WebSocketService)this.webSocketServices.get(state.reference);
                    this.host.sendRequest(Operation.createPost(service, path).setBody(body).setReferer(service.getUri()).setCompletion((completedOp, failure) -> {
                        ctx.writeAndFlush((Object)new TextWebSocketFrame(completedOp.getStatusCode() + " " + requestId));
                        if (completedOp.getStatusCode() >= 200 && completedOp.getStatusCode() < 300) {
                            Utils.atomicGetOrCreate(this.serviceSubscriptions, service.getUri(), ConcurrentSkipListSet::new).add(path);
                        }
                    }));
                    return;
                }
            }
            if (method.equals("REPLY") && path.startsWith(this.servicePrefix) && path.length() > this.servicePrefix.length()) {
                String serviceId = path.substring(this.servicePrefix.length() + 1);
                URI serviceUri = this.buildWsServiceUri(serviceId);
                WebSocketService service = (WebSocketService)this.webSocketServices.get(serviceUri);
                if (service != null) {
                    service.handleWebSocketMessage(body);
                }
                return;
            }
            ctx.writeAndFlush((Object)new TextWebSocketFrame("404 " + requestId));
            this.host.log(Level.FINE, "Unsupported websocket request: %s %s %s", method, path, body);
        }
        catch (Exception e) {
            ctx.writeAndFlush((Object)("500 " + requestId));
        }
    }

    private URI buildWsServiceUri(String serviceId) {
        return UriUtils.buildPublicUri(this.host, UriUtils.buildUriPath(this.servicePrefix, serviceId));
    }

    public static class CreateServiceResponse {
        public String uri;
    }
}

