/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common.http.netty;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.http.netty.NettyChannelContext;
import com.vmware.xenon.common.http.netty.NettyFullHttpRequest;
import com.vmware.xenon.common.http.netty.SimpleChannelPromiseAggregator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpUtil;

public class NettyHttpToHttp2Handler
extends HttpToHttp2ConnectionHandler {
    public NettyHttpToHttp2Handler(boolean server, Http2FrameListener listener) {
        super(server, listener);
    }

    public NettyHttpToHttp2Handler(Http2Connection connection, Http2FrameListener listener) {
        super(connection, listener);
    }

    public NettyHttpToHttp2Handler(Http2Connection connection, Http2FrameReader frameReader, Http2FrameWriter frameWriter, Http2FrameListener listener) {
        super(connection, frameReader, frameWriter, listener);
    }

    public NettyHttpToHttp2Handler(Http2ConnectionDecoder.Builder decoderBuilder, Http2ConnectionEncoder.Builder encoderBuilder) {
        super(decoderBuilder, encoderBuilder);
    }

    private int getStreamId(HttpHeaders httpHeaders) throws Exception {
        return httpHeaders.getInt((Object)HttpUtil.ExtensionHeaderNames.STREAM_ID.text(), this.connection().local().nextStreamId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof FullHttpMessage) {
            FullHttpMessage httpMsg = (FullHttpMessage)msg;
            boolean hasData = httpMsg.content().isReadable();
            boolean httpMsgNeedRelease = true;
            SimpleChannelPromiseAggregator promiseAggregator = null;
            try {
                NettyChannelContext socketContext;
                NettyFullHttpRequest request;
                Operation operation;
                int streamId = this.getStreamId(httpMsg.headers());
                if (msg instanceof NettyFullHttpRequest && (operation = (request = (NettyFullHttpRequest)((Object)msg)).getOperation()) != null && (socketContext = (NettyChannelContext)operation.getSocketContext()) != null) {
                    socketContext.setOperationForStream(streamId, operation);
                }
                Http2Headers http2Headers = HttpUtil.toHttp2Headers((FullHttpMessage)httpMsg);
                Http2ConnectionEncoder encoder = this.encoder();
                if (hasData) {
                    promiseAggregator = new SimpleChannelPromiseAggregator(promise, ctx.channel(), ctx.executor());
                    encoder.writeHeaders(ctx, streamId, http2Headers, 0, false, promiseAggregator.newPromise());
                    httpMsgNeedRelease = false;
                    encoder.writeData(ctx, streamId, httpMsg.content(), 0, true, promiseAggregator.newPromise());
                    promiseAggregator.doneAllocatingPromises();
                }
                encoder.writeHeaders(ctx, streamId, http2Headers, 0, true, promise);
            }
            catch (Throwable t) {
                if (promiseAggregator == null) {
                    promise.tryFailure(t);
                }
                promiseAggregator.setFailure(t);
            }
            finally {
                if (httpMsgNeedRelease) {
                    httpMsg.release();
                }
            }
        } else {
            ctx.write(msg, promise);
        }
    }
}

