/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.Operation;
import com.vmware.xenon.common.StatelessService;
import com.vmware.xenon.common.Utils;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class WebSocketService
extends StatelessService {
    private final ChannelHandlerContext ctx;
    private final URI uri;
    private Map<Long, Operation> pendingOperations = new ConcurrentHashMap<Long, Operation>();

    public WebSocketService(ChannelHandlerContext ctx, URI uri) {
        this.ctx = ctx;
        this.uri = uri;
    }

    public void handleWebSocketMessage(String body) {
        OperationResponse or = Utils.fromJson(body, OperationResponse.class);
        Operation op = this.pendingOperations.remove(or.id);
        if (op == null) {
            this.logFine("Unknown operation id: %d", or.id);
            return;
        }
        for (Map.Entry<String, String> entry : or.responseHeaders.entrySet()) {
            op.addResponseHeader(entry.getKey(), entry.getValue());
        }
        op.setStatusCode(or.statusCode);
        if (or.responseJsonBody != null) {
            op.setContentType("application/json");
            op.setBodyNoCloning(or.responseJsonBody);
        }
        op.complete();
    }

    @Override
    public void handleRequest(final Operation op) {
        this.prepareRequest(op);
        Operation.SerializedOperation serializedOperation = Operation.SerializedOperation.create(op);
        this.pendingOperations.put(op.getId(), op);
        ChannelFuture promise = this.ctx.writeAndFlush((Object)new TextWebSocketFrame("POST " + this.uri.toString() + "\r\n" + Utils.toJson(serializedOperation)));
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    op.fail(future.cause());
                    WebSocketService.this.pendingOperations.remove(op.getId());
                }
            }
        });
    }

    private static class OperationResponse {
        long id;
        Map<String, String> responseHeaders;
        int statusCode;
        String responseJsonBody;

        private OperationResponse() {
        }
    }
}

