/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.xenon.common;

import com.vmware.xenon.common.ODataToken;
import com.vmware.xenon.common.ODataTokenList;
import com.vmware.xenon.common.ODataTokenizer;
import com.vmware.xenon.services.common.QueryTask;

public class ODataQueryVisitor {
    private static final IllegalArgumentException LeftRightTypeException = new IllegalArgumentException("left and right side type mismatch");

    public QueryTask.Query toQuery(String filterExp) {
        ODataTokenizer tokenizer = new ODataTokenizer(filterExp);
        tokenizer.tokenize();
        if (tokenizer.tokens.hasTokens()) {
            return this.walkTokens(tokenizer.tokens, null);
        }
        return null;
    }

    public QueryTask.Query walkTokens(ODataTokenList tokens, QueryTask.Query left) {
        if (!tokens.hasNext()) {
            return null;
        }
        if (tokens.lookToken().getKind().equals((Object)ODataToken.ODataTokenKind.OPENPAREN)) {
            tokens.skip();
            left = this.walkTokens(tokens, left);
        }
        if (tokens.hasNext() && tokens.lookToken().getKind().equals((Object)ODataToken.ODataTokenKind.SIMPLE_TYPE)) {
            left = this.parseUnaryTerm(tokens);
        }
        if (tokens.hasNext() && tokens.lookToken().getKind().equals((Object)ODataToken.ODataTokenKind.CLOSEPAREN)) {
            tokens.skip();
            return left;
        }
        if (tokens.hasNext() && tokens.lookToken().getKind().equals((Object)ODataToken.ODataTokenKind.BINARY_OPERATOR)) {
            left = this.visitBinary(left, this.stringToVerb(tokens.next().getUriLiteral()), this.walkTokens(tokens, null));
        }
        if (tokens.hasNext()) {
            left = this.walkTokens(tokens, left);
        }
        return left;
    }

    public QueryTask.Query parseUnaryTerm(ODataTokenList tokens) throws IllegalArgumentException {
        if (!tokens.lookToken().getKind().equals((Object)ODataToken.ODataTokenKind.SIMPLE_TYPE)) {
            throw new IllegalArgumentException("Term mismatch");
        }
        ODataToken left = tokens.next();
        if (!tokens.lookToken().getKind().equals((Object)ODataToken.ODataTokenKind.BINARY_COMPARISON)) {
            throw new IllegalArgumentException("Term mismatch");
        }
        ODataToken verb = tokens.next();
        if (!tokens.lookToken().getKind().equals((Object)ODataToken.ODataTokenKind.SIMPLE_TYPE)) {
            throw new IllegalArgumentException("Term mismatch");
        }
        ODataToken right = tokens.next();
        return this.visitBinary(left.getUriLiteral(), this.stringToVerb(verb.getUriLiteral()), right.getUriLiteral());
    }

    private QueryTask.Query visitBinary(Object leftSide, BinaryVerb operator, Object rightSide) {
        QueryTask.Query q = new QueryTask.Query();
        q.occurance = ODataQueryVisitor.convertToLuceneOccur(operator);
        if (leftSide instanceof QueryTask.Query) {
            if (!(rightSide instanceof QueryTask.Query)) {
                throw LeftRightTypeException;
            }
            q.addBooleanClause((QueryTask.Query)leftSide);
            q.addBooleanClause((QueryTask.Query)rightSide);
            return q;
        }
        if (rightSide instanceof QueryTask.Query) {
            throw LeftRightTypeException;
        }
        q.setTermPropertyName((String)leftSide);
        if (((String)leftSide).contains("*")) {
            q.setTermMatchType(QueryTask.QueryTerm.MatchType.WILDCARD);
        }
        if (rightSide instanceof String) {
            if (ODataQueryVisitor.isNumeric((String)rightSide)) {
                QueryTask.NumericRange<?> r = this.createRange(rightSide.toString(), operator);
                q.setNumericRange(r);
            } else {
                q.setTermMatchValue(((String)rightSide).replace("'", ""));
                if (((String)rightSide).contains("*")) {
                    q.setTermMatchType(QueryTask.QueryTerm.MatchType.WILDCARD);
                }
            }
        } else {
            throw LeftRightTypeException;
        }
        return q;
    }

    private static QueryTask.Query.Occurance convertToLuceneOccur(BinaryVerb binaryOp) {
        if (binaryOp == null) {
            return QueryTask.Query.Occurance.MUST_OCCUR;
        }
        switch (binaryOp) {
            case OR: {
                return QueryTask.Query.Occurance.SHOULD_OCCUR;
            }
            case NE: {
                return QueryTask.Query.Occurance.MUST_NOT_OCCUR;
            }
            case AND: 
            case EQ: 
            case GT: 
            case GE: 
            case LT: 
            case LE: {
                return QueryTask.Query.Occurance.MUST_OCCUR;
            }
        }
        throw new IllegalArgumentException("unsupported operation");
    }

    private static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private QueryTask.NumericRange<?> createRange(String num, BinaryVerb op) {
        Number d = null;
        d = num.contains(".") ? (Number)Double.parseDouble(num) : (Number)Long.parseLong(num);
        if (op.equals((Object)BinaryVerb.LT)) {
            return QueryTask.NumericRange.createLessThanRange(d);
        }
        if (op.equals((Object)BinaryVerb.LE)) {
            return QueryTask.NumericRange.createLessThanOrEqualRange(d);
        }
        if (op.equals((Object)BinaryVerb.GT)) {
            return QueryTask.NumericRange.createGreaterThanRange(d);
        }
        if (op.equals((Object)BinaryVerb.GE)) {
            return QueryTask.NumericRange.createGreaterThanOrEqualRange(d);
        }
        if (op.equals((Object)BinaryVerb.EQ)) {
            return QueryTask.NumericRange.createEqualRange(d);
        }
        return null;
    }

    private BinaryVerb stringToVerb(String s) {
        for (BinaryVerb v : BinaryVerb.values()) {
            if (!v.equals(s)) continue;
            return v;
        }
        return null;
    }

    public static enum BinaryVerb {
        AND("and"),
        OR("or"),
        EQ("eq"),
        NE("ne"),
        LT("lt"),
        LE("le"),
        GT("gt"),
        GE("ge"),
        ADD("add"),
        SUB("sub"),
        MUL("mul"),
        DIV("div"),
        MODULO("mod");

        private String operator;

        private BinaryVerb(String op) {
            this.operator = op;
        }

        public boolean equals(String str) {
            return this.operator.equals(str);
        }
    }
}

