/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcac.code.stream.jenkins.plugin.util;

import com.vmware.vcac.code.stream.jenkins.plugin.model.PipelineParam;
import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EnvVariableResolver {
    private EnvVars environment;

    public EnvVariableResolver(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        this.environment = build.getEnvironment((TaskListener)listener);
        this.environment.overrideAll(build.getBuildVariables());
    }

    public String replaceBuildParamWithValue(String paramValue) {
        return Util.fixEmptyAndTrim((String)this.environment.expand(paramValue));
    }

    public List<PipelineParam> replaceBuildParamWithValue(List<PipelineParam> pipelineParams) {
        ArrayList<PipelineParam> temp = new ArrayList<PipelineParam>();
        if (pipelineParams != null) {
            for (PipelineParam param : pipelineParams) {
                try {
                    PipelineParam cloned = param.clone();
                    cloned.setName(this.replaceBuildParamWithValue(cloned.getName()));
                    cloned.setValue(this.replaceBuildParamWithValue(cloned.getValue()));
                    temp.add(cloned);
                }
                catch (CloneNotSupportedException e) {
                    new IOException("Not able to clone pipeline param");
                }
            }
        }
        return temp;
    }

    public EnvVars getEnvironment() {
        return this.environment;
    }
}

