/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcac.code.stream.jenkins.plugin;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.vmware.vcac.code.stream.jenkins.plugin.CodeStreamClient;
import com.vmware.vcac.code.stream.jenkins.plugin.model.ExecutionStatus;
import com.vmware.vcac.code.stream.jenkins.plugin.model.PipelineParam;
import com.vmware.vcac.code.stream.jenkins.plugin.model.PluginParam;
import com.vmware.vcac.code.stream.jenkins.plugin.model.TaskExecutionInfo;
import com.vmware.vcac.code.stream.jenkins.plugin.util.ReleasePipelineExecutionInfoParser;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.remoting.RoleChecker;

public class CodeStreamPipelineCallable
implements Callable<Map<String, String>, IOException>,
Serializable {
    private AbstractBuild<?, ?> build;
    private PluginParam params;

    public CodeStreamPipelineCallable(PluginParam params) {
        this.params = params;
    }

    public Map<String, String> call() throws IOException {
        HashMap<String, String> data = new HashMap<String, String>();
        try {
            JsonObject execJsonRes;
            JsonElement execIdElement;
            CodeStreamClient codeStreamClient = new CodeStreamClient(this.params);
            JsonObject pipelineJsonObj = codeStreamClient.fetchPipeline(this.params.getPipelineName());
            String pipelineId = pipelineJsonObj.get("id").getAsString();
            String status = pipelineJsonObj.get("status").getAsString();
            Map<String, PipelineParam> defaultParams = this.getPipelineParams(pipelineJsonObj);
            System.out.println("Successfully fetched Pipeline with id:" + pipelineId);
            if (!status.equals("ACTIVATED")) {
                throw new IOException(this.params.getPipelineName() + " is not activated");
            }
            if (!this.params.getPipelineParams().isEmpty()) {
                for (PipelineParam userParam : this.params.getPipelineParams()) {
                    PipelineParam defaultParam = defaultParams.get(Util.fixEmptyAndTrim((String)userParam.getName()));
                    defaultParam.setValue(Util.fixEmptyAndTrim((String)userParam.getValue()));
                }
            }
            if ((execIdElement = (execJsonRes = codeStreamClient.executePipeline(pipelineId, new ArrayList<PipelineParam>(defaultParams.values()))).get("id")) != null) {
                String execId = execIdElement.getAsString();
                data.put("CS_PIPELINE_EXECUTION_ID", execId);
                System.out.println("Pipeline executed successfully with execution id :" + execId);
                if (this.params.isWaitExec()) {
                    ReleasePipelineExecutionInfoParser parser = codeStreamClient.getPipelineExecutionResponse(pipelineId, execId);
                    while (!parser.isPipelineCompleted()) {
                        System.out.println("Waiting for pipeline execution to complete");
                        Thread.sleep(10000L);
                        parser = codeStreamClient.getPipelineExecutionResponse(pipelineId, execId);
                    }
                    ExecutionStatus pipelineExecStatus = parser.getPipelineExecStatus();
                    data.put("CS_PIPELINE_EXECUTION_STATUS", pipelineExecStatus.toString());
                    data.put("CS_PIPELINE_EXECUTION_RES", parser.getPipelineExeResponseAsJson());
                    switch (pipelineExecStatus) {
                        case COMPLETED: {
                            System.out.println("Pipeline complete successfully");
                            break;
                        }
                        case FAILED: {
                            TaskExecutionInfo failedTask = parser.getFailedTask();
                            System.out.println("Pipeline execution failed");
                            throw new IOException(failedTask.getTask().getName() + " task failed with message :" + failedTask.getMessages());
                        }
                        case CANCELED: {
                            throw new IOException("Pipeline execution cancelled. Please go to CodeStream for more details");
                        }
                    }
                }
            } else {
                codeStreamClient.handleError(execJsonRes);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return data;
    }

    private Map<String, PipelineParam> getPipelineParams(JsonObject pipelineJsonObj) {
        Type type = new TypeToken<List<PipelineParam>>(){}.getType();
        Gson gson = new Gson();
        List params = (List)gson.fromJson(pipelineJsonObj.get("pipelineParams").getAsJsonArray().toString(), type);
        HashMap<String, PipelineParam> paramMap = new HashMap<String, PipelineParam>();
        for (PipelineParam param : params) {
            paramMap.put(param.getName(), param);
        }
        return paramMap;
    }

    public void checkRoles(RoleChecker roleChecker) throws SecurityException {
    }
}

