/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Component
public class RestControllerReflection {
    private final ParameterNameDiscoverer parameterNameDiscoverer;
    private final ApplicationContext context;

    RestControllerReflection(ParameterNameDiscoverer parameterNameDiscoverer, ApplicationContext context) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
        this.context = context;
    }

    Map<String, Object> locateRestControllers() {
        return this.context.getBeansWithAnnotation(RestController.class);
    }

    Map<String, Method> extractControllerRequestMappings(Object controller) {
        return this.extractControllerByAnnotation(controller, RequestMapping.class);
    }

    Map<String, Method> extractControllerPatchMappings(Object controller) {
        return this.extractControllerByAnnotation(controller, PatchMapping.class);
    }

    Map<String, Method> extractControllerGetMappings(Object controller) {
        return this.extractControllerByAnnotation(controller, GetMapping.class);
    }

    Map<String, Method> extractControllerPostMappings(Object controller) {
        return this.extractControllerByAnnotation(controller, PostMapping.class);
    }

    Map<String, Method> extractControllerPutMappings(Object controller) {
        return this.extractControllerByAnnotation(controller, PutMapping.class);
    }

    Map<String, Method> extractControllerDeleteMappings(Object controller) {
        return this.extractControllerByAnnotation(controller, DeleteMapping.class);
    }

    private Map<String, Method> extractControllerByAnnotation(Object controller, Class annotationType) {
        List<Method> rawMethods = Arrays.asList(controller.getClass().getDeclaredMethods());
        HashMap<String, Method> cleanedMethods = new HashMap<String, Method>();
        for (Method method : rawMethods) {
            if (method.getAnnotationsByType(annotationType) == null) continue;
            cleanedMethods.put(method.getName(), method);
        }
        return cleanedMethods;
    }

    Map<String, Class> extractMethodParameters(Method method) {
        String[] params = this.parameterNameDiscoverer.getParameterNames(method);
        HashMap<String, Class> paramMap = new HashMap<String, Class>();
        int index = 0;
        if (params != null) {
            for (String param : params) {
                paramMap.put(param, method.getParameterTypes()[index]);
                ++index;
            }
        }
        return paramMap;
    }

    List<String> extractMethodParameterList(Method method) {
        String[] params = this.parameterNameDiscoverer.getParameterNames(method);
        ArrayList<String> paramList = new ArrayList<String>();
        if (params != null) {
            Collections.addAll(paramList, params);
        }
        return paramList;
    }

    Map<String, Class> extractMethodAnnotationTypes(Method method) {
        String[] paramNames = this.parameterNameDiscoverer.getParameterNames(method);
        Parameter[] params = method.getParameters();
        HashMap<String, Class> paramMap = new HashMap<String, Class>();
        if (params != null) {
            for (int x = 0; x < params.length; ++x) {
                if (params[x].getAnnotations() != null && params[x].getAnnotations().length >= 1) {
                    paramMap.put(paramNames[x], params[x].getAnnotations()[0].annotationType());
                    continue;
                }
                paramMap.put(paramNames[x], null);
            }
        }
        return paramMap;
    }

    Map<String, Object> extractMethodAnnotationValues(Method method) {
        Parameter[] params = method.getParameters();
        String[] paramNames = this.parameterNameDiscoverer.getParameterNames(method);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (int x = 0; x < params.length; ++x) {
            if (params[x].getAnnotations() != null && params[x].getAnnotations().length >= 1) {
                paramMap.put(paramNames[x], this.extractMethodAnnotation(params[x], params[x].getAnnotations()[0].annotationType()));
                continue;
            }
            paramMap.put(params[x].getName(), null);
        }
        return paramMap;
    }

    private Object extractMethodAnnotation(Parameter param, Class annotation) {
        switch (annotation.getName()) {
            case "org.springframework.web.bind.annotation.PathVariable": {
                return param.getAnnotation(PathVariable.class);
            }
            case "org.springframework.web.bind.annotation.RequestParam": {
                return param.getAnnotation(RequestParam.class);
            }
            case "org.springframework.web.bind.annotation.RequestBody": {
                return param.getAnnotation(RequestBody.class);
            }
            case "org.springframework.web.bind.annotation.RequestHeader": {
                return param.getAnnotation(RequestHeader.class);
            }
        }
        return null;
    }
}

