/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.core.operations;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.vmware.transport.bridge.Request;
import com.vmware.transport.bridge.Response;
import com.vmware.transport.bus.model.Message;
import com.vmware.transport.bus.store.model.BusStore;
import com.vmware.transport.core.AbstractService;
import com.vmware.transport.core.error.RestError;
import com.vmware.transport.core.model.RestOperation;
import com.vmware.transport.core.model.RestServiceRequest;
import com.vmware.transport.core.util.ClassMapper;
import com.vmware.transport.core.util.RestControllerInvoker;
import com.vmware.transport.core.util.URIMatcher;
import com.vmware.transport.core.util.URIMethodResult;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class RestService
extends AbstractService<Request<RestServiceRequest>, Response> {
    private final URIMatcher uriMatcher;
    private final RestControllerInvoker controllerInvoker;
    private final ObjectMapper mapper;
    private BusStore<String, String> baseHostStore;
    private JsonParser parser;

    @Autowired
    public RestService(URIMatcher uriMatcher, RestControllerInvoker controllerInvoker) {
        super("fabric-rest");
        this.uriMatcher = uriMatcher;
        this.controllerInvoker = controllerInvoker;
        this.mapper = new ObjectMapper();
        this.parser = new JsonParser();
    }

    @PostConstruct
    public void setUp() {
        this.storeManager.createStore("service-wide-headers-store");
        this.baseHostStore = this.storeManager.createStore("rest-service-hostconfig");
    }

    private String getBaseHost() {
        return this.baseHostStore.get("host");
    }

    private String getBasePort() {
        return this.baseHostStore.get("port");
    }

    @Override
    protected void handleServiceRequest(Request req, Message message) {
        RestOperation operation = new RestOperation();
        RestServiceRequest request = (RestServiceRequest)ClassMapper.CastPayload(RestServiceRequest.class, req);
        request.setHeaders((Map)req.getHeaders());
        this.logDebugMessage(this.getClass().getSimpleName() + " handling Rest Request for URI: " + request.getUri().toASCIIString());
        request.setUri(this.modifyURI(request.getUri()));
        operation.setUri(request.getUri());
        operation.setBody(request.getBody());
        operation.setMethod(request.getMethod());
        if (request.getHeaders() != null && request.getHeaders().keySet().size() > 0) {
            request.getHeaders().forEach((key, value) -> operation.getHeaders().merge((String)key, (String)value, (v, v2) -> v2));
        }
        operation.setApiClass(request.getApiClass());
        operation.setId(req.getId());
        operation.setSentFrom(this.getName());
        Consumer<Object> successHandler = restResponseObject -> {
            this.logDebugMessage(this.getClass().getSimpleName() + " Successful REST response " + request.getUri().toASCIIString());
            if (restResponseObject instanceof String) {
                JsonElement respJson = this.parser.parse(restResponseObject.toString());
                restResponseObject = respJson.toString();
            }
            Response<Object> response = new Response<Object>(req.getId(), restResponseObject);
            this.sendResponse(response, req.getId());
        };
        operation.setSuccessHandler(successHandler);
        Consumer<RestError> errorHandler = error -> {
            this.logErrorMessage(this.getClass().getSimpleName() + " Error with making REST response ", request.getUri().toASCIIString());
            Response<RestError> response = new Response<RestError>(req.getId(), (RestError)error);
            response.setError(true);
            response.setErrorCode(error.errorCode);
            response.setErrorMessage(error.message);
            this.sendError(response, req.getId());
        };
        operation.setErrorHandler(errorHandler);
        this.restServiceRequest(operation);
    }

    private URI modifyURI(URI origUri) {
        if (this.getBaseHost() != null && this.getBaseHost().length() > 0) {
            String baseHost = this.getBaseHost();
            this.logDebugMessage(this.getClass().getSimpleName() + " using over-ridden base host: " + baseHost);
            String uri = origUri.toString();
            UriComponentsBuilder b = UriComponentsBuilder.fromHttpUrl((String)uri);
            b.host(baseHost);
            String port = this.getBasePort();
            if (port != null && port.length() > 0) {
                b.port(port);
            }
            return URI.create(b.toUriString());
        }
        return origUri;
    }

    @Override
    protected void restServiceRequest(RestOperation operation) {
        block22: {
            try {
                URIMethodResult methodResult = this.locateRestControllerForURIAndMethod(operation);
                if (methodResult != null && methodResult.getMethod() != null) {
                    this.invokeRestController(methodResult, operation);
                    return;
                }
            }
            catch (Exception e) {
                this.logErrorMessage("Exception when Locating & Invoking RestController ", e.toString());
                if (operation == null || operation.getErrorHandler() == null) break block22;
                operation.getErrorHandler().accept(new RestError("Exception when Locating & Invoking RestController", 500));
            }
        }
        operation.setUri(this.modifyURI(operation.getUri()));
        HttpHeaders headers = new HttpHeaders();
        MediaType mediaType = new MediaType("application", "merge-patch+json");
        if (operation.getHeaders() != null) {
            Map<String, String> opHeaders = operation.getHeaders();
            Set<String> keySet = opHeaders.keySet();
            for (String key : keySet) {
                headers.add(key, opHeaders.get(key));
            }
        }
        if (headers.getContentType() == null) {
            headers.setContentType(mediaType);
        }
        HttpEntity entity = new HttpEntity(operation.getBody(), (MultiValueMap)headers);
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        try {
            switch (operation.getMethod()) {
                case GET: {
                    ResponseEntity resp = restTemplate.exchange(operation.getUri(), HttpMethod.GET, entity, Class.forName(operation.getApiClass()));
                    operation.getSuccessHandler().accept(resp.getBody());
                    break;
                }
                case POST: {
                    ResponseEntity resp = restTemplate.exchange(operation.getUri(), HttpMethod.POST, entity, Class.forName(operation.getApiClass()));
                    operation.getSuccessHandler().accept(resp.getBody());
                    break;
                }
                case PUT: {
                    ResponseEntity resp = restTemplate.exchange(operation.getUri(), HttpMethod.PUT, entity, Class.forName(operation.getApiClass()));
                    operation.getSuccessHandler().accept(resp.getBody());
                    break;
                }
                case PATCH: {
                    ResponseEntity resp = restTemplate.exchange(operation.getUri(), HttpMethod.PATCH, entity, Class.forName(operation.getApiClass()));
                    operation.getSuccessHandler().accept(resp.getBody());
                    break;
                }
                case DELETE: {
                    ResponseEntity resp = restTemplate.exchange(operation.getUri(), HttpMethod.DELETE, entity, Class.forName(operation.getApiClass()));
                    operation.getSuccessHandler().accept(resp.getBody());
                }
            }
        }
        catch (RestClientResponseException exp) {
            Object upstreamErrorObject;
            int errorCode;
            String errorMsg;
            try {
                Response errorResponse = (Response)this.mapper.readValue(exp.getResponseBodyAsString(), Response.class);
                errorMsg = errorResponse.getErrorMessage();
                errorCode = errorResponse.getErrorCode();
            }
            catch (IOException ioe) {
                errorMsg = exp.getResponseBodyAsString();
                errorCode = exp.getRawStatusCode();
            }
            this.logErrorMessage("REST Client Error, unable to complete request: ", errorMsg);
            ObjectMapper mapper = new ObjectMapper();
            try {
                upstreamErrorObject = mapper.readValue(errorMsg, LinkedHashMap.class);
            }
            catch (IOException e) {
                upstreamErrorObject = errorMsg;
            }
            RestError restError = new RestError("REST Client Error, unable to complete request: " + errorMsg, upstreamErrorObject, errorCode);
            operation.getErrorHandler().accept(restError);
        }
        catch (NullPointerException npe) {
            this.logErrorMessage("Null Pointer Exception when making REST Call", npe.toString());
            operation.getErrorHandler().accept(new RestError("Null Pointer exception thrown for: " + operation.getUri().toString(), 500));
        }
        catch (RuntimeException rex) {
            this.logErrorMessage("REST Client Error, unable to complete request: ", rex.toString());
            operation.getErrorHandler().accept(new RestError("REST Client Error, unable to complete request: " + operation.getUri().toString(), 500));
        }
        catch (ClassNotFoundException cnfexp) {
            this.logErrorMessage("Class Not Found Exception when making REST Call", cnfexp.toString());
            operation.getErrorHandler().accept(new RestError("Class Not Found Exception thrown for: " + operation.getUri().toString(), 500));
        }
    }

    private URIMethodResult locateRestControllerForURIAndMethod(RestOperation operation) throws Exception {
        URIMethodResult result = this.uriMatcher.findControllerMatch(operation.getUri(), RequestMethod.valueOf((String)operation.getMethod().toString()));
        if (result != null) {
            this.logDebugMessage("Located handling method for URI: " + operation.getUri().getRawPath(), result.getMethod().getName());
        } else {
            this.logDebugMessage("Unable to locate a local handler for for URI: ", operation.getUri().getRawPath());
        }
        return result;
    }

    private void invokeRestController(URIMethodResult result, RestOperation operation) {
        this.controllerInvoker.invokeMethod(result, operation);
    }
}

