/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.core.autogen;

import com.google.gson.Gson;
import com.vmware.transport.bridge.AbstractFrame;
import com.vmware.transport.bridge.Request;
import com.vmware.transport.bridge.Response;
import com.vmware.transport.bus.model.Message;
import com.vmware.transport.core.AbstractService;
import com.vmware.transport.core.autogen.ApiType;
import com.vmware.transport.core.autogen.IApiType;
import com.vmware.transport.core.autogen.IRestApiBridge;
import com.vmware.transport.core.error.RestError;
import com.vmware.transport.core.model.RestOperation;
import java.net.URI;
import java.util.function.Consumer;
import lombok.Generated;

public abstract class AbstractAutoService<RequestType extends Request, ResponseType extends Response>
extends AbstractService<RequestType, ResponseType> {
    protected String apihost = null;
    public static final Integer SERVICE_ERROR = 505;
    protected IRestApiBridge<RequestType, ResponseType> restApiBridge;
    protected RestError serviceError = new RestError("Invalid Service APIRequest!", SERVICE_ERROR);

    public AbstractAutoService(String serviceChannel) {
        super(serviceChannel);
        this.initializeRestApiHandling();
    }

    private void initializeRestApiHandling() {
        this.restApiBridge = (apiType, method, uri, jsonBody, successHandler, failureHandler, apiClassName, message) -> {
            if (this.apihost != null) {
                uri = this.apihost + ((String)uri).replaceAll("https?://", "");
            }
            Consumer<Object> restResponse = payload -> successHandler.apiSuccessHandler(apiType, payload, message);
            Consumer<RestError> restError = err -> failureHandler.apiFailureHandler(apiType, (RestError)err, message);
            RestOperation<String, Object> restOp = new RestOperation<String, Object>();
            restOp.setApiClass("java.lang.Object");
            restOp.setMethod(method);
            restOp.setUri(URI.create(uri));
            restOp.setBody(jsonBody);
            restOp.setSentFrom(this.getName());
            restOp.setSuccessHandler(restResponse);
            restOp.setErrorHandler(restError);
            restOp.setId(message.getId());
            if (message.getHeaders() != null) {
                restOp.setHeaders(message.getHeaders().getHeadersMap());
            }
            restOp.getHeaders().putAll(apiType.getApiHeaders());
            this.restServiceRequest(restOp);
        };
    }

    protected void apiSuccessHandler(IApiType<RequestType, ResponseType> apiType, Object payload, Message message) {
        ((AbstractFrame)apiType.getResponseType()).setPayload((Object)payload);
        this.postResponse(this.serviceChannel, apiType.getResponseType(), message);
    }

    protected void apiFailureHandler(IApiType<RequestType, ResponseType> apiType, RestError err, Message message) {
        this.postError(this.serviceChannel, err, message);
    }

    protected ApiType genApiObject(RequestType req, ResponseType resp) {
        return new ApiType<RequestType, ResponseType>(req, resp);
    }

    protected void broadcastResponse(String channel, Object payload) {
        this.bus.sendResponseMessage(channel, payload);
    }

    protected void broadcastNotification(String channel, Object payload) {
        this.broadcastResponse(channel, payload);
    }

    protected void postResponse(String channel, ResponseType response, Message message) {
        Gson gson = new Gson();
        ((AbstractFrame)response).setPayload((String)gson.toJson(((AbstractFrame)response).getPayload()));
        ((AbstractFrame)response).setId(message.getId());
        this.bus.sendResponseMessageWithId(channel, response, message.getId());
    }

    protected void postError(String channel, RestError err, Message message) {
        Response resp = new Response(message.getId(), true);
        resp.setErrorMessage(err.message);
        resp.setErrorCode(err.errorCode);
        resp.setPayload(err.errorObject);
        this.bus.sendErrorMessageWithId(channel, resp, message.getId());
    }

    protected RestError serviceRequestError() {
        return this.serviceError;
    }

    protected String callerOrgId() {
        return "TODO: Implement callerOrgId";
    }

    @Generated
    public String getApihost() {
        return this.apihost;
    }

    @Generated
    public void setApihost(String apihost) {
        this.apihost = apihost;
    }
}

