/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.core;

import com.vmware.transport.bridge.Request;
import com.vmware.transport.bridge.Response;
import com.vmware.transport.bus.model.Message;
import com.vmware.transport.core.AbstractService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:transport.properties"}, ignoreResourceNotFound=true)
public class VersionService
extends AbstractService<Request<String>, Response<String>> {
    @Value(value="${transport.version:local.dev}")
    private String transportVersion;

    VersionService() {
        super("fabric-version");
    }

    @Override
    protected void handleServiceRequest(Request request, Message busMessage) {
        switch (request.getRequest()) {
            case "version": {
                this.handleVersionRequest(request);
                break;
            }
            default: {
                this.handleUnknownRequest(request);
            }
        }
    }

    private void handleVersionRequest(Request request) {
        Response<String> response = new Response<String>(request.getId(), this.transportVersion);
        this.sendResponse(response, request.getId());
    }
}

