/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.core;

import com.fasterxml.jackson.databind.MapperFeature;
import com.vmware.transport.bridge.AbstractFrame;
import com.vmware.transport.bridge.Request;
import com.vmware.transport.bridge.Response;
import com.vmware.transport.bus.BusTransaction;
import com.vmware.transport.bus.model.Message;
import com.vmware.transport.core.AbstractBase;
import com.vmware.transport.core.error.GeneralError;
import com.vmware.transport.core.interfaces.BusServiceEnabled;
import io.reactivex.functions.Consumer;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.UUID;

public abstract class AbstractService<RequestType extends Request, ResponseType extends Response>
extends AbstractBase
implements BusServiceEnabled {
    protected String serviceChannel;
    protected BusTransaction serviceChannelStream;

    public AbstractService(String serviceChannel) {
        this.serviceChannel = serviceChannel;
        this.mapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES});
    }

    String getServiceChannel() {
        return this.serviceChannel;
    }

    private Response<GeneralError> buildErrorResponse(RequestType requestType) {
        if (!((Request)requestType).getIsRejected().booleanValue()) {
            return null;
        }
        Response<GeneralError> errorResponse = null;
        GeneralError generalError = null;
        try {
            generalError = (GeneralError)this.mapper.readValue(((AbstractFrame)requestType).getPayload().toString(), GeneralError.class);
        }
        catch (IOException e) {
            generalError = new GeneralError();
            generalError.errorCode = 500;
            generalError.message = "Failed to parse request payload into GeneralError: " + e.getMessage();
        }
        errorResponse = new Response<GeneralError>(((AbstractFrame)requestType).getId(), generalError);
        errorResponse.setErrorCode(generalError.errorCode);
        errorResponse.setError(true);
        errorResponse.setErrorMessage(generalError.message);
        return errorResponse;
    }

    @Override
    public void initialize() {
        this.online();
    }

    protected abstract void handleServiceRequest(RequestType var1, Message var2) throws Exception;

    protected void sendResponse(ResponseType response, UUID id) {
        this.logInfoMessage("\ud83d\udce4", "Sending Service Response", ((Response)response).toString());
        this.bus.sendResponseMessageWithId(this.serviceChannel, response, id);
    }

    protected void sendResponse(ResponseType response, UUID id, String targetUser) {
        String logMessageTemplate = "Sending Service Response%s";
        this.logInfoMessage("\ud83d\udce4", String.format(logMessageTemplate, targetUser != null ? String.format(" to %s", targetUser) : ""), ((Response)response).toString());
        this.bus.sendResponseMessageToTarget(this.serviceChannel, response, id, targetUser);
    }

    protected <E extends GeneralError> void sendError(E error, UUID id) {
        this.bus.sendErrorMessageWithId(this.serviceChannel, error, id);
    }

    protected <E extends GeneralError> void sendError(E error, UUID id, String targetUser) {
        this.bus.sendErrorMessageToTarget(this.serviceChannel, error, id, targetUser);
    }

    protected void sendError(Response errorResponse, UUID id) {
        this.bus.sendErrorMessageWithId(this.serviceChannel, errorResponse, id);
    }

    protected void sendError(Response errorResponse, UUID id, String targetUser) {
        this.bus.sendErrorMessageToTarget(this.serviceChannel, errorResponse, id, targetUser);
    }

    <T> T castPayload(Class clazz, Request request) throws ClassCastException {
        return (T)this.mapper.convertValue(request.getPayload(), clazz);
    }

    protected void handleUnknownRequest(Request request) {
        String unknownRequest = this.getName() + ": Unknown Request/Command '" + request.getRequest() + "'";
        Response<CallSite> response = new Response<CallSite>(request.getId(), (CallSite)((Object)unknownRequest));
        this.logInfoMessage("\ud83d\udce4", "Sending Service Response (Unknown Request)", response.toString());
        this.bus.sendResponseMessageWithId(this.serviceChannel, response, request.getId());
    }

    @Override
    public void online() {
        this.serviceChannelStream = this.bus.listenRequestStream(this.serviceChannel, (Consumer<Message>)((Consumer)message -> {
            try {
                Request requestType = (Request)message.getPayload();
                Response<GeneralError> requestError = this.buildErrorResponse(requestType);
                String logMessageTemplate = "Service Request Received%s";
                boolean isPrivateMessage = requestType.getTargetUser() != null;
                this.logInfoMessage("\ud83d\udce5", String.format(logMessageTemplate, isPrivateMessage ? String.format(" from %s", requestType.getTargetUser()) : ""), message.getPayload().toString());
                if (requestError != null) {
                    if (isPrivateMessage) {
                        this.bus.sendErrorMessageToTarget(this.serviceChannel, requestError, requestType.getId(), requestType.getTargetUser());
                    } else {
                        this.bus.sendErrorMessageWithId(this.serviceChannel, requestError, requestType.getId());
                    }
                    return;
                }
                message.setId(requestType.getId());
                this.handleServiceRequest((RequestType)requestType, (Message)message);
            }
            catch (ClassCastException cce) {
                this.logErrorMessage("Service unable to process request, request cannot be cast", message.getPayload().getClass().getSimpleName());
                GeneralError error = new GeneralError(this.getClass().getSimpleName() + " cannot handle request, payload isn't derived from 'Request', type: " + message.getPayload().getClass().getSimpleName(), cce, 500);
                this.sendError(error, message.getId());
            }
        }), (Consumer<Message>)((Consumer)message -> {}));
        this.logInfoMessage("\ud83d\udce3", this.getClass().getSimpleName() + " initialized, handling requests on channel", this.serviceChannel);
    }

    @Override
    public void offline() {
        this.serviceChannelStream.unsubscribe();
    }
}

