/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.bus.store;

import com.vmware.transport.bus.EventBus;
import com.vmware.transport.bus.store.BusStoreApi;
import com.vmware.transport.bus.store.model.BusStore;
import com.vmware.transport.bus.store.model.BusStoreImpl;
import com.vmware.transport.bus.store.model.StoreReadyResult;
import com.vmware.transport.core.util.Loggable;
import io.reactivex.functions.Consumer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="storeManager")
public class StoreManager
extends Loggable
implements BusStoreApi {
    private final Map<String, Object> storeMap = new ConcurrentHashMap<String, Object>();
    private EventBus bus;

    @Autowired
    public StoreManager(EventBus bus) {
        this.bus = bus;
    }

    @Override
    public <K, T> BusStore<K, T> createStore(String storeType) {
        if (storeType == null) {
            return null;
        }
        if (this.storeMap.containsKey(storeType)) {
            return (BusStore)this.storeMap.get(storeType);
        }
        BusStoreImpl busStore = new BusStoreImpl(this.bus, storeType);
        this.storeMap.put(storeType, busStore);
        return busStore;
    }

    @Override
    public <K, T> BusStore<K, T> getStore(String storeType) {
        if (storeType == null) {
            return null;
        }
        return (BusStore)this.storeMap.get(storeType);
    }

    @Override
    public boolean destroyStore(String storeType) {
        if (storeType == null) {
            return false;
        }
        return this.storeMap.remove(storeType) != null;
    }

    @Override
    public StoreReadyResult readyJoin(final String ... storeTypes) {
        if (ArrayUtils.isEmpty((Object[])storeTypes)) {
            return null;
        }
        return new StoreReadyResult(){

            @Override
            public void whenReady(Consumer<Void> successHandler) {
                AtomicInteger readyStores = new AtomicInteger(0);
                for (String storeType : storeTypes) {
                    StoreManager.this.createStore(storeType).whenReady(uuidObjectMap -> {
                        if (readyStores.incrementAndGet() == storeTypes.length) {
                            successHandler.accept(null);
                        }
                    });
                }
            }
        };
    }

    @Override
    public void wipeAllStores() {
        this.logInfoMessage("\ud83d\uddc4", this.getName(), "Stores: All data has been wiped out and reset.");
        for (Object storeObj : this.storeMap.values()) {
            ((BusStore)storeObj).reset();
        }
    }
}

