/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.bus.model;

import com.vmware.transport.bus.model.Message;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.concurrent.atomic.AtomicInteger;

public class Channel {
    private String name;
    private AtomicInteger refCount = new AtomicInteger(0);
    private Boolean closed;
    private Subject<Message> streamObject;

    public Channel(String name) {
        this.name = name;
        this.streamObject = PublishSubject.create();
        this.closed = false;
    }

    public Integer getRefCount() {
        return this.refCount.get();
    }

    public String getName() {
        return this.name;
    }

    public Subject<Message> getStreamObject() {
        return this.streamObject;
    }

    public Boolean isClosed() {
        return this.closed;
    }

    public void send(Message messageObject) {
        this.streamObject.onNext((Object)messageObject);
    }

    public void error(Error error) {
        this.streamObject.onError((Throwable)error);
    }

    public void complete() {
        this.streamObject.onComplete();
        this.closed = true;
    }

    public Integer increment() {
        return this.refCount.incrementAndGet();
    }

    public Integer decrement() {
        return this.refCount.updateAndGet(i -> i > 0 ? i - 1 : i);
    }
}

