/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.bus;

import com.vmware.transport.bus.EventBus;
import com.vmware.transport.bus.Transaction;
import com.vmware.transport.bus.TransactionReceipt;
import com.vmware.transport.bus.model.Message;
import com.vmware.transport.bus.model.MessageObject;
import com.vmware.transport.bus.model.MessageType;
import com.vmware.transport.bus.store.BusStoreApi;
import com.vmware.transport.core.util.Loggable;
import io.reactivex.functions.Consumer;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

public class TransactionImpl
extends Loggable
implements Transaction {
    private final EventBus bus;
    private final BusStoreApi storeManager;
    private final Transaction.TransactionType transactionType;
    private final String transactionName;
    private final UUID id;
    private boolean useRandomIdForRequests;
    private TransactionState state;
    private List<Consumer<Message[]>> onCompleteHandlers = new ArrayList<Consumer<Message[]>>();
    private List<Consumer<Message>> onErrorHandlers = new ArrayList<Consumer<Message>>();
    private List<TransactionRequest> requests = new ArrayList<TransactionRequest>();
    private Message[] responses;
    private TransactionReceiptImpl transactionReceipt;

    public TransactionImpl(EventBus bus, BusStoreApi storeManager, Transaction.TransactionType type, String name) {
        this(bus, storeManager, type, name, UUID.randomUUID());
        this.useRandomIdForRequests = true;
    }

    public TransactionImpl(EventBus bus, BusStoreApi storeManager, Transaction.TransactionType type, String name, UUID id) {
        this.bus = bus;
        this.storeManager = storeManager;
        this.transactionType = type;
        this.id = id;
        this.useRandomIdForRequests = false;
        this.transactionName = name != null ? name : "transaction-" + this.id.toString();
        this.state = TransactionState.uncommitted;
    }

    @Override
    public void sendRequest(String channel, Object payload) {
        this.assertUncommittedState("cannot queue a new request via sendRequest()");
        this.requests.add(new TransactionRequest(this.requests.size(), channel, payload, null, this.id));
    }

    @Override
    public void waitForStoreReady(String storeType) {
        this.assertUncommittedState("cannot queue a new request via sendRequest()");
        this.requests.add(new TransactionRequest(this.requests.size(), null, null, storeType, this.id));
    }

    @Override
    public void onComplete(Consumer<Message[]> completeHandler) {
        this.assertUncommittedState("cannot register onComplete() handler");
        this.onCompleteHandlers.add(completeHandler);
    }

    @Override
    public void onError(Consumer<Message> errorHandler) {
        this.assertUncommittedState("cannot register onError() handler");
        this.onErrorHandlers.add(errorHandler);
    }

    @Override
    public TransactionReceipt commit() {
        this.assertUncommittedState("cannot commit transaction");
        if (this.requests.isEmpty()) {
            throw new IllegalStateException("Transaction cannot be committed, no requests made.");
        }
        this.state = TransactionState.committed;
        this.transactionReceipt = new TransactionReceiptImpl(this.requests.size());
        this.responses = new Message[this.requests.size()];
        if (this.transactionType == Transaction.TransactionType.SYNC) {
            this.startSyncTransaction();
        } else {
            this.startAsyncTransaction();
        }
        return this.transactionReceipt;
    }

    private void startAsyncTransaction() {
        for (TransactionRequest request : this.requests) {
            if (request.isStoreTransaction()) {
                this.waitForStoreAndListen(request, null);
                continue;
            }
            this.sendRequestAndListen(request, null);
        }
    }

    private void startSyncTransaction() {
        PublishSubject syncStream = PublishSubject.create();
        syncStream.subscribe(arg_0 -> this.lambda$startSyncTransaction$1((Subject)syncStream, arg_0));
        syncStream.onNext((Object)this.requests.get(0));
    }

    private void waitForStoreAndListen(TransactionRequest request, Consumer<Message> onSuccess) {
        this.logDebugMessage(String.format("\u27a1\ufe0f Transaction: Waiting '%s' for store '%s'", this.transactionType.toString(), request.storeType), this.transactionName);
        ++this.transactionReceipt.requestsSent;
        this.storeManager.createStore(request.storeType).whenReady(map -> {
            if (this.state == TransactionState.aborted) {
                return;
            }
            this.onTransactionRequestSuccess(request, new MessageObject<Map>(MessageType.MessageTypeResponse, (Map)map), onSuccess);
        });
    }

    private void sendRequestAndListen(TransactionRequest request, Consumer<Message> onSuccess) {
        this.logDebugMessage(String.format("-->\ufe0f Transaction: Sending '%s' Request to channel: %s", this.transactionType.toString(), request.channel), this.transactionName);
        ++this.transactionReceipt.requestsSent;
        UUID requestId = this.useRandomIdForRequests ? UUID.randomUUID() : request.id;
        this.bus.requestOnceWithId(requestId, request.channel, request.payload, request.channel, this.transactionName, (Consumer<Message>)((Consumer)response -> {
            if (this.state == TransactionState.aborted) {
                return;
            }
            this.logDebugMessage(String.format("<-- Transaction: Received '%s' Response on channel: %s - %s", new Object[]{this.transactionType, request.channel, response.toString()}), this.transactionName);
            this.onTransactionRequestSuccess(request, (Message)response, onSuccess);
        }), (Consumer<Message>)((Consumer)errMessage -> {
            if (this.state == TransactionState.aborted) {
                return;
            }
            this.logDebugMessage(String.format("<-- Transaction: Received '%s' Error response on channel: %s - %s", new Object[]{this.transactionType, request.channel, errMessage.toString()}), this.transactionName);
            this.onTransactionError((Message)errMessage);
        }));
    }

    private void onTransactionRequestSuccess(TransactionRequest request, Message response, Consumer<Message> onSuccess) throws Exception {
        ++this.transactionReceipt.requestsCompleted;
        this.responses[request.requestIndex] = response;
        if (onSuccess != null) {
            onSuccess.accept((Object)response);
        }
        if (this.transactionReceipt.requestsCompleted == this.transactionReceipt.totalRequests) {
            this.onTransactionComplete();
        }
    }

    private void onTransactionError(Message errMessage) throws Exception {
        this.state = TransactionState.aborted;
        this.transactionReceipt.aborted = true;
        this.transactionReceipt.abortedTime = new Date();
        for (Consumer<Message> onErrorHandler : this.onErrorHandlers) {
            onErrorHandler.accept((Object)errMessage);
        }
    }

    private void onTransactionComplete() throws Exception {
        this.transactionReceipt.complete = true;
        this.transactionReceipt.completedTime = new Date();
        this.state = TransactionState.completed;
        for (Consumer<Message[]> onCompleteHandler : this.onCompleteHandlers) {
            onCompleteHandler.accept((Object)this.responses);
        }
    }

    private void assertUncommittedState(String msg) {
        if (this.state != TransactionState.uncommitted) {
            this.logWarnMessage(String.format("Transaction '%s' is in '%s' state: %s", this.transactionName, this.state.toString(), msg));
            throw new IllegalStateException(String.format("Transaction %s is in '%s' state", this.id, this.state.toString()));
        }
    }

    private /* synthetic */ void lambda$startSyncTransaction$1(Subject syncStream, TransactionRequest request) throws Exception {
        Consumer requestHandler = response -> {
            if (request.requestIndex + 1 < this.requests.size()) {
                syncStream.onNext((Object)this.requests.get(request.requestIndex + 1));
            }
        };
        if (request.isStoreTransaction()) {
            this.waitForStoreAndListen(request, (Consumer<Message>)requestHandler);
        } else {
            this.sendRequestAndListen(request, (Consumer<Message>)requestHandler);
        }
    }

    private static class TransactionReceiptImpl
    implements TransactionReceipt {
        public int totalRequests;
        public int requestsSent;
        public int requestsCompleted;
        public boolean complete;
        public boolean aborted;
        public Date startedTime;
        public Date completedTime;
        public Date abortedTime;

        TransactionReceiptImpl(int totalRequests) {
            this.totalRequests = totalRequests;
            this.startedTime = new Date();
        }

        @Override
        @Generated
        public int getTotalRequests() {
            return this.totalRequests;
        }

        @Override
        @Generated
        public int getRequestsSent() {
            return this.requestsSent;
        }

        @Override
        @Generated
        public int getRequestsCompleted() {
            return this.requestsCompleted;
        }

        @Override
        @Generated
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        @Generated
        public boolean isAborted() {
            return this.aborted;
        }

        @Override
        @Generated
        public Date getStartedTime() {
            return this.startedTime;
        }

        @Override
        @Generated
        public Date getCompletedTime() {
            return this.completedTime;
        }

        @Override
        @Generated
        public Date getAbortedTime() {
            return this.abortedTime;
        }
    }

    private static class TransactionRequest {
        final int requestIndex;
        final String channel;
        final Object payload;
        final UUID id;
        final String storeType;

        TransactionRequest(int index, String channel, Object payload, String storeType, UUID id) {
            this.requestIndex = index;
            this.payload = payload;
            this.channel = channel;
            this.storeType = storeType;
            this.id = id;
        }

        public boolean isStoreTransaction() {
            return this.storeType != null;
        }
    }

    private static enum TransactionState {
        uncommitted,
        committed,
        completed,
        aborted;

    }
}

