/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.bridge.spring.services;

import com.vmware.transport.bridge.BridgeChannelMode;
import com.vmware.transport.bridge.spring.TransportEnabled;
import com.vmware.transport.bridge.spring.TransportService;
import com.vmware.transport.bridge.spring.services.TransportBridgeSubscriptionRegistry;
import com.vmware.transport.bridge.util.BridgeUtil;
import com.vmware.transport.bus.BusTransaction;
import com.vmware.transport.bus.EventBus;
import com.vmware.transport.bus.model.Message;
import com.vmware.transport.bus.model.MessageObject;
import com.vmware.transport.bus.model.MessageType;
import com.vmware.transport.bus.model.MonitorObject;
import com.vmware.transport.bus.model.MonitorType;
import com.vmware.transport.bus.model.SystemChannels;
import com.vmware.transport.core.util.Loggable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.messaging.SessionSubscribeEvent;

@Service(value="transportSubscriptionService")
@TransportService
public class TransportSubscriptionService
extends Loggable
implements TransportBridgeSubscriptionRegistry,
TransportEnabled {
    @Autowired
    private EventBus bus;
    @Autowired(required=false)
    private SimpMessagingTemplate msgTmpl;
    private Map<String, TransportSubscription> openSubscriptions;
    private Map<String, List<String>> sessionChannels;
    private Map<String, OpenChannel> openChannels;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public TransportSubscriptionService() {
        this.openSubscriptions = new ConcurrentHashMap<String, TransportSubscription>();
        this.openChannels = new ConcurrentHashMap<String, OpenChannel>();
        this.sessionChannels = new HashMap<String, List<String>>();
    }

    @Override
    public Collection<TransportSubscription> getSubscriptions() {
        return new ArrayList<TransportSubscription>(this.openSubscriptions.values());
    }

    @Override
    public Collection<String> getOpenChannels() {
        return new HashSet<String>(this.openChannels.keySet());
    }

    @Override
    public Collection<String> getOpenChannelsWithAttribute(String attribute, Object attributeValue) {
        if (attribute == null || attributeValue == null) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        for (String channel : this.openChannels.keySet()) {
            if (!attributeValue.equals(this.bus.getApi().getChannelAttribute(channel, attribute))) continue;
            result.add(channel);
        }
        return result;
    }

    private void handleResponseMessage(Message msg, String destinationPrefix, String channelName) {
        if (msg.isError()) {
            this.logWarnMessage("Transport sending error payload over socket: " + msg.getPayload().toString() + " to " + channelName);
        } else {
            this.logTraceMessage("Transport sending payload over socket: " + msg.getPayload().toString() + " to ", channelName);
        }
        String destinationHeaderValue = (String)msg.getHeader("ext-msg-broker-destination");
        Object destination = null;
        if (destinationHeaderValue != null && !destinationHeaderValue.isEmpty()) {
            destination = destinationHeaderValue;
        }
        if (msg.getTargetUser() != null) {
            if (destination == null) {
                destination = destinationPrefix.replace("/user", "") + channelName;
            }
            this.msgTmpl.convertAndSendToUser(msg.getTargetUser(), (String)destination, msg.getPayload());
        } else {
            if (destination == null) {
                destination = destinationPrefix + channelName;
            }
            this.msgTmpl.convertAndSend(destination, msg.getPayload());
        }
    }

    public synchronized void addSubscription(String subId, String sessionId, String channelName, String destinationPrefix, SessionSubscribeEvent subscribeEvent) {
        TransportSubscription subscription = new TransportSubscription(channelName, subId, sessionId, destinationPrefix);
        if (this.openSubscriptions.containsKey(subscription.uniqueId)) {
            this.logger.info(String.format("[!] Transport Bus: subscription %s for channel %s already exists, ignoring", subscription.uniqueId, channelName));
            return;
        }
        if (BridgeUtil.getBridgeChannelMode(this.bus, channelName) == BridgeChannelMode.REQUESTS_ONLY) {
            this.logger.debug("Subscribing to REQUEST_ONLY channel: " + channelName);
            return;
        }
        this.logger.info(String.format("[+] Transport Bus: creating channel subscription to '%s' subId: (%s)", channelName, subscription.uniqueId));
        if (!this.openChannels.containsKey(channelName)) {
            BusTransaction transaction = this.bus.listenStream(channelName, (Consumer<Message>)((Consumer)msg -> this.handleResponseMessage((Message)msg, destinationPrefix, channelName)), (Consumer<Message>)((Consumer)msg -> this.handleResponseMessage((Message)msg, destinationPrefix, channelName)));
            this.openChannels.put(channelName, new OpenChannel(channelName, transaction));
        }
        this.openSubscriptions.put(subscription.uniqueId, subscription);
        ++this.openChannels.get((Object)channelName).activeSubscriptionsCount;
        if (this.sessionChannels.containsKey(sessionId)) {
            this.sessionChannels.get(sessionId).add(channelName);
        } else {
            ArrayList<String> chanList = new ArrayList<String>();
            chanList.add(channelName);
            this.sessionChannels.put(sessionId, chanList);
        }
        MonitorObject mo = new MonitorObject(MonitorType.MonitorNewBridgeSubscription, channelName, this.getClass().getName(), new NewBridgeSubscriptionEvent(subscription, subscribeEvent));
        this.bus.getApi().getMonitorStream().send(new MessageObject<MonitorObject>(MessageType.MessageTypeRequest, mo));
    }

    public synchronized void removeSubscription(String subId, String sessionId) {
        String uniqueSubId = TransportSubscription.generateUniqueSubId(subId, sessionId);
        if (this.openSubscriptions.containsKey(uniqueSubId)) {
            TransportSubscription sub = this.openSubscriptions.get(uniqueSubId);
            this.logger.info(String.format("[-] Transport Bus: unsubscribing from channel '%s' (%s)", sub.channelName, sub.uniqueId));
            this.openSubscriptions.remove(uniqueSubId);
            this.onUnsubscribeFromChannel(sub.channelName);
            if (this.sessionChannels.containsKey(sessionId)) {
                List<String> chans = this.sessionChannels.get(sessionId);
                chans.remove(sub.channelName);
            }
        }
    }

    public synchronized void unsubscribeSessionsAfterDisconnect(String sessionId) {
        if (this.sessionChannels.containsKey(sessionId)) {
            Collection<TransportSubscription> subs = this.openSubscriptions.values();
            ArrayList<String> subscriptionsToRemove = new ArrayList<String>();
            for (TransportSubscription sub : subs) {
                if (!sub.sessionId.equals(sessionId)) continue;
                this.logger.info(String.format("[-] Transport Bus: closing subscription %s to channel '%s' after disconnect", sub.uniqueId, sub.channelName));
                this.onUnsubscribeFromChannel(sub.channelName);
                subscriptionsToRemove.add(sub.uniqueId);
            }
            for (String subId : subscriptionsToRemove) {
                this.openSubscriptions.remove(subId);
            }
            this.sessionChannels.remove(sessionId);
        }
    }

    @Override
    public void initialize() {
        Consumer extMsgBrokerResponseHandler = message -> {
            String destination = (String)message.getHeader("ext-msg-broker-destination");
            if (destination == null || destination.isEmpty()) {
                this.logger.warn("Transport failed to send external broker message: invalid destination header");
            } else {
                this.msgTmpl.convertAndSend((Object)destination, message.getPayload());
            }
        };
        this.bus.listenStream(SystemChannels.EXTERNAL_MESSAGE_BROKER, (Consumer<Message>)extMsgBrokerResponseHandler, (Consumer<Message>)extMsgBrokerResponseHandler);
    }

    private void onUnsubscribeFromChannel(String channel) {
        OpenChannel openChannel = this.openChannels.get(channel);
        if (openChannel != null) {
            --openChannel.activeSubscriptionsCount;
            if (openChannel.activeSubscriptionsCount <= 0) {
                if (openChannel.transaction != null) {
                    openChannel.transaction.unsubscribe();
                }
                this.bus.closeChannel(channel, this.getClass().getName());
                this.openChannels.remove(channel);
            }
        }
    }

    public static class TransportSubscription {
        public final String channelName;
        public final String subId;
        public final String sessionId;
        public final String destinationPrefix;
        public final String uniqueId;

        public static String generateUniqueSubId(String subId, String sessionId) {
            return String.format("%s-%s", sessionId, subId);
        }

        public TransportSubscription(String channelName, String subId, String sessionId, String destinationPrefix) {
            this.uniqueId = TransportSubscription.generateUniqueSubId(subId, sessionId);
            this.channelName = channelName;
            this.subId = subId;
            this.sessionId = sessionId;
            this.destinationPrefix = destinationPrefix;
        }
    }

    public static class NewBridgeSubscriptionEvent {
        public final TransportSubscription transportSubscription;
        public final SessionSubscribeEvent subscribeEvent;

        public NewBridgeSubscriptionEvent(TransportSubscription subscription, SessionSubscribeEvent subscribeEvent) {
            this.transportSubscription = subscription;
            this.subscribeEvent = subscribeEvent;
        }
    }

    private static class OpenChannel {
        public final String channelName;
        public final BusTransaction transaction;
        public int activeSubscriptionsCount;

        public OpenChannel(String channelName, BusTransaction transaction) {
            this.channelName = channelName;
            this.transaction = transaction;
            this.activeSubscriptionsCount = 0;
        }
    }
}

