/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.transport.bridge.spring.config;

import com.vmware.transport.bridge.spring.config.TransportBridgeConfiguration;
import com.vmware.transport.bridge.spring.config.TransportBridgeConfigurer;
import com.vmware.transport.bridge.spring.config.interceptors.TransportChannelInterceptor;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;

@Configuration
@ComponentScan(basePackages={"com.vmware.transport.bridge.spring.config", "com.vmware.transport.bridge.spring.controllers", "com.vmware.transport.bridge.spring.handlers", "com.vmware.transport.bridge.spring", "com.vmware.transport.bridge", "com.vmware.transport.bus", "com.vmware.transport.bus.store", "com.vmware.transport.core", "com.vmware.transport.core.operations"})
public class TransportSpringConfig
extends AbstractWebSocketMessageBrokerConfigurer
implements SmartInitializingSingleton {
    @Autowired(required=false)
    private TransportBridgeConfigurer[] transportBridgeConfigurers;
    private final TransportBridgeConfiguration bridgeConfiguration = new TransportBridgeConfiguration();

    @Bean
    public TransportBridgeConfiguration transportBridgeConfiguration() {
        return this.bridgeConfiguration;
    }

    @Bean
    public ParameterNameDiscoverer parameterNameDiscoverer() {
        return new DefaultParameterNameDiscoverer();
    }

    public void afterSingletonsInstantiated() {
        if (this.transportBridgeConfigurers != null) {
            for (TransportBridgeConfigurer configurer : this.transportBridgeConfigurers) {
                configurer.registerTransportDestinationPrefixes(this.transportBridgeConfiguration());
                configurer.registerTransportStompInterceptors(this.transportBridgeConfiguration());
                configurer.configureGalacticChannels();
            }
        }
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        TransportChannelInterceptor transportChannelInterceptor = new TransportChannelInterceptor(this.bridgeConfiguration);
        registration.interceptors(new ChannelInterceptor[]{transportChannelInterceptor});
    }
}

