/*
 * Decompiled with CFR 0.152.
 */
package com.vlstr.fluentappbar;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.MenuRes;
import android.support.v7.widget.RecyclerView;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.vlstr.fluentappbar.MenuEntry;
import com.vlstr.fluentappbar.MenuParserHelper;
import com.vlstr.fluentappbar.R;
import java.util.ArrayList;

class MenuSecondaryItemsAdapter
extends RecyclerView.Adapter<MenuItem> {
    private Context context;
    private View.OnClickListener onClickListener;
    private int foregroundColour;
    private boolean keepFluentRipple = true;
    private ArrayList<MenuEntry> itemss;

    MenuSecondaryItemsAdapter(Context context, @MenuRes int secondaryMenuId, View.OnClickListener onClickListener, @ColorInt int foregroundColour) {
        this.context = context;
        this.onClickListener = onClickListener;
        this.foregroundColour = foregroundColour;
        this.itemss = new ArrayList();
        MenuParserHelper.parseMenu(context, secondaryMenuId, this.itemss);
    }

    public MenuItem onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.menu_item, parent, false);
        return new MenuItem(v);
    }

    public void onBindViewHolder(MenuItem holder, int position) {
        holder.label.setText((CharSequence)this.itemss.get(position).getTitle());
        holder.label.setTextColor(this.foregroundColour);
        holder.icon.setImageDrawable(this.itemss.get(position).getIcon());
        holder.icon.setColorFilter(this.foregroundColour);
        holder.itemView.setTag((Object)this.itemss.get(position).getResId());
        this.handleRipple(holder);
        holder.itemView.setOnClickListener(this.onClickListener);
    }

    public int getItemCount() {
        return this.itemss.size();
    }

    public void setForegroundColour(@ColorInt int foregroundColour) {
        this.foregroundColour = foregroundColour;
    }

    public void setKeepFluentRipple(boolean keepFluentRipple) {
        this.keepFluentRipple = keepFluentRipple;
        this.notifyDataSetChanged();
    }

    private void handleRipple(MenuItem holder) {
        if (!this.keepFluentRipple) {
            TypedValue outValue = new TypedValue();
            this.context.getTheme().resolveAttribute(16843534, outValue, true);
            holder.itemView.setBackgroundResource(outValue.resourceId);
        }
    }

    class MenuItem
    extends RecyclerView.ViewHolder {
        ImageView icon;
        TextView label;

        MenuItem(View itemView) {
            super(itemView);
            this.icon = (ImageView)itemView.findViewById(R.id.menu_item_icon);
            this.label = (TextView)itemView.findViewById(R.id.menu_item_label);
        }
    }
}

