/*
 * Decompiled with CFR 0.152.
 */
package com.vlstr.fluentappbar;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.MenuRes;
import android.support.v7.widget.RecyclerView;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.vlstr.fluentappbar.MenuEntry;
import com.vlstr.fluentappbar.MenuParserHelper;
import com.vlstr.fluentappbar.R;
import java.util.ArrayList;
import java.util.List;

class MenuNavigationItemsAdapter
extends RecyclerView.Adapter<MenuNavItem> {
    private Context context;
    private View.OnClickListener onClickListener;
    private int foregroundColour;
    private boolean keepFluentRipple = true;
    private List<MenuEntry> navItems;

    MenuNavigationItemsAdapter(Context context, @MenuRes int menuRes, View.OnClickListener onClickListener, @ColorInt int foregroundColour) {
        this.context = context;
        this.onClickListener = onClickListener;
        this.foregroundColour = foregroundColour;
        this.navItems = new ArrayList<MenuEntry>();
        this.populateNavigationItems(menuRes);
    }

    public MenuNavItem onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.menu_nav_item, parent, false);
        v.getLayoutParams().width = parent.getMeasuredWidth() / this.navItems.size();
        return new MenuNavItem(v);
    }

    public void onBindViewHolder(MenuNavItem holder, int position) {
        MenuEntry item = this.navItems.get(position);
        holder.label.setText((CharSequence)item.getTitle());
        holder.label.setTextColor(this.foregroundColour);
        holder.icon.setImageDrawable(item.getIcon());
        holder.icon.setColorFilter(this.foregroundColour);
        holder.itemView.setTag((Object)item.getResId());
        if (item.getTitle().isEmpty()) {
            this.setupMoreIcon(holder);
        }
        this.handleRipple(holder);
        holder.itemView.setOnClickListener(this.onClickListener);
    }

    public int getItemCount() {
        return this.navItems.size();
    }

    public void setForegroundColour(@ColorInt int foregroundColour) {
        this.foregroundColour = foregroundColour;
    }

    public void setKeepFluentRipple(boolean keepFluentRipple) {
        this.keepFluentRipple = keepFluentRipple;
        this.notifyDataSetChanged();
    }

    private void handleRipple(MenuNavItem holder) {
        if (!this.keepFluentRipple) {
            TypedValue outValue = new TypedValue();
            this.context.getTheme().resolveAttribute(16843534, outValue, true);
            holder.itemView.setBackgroundResource(outValue.resourceId);
        }
    }

    private void populateNavigationItems(int menuRes) {
        MenuParserHelper.parseMenu(this.context, menuRes, this.navItems);
        Drawable moreIcon = this.context.getResources().getDrawable(R.drawable.more);
        this.navItems.add(new MenuEntry("", moreIcon, 0));
    }

    private void setupMoreIcon(MenuNavItem menuNavItem) {
        menuNavItem.itemView.setFocusable(false);
        menuNavItem.itemView.setFocusableInTouchMode(false);
        menuNavItem.itemView.setBackground(null);
        menuNavItem.icon.setColorFilter(this.foregroundColour);
        menuNavItem.itemView.setTag((Object)"more_icon_tag");
    }

    class MenuNavItem
    extends RecyclerView.ViewHolder {
        ImageView icon;
        TextView label;

        MenuNavItem(View itemView) {
            super(itemView);
            this.icon = (ImageView)itemView.findViewById(R.id.nav_item_icon);
            this.label = (TextView)itemView.findViewById(R.id.nav_item_label);
        }
    }
}

