/*
 * Decompiled with CFR 0.152.
 */
package com.vlstr.fluentappbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.MenuRes;
import android.support.design.widget.BottomSheetBehavior;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.vlstr.fluentappbar.MenuNavigationItemsAdapter;
import com.vlstr.fluentappbar.MenuSecondaryItemsAdapter;
import com.vlstr.fluentappbar.R;
import eightbitlab.com.blurview.BlurAlgorithm;
import eightbitlab.com.blurview.BlurView;
import eightbitlab.com.blurview.RenderScriptBlur;

public class FluentAppBar
extends NestedScrollView {
    public static final int DISABLE_FLUENT = 0;
    public static final int TOUCH_FLUENT = 50;
    public static final int FULL_FLUENT = 100;
    public static final String MORE_ICON_TAG = "more_icon_tag";
    private int blurRadius = 20;
    private int backgroundAlpha = 78;
    private BottomSheetBehavior bottomSheetBehavior;
    private int backgroundColour;
    private int foregroundColour;
    private int fluentAppBarType;
    private boolean keepFluentRipple;
    private MenuSecondaryItemsAdapter menuSecondaryItemsAdapter;
    private MenuNavigationItemsAdapter menuNavigationItemsAdapter;
    private View.OnClickListener onMoreClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (FluentAppBar.this.bottomSheetBehavior.getState() == 4) {
                FluentAppBar.this.bottomSheetBehavior.setState(3);
            } else {
                FluentAppBar.this.bottomSheetBehavior.setState(4);
            }
        }
    };

    public FluentAppBar(Context context) {
        super(context);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FluentAppBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FluentAppBar, 0, 0);
        try {
            this.backgroundColour = a.getColor(R.styleable.FluentAppBar_fluent_background_colour, -1);
            this.foregroundColour = a.getColor(R.styleable.FluentAppBar_fluent_foreground_colour, -12303292);
            this.fluentAppBarType = a.getInt(R.styleable.FluentAppBar_fluent_app_bar_type, 50);
        }
        finally {
            a.recycle();
        }
        this.init();
    }

    private void init() {
        this.setClipToPadding(true);
        this.setBackgroundColor(this.backgroundColour);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setElevation(this.getResources().getDimension(R.dimen.bar_elevation));
        }
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.content_app_bar, (ViewGroup)this, true);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.bottomSheetBehavior = BottomSheetBehavior.from((View)this);
        this.bottomSheetBehavior.setPeekHeight((int)this.getResources().getDimension(R.dimen.bar_height));
        this.bottomSheetBehavior.setHideable(false);
        this.bottomSheetBehavior.setState(4);
        View moreIcon = this.findViewWithTag(MORE_ICON_TAG);
        moreIcon.setOnClickListener(this.onMoreClickListener);
        if (this.fluentAppBarType == 100) {
            this.handleShowFluentBlur();
        }
        if (this.fluentAppBarType == 0) {
            this.keepFluentRipple = false;
        }
    }

    public void setNavigationMenu(@MenuRes int menuRes, View.OnClickListener onClickListener) {
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.nav_items_recycler);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
        this.menuNavigationItemsAdapter = new MenuNavigationItemsAdapter(this.getContext(), menuRes, onClickListener, this.foregroundColour);
        recyclerView.setAdapter((RecyclerView.Adapter)this.menuNavigationItemsAdapter);
    }

    public void setSecondaryMenu(@MenuRes int menuRes, View.OnClickListener onClickListener) {
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.secondary_menu_items_recyler);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.menuSecondaryItemsAdapter = new MenuSecondaryItemsAdapter(this.getContext(), menuRes, onClickListener, this.foregroundColour);
        recyclerView.setAdapter((RecyclerView.Adapter)this.menuSecondaryItemsAdapter);
    }

    public int getBackgroundColour() {
        return this.backgroundColour;
    }

    public void setBackgroundColour(@ColorInt int backgroundColour) {
        this.backgroundColour = backgroundColour;
        this.setBackgroundColor(backgroundColour);
    }

    public int getForegroundColour() {
        return this.foregroundColour;
    }

    public void setForegroundColour(@ColorInt int foregroundColour) {
        this.foregroundColour = foregroundColour;
        this.menuNavigationItemsAdapter.setForegroundColour(foregroundColour);
        this.menuNavigationItemsAdapter.notifyDataSetChanged();
        this.menuSecondaryItemsAdapter.setForegroundColour(foregroundColour);
        this.menuSecondaryItemsAdapter.notifyDataSetChanged();
    }

    public int getFluentAppBarType() {
        return this.fluentAppBarType;
    }

    public void setFluentAppBarType(int fluentAppBarType) {
        this.fluentAppBarType = fluentAppBarType;
        this.menuNavigationItemsAdapter.setForegroundColour(this.foregroundColour);
        this.menuNavigationItemsAdapter.notifyDataSetChanged();
        this.menuSecondaryItemsAdapter.setForegroundColour(this.foregroundColour);
        this.menuSecondaryItemsAdapter.notifyDataSetChanged();
    }

    public boolean isFluentRipple() {
        return this.keepFluentRipple;
    }

    public void setFluentRipple(boolean keepFluentRipple) {
        this.keepFluentRipple = keepFluentRipple;
        this.menuNavigationItemsAdapter.setKeepFluentRipple(keepFluentRipple);
        this.menuSecondaryItemsAdapter.setKeepFluentRipple(keepFluentRipple);
    }

    public void setBlurRadius(int blurRadius) {
        this.blurRadius = blurRadius;
    }

    public int getBlurRadius() {
        return this.blurRadius;
    }

    public int getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(int backgroundAlpha) {
        this.backgroundAlpha = backgroundAlpha;
    }

    public void collapse() {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                FluentAppBar.this.bottomSheetBehavior.setState(4);
            }
        }, 500L);
    }

    public void collapseWithoutDelay() {
        this.bottomSheetBehavior.setState(4);
    }

    public void expand() {
        this.bottomSheetBehavior.setState(3);
    }

    private void handleShowFluentBlur() {
        this.setBackground(null);
        ViewGroup rootView = (ViewGroup)this.getRootView();
        Drawable windowBackground = this.getBackground();
        BlurView blurView = (BlurView)this.findViewById(R.id.blurview);
        blurView.setupWith(rootView).windowBackground(windowBackground).blurAlgorithm((BlurAlgorithm)new RenderScriptBlur(this.getContext())).blurRadius((float)this.blurRadius);
        int transparentBackgroundColour = Color.argb((int)this.backgroundAlpha, (int)Color.red((int)this.backgroundColour), (int)Color.green((int)this.backgroundColour), (int)Color.blue((int)this.backgroundColour));
        blurView.setOverlayColor(transparentBackgroundColour);
    }
}

