/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.Range;

public class SubSequence
extends BasedSequenceImpl {
    protected final CharSequence baseSeq;
    protected final SubSequence base;
    protected final int startOffset;
    protected final int endOffset;

    public SubSequence getBaseSeq() {
        return this.base;
    }

    @Override
    public CharSequence getBase() {
        return this.baseSeq;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    public SubSequence(CharSequence charSequence) {
        if (charSequence instanceof SubSequence) {
            this.base = (SubSequence)charSequence;
            this.baseSeq = this.base.baseSeq;
            this.startOffset = this.base.startOffset;
            this.endOffset = this.base.endOffset;
        } else if (charSequence instanceof BasedSequence) {
            this.base = this;
            this.baseSeq = ((BasedSequence)charSequence).getBase();
            this.startOffset = ((BasedSequence)charSequence).getStartOffset();
            this.endOffset = ((BasedSequence)charSequence).getEndOffset();
        } else {
            this.base = this;
            this.baseSeq = charSequence;
            this.startOffset = 0;
            this.endOffset = charSequence.length();
        }
    }

    protected SubSequence(SubSequence subSequence, int start, int end) {
        this.base = subSequence;
        this.baseSeq = subSequence.baseSeq;
        this.startOffset = subSequence.startOffset + start;
        this.endOffset = subSequence.startOffset + end;
    }

    public SubSequence(CharSequence charSequence, int start, int end) {
        if (start == 0 && end == charSequence.length()) {
            if (charSequence instanceof SubSequence) {
                this.base = (SubSequence)charSequence;
                this.baseSeq = this.base.baseSeq;
                this.startOffset = this.base.startOffset;
                this.endOffset = this.base.endOffset;
            } else if (charSequence instanceof BasedSequence) {
                this.base = this;
                this.baseSeq = ((BasedSequence)charSequence).getBase();
                this.startOffset = ((BasedSequence)charSequence).getStartOffset();
                this.endOffset = ((BasedSequence)charSequence).getEndOffset();
            } else {
                this.base = this;
                this.baseSeq = charSequence;
                this.startOffset = 0;
                this.endOffset = charSequence.length();
            }
        } else if (start >= 0 && end <= charSequence.length()) {
            this.base = new SubSequence(charSequence);
            this.baseSeq = this.base.baseSeq;
            this.startOffset = this.base.startOffset + start;
            this.endOffset = this.base.startOffset + end;
        } else {
            if (start < 0) {
                throw new StringIndexOutOfBoundsException("beginIndex:" + start + " must be at least 0");
            }
            if (end < 0) {
                throw new StringIndexOutOfBoundsException("endIndex:" + end + " must be at least 0");
            }
            if (end < start) {
                throw new StringIndexOutOfBoundsException("endIndex:" + end + " must not be less than beginIndex:" + start);
            }
            throw new StringIndexOutOfBoundsException("endIndex:" + end + " must not be greater than length");
        }
    }

    @Override
    public int length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public Range getSourceRange() {
        return new Range(this.startOffset, this.endOffset);
    }

    @Override
    public int getIndexOffset(int index) {
        if (index >= 0 && index <= this.endOffset - this.startOffset) {
            return this.startOffset + index;
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + index + " out of range: 0, " + this.length());
    }

    @Override
    public char charAt(int index) {
        if (index >= 0 && index < this.endOffset - this.startOffset) {
            char c = this.baseSeq.charAt(index + this.startOffset);
            return c == '\u0000' ? (char)'\ufffd' : (char)c;
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + index + " out of range: 0, " + this.length());
    }

    @Override
    public BasedSequence subSequence(int start, int end) {
        if (start >= 0 && end <= this.endOffset - this.startOffset) {
            return this.baseSubSequence(this.startOffset + start, this.startOffset + end);
        }
        if (start < 0 || this.startOffset + start > this.endOffset) {
            throw new StringIndexOutOfBoundsException("SubCharSequence index: " + start + " out of range: 0, " + this.length());
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + end + " out of range: 0, " + this.length());
    }

    @Override
    public BasedSequence baseSubSequence(int start, int end) {
        if (start >= 0 && end <= this.base.length()) {
            return start == this.startOffset && end == this.endOffset ? this : (this.base != this ? this.base.baseSubSequence(start, end) : new SubSequence(this, start, end));
        }
        if (start < 0 || start > this.base.length()) {
            throw new StringIndexOutOfBoundsException("SubCharSequence index: " + start + " out of range: 0, " + this.length());
        }
        throw new StringIndexOutOfBoundsException("SubCharSequence index: " + end + " out of range: 0, " + this.length());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharSequence && this.toString().equals(obj.toString());
    }
}

