/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.options;

import com.vladsch.flexmark.util.options.Attribute;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class Attributes {
    public static final Attributes EMPTY = new Attributes();
    private LinkedHashMap<String, Attribute> myAttributes;

    public Attributes() {
        this.myAttributes = null;
    }

    public Attributes(Attributes attributes) {
        this.myAttributes = attributes.myAttributes == null ? null : new LinkedHashMap<String, Attribute>(attributes.myAttributes);
    }

    protected LinkedHashMap<String, Attribute> getAttributes() {
        if (this.myAttributes == null) {
            this.myAttributes = new LinkedHashMap();
        }
        return this.myAttributes;
    }

    public Attribute get(String key) {
        if (this.myAttributes == null) {
            return null;
        }
        return this.myAttributes.get(key);
    }

    public String getValue(String key) {
        if (this.myAttributes == null) {
            return "";
        }
        Attribute attribute = this.myAttributes.get(key);
        if (attribute == null) {
            return "";
        }
        return attribute.getValue();
    }

    public Attribute replaceValue(Attribute attribute) {
        return this.replaceValue(attribute.getName(), attribute.getValue());
    }

    public Attribute replaceValue(String key, String value) {
        Attribute attribute;
        attribute = this.myAttributes == null ? new Attribute(key, value) : ((attribute = this.myAttributes.get(key)) != null ? attribute.replaceValue(value) : new Attribute(key, value));
        this.getAttributes().put(key, attribute);
        return attribute;
    }

    public Attribute addValue(Attribute attribute) {
        return this.addValue(attribute.getName(), attribute.getValue());
    }

    public Attribute addValue(String key, String value) {
        Attribute attribute;
        attribute = this.myAttributes == null ? new Attribute(key, value) : ((attribute = this.myAttributes.get(key)) != null ? attribute.addValue(value) : new Attribute(key, value));
        this.getAttributes().put(key, attribute);
        return attribute;
    }

    public Attribute removeValue(Attribute attribute) {
        return this.removeValue(attribute.getName(), attribute.getValue());
    }

    public Attribute remove(Attribute attribute) {
        return this.remove(attribute.getName());
    }

    public Attribute removeValue(String key, String value) {
        if (this.myAttributes == null) {
            return null;
        }
        Attribute oldAttribute = this.myAttributes.get(key);
        Attribute attribute = oldAttribute.removeValue(value);
        if (attribute != oldAttribute) {
            this.getAttributes().put(key, attribute);
        }
        return attribute;
    }

    public boolean contains(String key) {
        return this.myAttributes != null && this.myAttributes.containsKey(key);
    }

    public boolean containsValue(String key, String value) {
        if (this.myAttributes == null) {
            return false;
        }
        Attribute attribute = this.myAttributes.get(key);
        return attribute != null && attribute.containsValue(value);
    }

    public boolean isEmpty() {
        return this.myAttributes == null || this.myAttributes.isEmpty();
    }

    public void clear() {
        this.myAttributes = null;
    }

    public Set<String> keySet() {
        return this.myAttributes != null ? this.myAttributes.keySet() : Collections.EMPTY_SET;
    }

    public Collection<Attribute> values() {
        return this.myAttributes != null ? this.myAttributes.values() : Collections.EMPTY_LIST;
    }

    public Set<Map.Entry<String, Attribute>> entrySet() {
        return this.myAttributes != null ? this.myAttributes.entrySet() : Collections.EMPTY_SET;
    }

    public void forEach(BiConsumer<? super String, ? super Attribute> action) {
        if (this.myAttributes != null) {
            this.myAttributes.forEach(action);
        }
    }

    public int size() {
        return this.myAttributes == null ? 0 : this.myAttributes.size();
    }

    public Attribute remove(String key) {
        if (this.myAttributes == null) {
            return null;
        }
        Attribute oldAttribute = this.myAttributes.get(key);
        this.myAttributes.remove(key);
        return oldAttribute;
    }

    public void replaceValues(Attributes attributes) {
        if (this.myAttributes == null) {
            this.myAttributes = new LinkedHashMap<String, Attribute>(attributes.myAttributes);
        } else {
            this.myAttributes.putAll(attributes.myAttributes);
        }
    }
}

