/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection.iteration;

import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterator;
import java.util.List;

public class Reverse<T>
implements ReversibleIterable<T> {
    private final List<T> myList;
    private final boolean myIsReversed;

    public Reverse(List<T> list) {
        this(list, true);
    }

    public Reverse(List<T> list, boolean isReversed) {
        this.myList = list;
        this.myIsReversed = isReversed;
    }

    @Override
    public ReversibleIterator<T> iterator() {
        return new ReversedListIterator<T>(this.myList, this.myIsReversed);
    }

    @Override
    public ReversibleIterable<T> reversed() {
        return new Reverse<T>(this.myList, !this.myIsReversed);
    }

    @Override
    public boolean isReversed() {
        return this.myIsReversed;
    }

    @Override
    public ReversibleIterator<T> reversedIterator() {
        return new ReversedListIterator<T>(this.myList, !this.myIsReversed);
    }

    static class ReversedListIterator<T>
    implements ReversibleIterator<T> {
        private final List<T> myList;
        private final boolean myIsReversed;
        private int index;

        public ReversedListIterator(List<T> list) {
            this(list, true);
        }

        public ReversedListIterator(List<T> list, boolean isReversed) {
            this.myList = list;
            this.myIsReversed = isReversed;
            this.index = isReversed ? (list.size() == 0 ? -1 : list.size() - 1) : (list.size() == 0 ? -1 : 0);
        }

        @Override
        public boolean isReversed() {
            return this.myIsReversed;
        }

        @Override
        public boolean hasNext() {
            return this.index != -1;
        }

        @Override
        public T next() {
            T t = this.myList.get(this.index);
            if (this.index != -1) {
                this.index = this.myIsReversed ? --this.index : (this.index == this.myList.size() - 1 ? -1 : ++this.index);
            }
            return t;
        }
    }
}

