/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.SubSequence;

public class StringSequence
extends BasedSequenceImpl {
    protected final String base;

    @Override
    public CharSequence getBase() {
        return this.base;
    }

    public StringSequence(String base) {
        this.base = base;
    }

    @Override
    public int getStartOffset() {
        return 0;
    }

    @Override
    public int getEndOffset() {
        return this.length();
    }

    @Override
    public int length() {
        return this.base.length();
    }

    @Override
    public Range getSourceRange() {
        return new Range(0, this.length());
    }

    @Override
    public int getIndexOffset(int index) {
        if (index < 0 || index > this.base.length()) {
            throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: 0, " + this.length());
        }
        return index;
    }

    @Override
    public char charAt(int index) {
        char c = this.base.charAt(index);
        return c == '\u0000' ? (char)'\ufffd' : (char)c;
    }

    @Override
    public BasedSequence subSequence(int start, int end) {
        return new SubSequence(this, start, end);
    }

    @Override
    public BasedSequence baseSubSequence(int start, int end) {
        if (start < 0 || start > this.base.length()) {
            throw new StringIndexOutOfBoundsException("String index: " + start + " out of range: 0, " + this.length());
        }
        if (end < 0 || end > this.base.length()) {
            throw new StringIndexOutOfBoundsException("String index: " + end + " out of range: 0, " + this.length());
        }
        return new SubSequence(this, start, end);
    }

    @Override
    public String toString() {
        return this.base;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharSequence && this.toString().equals(obj.toString());
    }
}

