/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.builder;

import com.vladsch.flexmark.util.builder.Extension;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public abstract class BuilderBase<T extends BuilderBase>
extends MutableDataSet {
    public static final DataKey<Iterable<Extension>> EXTENSIONS = new DataKey<Iterable<Extension>>("EXTENSIONS", Extension.EMPTY_LIST);
    public static final DataKey<Iterable<Extension>> UNLOAD_EXTENSIONS = new DataKey<Iterable<Extension>>("UNLOAD_EXTENSIONS", Extension.EMPTY_LIST);
    public static final DataKey<Boolean> RELOAD_EXTENSIONS = new DataKey<Boolean>("RELOAD_EXTENSIONS", true);
    private final HashSet<Class> loadedExtensions = new HashSet();
    private final HashMap<Class, HashSet<Object>> extensionApiPoints = new HashMap();
    private Extension currentExtension;

    protected abstract void removeApiPoint(Object var1);

    protected abstract void preloadExtension(Extension var1);

    protected abstract boolean loadExtension(Extension var1);

    public final T extensions(Iterable<? extends Extension> extensions) {
        Extension extension;
        Iterator<? extends Extension> iterator = extensions.iterator();
        while (iterator.hasNext()) {
            this.currentExtension = extension = iterator.next();
            if (!this.loadedExtensions.contains(extension.getClass())) {
                this.preloadExtension(extension);
            }
            this.currentExtension = null;
        }
        iterator = extensions.iterator();
        while (iterator.hasNext()) {
            this.currentExtension = extension = iterator.next();
            Class<?> extensionClass = extension.getClass();
            if (!this.loadedExtensions.contains(extensionClass) && this.loadExtension(extension)) {
                this.loadedExtensions.add(extensionClass);
            }
            this.currentExtension = null;
        }
        return (T)this;
    }

    protected void addExtensionApiPoint(Object apiPoint) {
        Extension extension = this.currentExtension;
        if (extension != null) {
            Class<?> extensionClass = extension.getClass();
            HashSet apiPoints = this.extensionApiPoints.computeIfAbsent(extensionClass, k -> new HashSet());
            apiPoints.add(apiPoint);
        }
    }

    public void unloadExtension(Class extensionClass) {
        if (extensionClass != null && this.loadedExtensions.contains(extensionClass)) {
            HashSet<Object> apiPoints = this.extensionApiPoints.get(extensionClass);
            if (apiPoints != null) {
                ArrayList<Object> list = new ArrayList<Object>(apiPoints);
                for (Object apiPoint : list) {
                    if (apiPoint instanceof DataKey) {
                        this.getAll().remove(apiPoint);
                    } else {
                        this.removeApiPoint(apiPoint);
                    }
                    apiPoints.remove(apiPoint);
                }
            }
            this.loadedExtensions.remove(extensionClass);
        }
    }

    @Override
    public <T> MutableDataSet set(DataKey<? extends T> key, T value) {
        this.addExtensionApiPoint(key);
        return super.set((DataKey)key, (Object)value);
    }

    public void unloadExtensions() {
        ArrayList<Class> list = new ArrayList<Class>(this.loadedExtensions);
        for (Class extension : list) {
            this.unloadExtension(extension);
        }
    }

    protected BuilderBase(DataHolder options) {
        super(options);
    }

    protected void loadExtensions() {
        if (this.contains(EXTENSIONS)) {
            this.extensions(this.get(EXTENSIONS));
        }
    }

    protected BuilderBase() {
    }

    protected BuilderBase(T other) {
        super((DataHolder)other);
        HashMap<Class, HashSet<Object>> points = ((BuilderBase)other).extensionApiPoints;
        for (Map.Entry<Class, HashSet<Object>> entry : points.entrySet()) {
            this.extensionApiPoints.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        this.loadedExtensions.addAll(((BuilderBase)other).loadedExtensions);
    }

    protected void withOptions(DataHolder options) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        HashSet extensionSet = new HashSet();
        HashSet unloadExtensionSet = null;
        if (options != null && options.contains(UNLOAD_EXTENSIONS)) {
            unloadExtensionSet = new HashSet();
            for (Extension extension : UNLOAD_EXTENSIONS.getFrom(options)) {
                unloadExtensionSet.add(extension.getClass());
            }
        }
        for (Extension extension : this.get(EXTENSIONS)) {
            if (unloadExtensionSet != null && unloadExtensionSet.contains(extension.getClass())) continue;
            extensions.add(extension);
            extensionSet.add(extension.getClass());
        }
        if (options != null) {
            for (DataKey dataKey : options.getKeys()) {
                if (dataKey == EXTENSIONS) {
                    for (Extension extension : options.get(EXTENSIONS)) {
                        if (unloadExtensionSet != null && unloadExtensionSet.contains(extension.getClass()) || extensionSet.contains(extension.getClass())) continue;
                        extensions.add(extension);
                    }
                    continue;
                }
                this.set(dataKey, options.get(dataKey));
            }
        }
        if (options != null && options.contains(RELOAD_EXTENSIONS)) {
            if (RELOAD_EXTENSIONS.getFrom(options).booleanValue()) {
                this.unloadExtensions();
            }
        } else if (RELOAD_EXTENSIONS.getFrom(this).booleanValue()) {
            this.unloadExtensions();
        }
        this.set(EXTENSIONS, extensions);
        this.extensions(extensions);
    }
}

