/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.options;

import com.vladsch.flexmark.util.Pair;
import com.vladsch.flexmark.util.options.MessageProvider;
import com.vladsch.flexmark.util.options.OptionParser;
import com.vladsch.flexmark.util.options.ParsedOption;
import com.vladsch.flexmark.util.options.ParsedOptionStatus;
import com.vladsch.flexmark.util.options.ParserMessage;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Collections;
import java.util.List;

public abstract class BooleanOptionParser<T>
implements OptionParser<T> {
    public static final String OPTION_0_PARAMETERS_1_IGNORED = "Option {0} does not have any parameters. {1} was ignored";
    public static final String KEY_OPTION_0_PARAMETERS_1_IGNORED = "options.parser.boolean-option.ignored";
    private final String myOptionName;

    public BooleanOptionParser(String optionName) {
        this.myOptionName = optionName;
    }

    protected abstract T setOptions(T var1);

    protected abstract boolean isOptionSet(T var1);

    @Override
    public String getOptionName() {
        return this.myOptionName;
    }

    @Override
    public Pair<T, List<ParsedOption<T>>> parseOption(BasedSequence optionText, T options, MessageProvider provider) {
        if (optionText.isEmpty()) {
            return new Pair(this.setOptions(options), Collections.singletonList(new ParsedOption(optionText, this, ParsedOptionStatus.VALID)));
        }
        if (provider == null) {
            provider = MessageProvider.DEFAULT;
        }
        String message = provider.message(KEY_OPTION_0_PARAMETERS_1_IGNORED, OPTION_0_PARAMETERS_1_IGNORED, this.myOptionName, optionText);
        return new Pair(this.setOptions(options), Collections.singletonList(new ParsedOption(optionText, this, ParsedOptionStatus.IGNORED, Collections.singletonList(new ParserMessage(optionText, ParsedOptionStatus.IGNORED, message)))));
    }

    @Override
    public String getOptionText(T options, T defaultOptions) {
        return this.isOptionSet(options) && (defaultOptions == null || !this.isOptionSet(defaultOptions)) ? this.myOptionName : "";
    }
}

