/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.experimental.util.collection.iteration;

import com.vladsch.flexmark.experimental.util.collection.iteration.IPositionHolder;
import com.vladsch.flexmark.util.sequence.PositionAnchor;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PositionIterator<T, P extends IPositionHolder<T, P>>
implements Iterator<P> {
    @Nullable
    private P myIndex;
    @Nullable
    private P myNext;

    public PositionIterator(@NotNull P index) {
        assert (index.getAnchor() != PositionAnchor.CURRENT);
        this.myIndex = null;
        this.myNext = index;
    }

    @Override
    public boolean hasNext() {
        assert (this.myNext == null || this.myNext.isValid() || this.myNext.getAnchor() == PositionAnchor.PREVIOUS);
        return this.myNext != null && this.myNext.isValidElement();
    }

    @Override
    public P next() {
        if (this.myNext == null || !this.myNext.isValidElement()) {
            throw new NoSuchElementException();
        }
        this.myIndex = this.myNext.withAnchor(PositionAnchor.CURRENT);
        P oldNext = this.myNext;
        this.myNext = this.myNext.getAnchor() == PositionAnchor.PREVIOUS ? this.myNext.previousOrNull() : this.myNext.nextOrNull();
        oldNext.detachListener();
        assert (this.myNext == null || this.myIndex.getIndex() != this.myNext.getIndex());
        return this.myIndex;
    }

    @Override
    public void remove() {
        if (this.myIndex == null) {
            throw new IllegalStateException("next() has not been called");
        }
        this.myIndex.remove();
    }
}

