/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.tree.iteration;

import com.vladsch.flexmark.tree.iteration.ValueIteration;
import com.vladsch.flexmark.tree.iteration.ValueIterationAdapter;
import com.vladsch.flexmark.tree.iteration.ValueIterationConsumer;
import com.vladsch.flexmark.tree.iteration.ValueIterationConsumerAdapter;
import com.vladsch.flexmark.tree.iteration.ValueIterationFilter;
import com.vladsch.flexmark.tree.iteration.VoidIteration;
import com.vladsch.flexmark.tree.iteration.VoidIterationConsumer;
import com.vladsch.flexmark.tree.iteration.VoidToValueIConsumerAdapter;
import com.vladsch.flexmark.util.collection.iteration.ArrayIterable;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueIterationAdapterImpl<N, T>
implements ValueIterationAdapter<N, T> {
    @NotNull
    private final ValueIterationConsumerAdapter<N, T> myConsumerAdapter;

    public ValueIterationAdapterImpl(@NotNull Function<? super N, T> function) {
        this(function, null);
    }

    public ValueIterationAdapterImpl(@NotNull Function<? super N, T> function, @Nullable ValueIterationFilter<? super T> filter) {
        this(new ConsumerAdapter<N, T>(function, filter));
    }

    public ValueIterationAdapterImpl(@NotNull ValueIterationConsumerAdapter<N, T> consumerAdapter) {
        this.myConsumerAdapter = consumerAdapter;
    }

    @Override
    @NotNull
    public ValueIterationConsumerAdapter<N, T> getConsumerAdapter() {
        return this.myConsumerAdapter;
    }

    @Override
    @NotNull
    public <V> ValueIterationAdapter<N, V> andThen(ValueIterationAdapter<? super T, V> after) {
        return new ValueIterationAdapterImpl<N, T>(new ChainedConsumerAdapter<N, T, V>(this.myConsumerAdapter, after.getConsumerAdapter()));
    }

    @Override
    @NotNull
    public ValueIterationAdapter<N, T> compose(ValueIterationAdapter<? super N, N> before) {
        return new ValueIterationAdapterImpl<N, T>(new ChainedConsumerAdapter<N, N, T>(before.getConsumerAdapter(), this.myConsumerAdapter));
    }

    public static <N> ValueIterationAdapter<N, N> of() {
        return new ValueIterationAdapterImpl(Function.identity());
    }

    public static <N> ValueIterationAdapter<N, N> of(ValueIterationFilter<? super N> filter) {
        return new ValueIterationAdapterImpl(Function.identity(), filter);
    }

    public static <N, T> ValueIterationAdapter<N, T> of(Function<? super N, T> function) {
        return new ValueIterationAdapterImpl<N, T>(function);
    }

    public static <N, T> ValueIterationAdapter<N, T> of(Class<? extends T> clazz) {
        return new ValueIterationAdapterImpl<Object, Object>(it -> clazz.isInstance(it) ? clazz.cast(it) : null);
    }

    public static <N, T> ValueIterationAdapter<N, T> of(Iterable<Class<? extends T>> clazzes) {
        return new ValueIterationAdapterImpl<Object, Object>(it -> {
            for (Class clazz : clazzes) {
                if (!clazz.isInstance(it)) continue;
                return clazz.cast(it);
            }
            return null;
        });
    }

    public static <N, T> ValueIterationAdapter<N, T> of(Class<? extends T> ... clazzes) {
        return ValueIterationAdapterImpl.of(new ArrayIterable((Object[])clazzes));
    }

    public static <N, T> ValueIterationAdapter<N, T> of(Class<? extends T> clazz, Predicate<? super T> filter) {
        return new ValueIterationAdapterImpl<Object, Object>(it -> clazz.isInstance(it) ? clazz.cast(it) : null, (it, loop) -> filter.test(it));
    }

    public static <N, T> ValueIterationAdapter<N, T> of(Predicate<? super T> filter, Iterable<Class<? extends T>> clazzes) {
        return new ValueIterationAdapterImpl<Object, Object>(it -> {
            for (Class clazz : clazzes) {
                if (!clazz.isInstance(it)) continue;
                return clazz.cast(it);
            }
            return null;
        }, (it, loop) -> filter.test(it));
    }

    public static <N, T> ValueIterationAdapter<N, T> of(Predicate<? super T> filter, Class<? extends T> ... clazzes) {
        return ValueIterationAdapterImpl.of(filter, new ArrayIterable((Object[])clazzes));
    }

    public static <N, T> ValueIterationAdapter<N, T> of(Class<T> clazz, ValueIterationFilter<? super T> filter) {
        return new ValueIterationAdapterImpl<Object, T>(it -> clazz.isInstance(it) ? clazz.cast(it) : null, filter);
    }

    public static <N, T> ValueIterationAdapter<N, T> of(ValueIterationFilter<? super T> filter, Class<? extends T> ... clazzes) {
        return ValueIterationAdapterImpl.of(filter, new ArrayIterable((Object[])clazzes));
    }

    public static <N, T> ValueIterationAdapter<N, T> of(ValueIterationFilter<? super T> filter, Iterable<Class<? extends T>> clazzes) {
        return new ValueIterationAdapterImpl<Object, T>(it -> {
            for (Class clazz : clazzes) {
                if (!clazz.isInstance(it)) continue;
                return clazz.cast(it);
            }
            return null;
        }, filter);
    }

    static class ChainedConsumerAdapter<P, T, V>
    implements ValueIterationConsumerAdapter<P, V> {
        private final ValueIterationConsumerAdapter<? super P, T> myBeforeAdapter;
        private final ValueIterationConsumerAdapter<? super T, V> myAfterAdapter;

        public ChainedConsumerAdapter(ValueIterationConsumerAdapter<? super P, T> beforeAdapter, ValueIterationConsumerAdapter<? super T, V> afterAdapter) {
            this.myBeforeAdapter = beforeAdapter;
            this.myAfterAdapter = afterAdapter;
        }

        @Override
        @NotNull
        public <R> ValueIterationConsumer<? super P, R> getConsumer(ValueIterationConsumer<? super V, R> valueConsumer) {
            return this.myBeforeAdapter.getConsumer(this.myAfterAdapter.getConsumer(valueConsumer));
        }

        @Override
        @NotNull
        public <R> ValueIterationConsumer<? super P, R> getConsumer(VoidIterationConsumer<? super V> voidConsumer) {
            return this.myBeforeAdapter.getConsumer(this.myAfterAdapter.getConsumer(voidConsumer));
        }
    }

    private static class MyValueIterationConsumer<P, T, R>
    implements ValueIterationConsumer<P, R> {
        private final ValueIterationConsumer<? super T, R> myConsumer;
        private final Function<? super P, ? extends T> myFunction;
        @Nullable
        private final ValueIterationFilter<? super T> myFilter;

        public MyValueIterationConsumer(@NotNull Function<? super P, ? extends T> function, @Nullable ValueIterationFilter<? super T> filter, ValueIterationConsumer<? super T, R> consumer) {
            this.myFunction = function;
            this.myFilter = filter;
            this.myConsumer = consumer;
        }

        @Override
        public void accept(@NotNull P it, @NotNull ValueIteration<R> iteration) {
            T applied = this.myFunction.apply(it);
            if (applied != null && (this.myFilter == null || this.myFilter.filter(applied, iteration))) {
                this.myConsumer.accept(applied, iteration);
            }
        }

        @Override
        public void beforeStart(@NotNull ValueIteration<R> iteration) {
            this.myConsumer.beforeStart(iteration);
        }

        @Override
        public void startRecursion(@NotNull VoidIteration iteration) {
            this.myConsumer.startRecursion(iteration);
        }

        @Override
        public void endRecursion(@NotNull VoidIteration iteration) {
            this.myConsumer.endRecursion(iteration);
        }

        @Override
        public void afterEnd(@NotNull ValueIteration<R> iteration) {
            this.myConsumer.afterEnd(iteration);
        }
    }

    static class ConsumerAdapter<P, T>
    implements ValueIterationConsumerAdapter<P, T> {
        @NotNull
        private final Function<? super P, ? extends T> myFunction;
        @Nullable
        private final ValueIterationFilter<? super T> myFilter;

        public ConsumerAdapter(@NotNull Function<? super P, ? extends T> function, @Nullable ValueIterationFilter<? super T> filter) {
            this.myFunction = function;
            this.myFilter = filter;
        }

        @Override
        @NotNull
        public <R> ValueIterationConsumer<? super P, R> getConsumer(ValueIterationConsumer<? super T, R> valueConsumer) {
            return new MyValueIterationConsumer<P, T, R>(this.myFunction, this.myFilter, valueConsumer);
        }

        @Override
        @NotNull
        public <R> ValueIterationConsumer<? super P, R> getConsumer(VoidIterationConsumer<? super T> voidConsumer) {
            return new MyValueIterationConsumer(this.myFunction, this.myFilter, new VoidToValueIConsumerAdapter(voidConsumer));
        }
    }
}

