/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util;

import com.vladsch.flexmark.test.util.FullSpecTestCase;
import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.test.util.spec.ResourceLocation;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class ComboSpecTestCase
extends FullSpecTestCase {
    public static final DataKey<BiFunction<String, String, DataHolder>> CUSTOM_OPTION = TestUtils.CUSTOM_OPTION;
    @NotNull
    protected final SpecExample example;
    @NotNull
    protected final Map<String, DataHolder> optionsMap = new HashMap<String, DataHolder>();
    @Nullable
    protected final DataHolder myDefaultOptions;

    public ComboSpecTestCase(@NotNull SpecExample example, @Nullable Map<String, ? extends DataHolder> optionMap, DataHolder ... defaultOptions) {
        this.example = example;
        this.myDefaultOptions = TestUtils.combineDefaultOptions(defaultOptions);
        if (optionMap != null) {
            this.optionsMap.putAll(optionMap);
        }
    }

    @NotNull
    public static Map<String, DataHolder> placementAndSortOptions(DataKey<ElementPlacement> placementDataKey, DataKey<ElementPlacementSort> sortDataKey) {
        return ComboSpecTestCase.placementAndSortOptions(null, placementDataKey, sortDataKey);
    }

    @NotNull
    public static Map<String, DataHolder> placementAndSortOptions(@Nullable DataKey<KeepType> keepTypeDataKey, @Nullable DataKey<ElementPlacement> placementDataKey, @Nullable DataKey<ElementPlacementSort> sortDataKey) {
        HashMap<String, DataHolder> optionsMap = new HashMap<String, DataHolder>();
        if (keepTypeDataKey != null) {
            optionsMap.put("references-keep-last", (DataHolder)new MutableDataSet().set(keepTypeDataKey, (Object)KeepType.LAST));
            optionsMap.put("references-keep-first", (DataHolder)new MutableDataSet().set(keepTypeDataKey, (Object)KeepType.FIRST));
            optionsMap.put("references-keep-fail", (DataHolder)new MutableDataSet().set(keepTypeDataKey, (Object)KeepType.FAIL));
            optionsMap.put("references-keep-locked", (DataHolder)new MutableDataSet().set(keepTypeDataKey, (Object)KeepType.LOCKED));
        }
        if (placementDataKey != null) {
            optionsMap.put("references-as-is", (DataHolder)new MutableDataSet().set(placementDataKey, (Object)ElementPlacement.AS_IS));
            optionsMap.put("references-document-top", (DataHolder)new MutableDataSet().set(placementDataKey, (Object)ElementPlacement.DOCUMENT_TOP));
            optionsMap.put("references-group-with-first", (DataHolder)new MutableDataSet().set(placementDataKey, (Object)ElementPlacement.GROUP_WITH_FIRST));
            optionsMap.put("references-group-with-last", (DataHolder)new MutableDataSet().set(placementDataKey, (Object)ElementPlacement.GROUP_WITH_LAST));
            optionsMap.put("references-document-bottom", (DataHolder)new MutableDataSet().set(placementDataKey, (Object)ElementPlacement.DOCUMENT_BOTTOM));
        }
        if (sortDataKey != null) {
            optionsMap.put("references-sort", (DataHolder)new MutableDataSet().set(sortDataKey, (Object)ElementPlacementSort.SORT));
            optionsMap.put("references-sort-unused-last", (DataHolder)new MutableDataSet().set(sortDataKey, (Object)ElementPlacementSort.SORT_UNUSED_LAST));
            optionsMap.put("references-sort-delete-unused", (DataHolder)new MutableDataSet().set(sortDataKey, (Object)ElementPlacementSort.SORT_DELETE_UNUSED));
            optionsMap.put("references-delete-unused", (DataHolder)new MutableDataSet().set(sortDataKey, (Object)ElementPlacementSort.DELETE_UNUSED));
        }
        return optionsMap;
    }

    @Override
    protected boolean compoundSections() {
        return true;
    }

    @Nullable
    public static Map<String, ? extends DataHolder> optionsMaps(@Nullable Map<String, ? extends DataHolder> other, @Nullable Map<String, ? extends DataHolder> overrides) {
        return TestUtils.optionsMaps(other, overrides);
    }

    @Nullable
    public static DataHolder[] dataHolders(@Nullable DataHolder other, @Nullable DataHolder[] overrides) {
        return TestUtils.dataHolders(other, overrides);
    }

    @NotNull
    public static DataHolder aggregate(@Nullable DataHolder other, @Nullable DataHolder overrides) {
        return DataSet.aggregate((DataHolder)other, (DataHolder)overrides);
    }

    @Override
    @Nullable
    public DataHolder options(@NotNull String option) {
        return TestUtils.processOption(this.optionsMap, option);
    }

    @Override
    @NotNull
    protected final ResourceLocation getSpecResourceLocation() {
        return this.example.getResourceLocation();
    }

    @Override
    @Test
    public void testSpecExample() {
        if (this.example.isFullSpecExample()) {
            super.testSpecExample();
        } else {
            this.assertRendering(this.example);
        }
    }

    @NotNull
    protected static List<Object[]> getTestData(@NotNull ResourceLocation location) {
        return TestUtils.getTestData(location);
    }
}

