/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util;

import com.vladsch.flexmark.test.util.SpecExampleRendererBase;
import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.IParse;
import com.vladsch.flexmark.util.ast.IRender;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexmarkSpecExampleRenderer
extends SpecExampleRendererBase {
    @Nullable
    private Node myIncludedDocument = null;
    @Nullable
    private Node myDocument = null;
    @NotNull
    private IParse myParser;
    @NotNull
    private IRender myRender;

    public FlexmarkSpecExampleRenderer(@NotNull SpecExample example, @Nullable DataHolder options, @NotNull IParse parser, @NotNull IRender render) {
        this(example, options, parser, render, true);
    }

    public FlexmarkSpecExampleRenderer(@NotNull SpecExample example, @Nullable DataHolder options, @NotNull IParse parser, @NotNull IRender render, boolean includeExampleCoord) {
        super(example, options, includeExampleCoord);
        this.myParser = parser;
        this.myRender = render;
    }

    @Override
    public void includeDocument(@NotNull String includedText) {
        this.myIncludedDocument = null;
        if (!includedText.isEmpty()) {
            this.myIncludedDocument = this.getParser().parse(includedText);
            this.adjustParserForInclusion();
        }
    }

    @NotNull
    protected Node getIncludedDocument() {
        assert (this.myIncludedDocument != null);
        return this.myIncludedDocument;
    }

    @Override
    public void parse(CharSequence input) {
        this.myDocument = this.getParser().parse(BasedSequence.of((CharSequence)input));
    }

    @Override
    public void finalizeDocument() {
        assert (this.myDocument != null);
        if (this.myIncludedDocument != null) {
            this.adjustParserForInclusion();
        }
    }

    protected void adjustParserForInclusion() {
        if (this.myDocument instanceof Document && this.myIncludedDocument instanceof Document) {
            this.getParser().transferReferences((Document)this.myDocument, (Document)this.myIncludedDocument, null);
        }
    }

    @NotNull
    public Node getDocument() {
        assert (this.myDocument != null);
        return this.myDocument;
    }

    @Override
    @NotNull
    protected String renderHtml() {
        assert (this.myDocument != null);
        return this.getRenderer().render(this.myDocument);
    }

    @Override
    @NotNull
    protected String renderAst() {
        assert (this.myDocument != null);
        return TestUtils.ast(this.myDocument);
    }

    @Override
    public void finalizeRender() {
        super.finalizeRender();
    }

    @NotNull
    public final IParse getParser() {
        return this.myParser;
    }

    public void setParser(@NotNull IParse parser) {
        this.myParser = parser;
    }

    public void setRender(@NotNull IRender render) {
        this.myRender = render;
    }

    @NotNull
    public final IRender getRenderer() {
        return this.myRender;
    }
}

