/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util.spec;

import com.vladsch.flexmark.test.util.ComboSpecTestCase;
import com.vladsch.flexmark.test.util.TestUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class ResourceLocation {
    public static final ResourceLocation NULL = ResourceLocation.of(Object.class, "", "");
    @NotNull
    private final Class<?> resourceClass;
    @NotNull
    private final String resourcePath;
    @NotNull
    private final String fileUrl;
    @NotNull
    private final String resolvedResourcePath;

    public ResourceLocation(@NotNull Class<?> resourceClass, @NotNull String resourcePath, @NotNull String fileUrl) {
        this(resourceClass, resourcePath, fileUrl, TestUtils.getResolvedSpecResourcePath(resourceClass.getName(), resourcePath));
    }

    private ResourceLocation(@NotNull Class<?> resourceClass, @NotNull String resourcePath, @NotNull String fileUrl, @NotNull String resolvedResourcePath) {
        this.resourceClass = resourceClass;
        this.resourcePath = resourcePath;
        this.fileUrl = fileUrl;
        this.resolvedResourcePath = resolvedResourcePath;
    }

    @NotNull
    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    @NotNull
    public String getResourcePath() {
        return this.resourcePath;
    }

    @NotNull
    public String getFileUrl() {
        return this.fileUrl;
    }

    @NotNull
    public String getFileDirectoryUrl() {
        int pos = this.fileUrl.lastIndexOf(File.separatorChar);
        if (pos > 0) {
            return this.fileUrl.substring(0, pos + 1);
        }
        return this.fileUrl;
    }

    @NotNull
    public String getFileUrl(int lineNumber) {
        return TestUtils.getUrlWithLineNumber(this.getFileUrl(), lineNumber);
    }

    @NotNull
    public String getResolvedResourcePath() {
        return this.resolvedResourcePath;
    }

    public boolean isNull() {
        return this == NULL;
    }

    @NotNull
    public InputStream getResourceInputStream() {
        return ResourceLocation.getResourceInputStream(this);
    }

    @NotNull
    public String getResourceText() {
        return ResourceLocation.getResourceText(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceLocation location = (ResourceLocation)o;
        if (!this.resourceClass.equals(location.resourceClass)) {
            return false;
        }
        if (!this.resourcePath.equals(location.resourcePath)) {
            return false;
        }
        if (!this.fileUrl.equals(location.fileUrl)) {
            return false;
        }
        return this.resolvedResourcePath.equals(location.resolvedResourcePath);
    }

    @NotNull
    public ResourceLocation withResourceClass(@NotNull Class<?> resourceClass) {
        return new ResourceLocation(resourceClass, this.resourcePath, this.fileUrl, this.resolvedResourcePath);
    }

    @NotNull
    public ResourceLocation withResourcePath(@NotNull String resourcePath) {
        return new ResourceLocation(this.resourceClass, resourcePath, this.fileUrl, this.resolvedResourcePath);
    }

    @NotNull
    public ResourceLocation withFileUrl(@NotNull String fileUrl) {
        return new ResourceLocation(this.resourceClass, this.resourcePath, fileUrl, this.resolvedResourcePath);
    }

    @NotNull
    public ResourceLocation withResolvedResourcePath(@NotNull String resolvedResourcePath) {
        return new ResourceLocation(this.resourceClass, this.resourcePath, this.fileUrl, resolvedResourcePath);
    }

    public int hashCode() {
        int result = this.resourceClass.hashCode();
        result = 31 * result + this.resourcePath.hashCode();
        result = 31 * result + this.fileUrl.hashCode();
        result = 31 * result + this.resolvedResourcePath.hashCode();
        return result;
    }

    public String toString() {
        return "ResourceLocation { resourceClass=" + this.resourceClass + ", resourcePath='" + this.resourcePath + '\'' + '}';
    }

    @NotNull
    public static ResourceLocation of(@NotNull String resourcePath) {
        return new ResourceLocation(ComboSpecTestCase.class, resourcePath, TestUtils.getSpecResourceFileUrl(ComboSpecTestCase.class, resourcePath), TestUtils.getResolvedSpecResourcePath(ComboSpecTestCase.class.getName(), resourcePath));
    }

    @NotNull
    public static ResourceLocation of(@NotNull Class<?> resourceClass, @NotNull String resourcePath) {
        return new ResourceLocation(resourceClass, resourcePath, TestUtils.getSpecResourceFileUrl(resourceClass, resourcePath), TestUtils.getResolvedSpecResourcePath(resourceClass.getName(), resourcePath));
    }

    @NotNull
    public static ResourceLocation of(@NotNull Class<?> resourceClass, @NotNull String resourcePath, @NotNull String fileUrl) {
        return new ResourceLocation(resourceClass, resourcePath, fileUrl);
    }

    @NotNull
    public static String getResourceText(@NotNull ResourceLocation location) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            InputStream inputStream = ResourceLocation.getResourceInputStream(location);
            InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            BufferedReader reader = new BufferedReader(streamReader);
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            reader.close();
            streamReader.close();
            inputStream.close();
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static InputStream getResourceInputStream(@NotNull ResourceLocation location) {
        String useSpecResource = location.getResolvedResourcePath();
        InputStream stream = location.getResourceClass().getResourceAsStream(useSpecResource);
        if (stream == null) {
            throw new IllegalStateException("Could not load " + location);
        }
        return stream;
    }
}

