/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.test.util.spec;

import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.IParse;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IParseBase
implements IParse {
    private final DataHolder myOptions;

    public IParseBase() {
        this(null);
    }

    public IParseBase(DataHolder options) {
        this.myOptions = options;
    }

    @NotNull
    public Node parse(@NotNull String input) {
        return this.parse(BasedSequence.of((CharSequence)input));
    }

    public boolean transferReferences(@NotNull Document document, @NotNull Document included, Boolean onlyIfUndefined) {
        return false;
    }

    @NotNull
    public Node parseReader(@NotNull Reader input) throws IOException {
        int charsRead;
        BufferedReader bufferedReader = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        StringBuilder file = new StringBuilder();
        char[] buffer = new char[16384];
        do {
            charsRead = bufferedReader.read(buffer);
            file.append(buffer, 0, charsRead);
        } while (charsRead >= buffer.length);
        BasedSequence source = BasedSequence.of((CharSequence)file.toString());
        return this.parse(source);
    }

    @Nullable
    public DataHolder getOptions() {
        return this.myOptions;
    }
}

