/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.spec;

import java.net.URL;

public class UrlString {
    public static final String TARGET_TEST_CLASSES = "/target/test-classes/";
    public static final String OUT_TEST = "/out/test/";
    public static final String FILE_PROTOCOL = "file://";
    private final String fileUrl;

    public UrlString(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public UrlString(URL fileUrl) {
        this.fileUrl = UrlString.adjustedFileUrl(fileUrl);
    }

    public UrlString(URL fileUrl, int lineNumber) {
        this.fileUrl = UrlString.fileUrlWithLineNumber(fileUrl, lineNumber);
    }

    public String toString() {
        return this.fileUrl;
    }

    public static String adjustedFileUrl(URL url) {
        String externalForm = url.toExternalForm();
        if (externalForm.startsWith("file:/")) {
            int pathPos;
            String noFileProtocol = externalForm.substring("file:".length());
            if (noFileProtocol.contains(TARGET_TEST_CLASSES)) {
                return noFileProtocol.replace(TARGET_TEST_CLASSES, "/src/test/resources/");
            }
            int pos = noFileProtocol.indexOf(OUT_TEST);
            if (pos > 0 && (pathPos = noFileProtocol.indexOf("/", pos + OUT_TEST.length())) > 0) {
                return noFileProtocol.substring(0, pos) + "/" + noFileProtocol.substring(pos + OUT_TEST.length(), pathPos) + "/src/test/resources/" + noFileProtocol.substring(pathPos + 1);
            }
            return noFileProtocol;
        }
        return externalForm;
    }

    public static String fileUrlWithLineNumber(URL fileUrl, int lineNumber) {
        if (fileUrl != null) {
            if (lineNumber > 0) {
                return UrlString.adjustedFileUrl(fileUrl) + ":" + (lineNumber + 1);
            }
            return UrlString.adjustedFileUrl(fileUrl);
        }
        return null;
    }
}

