/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.spec;

import java.net.URL;

public class UrlString {
    private final String fileUrl;

    public UrlString(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public UrlString(URL fileUrl) {
        this.fileUrl = UrlString.adjustedFileUrl(fileUrl);
    }

    public UrlString(URL fileUrl, int lineNumber) {
        this.fileUrl = UrlString.fileUrlWithLineNumber(fileUrl, lineNumber);
    }

    public String toString() {
        return this.fileUrl;
    }

    public static String adjustedFileUrl(URL url) {
        String externalForm = url.toExternalForm();
        return externalForm.startsWith("file:/") ? "file://" + externalForm.substring("file:".length()).replace("/target/test-classes/", "/src/test/resources/") : externalForm;
    }

    public static String fileUrlWithLineNumber(URL fileUrl, int lineNumber) {
        if (fileUrl != null) {
            if (lineNumber > 0) {
                return UrlString.adjustedFileUrl(fileUrl) + ":" + (lineNumber + 1);
            }
            return UrlString.adjustedFileUrl(fileUrl);
        }
        return null;
    }
}

