/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.IRichSequenceBase;
import com.vladsch.flexmark.util.sequence.MappedBasedSequence;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.SubSequence;
import com.vladsch.flexmark.util.sequence.builder.BasedSegmentBuilder;
import com.vladsch.flexmark.util.sequence.builder.IBasedSegmentBuilder;
import com.vladsch.flexmark.util.sequence.builder.SequenceBuilder;
import com.vladsch.flexmark.util.sequence.builder.tree.SegmentTree;
import com.vladsch.flexmark.util.sequence.mappers.CharMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasedSequenceImpl
extends IRichSequenceBase<BasedSequence>
implements BasedSequence {
    public static BasedSequence firstNonNull(BasedSequence ... sequences) {
        for (BasedSequence sequence : sequences) {
            if (sequence == null || sequence == NULL) continue;
            return sequence;
        }
        return NULL;
    }

    public BasedSequenceImpl(int hash) {
        super(hash);
    }

    @NotNull
    public BasedSequence[] emptyArray() {
        return EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public BasedSequence nullSequence() {
        return NULL;
    }

    @Override
    @NotNull
    public BasedSequence sequenceOf(@Nullable CharSequence charSequence, int startIndex, int endIndex) {
        return BasedSequence.of(charSequence).subSequence(startIndex, endIndex);
    }

    @Override
    @NotNull
    public SequenceBuilder getBuilder() {
        return SequenceBuilder.emptyBuilder(this);
    }

    @Override
    public void addSegments(@NotNull IBasedSegmentBuilder<?> builder) {
        builder.append(this.getStartOffset(), this.getEndOffset());
    }

    @Override
    @NotNull
    public SegmentTree getSegmentTree() {
        BasedSegmentBuilder segmentBuilder = BasedSegmentBuilder.emptyBuilder(this.getBaseSequence());
        this.addSegments(segmentBuilder);
        return SegmentTree.build(segmentBuilder.getSegments(), segmentBuilder.getText());
    }

    @Override
    @NotNull
    public BasedSequence toMapped(CharMapper mapper) {
        return MappedBasedSequence.mappedOf(this, mapper);
    }

    @Override
    @NotNull
    public final BasedSequence baseSubSequence(int startIndex) {
        return this.baseSubSequence(startIndex, this.getBaseSequence().getEndOffset());
    }

    @Override
    @NotNull
    public BasedSequence baseSubSequence(int startIndex, int endIndex) {
        return this.getBaseSequence().subSequence(startIndex, endIndex);
    }

    @Override
    public char safeCharAt(int index) {
        return index < 0 || index >= this.length() ? (char)'\u0000' : this.charAt(index);
    }

    @Override
    public char safeBaseCharAt(int index) {
        int startOffset = this.getStartOffset();
        if (index >= startOffset && index < startOffset + this.length()) {
            return this.charAt(index - startOffset);
        }
        return this.getBaseSequence().safeCharAt(index);
    }

    @Override
    public boolean isBaseCharAt(int index, @NotNull CharPredicate predicate) {
        return predicate.test(this.safeBaseCharAt(index));
    }

    @Override
    @NotNull
    public BasedSequence getEmptyPrefix() {
        return this.subSequence(0, 0);
    }

    @Override
    @NotNull
    public BasedSequence getEmptySuffix() {
        return (BasedSequence)this.subSequence(this.length());
    }

    @Override
    @Nullable
    public String toStringOrNull() {
        return this.isNull() ? null : this.toString();
    }

    @Override
    @NotNull
    public String unescape() {
        return Escaping.unescapeString(this);
    }

    @Override
    @NotNull
    public String unescapeNoEntities() {
        return Escaping.unescapeString(this, false);
    }

    @Override
    @NotNull
    public BasedSequence unescape(@NotNull ReplacedTextMapper textMapper) {
        return Escaping.unescape(this, textMapper);
    }

    @Override
    @NotNull
    public BasedSequence normalizeEOL(@NotNull ReplacedTextMapper textMapper) {
        return Escaping.normalizeEOL(this, textMapper);
    }

    @Override
    @NotNull
    public BasedSequence normalizeEndWithEOL(@NotNull ReplacedTextMapper textMapper) {
        return Escaping.normalizeEndWithEOL(this, textMapper);
    }

    @Override
    public boolean isContinuedBy(@NotNull BasedSequence other) {
        return other.length() > 0 && this.length() > 0 && other.getBase() == this.getBase() && other.getStartOffset() == this.getEndOffset();
    }

    @Override
    public boolean isContinuationOf(@NotNull BasedSequence other) {
        return other.length() > 0 && this.length() > 0 && other.getBase() == this.getBase() && other.getEndOffset() == this.getStartOffset();
    }

    @Override
    @NotNull
    public BasedSequence spliceAtEnd(@NotNull BasedSequence other) {
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        assert (this.isContinuedBy(other)) : "sequence[" + this.getStartOffset() + ", " + this.getEndOffset() + "] is not continued by other[" + other.getStartOffset() + ", " + other.getEndOffset() + "]";
        return this.baseSubSequence(this.getStartOffset(), other.getEndOffset());
    }

    @Override
    public boolean containsAllOf(@NotNull BasedSequence other) {
        return this.getBase() == other.getBase() && other.getStartOffset() >= this.getStartOffset() && other.getEndOffset() <= this.getEndOffset();
    }

    @Override
    public boolean containsSomeOf(@NotNull BasedSequence other) {
        return this.getBase() == other.getBase() && this.getStartOffset() < other.getEndOffset() && this.getEndOffset() > other.getStartOffset();
    }

    @Override
    @NotNull
    public BasedSequence intersect(@NotNull BasedSequence other) {
        if (this.getBase() != other.getBase()) {
            return BasedSequence.NULL;
        }
        if (other.getEndOffset() <= this.getStartOffset()) {
            return this.subSequence(0, 0);
        }
        if (other.getStartOffset() >= this.getEndOffset()) {
            return this.subSequence(this.length(), this.length());
        }
        return this.baseSubSequence(Utils.max(this.getStartOffset(), other.getStartOffset()), Utils.min(this.getEndOffset(), other.getEndOffset()));
    }

    @Override
    @NotNull
    public BasedSequence extendByAny(@NotNull CharPredicate charSet) {
        return this.extendByAny(charSet, Integer.MAX_VALUE - this.getEndOffset());
    }

    @Override
    @NotNull
    public BasedSequence extendByOneOfAny(@NotNull CharPredicate charSet) {
        return this.extendByAny(charSet, 1);
    }

    @Override
    @NotNull
    public BasedSequence extendByAny(@NotNull CharPredicate charSet, int maxCount) {
        int count = this.getBaseSequence().countLeading(charSet, this.getEndOffset(), this.getEndOffset() + maxCount);
        return count == 0 ? this : this.baseSubSequence(this.getStartOffset(), this.getEndOffset() + count);
    }

    @Override
    @NotNull
    public BasedSequence extendByAnyNot(@NotNull CharPredicate charSet) {
        return this.extendByAnyNot(charSet, Integer.MAX_VALUE - this.getEndOffset());
    }

    @Override
    @NotNull
    public BasedSequence extendByOneOfAnyNot(@NotNull CharPredicate charSet) {
        return this.extendByAnyNot(charSet, 1);
    }

    @Override
    @NotNull
    public BasedSequence extendByAnyNot(@NotNull CharPredicate charSet, int maxCount) {
        int count = this.getBaseSequence().countLeadingNot(charSet, this.getEndOffset(), this.getEndOffset() + maxCount);
        return count == this.getBaseSequence().length() - this.getEndOffset() ? this : this.baseSubSequence(this.getStartOffset(), this.getEndOffset() + count + 1);
    }

    @Override
    @NotNull
    public final BasedSequence extendToEndOfLine(@NotNull CharPredicate eolChars) {
        return this.extendToEndOfLine(eolChars, false);
    }

    @Override
    @NotNull
    public final BasedSequence extendToEndOfLine(boolean includeEol) {
        return this.extendToEndOfLine(CharPredicate.EOL, includeEol);
    }

    @Override
    @NotNull
    public final BasedSequence extendToEndOfLine() {
        return this.extendToEndOfLine(CharPredicate.EOL, false);
    }

    @Override
    @NotNull
    public final BasedSequence extendToStartOfLine(@NotNull CharPredicate eolChars) {
        return this.extendToStartOfLine(eolChars, false);
    }

    @Override
    @NotNull
    public final BasedSequence extendToStartOfLine(boolean includeEol) {
        return this.extendToStartOfLine(CharPredicate.EOL, includeEol);
    }

    @Override
    @NotNull
    public final BasedSequence extendToStartOfLine() {
        return this.extendToStartOfLine(CharPredicate.EOL, false);
    }

    @Override
    @NotNull
    public final BasedSequence extendToEndOfLine(@NotNull CharPredicate eolChars, boolean includeEol) {
        int endOffset = this.getEndOffset();
        if (eolChars.test(this.lastChar())) {
            return this;
        }
        BasedSequence baseSequence = this.getBaseSequence();
        int endOfLine = baseSequence.endOfLine(endOffset);
        if (includeEol) {
            endOfLine = Math.min(baseSequence.length(), endOfLine + Math.min(baseSequence.eolStartLength(endOfLine), 1));
        }
        if (endOfLine != endOffset) {
            return baseSequence.subSequence(this.getStartOffset(), endOfLine);
        }
        return this;
    }

    @Override
    @NotNull
    public BasedSequence extendToStartOfLine(@NotNull CharPredicate eolChars, boolean includeEol) {
        int startOffset = this.getStartOffset();
        if (eolChars.test(this.firstChar())) {
            return this;
        }
        BasedSequence baseSequence = this.getBaseSequence();
        int startOfLine = baseSequence.startOfLine(startOffset);
        if (includeEol) {
            startOfLine = Math.max(0, startOfLine - Math.min(baseSequence.eolEndLength(startOfLine), 1));
        }
        if (startOfLine != startOffset) {
            return baseSequence.subSequence(startOfLine, this.getEndOffset());
        }
        return this;
    }

    @Override
    @NotNull
    public BasedSequence prefixWith(@Nullable CharSequence prefix) {
        return prefix == null || prefix.length() == 0 ? this : PrefixedSubSequence.prefixOf(prefix.toString(), this);
    }

    @Override
    @NotNull
    public final BasedSequence prefixWithIndent() {
        return this.prefixWithIndent(Integer.MAX_VALUE);
    }

    @Override
    @NotNull
    public BasedSequence prefixWithIndent(int maxColumns) {
        int offset;
        block9: {
            int startOffset;
            offset = this.getStartOffset();
            int columns = 0;
            int columnOffset = 0;
            boolean hadTab = false;
            for (startOffset = this.getStartOffset(); startOffset >= 0; --startOffset) {
                char c = this.getBaseSequence().charAt(startOffset);
                if (c == '\t') {
                    hadTab = true;
                    continue;
                }
                if (c != '\n') continue;
                ++startOffset;
                break;
            }
            if (startOffset < 0) {
                startOffset = 0;
            }
            if (startOffset >= offset) break block9;
            if (hadTab) {
                int[] offsetColumns = new int[offset - startOffset];
                for (int currOffset = startOffset; currOffset < offset; ++currOffset) {
                    if (this.getBaseSequence().charAt(currOffset) == '\t') {
                        int n = 4 - columnOffset % 4;
                        offsetColumns[currOffset - startOffset] = n;
                        columnOffset += n;
                        continue;
                    }
                    offsetColumns[currOffset - startOffset] = 1;
                    ++columnOffset;
                }
                while (columns < maxColumns && offset > 0 && (this.getBaseSequence().charAt(offset - 1) == ' ' || this.getBaseSequence().charAt(offset - 1) == '\t') && (columns += offsetColumns[offset - 1 - startOffset]) <= maxColumns) {
                    --offset;
                }
            } else {
                while (columns < maxColumns && offset > 0 && (this.getBaseSequence().charAt(offset - 1) == ' ' || this.getBaseSequence().charAt(offset - 1) == '\t')) {
                    ++columns;
                    --offset;
                }
            }
        }
        return offset == this.getStartOffset() ? this : this.baseSubSequence(offset, this.getEndOffset());
    }

    @Override
    @NotNull
    public BasedSequence prefixOf(@NotNull BasedSequence other) {
        if (this.getBase() != other.getBase()) {
            return BasedSequence.NULL;
        }
        if (other.getStartOffset() <= this.getStartOffset()) {
            return this.subSequence(0, 0);
        }
        if (other.getStartOffset() >= this.getEndOffset()) {
            return this;
        }
        return this.baseSubSequence(this.getStartOffset(), other.getStartOffset());
    }

    @Override
    @NotNull
    public BasedSequence suffixOf(@NotNull BasedSequence other) {
        if (this.getBase() != other.getBase()) {
            return BasedSequence.NULL;
        }
        if (other.getEndOffset() >= this.getEndOffset()) {
            return this.subSequence(this.length(), this.length());
        }
        if (other.getEndOffset() <= this.getStartOffset()) {
            return this;
        }
        return this.baseSubSequence(other.getEndOffset(), this.getEndOffset());
    }

    @Override
    @NotNull
    public Range baseLineRangeAtIndex(int index) {
        return this.getBaseSequence().lineRangeAt(index);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> baseLineColumnAtIndex(int index) {
        return this.getBaseSequence().lineColumnAtIndex(index);
    }

    @Override
    public int baseEndOfLine(int index) {
        return this.getBaseSequence().endOfLine(index);
    }

    @Override
    public int baseEndOfLineAnyEOL(int index) {
        return this.getBaseSequence().endOfLineAnyEOL(index);
    }

    @Override
    public int baseStartOfLine(int index) {
        return this.getBaseSequence().startOfLine(index);
    }

    @Override
    public int baseStartOfLineAnyEOL(int index) {
        return this.getBaseSequence().startOfLineAnyEOL(index);
    }

    @Override
    public int baseColumnAtIndex(int index) {
        return this.getBaseSequence().columnAtIndex(index);
    }

    @Override
    public int baseEndOfLine() {
        return this.baseEndOfLine(this.getEndOffset());
    }

    @Override
    public int baseEndOfLineAnyEOL() {
        return this.baseEndOfLineAnyEOL(this.getEndOffset());
    }

    @Override
    public int baseColumnAtEnd() {
        return this.baseColumnAtIndex(this.getEndOffset());
    }

    @Override
    @NotNull
    public Range baseLineRangeAtEnd() {
        return this.baseLineRangeAtIndex(this.getEndOffset());
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> baseLineColumnAtEnd() {
        return this.baseLineColumnAtIndex(this.getEndOffset());
    }

    @Override
    public int baseStartOfLine() {
        return this.baseStartOfLine(this.getStartOffset());
    }

    @Override
    public int baseStartOfLineAnyEOL() {
        return this.baseStartOfLineAnyEOL(this.getStartOffset());
    }

    @Override
    public int baseColumnAtStart() {
        return this.baseColumnAtIndex(this.getStartOffset());
    }

    @Override
    @NotNull
    public Range baseLineRangeAtStart() {
        return this.baseLineRangeAtIndex(this.getStartOffset());
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> baseLineColumnAtStart() {
        return this.baseLineColumnAtIndex(this.getStartOffset());
    }

    static BasedSequence create(@Nullable CharSequence charSequence) {
        if (charSequence == null) {
            return BasedSequence.NULL;
        }
        if (charSequence instanceof BasedSequence) {
            return (BasedSequence)charSequence;
        }
        return SubSequence.create(charSequence);
    }
}

