/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.autolink.internal;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.DelimitedLinkNode;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.ast.DoNotDecorate;
import com.vladsch.flexmark.util.ast.DoNotLinkDecorate;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.ast.TypographicText;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.nibor.autolink.LinkExtractor;
import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;

public class AutolinkNodePostProcessor
extends NodePostProcessor {
    private static final Pattern URI_PREFIX = Pattern.compile("\\b([a-z][a-z0-9+.-]*://)(?:\\s|$)");
    private final Pattern ignoredLinks;
    private final boolean intellijDummyIdentifier;
    private final LinkExtractor linkExtractor = LinkExtractor.builder().linkTypes(EnumSet.of(LinkType.URL, LinkType.WWW, LinkType.EMAIL)).build();

    public AutolinkNodePostProcessor(Document document) {
        String ignoreLinks = AutolinkExtension.IGNORE_LINKS.get(document);
        this.ignoredLinks = ignoreLinks.isEmpty() ? null : Pattern.compile(ignoreLinks);
        this.intellijDummyIdentifier = Parser.INTELLIJ_DUMMY_IDENTIFIER.get(document);
    }

    public boolean isIgnoredLinkPrefix(CharSequence url) {
        if (this.ignoredLinks != null) {
            Matcher matcher = this.ignoredLinks.matcher(url);
            return matcher.matches();
        }
        return false;
    }

    @Override
    public void process(@NotNull NodeTracker state, @NotNull Node node) {
        BasedSequence combined;
        if (node.getAncestorOfType(DoNotDecorate.class, DoNotLinkDecorate.class) != null) {
            return;
        }
        BasedSequence original = combined = node.getChars();
        Node firstNode = node;
        Node lastNode = node;
        if (node.getNext() instanceof TypographicText && node.getNext().getChars().isContinuationOf(combined)) {
            Node typoGraphic = node.getNext();
            ArrayList<BasedSequence> combinedSequences = new ArrayList<BasedSequence>();
            combinedSequences.add(combined);
            while ((typoGraphic instanceof TypographicText || typoGraphic instanceof Text) && typoGraphic.getChars().isContinuationOf(combined) && !typoGraphic.getChars().startsWith(" ") && !combined.endsWith(" ")) {
                combined = typoGraphic.getChars();
                combinedSequences.add(combined);
                lastNode = typoGraphic;
                typoGraphic = typoGraphic.getNext();
            }
            original = SegmentedSequence.create(node.getChars(), combinedSequences);
        }
        ReplacedTextMapper textMapper = new ReplacedTextMapper(original);
        BasedSequence literal = Escaping.unescape(original, textMapper);
        if (this.intellijDummyIdentifier) {
            literal = Escaping.removeAll(literal, "\u001f", textMapper);
        }
        Iterable<LinkSpan> links = this.linkExtractor.extractLinks(literal);
        ArrayList<LinkSpan> linksList = new ArrayList<LinkSpan>();
        for (LinkSpan link : links) {
            linksList.add(link);
        }
        Matcher matcher = URI_PREFIX.matcher(literal);
        while (matcher.find()) {
            int start = matcher.start(1);
            int end = matcher.end(1);
            if (linksList.isEmpty()) {
                linksList.add(new DummyLinkSpan(LinkType.URL, start, end));
                continue;
            }
            int iMax = linksList.size();
            boolean skip = false;
            for (int i = 0; i < iMax; ++i) {
                LinkSpan link = (LinkSpan)linksList.get(i);
                if (end < link.getBeginIndex()) {
                    linksList.add(i, new DummyLinkSpan(LinkType.URL, start, end));
                    skip = true;
                    break;
                }
                if (start < link.getBeginIndex() || end > link.getEndIndex()) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            linksList.add(new DummyLinkSpan(LinkType.URL, start, end));
        }
        int lastEscaped = 0;
        boolean wrapInTextBase = !(node.getParent() instanceof TextBase);
        TextBase textBase = wrapInTextBase || !(node.getParent() instanceof TextBase) ? null : (TextBase)node.getParent();
        boolean processedNode = false;
        for (LinkSpan link : linksList) {
            DelimitedLinkNode linkNode;
            BasedSequence linkText = (BasedSequence)literal.subSequence(link.getBeginIndex(), link.getEndIndex()).trimEnd();
            if (this.isIgnoredLinkPrefix(linkText)) continue;
            int startOffset = textMapper.originalOffset(link.getBeginIndex());
            processedNode = true;
            if (lastEscaped == 0 && firstNode != lastNode && startOffset >= node.getChars().length()) {
                return;
            }
            if (wrapInTextBase) {
                wrapInTextBase = false;
                textBase = new TextBase(original);
                node.insertBefore(textBase);
                state.nodeAdded(textBase);
            }
            if (startOffset > lastEscaped) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, startOffset);
                Text node1 = new Text(escapedChars);
                if (textBase != null) {
                    textBase.appendChild(node1);
                } else {
                    node.insertBefore(node1);
                }
                state.nodeAdded(node1);
            }
            BasedSequence linkChars = linkText.baseSubSequence(linkText.getStartOffset(), linkText.getEndOffset());
            Text contentNode = new Text(linkChars);
            if (link.getType() == LinkType.EMAIL) {
                linkNode = new MailLink();
                linkNode.setText(linkChars);
            } else {
                linkNode = new AutoLink();
                ((AutoLink)linkNode).setText(linkChars);
                ((AutoLink)linkNode).setUrlChars(linkChars);
            }
            linkNode.setCharsFromContent();
            linkNode.appendChild(contentNode);
            if (textBase != null) {
                textBase.appendChild(linkNode);
            } else {
                node.insertBefore(linkNode);
            }
            state.nodeAddedWithChildren(linkNode);
            lastEscaped = textMapper.originalOffset(link.getBeginIndex() + linkText.length());
        }
        if (lastEscaped > 0) {
            if (firstNode != lastNode) {
                Node removeNode = firstNode.getNext();
                int length = node.getChars().length();
                while (removeNode != null) {
                    if (length >= lastEscaped) {
                        original = original.subSequence(0, length);
                        break;
                    }
                    length += removeNode.getChars().length();
                    Node next = removeNode.getNext();
                    removeNode.unlink();
                    state.nodeRemoved(removeNode);
                    if (removeNode == lastNode) break;
                    removeNode = next;
                }
            }
            if (lastEscaped < original.length()) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, original.length());
                Text node1 = new Text(escapedChars);
                if (textBase != null) {
                    textBase.appendChild(node1);
                } else {
                    node.insertBefore(node1);
                }
                state.nodeAdded(node1);
            }
        }
        if (processedNode) {
            node.unlink();
            state.nodeRemoved(node);
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodes(Text.class);
        }

        @Override
        @NotNull
        public NodePostProcessor apply(@NotNull Document document) {
            return new AutolinkNodePostProcessor(document);
        }
    }

    private static class DummyLinkSpan
    implements LinkSpan {
        private final LinkType linkType;
        private final int beginIndex;
        private final int endIndex;

        public DummyLinkSpan(LinkType linkType, int beginIndex, int endIndex) {
            this.linkType = linkType;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        @Override
        public LinkType getType() {
            return this.linkType;
        }

        @Override
        public int getBeginIndex() {
            return this.beginIndex;
        }

        @Override
        public int getEndIndex() {
            return this.endIndex;
        }
    }
}

