/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.typographic;

import com.vladsch.flexmark.util.ast.DoNotAttributeDecorate;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.TypographicText;
import com.vladsch.flexmark.util.misc.BitFieldSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import org.jetbrains.annotations.NotNull;

public class TypographicSmarts
extends Node
implements DoNotAttributeDecorate,
TypographicText {
    private String typographicText;

    public TypographicSmarts() {
    }

    public TypographicSmarts(BasedSequence chars) {
        super(chars);
    }

    public TypographicSmarts(String typographicText) {
        this.typographicText = typographicText;
    }

    public TypographicSmarts(BasedSequence chars, String typographicText) {
        super(chars);
        this.typographicText = typographicText;
    }

    @Override
    public boolean collectText(ISequenceBuilder<? extends ISequenceBuilder<?, BasedSequence>, BasedSequence> out, int flags) {
        if (BitFieldSet.any(flags, F_NODE_TEXT)) {
            out.append(this.getChars());
        } else {
            ReplacedTextMapper textMapper = new ReplacedTextMapper(this.getChars());
            BasedSequence unescaped = Escaping.unescape(this.getChars(), textMapper);
            out.append(unescaped);
        }
        return false;
    }

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        out.append(" typographic: ").append(this.typographicText).append(" ");
    }

    public String getTypographicText() {
        return this.typographicText;
    }

    public void setTypographicText(String typographicText) {
        this.typographicText = typographicText;
    }

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return EMPTY_SEGMENTS;
    }

    @Override
    @NotNull
    protected String toStringAttributes() {
        return "text=" + this.getChars();
    }
}

