/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.ast;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeClassifier;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.collection.ClassificationBag;
import com.vladsch.flexmark.util.collection.OrderedMap;
import com.vladsch.flexmark.util.collection.OrderedSet;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterable;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassifyingNodeTracker
implements NodeTracker {
    @NotNull
    protected final ClassificationBag<Class<?>, Node> nodeClassifier;
    @Nullable
    private final NodeTracker host;
    @NotNull
    private final OrderedMap<Class<?>, Set<Class<?>>> exclusionMap;
    @NotNull
    private final OrderedSet<Class<?>> exclusionSet;
    @NotNull
    private final HashMap<Integer, BitSet> nodeAncestryMap;

    public ClassifyingNodeTracker(@Nullable NodeTracker host, @NotNull Map<Class<? extends Node>, Set<Class<?>>> exclusionMap) {
        this.host = host;
        this.nodeClassifier = new ClassificationBag(NodeClassifier.INSTANCE);
        this.exclusionMap = new OrderedMap(exclusionMap.size());
        this.exclusionMap.putAll(exclusionMap);
        this.exclusionSet = new OrderedSet();
        Iterator iterator = this.exclusionMap.valueIterable().iterator();
        while (iterator.hasNext()) {
            this.exclusionSet.addAll((Collection)iterator.next());
        }
        this.nodeAncestryMap = new HashMap();
    }

    @NotNull
    public OrderedMap<Class<?>, Set<Class<?>>> getExclusionMap() {
        return this.exclusionMap;
    }

    @NotNull
    public HashMap<Integer, BitSet> getNodeAncestryMap() {
        return this.nodeAncestryMap;
    }

    @NotNull
    public OrderedSet<Class<?>> getExclusionSet() {
        return this.exclusionSet;
    }

    @NotNull
    public ClassificationBag<Class<?>, Node> getNodeClassifier() {
        return this.nodeClassifier;
    }

    private void validateLinked(Node node) {
        if (node.getNext() == null && node.getParent() == null) {
            throw new IllegalStateException("Added block " + node + " is not linked into the AST");
        }
    }

    @Override
    public void nodeAdded(@NotNull Node node) {
        this.validateLinked(node);
        this.nodeClassifier.add(node);
        if (this.host != null) {
            this.host.nodeAdded(node);
        }
    }

    @Override
    public void nodeAddedWithChildren(@NotNull Node node) {
        this.validateLinked(node);
        this.nodeClassifier.add(node);
        this.addNodes(node.getChildren());
        if (this.host != null) {
            this.host.nodeAddedWithChildren(node);
        }
    }

    @Override
    public void nodeAddedWithDescendants(@NotNull Node node) {
        this.validateLinked(node);
        this.nodeClassifier.add(node);
        this.addNodes(node.getDescendants());
        if (this.host != null) {
            this.host.nodeAddedWithDescendants(node);
        }
    }

    private void addNodes(@NotNull ReversiblePeekingIterable<Node> nodes) {
        for (Node child : nodes) {
            this.nodeClassifier.add(child);
        }
    }

    private void validateUnlinked(@NotNull Node node) {
        if (node.getNext() != null || node.getParent() != null) {
            throw new IllegalStateException("Removed block " + node + " is still linked in the AST");
        }
    }

    @Override
    public void nodeRemoved(@NotNull Node node) {
        this.nodeRemovedWithDescendants(node);
    }

    @Override
    public void nodeRemovedWithChildren(@NotNull Node node) {
        this.nodeRemovedWithDescendants(node);
    }

    @Override
    public void nodeRemovedWithDescendants(@NotNull Node node) {
        this.validateUnlinked(node);
        this.nodeClassifier.add(node);
        this.removeNodes(node.getDescendants());
        if (this.host != null) {
            this.host.nodeRemovedWithDescendants(node);
        }
    }

    private void removeNodes(@NotNull ReversiblePeekingIterable<Node> nodes) {
        for (Node child : nodes) {
            this.nodeClassifier.add(child);
        }
    }

    @NotNull
    public OrderedSet<Node> getItems() {
        return this.nodeClassifier.getItems();
    }

    @NotNull
    public <X> ReversibleIterable<X> getCategoryItems(@NotNull Class<? extends X> nodeClass, @NotNull Set<Class<?>> classes) {
        return this.nodeClassifier.getCategoryItems(nodeClass, (Collection<Class<?>>)classes);
    }
}

