/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.jekyll.tag.internal;

import com.vladsch.flexmark.ext.jekyll.tag.JekyllTag;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagBlock;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagExtension;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JekyllTagNodeRenderer
implements NodeRenderer {
    private final boolean embedIncludes;
    private final Map<String, String> includeContent;

    public JekyllTagNodeRenderer(DataHolder options) {
        this.includeContent = JekyllTagExtension.INCLUDED_HTML.get(options);
        this.embedIncludes = JekyllTagExtension.EMBED_INCLUDED_CONTENT.get(options);
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<JekyllTag>(JekyllTag.class, this::render));
        set.add(new NodeRenderingHandler<JekyllTagBlock>(JekyllTagBlock.class, this::render));
        return set;
    }

    private void render(JekyllTag node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(JekyllTagBlock node, NodeRendererContext context, HtmlWriter html) {
        if (this.embedIncludes) {
            Node child = node.getFirstChild();
            if (child != null) {
                child = child.getNextAnyNot(JekyllTag.class);
            }
            while (child != null) {
                Node next = child.getNextAnyNot(JekyllTag.class);
                context.render(child);
                child = next;
            }
        } else {
            Node child = node.getFirstChild();
            while (child != null) {
                Node next = child.getNextAny(JekyllTag.class);
                context.render(child);
                child = next;
            }
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new JekyllTagNodeRenderer(options);
        }
    }
}

