/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter;

import com.vladsch.flexmark.formatter.ExplicitAttributeIdProvider;
import com.vladsch.flexmark.formatter.FormatterOptions;
import com.vladsch.flexmark.formatter.FormattingPhase;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.MergeContext;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormatterSubContext;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.PhasedNodeFormatter;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.formatter.TranslatingSpanRender;
import com.vladsch.flexmark.formatter.TranslationHandler;
import com.vladsch.flexmark.formatter.TranslationHandlerFactory;
import com.vladsch.flexmark.formatter.TranslationPlaceholderGenerator;
import com.vladsch.flexmark.formatter.internal.CoreNodeFormatter;
import com.vladsch.flexmark.formatter.internal.FormatControlProcessor;
import com.vladsch.flexmark.formatter.internal.MergeContextImpl;
import com.vladsch.flexmark.formatter.internal.MergeLinkResolver;
import com.vladsch.flexmark.formatter.internal.TranslationHandlerImpl;
import com.vladsch.flexmark.html.AttributeProviderFactory;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.HeaderIdGenerator;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.HtmlIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.ast.BlankLine;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.IRender;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeCollectingVisitor;
import com.vladsch.flexmark.util.builder.BuilderBase;
import com.vladsch.flexmark.util.collection.SubClassingBag;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.data.NullableDataKey;
import com.vladsch.flexmark.util.data.ScopedDataSet;
import com.vladsch.flexmark.util.data.SharedDataKeys;
import com.vladsch.flexmark.util.dependency.DependencyResolver;
import com.vladsch.flexmark.util.dependency.FlatDependencyHandler;
import com.vladsch.flexmark.util.format.CharWidthProvider;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.format.TrackedOffset;
import com.vladsch.flexmark.util.format.TrackedOffsetList;
import com.vladsch.flexmark.util.format.TrackedOffsetUtils;
import com.vladsch.flexmark.util.format.options.BlockQuoteMarker;
import com.vladsch.flexmark.util.format.options.CodeFenceMarker;
import com.vladsch.flexmark.util.format.options.DiscretionaryText;
import com.vladsch.flexmark.util.format.options.ElementAlignment;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import com.vladsch.flexmark.util.format.options.EqualizeTrailingMarker;
import com.vladsch.flexmark.util.format.options.HeadingStyle;
import com.vladsch.flexmark.util.format.options.ListBulletMarker;
import com.vladsch.flexmark.util.format.options.ListNumberedMarker;
import com.vladsch.flexmark.util.format.options.ListSpacing;
import com.vladsch.flexmark.util.format.options.TableCaptionHandling;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.misc.Extension;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.LineAppendable;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import com.vladsch.flexmark.util.sequence.builder.SequenceBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Formatter
implements IRender {
    public static final Document[] EMPTY_DOCUMENTS = new Document[0];
    public static final DataKey<Integer> FORMAT_FLAGS = new DataKey<Integer>("FORMAT_FLAGS", LineAppendable.F_TRIM_LEADING_WHITESPACE | LineAppendable.F_TRIM_LEADING_EOL);
    @Deprecated
    public static final int FORMAT_CONVERT_TABS = LineAppendable.F_CONVERT_TABS;
    @Deprecated
    public static final int FORMAT_COLLAPSE_WHITESPACE = LineAppendable.F_COLLAPSE_WHITESPACE;
    @Deprecated
    public static final int FORMAT_SUPPRESS_TRAILING_WHITESPACE = LineAppendable.F_TRIM_TRAILING_WHITESPACE;
    @Deprecated
    public static final int FORMAT_ALL_OPTIONS = LineAppendable.F_FORMAT_ALL;
    public static final DataKey<Boolean> GENERATE_HEADER_ID = new DataKey<Boolean>("GENERATE_HEADER_ID", false);
    public static final DataKey<Integer> MAX_BLANK_LINES = SharedDataKeys.FORMATTER_MAX_BLANK_LINES;
    public static final DataKey<Integer> MAX_TRAILING_BLANK_LINES = SharedDataKeys.FORMATTER_MAX_TRAILING_BLANK_LINES;
    public static final DataKey<Integer> RIGHT_MARGIN = new DataKey<Integer>("RIGHT_MARGIN", 0);
    public static final DataKey<Boolean> APPLY_SPECIAL_LEAD_IN_HANDLERS = SharedDataKeys.APPLY_SPECIAL_LEAD_IN_HANDLERS;
    public static final DataKey<Boolean> ESCAPE_SPECIAL_CHARS = SharedDataKeys.ESCAPE_SPECIAL_CHARS;
    public static final DataKey<Boolean> ESCAPE_NUMBERED_LEAD_IN = SharedDataKeys.ESCAPE_NUMBERED_LEAD_IN;
    public static final DataKey<Boolean> UNESCAPE_SPECIAL_CHARS = SharedDataKeys.UNESCAPE_SPECIAL_CHARS;
    public static final DataKey<DiscretionaryText> SPACE_AFTER_ATX_MARKER = new DataKey<DiscretionaryText>("SPACE_AFTER_ATX_MARKER", DiscretionaryText.ADD);
    public static final DataKey<Boolean> SETEXT_HEADING_EQUALIZE_MARKER = new DataKey<Boolean>("SETEXT_HEADING_EQUALIZE_MARKER", true);
    public static final DataKey<EqualizeTrailingMarker> ATX_HEADING_TRAILING_MARKER = new DataKey<EqualizeTrailingMarker>("ATX_HEADING_TRAILING_MARKER", EqualizeTrailingMarker.AS_IS);
    public static final DataKey<HeadingStyle> HEADING_STYLE = new DataKey<HeadingStyle>("HEADING_STYLE", HeadingStyle.AS_IS);
    public static final NullableDataKey<String> THEMATIC_BREAK = new NullableDataKey("THEMATIC_BREAK");
    public static final DataKey<Boolean> BLOCK_QUOTE_BLANK_LINES = SharedDataKeys.BLOCK_QUOTE_BLANK_LINES;
    public static final DataKey<BlockQuoteMarker> BLOCK_QUOTE_MARKERS = new DataKey<BlockQuoteMarker>("BLOCK_QUOTE_MARKERS", BlockQuoteMarker.ADD_COMPACT_WITH_SPACE);
    public static final DataKey<Boolean> INDENTED_CODE_MINIMIZE_INDENT = new DataKey<Boolean>("INDENTED_CODE_MINIMIZE_INDENT", true);
    public static final DataKey<Boolean> FENCED_CODE_MINIMIZE_INDENT = new DataKey<Boolean>("FENCED_CODE_MINIMIZE_INDENT", true);
    public static final DataKey<Boolean> FENCED_CODE_MATCH_CLOSING_MARKER = new DataKey<Boolean>("FENCED_CODE_MATCH_CLOSING_MARKER", true);
    public static final DataKey<Boolean> FENCED_CODE_SPACE_BEFORE_INFO = new DataKey<Boolean>("FENCED_CODE_SPACE_BEFORE_INFO", false);
    public static final DataKey<Integer> FENCED_CODE_MARKER_LENGTH = new DataKey<Integer>("FENCED_CODE_MARKER_LENGTH", 3);
    public static final DataKey<CodeFenceMarker> FENCED_CODE_MARKER_TYPE = new DataKey<CodeFenceMarker>("FENCED_CODE_MARKER_TYPE", CodeFenceMarker.ANY);
    public static final DataKey<Boolean> LIST_ADD_BLANK_LINE_BEFORE = new DataKey<Boolean>("LIST_ADD_BLANK_LINE_BEFORE", false);
    public static final DataKey<Boolean> LIST_RENUMBER_ITEMS = new DataKey<Boolean>("LIST_RENUMBER_ITEMS", true);
    public static final DataKey<Boolean> LIST_REMOVE_EMPTY_ITEMS = new DataKey<Boolean>("LIST_REMOVE_EMPTY_ITEMS", false);
    public static final DataKey<ElementAlignment> LIST_ALIGN_NUMERIC = new DataKey<ElementAlignment>("LIST_ALIGN_NUMERIC", ElementAlignment.NONE);
    public static final DataKey<Boolean> LIST_RESET_FIRST_ITEM_NUMBER = new DataKey<Boolean>("LIST_RESET_FIRST_ITEM_NUMBER", false);
    public static final DataKey<ListBulletMarker> LIST_BULLET_MARKER = new DataKey<ListBulletMarker>("LIST_BULLET_MARKER", ListBulletMarker.ANY);
    public static final DataKey<ListNumberedMarker> LIST_NUMBERED_MARKER = new DataKey<ListNumberedMarker>("LIST_NUMBERED_MARKER", ListNumberedMarker.ANY);
    public static final DataKey<ListSpacing> LIST_SPACING = new DataKey<ListSpacing>("LIST_SPACING", ListSpacing.AS_IS);
    public static final DataKey<Boolean> LISTS_ITEM_CONTENT_AFTER_SUFFIX = new DataKey<Boolean>("LISTS_ITEM_CONTENT_AFTER_SUFFIX", false);
    public static final DataKey<ElementPlacement> REFERENCE_PLACEMENT = new DataKey<ElementPlacement>("REFERENCE_PLACEMENT", ElementPlacement.AS_IS);
    public static final DataKey<ElementPlacementSort> REFERENCE_SORT = new DataKey<ElementPlacementSort>("REFERENCE_SORT", ElementPlacementSort.AS_IS);
    public static final DataKey<Boolean> KEEP_IMAGE_LINKS_AT_START = new DataKey<Boolean>("KEEP_IMAGE_LINKS_AT_START", false);
    public static final DataKey<Boolean> KEEP_EXPLICIT_LINKS_AT_START = new DataKey<Boolean>("KEEP_EXPLICIT_LINKS_AT_START", false);
    public static final DataKey<Boolean> OPTIMIZED_INLINE_RENDERING = new DataKey<Boolean>("OPTIMIZED_INLINE_RENDERING", false);
    public static final DataKey<CharWidthProvider> FORMAT_CHAR_WIDTH_PROVIDER = TableFormatOptions.FORMAT_CHAR_WIDTH_PROVIDER;
    public static final DataKey<Boolean> KEEP_HARD_LINE_BREAKS = new DataKey<Boolean>("KEEP_HARD_LINE_BREAKS", true);
    public static final DataKey<Boolean> KEEP_SOFT_LINE_BREAKS = new DataKey<Boolean>("KEEP_SOFT_LINE_BREAKS", true);
    public static final DataKey<String> FORMATTER_ON_TAG = new DataKey<String>("FORMATTER_ON_TAG", "@formatter:on");
    public static final DataKey<String> FORMATTER_OFF_TAG = new DataKey<String>("FORMATTER_OFF_TAG", "@formatter:off");
    public static final DataKey<Boolean> FORMATTER_TAGS_ENABLED = new DataKey<Boolean>("FORMATTER_TAGS_ENABLED", false);
    public static final DataKey<Boolean> FORMATTER_TAGS_ACCEPT_REGEXP = new DataKey<Boolean>("FORMATTER_TAGS_ACCEPT_REGEXP", false);
    public static final NullableDataKey<Pattern> LINK_MARKER_COMMENT_PATTERN = new NullableDataKey<Pattern>("FORMATTER_TAGS_ACCEPT_REGEXP", (Pattern)null);
    public static final DataKey<Boolean> APPEND_TRANSFERRED_REFERENCES = new DataKey<Boolean>("APPEND_TRANSFERRED_REFERENCES", false);
    public static final DataKey<String> TRANSLATION_ID_FORMAT = new DataKey<String>("TRANSLATION_ID_FORMAT", "_%d_");
    public static final DataKey<String> TRANSLATION_HTML_BLOCK_PREFIX = new DataKey<String>("TRANSLATION_HTML_BLOCK_PREFIX", "__");
    public static final DataKey<String> TRANSLATION_HTML_INLINE_PREFIX = new DataKey<String>("TRANSLATION_HTML_INLINE_PREFIX", "_");
    public static final DataKey<String> TRANSLATION_AUTOLINK_PREFIX = new DataKey<String>("TRANSLATION_AUTOLINK_PREFIX", "___");
    public static final DataKey<String> TRANSLATION_EXCLUDE_PATTERN = new DataKey<String>("TRANSLATION_EXCLUDE_PATTERN", "^[^\\p{IsAlphabetic}]*$");
    public static final DataKey<String> TRANSLATION_HTML_BLOCK_TAG_PATTERN = Parser.TRANSLATION_HTML_BLOCK_TAG_PATTERN;
    public static final DataKey<String> TRANSLATION_HTML_INLINE_TAG_PATTERN = Parser.TRANSLATION_HTML_INLINE_TAG_PATTERN;
    public static final DataKey<String> DOC_RELATIVE_URL = new DataKey<String>("DOC_RELATIVE_URL", "");
    public static final DataKey<String> DOC_ROOT_URL = new DataKey<String>("DOC_ROOT_URL", "");
    public static final DataKey<Boolean> DEFAULT_LINK_RESOLVER = new DataKey<Boolean>("DEFAULT_LINK_RESOLVER", false);
    public static final DataKey<ParserEmulationProfile> FORMATTER_EMULATION_PROFILE = new DataKey<DataKey<ParserEmulationProfile>>("FORMATTER_EMULATION_PROFILE", Parser.PARSER_EMULATION_PROFILE);
    public static final DataKey<List<TrackedOffset>> TRACKED_OFFSETS = new DataKey("TRACKED_OFFSETS", Collections.emptyList());
    public static final DataKey<BasedSequence> TRACKED_SEQUENCE = new DataKey<BasedSequence>("TRACKED_SEQUENCE", BasedSequence.NULL);
    public static final DataKey<Boolean> RESTORE_TRACKED_SPACES = new DataKey<Boolean>("RESTORE_END_SPACES", false);
    public static final DataKey<CharSequence> DOCUMENT_FIRST_PREFIX = new DataKey<BasedSequence>("DOCUMENT_FIRST_PREFIX", BasedSequence.NULL);
    public static final DataKey<CharSequence> DOCUMENT_PREFIX = new DataKey<BasedSequence>("DOCUMENT_PREFIX", BasedSequence.NULL);
    @Deprecated
    public static final DataKey<Boolean> SETEXT_HEADER_EQUALIZE_MARKER = SETEXT_HEADING_EQUALIZE_MARKER;
    @Deprecated
    public static final DataKey<EqualizeTrailingMarker> ATX_HEADER_TRAILING_MARKER = ATX_HEADING_TRAILING_MARKER;
    @Deprecated
    public static final DataKey<TableCaptionHandling> FORMAT_TABLE_CAPTION = TableFormatOptions.FORMAT_TABLE_CAPTION;
    @Deprecated
    public static final DataKey<DiscretionaryText> FORMAT_TABLE_CAPTION_SPACES = TableFormatOptions.FORMAT_TABLE_CAPTION_SPACES;
    @Deprecated
    public static final DataKey<String> FORMAT_TABLE_INDENT_PREFIX = TableFormatOptions.FORMAT_TABLE_INDENT_PREFIX;
    private final DataHolder options;
    final List<LinkResolverFactory> linkResolverFactories;
    final List<NodeFormatterFactory> nodeFormatterFactories;
    final HeaderIdGeneratorFactory idGeneratorFactory;
    private static final Iterator<Node> NULL_ITERATOR = new Iterator<Node>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Node next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };
    public static final Iterable<Node> NULL_ITERABLE = () -> NULL_ITERATOR;

    Formatter(Builder builder) {
        this.options = builder.toImmutable();
        this.idGeneratorFactory = builder.htmlIdGeneratorFactory == null ? new HeaderIdGenerator.Factory() : builder.htmlIdGeneratorFactory;
        this.linkResolverFactories = FlatDependencyHandler.computeDependencies(builder.linkResolverFactories);
        this.nodeFormatterFactories = Formatter.calculateNodeFormatterFactories(builder.nodeFormatterFactories);
    }

    private static List<NodeFormatterFactory> calculateNodeFormatterFactories(List<NodeFormatterFactory> formatterFactories) {
        ArrayList<NodeFormatterFactory> list = new ArrayList<NodeFormatterFactory>(formatterFactories);
        list.add(new CoreNodeFormatter.Factory());
        return DependencyResolver.resolveFlatDependencies(list, null, null);
    }

    public TranslationHandler getTranslationHandler(TranslationHandlerFactory translationHandlerFactory, HtmlIdGeneratorFactory idGeneratorFactory) {
        return translationHandlerFactory.create(this.options, idGeneratorFactory);
    }

    public TranslationHandler getTranslationHandler(HtmlIdGeneratorFactory idGeneratorFactory) {
        return new TranslationHandlerImpl(this.options, idGeneratorFactory);
    }

    public TranslationHandler getTranslationHandler() {
        return new TranslationHandlerImpl(this.options, this.idGeneratorFactory);
    }

    @Override
    @NotNull
    public DataHolder getOptions() {
        return this.options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataHolder options) {
        return new Builder(options);
    }

    @Override
    public void render(@NotNull Node node, @NotNull Appendable output) {
        this.render(node, output, MAX_TRAILING_BLANK_LINES.get(this.options));
    }

    public void render(@NotNull Node node, @NotNull Appendable output, int maxTrailingBlankLines) {
        MarkdownWriter markdown = new MarkdownWriter(output, FORMAT_FLAGS.get(this.options));
        MainNodeFormatter renderer = new MainNodeFormatter(this.options, markdown, node.getDocument(), null);
        renderer.render(node);
        markdown.appendToSilently(output, MAX_BLANK_LINES.get(this.options), maxTrailingBlankLines);
        BasedSequence sequence = node.getDocument().getChars();
        if (output instanceof SequenceBuilder && node.getDocument().getChars() != renderer.trackedSequence) {
            sequence = ((SequenceBuilder)output).toSequence(renderer.trackedSequence);
        }
        TrackedOffsetUtils.resolveTrackedOffsets(sequence, markdown, renderer.trackedOffsets.getUnresolvedOffsets(), maxTrailingBlankLines, SharedDataKeys.RUNNING_TESTS.get(this.options));
    }

    @Override
    @NotNull
    public String render(@NotNull Node document) {
        StringBuilder sb = new StringBuilder();
        this.render(document, sb);
        return sb.toString();
    }

    public void translationRender(Node document, Appendable output, TranslationHandler translationHandler, RenderPurpose renderPurpose) {
        this.translationRender(document, output, MAX_TRAILING_BLANK_LINES.get(this.options), translationHandler, renderPurpose);
    }

    public String translationRender(Node document, TranslationHandler translationHandler, RenderPurpose renderPurpose) {
        StringBuilder sb = new StringBuilder();
        this.translationRender(document, sb, translationHandler, renderPurpose);
        return sb.toString();
    }

    public void translationRender(Node document, Appendable output, int maxTrailingBlankLines, TranslationHandler translationHandler, RenderPurpose renderPurpose) {
        translationHandler.setRenderPurpose(renderPurpose);
        MainNodeFormatter renderer = new MainNodeFormatter(this.options, new MarkdownWriter(FORMAT_FLAGS.get(this.options) & ~LineAppendable.F_TRIM_LEADING_WHITESPACE), document.getDocument(), translationHandler);
        renderer.render(document);
        renderer.flushTo(output, MAX_BLANK_LINES.get(this.options), maxTrailingBlankLines);
    }

    public void mergeRender(Document[] documents, Appendable output) {
        this.mergeRender(documents, output, (int)MAX_TRAILING_BLANK_LINES.get(this.options));
    }

    public void mergeRender(List<Document> documents, Appendable output) {
        this.mergeRender(documents.toArray(EMPTY_DOCUMENTS), output);
    }

    public String mergeRender(Document[] documents, int maxTrailingBlankLines) {
        StringBuilder sb = new StringBuilder();
        this.mergeRender(documents, (Appendable)sb, maxTrailingBlankLines);
        return sb.toString();
    }

    public String mergeRender(List<Document> documents, int maxTrailingBlankLines) {
        return this.mergeRender(documents.toArray(EMPTY_DOCUMENTS), maxTrailingBlankLines);
    }

    public void mergeRender(List<Document> documents, Appendable output, int maxTrailingBlankLines) {
        this.mergeRender(documents.toArray(EMPTY_DOCUMENTS), output, maxTrailingBlankLines);
    }

    public void mergeRender(Document[] documents, Appendable output, int maxTrailingBlankLines) {
        MutableDataSet mergeOptions = new MutableDataSet(this.options);
        mergeOptions.set((DataKey)Parser.HTML_FOR_TRANSLATOR, (Object)true);
        TranslationHandler[] translationHandlers = new TranslationHandler[documents.length];
        List[] translationHandlersTexts = new List[documents.length];
        int iMax = documents.length;
        for (int i = 0; i < iMax; ++i) {
            translationHandlers[i] = this.getTranslationHandler(this.idGeneratorFactory == null ? new HeaderIdGenerator.Factory() : this.idGeneratorFactory);
        }
        MergeContextImpl mergeContext = new MergeContextImpl(documents, translationHandlers);
        int formatFlags = FORMAT_FLAGS.get(this.options);
        int maxBlankLines = MAX_BLANK_LINES.get(this.options);
        mergeContext.forEachPrecedingDocument(null, (context, document, index) -> {
            TranslationHandler translationHandler = (TranslationHandler)context;
            translationHandler.setRenderPurpose(RenderPurpose.TRANSLATION_SPANS);
            MainNodeFormatter renderer = new MainNodeFormatter(mergeOptions, new MarkdownWriter(formatFlags), document, translationHandler);
            renderer.render(document);
            translationHandlersTexts[index] = translationHandler.getTranslatingTexts();
        });
        Document[] translatedDocuments = new Document[documents.length];
        mergeContext.forEachPrecedingDocument(null, (context, document, index) -> {
            TranslationHandler translationHandler = (TranslationHandler)context;
            translationHandler.setRenderPurpose(RenderPurpose.TRANSLATED_SPANS);
            translationHandler.setTranslatedTexts(translationHandlersTexts[index]);
            MainNodeFormatter renderer = new MainNodeFormatter(mergeOptions, new MarkdownWriter(formatFlags), document, translationHandler);
            renderer.render(document);
            StringBuilder sb = new StringBuilder();
            renderer.flushTo(sb, maxBlankLines, maxTrailingBlankLines);
            translatedDocuments[index] = Parser.builder(mergeOptions).build().parse(sb.toString());
        });
        mergeContext.setDocuments(translatedDocuments);
        mergeContext.forEachPrecedingDocument(null, (context, document, index) -> {
            TranslationHandler translationHandler = (TranslationHandler)context;
            translationHandler.setRenderPurpose(RenderPurpose.TRANSLATED);
            MarkdownWriter markdownWriter = new MarkdownWriter(formatFlags);
            MainNodeFormatter renderer = new MainNodeFormatter(mergeOptions, markdownWriter, document, translationHandler);
            renderer.render(document);
            markdownWriter.blankLine();
            renderer.flushTo(output, maxBlankLines, maxTrailingBlankLines);
        });
    }

    private class MainNodeFormatter
    extends NodeFormatterSubContext {
        private final Document document;
        private final Map<Class<?>, List<NodeFormattingHandler<?>>> renderers;
        private final SubClassingBag<Node> collectedNodes;
        private final List<PhasedNodeFormatter> phasedFormatters;
        private final Set<FormattingPhase> renderingPhases;
        private final DataHolder options;
        @NotNull
        private final Boolean isFormatControlEnabled;
        private FormattingPhase phase;
        final TranslationHandler translationHandler;
        private final LinkResolver[] linkResolvers;
        private final HashMap<LinkType, HashMap<String, ResolvedLink>> resolvedLinkMap;
        private final ExplicitAttributeIdProvider explicitAttributeIdProvider;
        private final HtmlIdGenerator idGenerator;
        @Nullable
        private FormatControlProcessor controlProcessor;
        private final CharPredicate blockQuoteLikePredicate;
        private final BasedSequence blockQuoteLikeChars;
        final TrackedOffsetList trackedOffsets;
        final BasedSequence trackedSequence;
        final boolean restoreTrackedSpaces;
        final FormatterOptions formatterOptions;

        MainNodeFormatter(DataHolder options, MarkdownWriter out, Document document, TranslationHandler translationHandler) {
            super(out);
            this.resolvedLinkMap = new HashMap();
            this.translationHandler = translationHandler;
            this.options = new ScopedDataSet(document, options);
            this.formatterOptions = new FormatterOptions(this.options);
            this.document = document;
            this.renderers = new HashMap(32);
            this.renderingPhases = new HashSet<FormattingPhase>(FormattingPhase.values().length);
            HashSet collectNodeTypes = new HashSet(100);
            Boolean defaultLinkResolver = DEFAULT_LINK_RESOLVER.get(this.options);
            this.linkResolvers = new LinkResolver[Formatter.this.linkResolverFactories.size() + (defaultLinkResolver != false ? 1 : 0)];
            this.isFormatControlEnabled = FORMATTER_TAGS_ENABLED.get(this.options);
            for (int i = 0; i < Formatter.this.linkResolverFactories.size(); ++i) {
                this.linkResolvers[i] = Formatter.this.linkResolverFactories.get(i).apply(this);
            }
            if (defaultLinkResolver.booleanValue()) {
                this.linkResolvers[Formatter.this.linkResolverFactories.size()] = new MergeLinkResolver.Factory().apply(this);
            }
            out.setContext(this);
            List<NodeFormatterFactory> formatterFactories = Formatter.this.nodeFormatterFactories;
            this.phasedFormatters = new ArrayList<PhasedNodeFormatter>(formatterFactories.size());
            ExplicitAttributeIdProvider explicitAttributeIdProvider = null;
            StringBuilder blockLikePrefixChars = new StringBuilder();
            for (int i = formatterFactories.size() - 1; i >= 0; --i) {
                Set<NodeFormattingHandler<?>> formattingHandlers;
                char blockLikePrefixChar;
                NodeFormatterFactory nodeFormatterFactory = formatterFactories.get(i);
                NodeFormatter nodeFormatter = nodeFormatterFactory.create(this.options);
                if (nodeFormatter instanceof ExplicitAttributeIdProvider) {
                    explicitAttributeIdProvider = (ExplicitAttributeIdProvider)((Object)nodeFormatter);
                }
                if ((blockLikePrefixChar = nodeFormatter.getBlockQuoteLikePrefixChar()) != '\u0000') {
                    blockLikePrefixChars.append(blockLikePrefixChar);
                }
                if ((formattingHandlers = nodeFormatter.getNodeFormattingHandlers()) == null) continue;
                for (NodeFormattingHandler<?> formattingHandler : formattingHandlers) {
                    List rendererList = this.renderers.computeIfAbsent(formattingHandler.getNodeType(), key -> new ArrayList());
                    rendererList.add(0, formattingHandler);
                }
                Set<Class<?>> nodeClasses = nodeFormatter.getNodeClasses();
                if (nodeClasses != null) {
                    collectNodeTypes.addAll(nodeClasses);
                }
                if (!(nodeFormatter instanceof PhasedNodeFormatter)) continue;
                Set<FormattingPhase> phases = ((PhasedNodeFormatter)nodeFormatter).getFormattingPhases();
                if (phases != null) {
                    if (phases.isEmpty()) {
                        throw new IllegalStateException("PhasedNodeFormatter with empty Phases");
                    }
                    this.renderingPhases.addAll(phases);
                    this.phasedFormatters.add((PhasedNodeFormatter)nodeFormatter);
                    continue;
                }
                throw new IllegalStateException("PhasedNodeFormatter with null Phases");
            }
            this.restoreTrackedSpaces = RESTORE_TRACKED_SPACES.get(this.options);
            BasedSequence sequence = TRACKED_SEQUENCE.get(this.options);
            List<TrackedOffset> offsets = TRACKED_OFFSETS.get(this.options);
            this.trackedSequence = sequence.isEmpty() ? document.getChars() : sequence;
            TrackedOffsetList trackedOffsetList = this.trackedOffsets = offsets.isEmpty() ? TrackedOffsetList.EMPTY_LIST : TrackedOffsetList.create(this.trackedSequence, offsets);
            assert (this.trackedSequence.equals(document.getChars())) : String.format("TRACKED_SEQUENCE must be character identical to document.getChars()\nTRACKED_SEQUENCE: '%s'\n altSeq: '%s'\n", this.trackedSequence.toVisibleWhitespaceString(), document.getChars().toVisibleWhitespaceString());
            String charSequence = blockLikePrefixChars.toString();
            this.blockQuoteLikeChars = BasedSequence.of(charSequence);
            this.blockQuoteLikePredicate = CharPredicate.anyOf(charSequence);
            HtmlIdGenerator htmlIdGenerator = GENERATE_HEADER_ID.get(this.options).booleanValue() ? (Formatter.this.idGeneratorFactory != null ? Formatter.this.idGeneratorFactory.create(this) : new HeaderIdGenerator.Factory().create(this)) : (this.idGenerator = null);
            if (this.idGenerator != null) {
                this.idGenerator.generateIds(document);
            }
            this.explicitAttributeIdProvider = explicitAttributeIdProvider;
            if (!collectNodeTypes.isEmpty()) {
                NodeCollectingVisitor collectingVisitor = new NodeCollectingVisitor(collectNodeTypes);
                collectingVisitor.collect(document);
                this.collectedNodes = collectingVisitor.getSubClassingBag();
            } else {
                this.collectedNodes = null;
            }
        }

        @Override
        @NotNull
        public String encodeUrl(@NotNull CharSequence url) {
            return String.valueOf(url);
        }

        @Override
        @NotNull
        public ResolvedLink resolveLink(@NotNull LinkType linkType, @NotNull CharSequence url, Boolean urlEncode) {
            return this.resolveLink(this, linkType, url, null);
        }

        @Override
        @NotNull
        public ResolvedLink resolveLink(@NotNull LinkType linkType, @NotNull CharSequence url, Attributes attributes, Boolean urlEncode) {
            return this.resolveLink(this, linkType, url, attributes);
        }

        ResolvedLink resolveLink(NodeFormatterSubContext context, LinkType linkType, CharSequence url, Attributes attributes) {
            String urlSeq;
            HashMap resolvedLinks = this.resolvedLinkMap.computeIfAbsent(linkType, k -> new HashMap());
            ResolvedLink resolvedLink = (ResolvedLink)resolvedLinks.get(urlSeq = String.valueOf(url));
            if (resolvedLink == null) {
                resolvedLink = new ResolvedLink(linkType, urlSeq, attributes);
                if (!urlSeq.isEmpty()) {
                    LinkResolver linkResolver;
                    Node currentNode = context.renderingNode;
                    LinkResolver[] linkResolverArray = this.linkResolvers;
                    int n = linkResolverArray.length;
                    for (int i = 0; i < n && (resolvedLink = (linkResolver = linkResolverArray[i]).resolveLink(currentNode, this, resolvedLink)).getStatus() == LinkStatus.UNKNOWN; ++i) {
                    }
                }
                resolvedLinks.put(urlSeq, resolvedLink);
            }
            return resolvedLink;
        }

        @Override
        public void addExplicitId(@NotNull Node node, @Nullable String id, @NotNull NodeFormatterContext context, @NotNull MarkdownWriter markdown) {
            if (id != null && this.explicitAttributeIdProvider != null) {
                this.explicitAttributeIdProvider.addExplicitId(node, id, context, markdown);
            }
        }

        @Override
        @NotNull
        public RenderPurpose getRenderPurpose() {
            return this.translationHandler == null ? RenderPurpose.FORMAT : this.translationHandler.getRenderPurpose();
        }

        @Override
        public boolean isTransformingText() {
            return this.translationHandler != null && this.translationHandler.isTransformingText();
        }

        @Override
        @NotNull
        public CharSequence transformNonTranslating(CharSequence prefix, @NotNull CharSequence nonTranslatingText, CharSequence suffix, CharSequence suffix2) {
            return this.translationHandler == null ? nonTranslatingText : this.translationHandler.transformNonTranslating(prefix, nonTranslatingText, suffix, suffix2);
        }

        @Override
        @NotNull
        public CharSequence transformTranslating(CharSequence prefix, @NotNull CharSequence translatingText, CharSequence suffix, CharSequence suffix2) {
            return this.translationHandler == null ? translatingText : this.translationHandler.transformTranslating(prefix, translatingText, suffix, suffix2);
        }

        @Override
        @NotNull
        public CharSequence transformAnchorRef(@NotNull CharSequence pageRef, @NotNull CharSequence anchorRef) {
            return this.translationHandler == null ? anchorRef : this.translationHandler.transformAnchorRef(pageRef, anchorRef);
        }

        @Override
        public void postProcessNonTranslating(@NotNull Function<String, CharSequence> postProcessor, @NotNull Runnable scope) {
            if (this.translationHandler != null) {
                this.translationHandler.postProcessNonTranslating(postProcessor, scope);
            } else {
                scope.run();
            }
        }

        @Override
        @NotNull
        public <T> T postProcessNonTranslating(@NotNull Function<String, CharSequence> postProcessor, @NotNull Supplier<T> scope) {
            if (this.translationHandler != null) {
                return this.translationHandler.postProcessNonTranslating(postProcessor, scope);
            }
            return scope.get();
        }

        @Override
        public boolean isPostProcessingNonTranslating() {
            return this.translationHandler != null && this.translationHandler.isPostProcessingNonTranslating();
        }

        @Override
        public MergeContext getMergeContext() {
            return this.translationHandler == null ? null : this.translationHandler.getMergeContext();
        }

        @Override
        public HtmlIdGenerator getIdGenerator() {
            return this.translationHandler == null ? this.idGenerator : this.translationHandler.getIdGenerator();
        }

        @Override
        public void translatingSpan(@NotNull TranslatingSpanRender render) {
            if (this.translationHandler != null) {
                this.translationHandler.translatingSpan(render);
            } else {
                render.render(this, this.markdown);
            }
        }

        @Override
        public void nonTranslatingSpan(@NotNull TranslatingSpanRender render) {
            if (this.translationHandler != null) {
                this.translationHandler.nonTranslatingSpan(render);
            } else {
                render.render(this, this.markdown);
            }
        }

        @Override
        public void translatingRefTargetSpan(@Nullable Node target, @NotNull TranslatingSpanRender render) {
            if (this.translationHandler != null) {
                this.translationHandler.translatingRefTargetSpan(target, render);
            } else {
                render.render(this, this.markdown);
            }
        }

        @Override
        @NotNull
        public MutableDataHolder getTranslationStore() {
            if (this.translationHandler != null) {
                return this.translationHandler.getTranslationStore();
            }
            return this.document;
        }

        @Override
        public void customPlaceholderFormat(@NotNull TranslationPlaceholderGenerator generator, @NotNull TranslatingSpanRender render) {
            if (this.translationHandler != null) {
                this.translationHandler.customPlaceholderFormat(generator, render);
            } else {
                render.render(this, this.markdown);
            }
        }

        @Override
        @NotNull
        public Node getCurrentNode() {
            return this.renderingNode;
        }

        @Override
        @NotNull
        public DataHolder getOptions() {
            return this.options;
        }

        @Override
        @NotNull
        public FormatterOptions getFormatterOptions() {
            return this.formatterOptions;
        }

        @Override
        @NotNull
        public Document getDocument() {
            return this.document;
        }

        @Override
        @NotNull
        public CharPredicate getBlockQuoteLikePrefixPredicate() {
            return this.blockQuoteLikePredicate;
        }

        @Override
        @NotNull
        public BasedSequence getBlockQuoteLikePrefixChars() {
            return this.blockQuoteLikeChars;
        }

        @Override
        @NotNull
        public TrackedOffsetList getTrackedOffsets() {
            return this.trackedOffsets;
        }

        @Override
        public boolean isRestoreTrackedSpaces() {
            return this.restoreTrackedSpaces;
        }

        @Override
        @NotNull
        public BasedSequence getTrackedSequence() {
            return this.trackedSequence;
        }

        @Override
        @NotNull
        public FormattingPhase getFormattingPhase() {
            return this.phase;
        }

        @Override
        public void render(@NotNull Node node) {
            this.renderNode(node, this);
        }

        @Override
        @NotNull
        public final Iterable<? extends Node> nodesOfType(@NotNull Class<?>[] classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.itemsOfType(Node.class, classes);
        }

        @Override
        @NotNull
        public final Iterable<? extends Node> nodesOfType(@NotNull Collection<Class<?>> classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.itemsOfType(Node.class, classes);
        }

        @Override
        @NotNull
        public final Iterable<? extends Node> reversedNodesOfType(@NotNull Class<?>[] classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.reversedItemsOfType(Node.class, classes);
        }

        @Override
        @NotNull
        public final Iterable<? extends Node> reversedNodesOfType(@NotNull Collection<Class<?>> classes) {
            return this.collectedNodes == null ? NULL_ITERABLE : this.collectedNodes.reversedItemsOfType(Node.class, classes);
        }

        @Override
        public NodeFormatterContext getSubContext() {
            return this.getSubContextRaw(null, this.markdown.getBuilder());
        }

        @Override
        public NodeFormatterContext getSubContext(DataHolder options) {
            return this.getSubContextRaw(options, this.markdown.getBuilder());
        }

        @Override
        public NodeFormatterContext getSubContext(DataHolder options, @NotNull ISequenceBuilder<?, ?> builder) {
            return this.getSubContextRaw(options, builder);
        }

        NodeFormatterContext getSubContextRaw(@Nullable DataHolder options, @NotNull ISequenceBuilder<?, ?> builder) {
            MarkdownWriter writer = new MarkdownWriter(builder, this.getMarkdown().getOptions());
            writer.setContext(this);
            return new SubNodeFormatter(this, writer, options);
        }

        void renderNode(Node node, NodeFormatterSubContext subContext) {
            if (node instanceof Document) {
                if (this.translationHandler != null) {
                    this.translationHandler.beginRendering((Document)node, subContext, subContext.markdown);
                }
                for (FormattingPhase phase : FormattingPhase.values()) {
                    if (phase != FormattingPhase.DOCUMENT && !this.renderingPhases.contains((Object)phase)) continue;
                    this.phase = phase;
                    if (this.phase == FormattingPhase.DOCUMENT) {
                        ((MarkdownWriter)((MarkdownWriter)subContext.markdown.pushPrefix()).setPrefix(DOCUMENT_FIRST_PREFIX.get((Document)node), false)).setPrefix(DOCUMENT_PREFIX.get((Document)node), true);
                        List<NodeFormattingHandler<?>> nodeRendererList = this.renderers.get(node.getClass());
                        if (nodeRendererList != null) {
                            subContext.rendererList = nodeRendererList;
                            subContext.rendererIndex = 0;
                            subContext.renderingNode = node;
                            nodeRendererList.get(0).render(node, subContext, subContext.markdown);
                            subContext.renderingNode = null;
                            subContext.rendererList = null;
                            subContext.rendererIndex = -1;
                        }
                        subContext.markdown.popPrefix();
                        continue;
                    }
                    for (PhasedNodeFormatter phasedFormatter : this.phasedFormatters) {
                        if (!phasedFormatter.getFormattingPhases().contains((Object)phase)) continue;
                        subContext.renderingNode = node;
                        phasedFormatter.renderDocument(subContext, subContext.markdown, (Document)node, phase);
                        subContext.renderingNode = null;
                    }
                }
            } else {
                if (this.isFormatControlEnabled.booleanValue()) {
                    if (this.controlProcessor == null) {
                        this.controlProcessor = new FormatControlProcessor(this.document, this.options);
                        this.controlProcessor.initializeFrom(node);
                    } else {
                        this.controlProcessor.processFormatControl(node);
                    }
                }
                if (this.isFormatControlEnabled.booleanValue() && this.controlProcessor.isFormattingOff()) {
                    if (node instanceof BlankLine) {
                        subContext.markdown.blankLine();
                    } else {
                        subContext.markdown.append(node.getChars());
                    }
                } else {
                    List<NodeFormattingHandler<?>> nodeRendererList = this.renderers.get(node.getClass());
                    if (nodeRendererList == null) {
                        nodeRendererList = this.renderers.get(Node.class);
                    }
                    if (nodeRendererList != null) {
                        List<NodeFormattingHandler<?>> oldRendererList = subContext.rendererList;
                        int oldRendererIndex = subContext.rendererIndex;
                        Node oldRenderingNode = subContext.renderingNode;
                        subContext.rendererList = nodeRendererList;
                        subContext.rendererIndex = 0;
                        subContext.renderingNode = node;
                        nodeRendererList.get(0).render(node, subContext, subContext.markdown);
                        subContext.renderingNode = oldRenderingNode;
                        subContext.rendererList = oldRendererList;
                        subContext.rendererIndex = oldRendererIndex;
                    } else {
                        throw new IllegalStateException("Core Node Formatter should implement generic Node renderer");
                    }
                }
            }
        }

        @Override
        public void renderChildren(@NotNull Node parent) {
            this.renderChildrenNode(parent, this);
        }

        @Override
        public void delegateRender() {
            this.delegateRender(this);
        }

        protected void delegateRender(NodeFormatterSubContext subContext) {
            if (subContext.getFormattingPhase() != FormattingPhase.DOCUMENT) {
                throw new IllegalStateException("Delegate rendering only supported in document rendering phase");
            }
            if (subContext.rendererList == null || subContext.renderingNode == null) {
                throw new IllegalStateException("Delegate rendering can only be called from node render handler");
            }
            Node node = subContext.renderingNode;
            int oldRendererIndex = subContext.rendererIndex;
            int rendererIndex = oldRendererIndex + 1;
            List<NodeFormattingHandler<?>> oldRendererList = subContext.rendererList;
            List<NodeFormattingHandler<?>> rendererList = oldRendererList;
            if (rendererIndex >= rendererList.size()) {
                if (node instanceof Document) {
                    return;
                }
                List<NodeFormattingHandler<?>> nodeRendererList = this.renderers.get(Node.class);
                if (nodeRendererList == null) {
                    throw new IllegalStateException("Core Node Formatter should implement generic Node renderer");
                }
                if (oldRendererList == nodeRendererList) {
                    throw new IllegalStateException("Core Node Formatter should not delegate generic Node renderer");
                }
                rendererList = nodeRendererList;
                rendererIndex = 0;
            }
            subContext.rendererList = rendererList;
            subContext.rendererIndex = rendererIndex;
            rendererList.get(rendererIndex).render(node, subContext, subContext.markdown);
            subContext.rendererIndex = oldRendererIndex;
            subContext.rendererList = oldRendererList;
        }

        protected void renderChildrenNode(Node parent, NodeFormatterSubContext subContext) {
            Node node = parent.getFirstChild();
            while (node != null) {
                Node next = node.getNext();
                this.renderNode(node, subContext);
                node = next;
            }
        }

        private class SubNodeFormatter
        extends NodeFormatterSubContext
        implements NodeFormatterContext {
            private final MainNodeFormatter myMainNodeRenderer;
            private final DataHolder myOptions;
            private final FormatterOptions myFormatterOptions;

            public SubNodeFormatter(MainNodeFormatter mainNodeRenderer, @Nullable MarkdownWriter out, DataHolder options) {
                super(out);
                this.myMainNodeRenderer = mainNodeRenderer;
                this.myOptions = options == null || options == this.myMainNodeRenderer.getOptions() ? this.myMainNodeRenderer.getOptions() : new ScopedDataSet(this.myMainNodeRenderer.getOptions(), options);
                this.myFormatterOptions = new FormatterOptions(this.myOptions);
            }

            @Override
            @NotNull
            public MutableDataHolder getTranslationStore() {
                return this.myMainNodeRenderer.getTranslationStore();
            }

            @Override
            @NotNull
            public final Iterable<? extends Node> nodesOfType(@NotNull Class<?>[] classes) {
                return this.myMainNodeRenderer.nodesOfType(classes);
            }

            @Override
            @NotNull
            public final Iterable<? extends Node> nodesOfType(@NotNull Collection<Class<?>> classes) {
                return this.myMainNodeRenderer.nodesOfType(classes);
            }

            @Override
            @NotNull
            public final Iterable<? extends Node> reversedNodesOfType(@NotNull Class<?>[] classes) {
                return this.myMainNodeRenderer.reversedNodesOfType(classes);
            }

            @Override
            @NotNull
            public final Iterable<? extends Node> reversedNodesOfType(@NotNull Collection<Class<?>> classes) {
                return this.myMainNodeRenderer.reversedNodesOfType(classes);
            }

            @Override
            @NotNull
            public DataHolder getOptions() {
                return this.myOptions;
            }

            @Override
            @NotNull
            public FormatterOptions getFormatterOptions() {
                return this.myFormatterOptions;
            }

            @Override
            @NotNull
            public Document getDocument() {
                return this.myMainNodeRenderer.getDocument();
            }

            @Override
            @NotNull
            public CharPredicate getBlockQuoteLikePrefixPredicate() {
                return this.myMainNodeRenderer.getBlockQuoteLikePrefixPredicate();
            }

            @Override
            @NotNull
            public BasedSequence getBlockQuoteLikePrefixChars() {
                return this.myMainNodeRenderer.getBlockQuoteLikePrefixChars();
            }

            @Override
            @NotNull
            public TrackedOffsetList getTrackedOffsets() {
                return TrackedOffsetList.EMPTY_LIST;
            }

            @Override
            public boolean isRestoreTrackedSpaces() {
                return false;
            }

            @Override
            @NotNull
            public BasedSequence getTrackedSequence() {
                return this.myMainNodeRenderer.getTrackedSequence();
            }

            @Override
            @NotNull
            public FormattingPhase getFormattingPhase() {
                return this.myMainNodeRenderer.getFormattingPhase();
            }

            @Override
            public void render(@NotNull Node node) {
                this.myMainNodeRenderer.renderNode(node, this);
            }

            @Override
            @NotNull
            public Node getCurrentNode() {
                return this.renderingNode;
            }

            @Override
            public void delegateRender() {
                this.myMainNodeRenderer.delegateRender(this);
            }

            @Override
            public NodeFormatterContext getSubContext() {
                return this.getSubContext((DataHolder)null, (ISequenceBuilder)this.markdown.getBuilder());
            }

            @Override
            public NodeFormatterContext getSubContext(DataHolder options) {
                return this.getSubContext(options, (ISequenceBuilder)this.markdown.getBuilder());
            }

            @Override
            public NodeFormatterContext getSubContext(DataHolder options, @NotNull ISequenceBuilder<?, ?> builder) {
                MarkdownWriter htmlWriter = new MarkdownWriter(builder, this.markdown.getOptions());
                htmlWriter.setContext(this);
                return new SubNodeFormatter(this.myMainNodeRenderer, htmlWriter, options == null || options == this.myOptions ? this.myOptions : new ScopedDataSet(this.myOptions, options));
            }

            @Override
            public void renderChildren(@NotNull Node parent) {
                this.myMainNodeRenderer.renderChildrenNode(parent, this);
            }

            @Override
            @NotNull
            public MarkdownWriter getMarkdown() {
                return this.markdown;
            }

            @Override
            @NotNull
            public RenderPurpose getRenderPurpose() {
                return this.myMainNodeRenderer.getRenderPurpose();
            }

            @Override
            public boolean isTransformingText() {
                return this.myMainNodeRenderer.isTransformingText();
            }

            @Override
            @NotNull
            public CharSequence transformNonTranslating(CharSequence prefix, @NotNull CharSequence nonTranslatingText, CharSequence suffix, CharSequence suffix2) {
                return this.myMainNodeRenderer.transformNonTranslating(prefix, nonTranslatingText, suffix, suffix2);
            }

            @Override
            @NotNull
            public CharSequence transformTranslating(CharSequence prefix, @NotNull CharSequence translatingText, CharSequence suffix, CharSequence suffix2) {
                return this.myMainNodeRenderer.transformTranslating(prefix, translatingText, suffix, suffix2);
            }

            @Override
            @NotNull
            public CharSequence transformAnchorRef(@NotNull CharSequence pageRef, @NotNull CharSequence anchorRef) {
                return this.myMainNodeRenderer.transformAnchorRef(pageRef, anchorRef);
            }

            @Override
            public void translatingSpan(@NotNull TranslatingSpanRender render) {
                this.myMainNodeRenderer.translatingSpan(render);
            }

            @Override
            public void nonTranslatingSpan(@NotNull TranslatingSpanRender render) {
                this.myMainNodeRenderer.nonTranslatingSpan(render);
            }

            @Override
            public void translatingRefTargetSpan(@Nullable Node target, @NotNull TranslatingSpanRender render) {
                this.myMainNodeRenderer.translatingRefTargetSpan(target, render);
            }

            @Override
            public void customPlaceholderFormat(@NotNull TranslationPlaceholderGenerator generator, @NotNull TranslatingSpanRender render) {
                this.myMainNodeRenderer.customPlaceholderFormat(generator, render);
            }

            @Override
            @NotNull
            public String encodeUrl(@NotNull CharSequence url) {
                return this.myMainNodeRenderer.encodeUrl(url);
            }

            @Override
            @NotNull
            public ResolvedLink resolveLink(@NotNull LinkType linkType, @NotNull CharSequence url, Boolean urlEncode) {
                return this.myMainNodeRenderer.resolveLink(this, linkType, url, null);
            }

            @Override
            @NotNull
            public ResolvedLink resolveLink(@NotNull LinkType linkType, @NotNull CharSequence url, Attributes attributes, Boolean urlEncode) {
                return this.myMainNodeRenderer.resolveLink(this, linkType, url, attributes);
            }

            @Override
            public void postProcessNonTranslating(@NotNull Function<String, CharSequence> postProcessor, @NotNull Runnable scope) {
                this.myMainNodeRenderer.postProcessNonTranslating(postProcessor, scope);
            }

            @Override
            @NotNull
            public <T> T postProcessNonTranslating(@NotNull Function<String, CharSequence> postProcessor, @NotNull Supplier<T> scope) {
                return this.myMainNodeRenderer.postProcessNonTranslating(postProcessor, scope);
            }

            @Override
            public boolean isPostProcessingNonTranslating() {
                return this.myMainNodeRenderer.isPostProcessingNonTranslating();
            }

            @Override
            public MergeContext getMergeContext() {
                return this.myMainNodeRenderer.getMergeContext();
            }

            @Override
            public void addExplicitId(@NotNull Node node, @Nullable String id, @NotNull NodeFormatterContext context, @NotNull MarkdownWriter markdown) {
                this.myMainNodeRenderer.addExplicitId(node, id, context, markdown);
            }

            @Override
            public HtmlIdGenerator getIdGenerator() {
                return this.myMainNodeRenderer.getIdGenerator();
            }
        }
    }

    public static interface FormatterExtension
    extends Extension {
        public void rendererOptions(MutableDataHolder var1);

        public void extend(Builder var1);
    }

    public static class Builder
    extends BuilderBase<Builder> {
        List<AttributeProviderFactory> attributeProviderFactories = new ArrayList<AttributeProviderFactory>();
        List<NodeFormatterFactory> nodeFormatterFactories = new ArrayList<NodeFormatterFactory>();
        List<LinkResolverFactory> linkResolverFactories = new ArrayList<LinkResolverFactory>();
        HeaderIdGeneratorFactory htmlIdGeneratorFactory = null;

        public Builder() {
        }

        public Builder(DataHolder options) {
            super(options);
            this.loadExtensions();
        }

        @Override
        @NotNull
        public Formatter build() {
            return new Formatter(this);
        }

        @Override
        protected void removeApiPoint(@NotNull Object apiPoint) {
            if (apiPoint instanceof AttributeProviderFactory) {
                this.attributeProviderFactories.remove(apiPoint);
            } else if (apiPoint instanceof NodeFormatterFactory) {
                this.nodeFormatterFactories.remove(apiPoint);
            } else if (apiPoint instanceof LinkResolverFactory) {
                this.linkResolverFactories.remove(apiPoint);
            } else if (apiPoint instanceof HeaderIdGeneratorFactory) {
                this.htmlIdGeneratorFactory = null;
            } else {
                throw new IllegalStateException("Unknown data point type: " + apiPoint.getClass().getName());
            }
        }

        @Override
        protected void preloadExtension(@NotNull Extension extension) {
            if (extension instanceof FormatterExtension) {
                FormatterExtension formatterExtension = (FormatterExtension)extension;
                formatterExtension.rendererOptions(this);
            }
        }

        @Override
        protected boolean loadExtension(@NotNull Extension extension) {
            if (extension instanceof FormatterExtension) {
                FormatterExtension formatterExtension = (FormatterExtension)extension;
                formatterExtension.extend(this);
                return true;
            }
            return false;
        }

        public Builder nodeFormatterFactory(NodeFormatterFactory nodeFormatterFactory) {
            this.nodeFormatterFactories.add(nodeFormatterFactory);
            return this;
        }

        @NotNull
        public Builder htmlIdGeneratorFactory(@NotNull HeaderIdGeneratorFactory htmlIdGeneratorFactory) {
            if (this.htmlIdGeneratorFactory != null) {
                throw new IllegalStateException("custom header id factory is already set to " + htmlIdGeneratorFactory.getClass().getName());
            }
            this.htmlIdGeneratorFactory = htmlIdGeneratorFactory;
            this.addExtensionApiPoint(htmlIdGeneratorFactory);
            return this;
        }
    }
}

