/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.wikilink.internal;

import com.vladsch.flexmark.ext.wikilink.WikiImage;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.ext.wikilink.internal.WikiLinkOptions;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WikiLinkLinkResolver
implements LinkResolver {
    private final WikiLinkOptions options;

    public WikiLinkLinkResolver(LinkResolverContext context) {
        this.options = new WikiLinkOptions(context.getOptions());
    }

    @Override
    @NotNull
    public ResolvedLink resolveLink(@NotNull Node node, @NotNull LinkResolverContext context, @NotNull ResolvedLink link) {
        block8: {
            int i;
            if (link.getLinkType() != WikiLinkExtension.WIKI_LINK) break block8;
            StringBuilder sb = new StringBuilder();
            boolean isWikiImage = node instanceof WikiImage;
            String wikiLink = link.getUrl();
            int iMax = wikiLink.length();
            boolean absolute = iMax > 0 && wikiLink.charAt(0) == '/';
            sb.append(isWikiImage ? this.options.getImagePrefix(absolute) : this.options.getLinkPrefix(absolute));
            boolean hadAnchorRef = false;
            String linkEscapeChars = this.options.linkEscapeChars;
            String linkReplaceChars = this.options.linkReplaceChars;
            int n = i = absolute ? 1 : 0;
            while (i < iMax) {
                block10: {
                    int pos;
                    char c;
                    block9: {
                        c = wikiLink.charAt(i);
                        if (c != '#') break block9;
                        if (hadAnchorRef) break block10;
                        sb.append(isWikiImage ? this.options.imageFileExtension : this.options.linkFileExtension);
                        hadAnchorRef = true;
                    }
                    if ((pos = linkEscapeChars.indexOf(c)) < 0) {
                        sb.append(c);
                    } else {
                        sb.append(linkReplaceChars.charAt(pos));
                    }
                }
                ++i;
            }
            if (!hadAnchorRef) {
                sb.append(isWikiImage ? this.options.imageFileExtension : this.options.linkFileExtension);
            }
            if (isWikiImage) {
                return new ResolvedLink(LinkType.IMAGE, sb.toString(), null, LinkStatus.UNCHECKED);
            }
            return new ResolvedLink(LinkType.LINK, sb.toString(), null, LinkStatus.UNCHECKED);
        }
        return link;
    }

    public static class Factory
    implements LinkResolverFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @NotNull
        public LinkResolver apply(@NotNull LinkResolverContext context) {
            return new WikiLinkLinkResolver(context);
        }
    }
}

