/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables;

import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.ast.Visitor;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.format.MarkdownTable;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.List;

public class TableExtractingVisitor {
    private final TableFormatOptions options;
    private NodeVisitor myVisitor = new NodeVisitor((VisitHandler<?>[])new VisitHandler[]{new VisitHandler<TableBlock>(TableBlock.class, new Visitor<TableBlock>(){

        @Override
        public void visit(TableBlock node) {
            TableExtractingVisitor.this.visit(node);
        }
    }), new VisitHandler<TableHead>(TableHead.class, new Visitor<TableHead>(){

        @Override
        public void visit(TableHead node) {
            TableExtractingVisitor.this.visit(node);
        }
    }), new VisitHandler<TableSeparator>(TableSeparator.class, new Visitor<TableSeparator>(){

        @Override
        public void visit(TableSeparator node) {
            TableExtractingVisitor.this.visit(node);
        }
    }), new VisitHandler<TableBody>(TableBody.class, new Visitor<TableBody>(){

        @Override
        public void visit(TableBody node) {
            TableExtractingVisitor.this.visit(node);
        }
    }), new VisitHandler<TableRow>(TableRow.class, new Visitor<TableRow>(){

        @Override
        public void visit(TableRow node) {
            TableExtractingVisitor.this.visit(node);
        }
    }), new VisitHandler<TableCell>(TableCell.class, new Visitor<TableCell>(){

        @Override
        public void visit(TableCell node) {
            TableExtractingVisitor.this.visit(node);
        }
    }), new VisitHandler<TableCaption>(TableCaption.class, new Visitor<TableCaption>(){

        @Override
        public void visit(TableCaption node) {
            TableExtractingVisitor.this.visit(node);
        }
    })});
    private MarkdownTable myTable;
    private final List<MarkdownTable> myTables;

    public TableExtractingVisitor(DataHolder options) {
        this.options = new TableFormatOptions(options);
        this.myTables = new ArrayList<MarkdownTable>();
    }

    public MarkdownTable[] getTables(Node node) {
        this.myTable = null;
        this.myVisitor.visit(node);
        return this.myTables.toArray(new MarkdownTable[0]);
    }

    private void visit(TableBlock node) {
        this.myTable = new MarkdownTable(this.options);
        this.myVisitor.visitChildren(node);
        this.myTables.add(this.myTable);
        this.myTable = null;
    }

    private void visit(TableHead node) {
        this.myTable.setSeparator(false);
        this.myTable.setHeader(true);
        this.myVisitor.visitChildren(node);
    }

    private void visit(TableSeparator node) {
        this.myTable.setSeparator(true);
        this.myVisitor.visitChildren(node);
    }

    private void visit(TableBody node) {
        this.myTable.setSeparator(false);
        this.myTable.setHeader(false);
        this.myVisitor.visitChildren(node);
    }

    private void visit(TableRow node) {
        this.myVisitor.visitChildren(node);
        if (!this.myTable.isSeparator()) {
            this.myTable.nextRow();
        }
    }

    private void visit(TableCaption node) {
        this.myTable.setCaptionWithMarkers(node, node.getOpeningMarker(), node.getText(), node.getClosingMarker());
    }

    private void visit(TableCell node) {
        BasedSequence text = node.getText();
        if (this.options.trimCellWhitespace) {
            text = text.isBlank() && !text.isEmpty() ? (BasedSequence)text.subSequence(0, 1) : (BasedSequence)text.trim();
        }
        this.myTable.addCell(new com.vladsch.flexmark.util.format.TableCell(node, node.getOpeningMarker(), text, node.getClosingMarker(), 1, node.getSpan(), node.getAlignment() == null ? CellAlignment.NONE : node.getAlignment().cellAlignment()));
    }
}

