/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes;

import com.vladsch.flexmark.ext.attributes.FencedCodeAddType;
import com.vladsch.flexmark.ext.attributes.internal.AttributesAttributeProvider;
import com.vladsch.flexmark.ext.attributes.internal.AttributesInlineParserExtension;
import com.vladsch.flexmark.ext.attributes.internal.AttributesNodeFormatter;
import com.vladsch.flexmark.ext.attributes.internal.AttributesNodePostProcessor;
import com.vladsch.flexmark.ext.attributes.internal.AttributesNodeRenderer;
import com.vladsch.flexmark.ext.attributes.internal.NodeAttributeRepository;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.RendererBuilder;
import com.vladsch.flexmark.html.RendererExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataValueFactory;
import com.vladsch.flexmark.util.data.MutableDataHolder;

public class AttributesExtension
implements Parser.ParserExtension,
RendererExtension,
HtmlRenderer.HtmlRendererExtension,
Formatter.FormatterExtension {
    public static final DataKey<NodeAttributeRepository> NODE_ATTRIBUTES = new DataKey<DataValueFactory>("NODE_ATTRIBUTES", NodeAttributeRepository::new);
    public static final DataKey<KeepType> ATTRIBUTES_KEEP = new DataKey<KeepType>("ATTRIBUTES_KEEP", KeepType.FIRST);
    public static final DataKey<Boolean> ASSIGN_TEXT_ATTRIBUTES = new DataKey<Boolean>("ASSIGN_TEXT_ATTRIBUTES", true);
    public static final DataKey<Boolean> FENCED_CODE_INFO_ATTRIBUTES = new DataKey<Boolean>("FENCED_CODE_INFO_ATTRIBUTES", false);
    public static final DataKey<FencedCodeAddType> FENCED_CODE_ADD_ATTRIBUTES = new DataKey<FencedCodeAddType>("FENCED_CODE_ADD_ATTRIBUTES", FencedCodeAddType.ADD_TO_PRE_CODE);
    public static final DataKey<Boolean> WRAP_NON_ATTRIBUTE_TEXT = new DataKey<Boolean>("WRAP_NON_ATTRIBUTE_TEXT", true);
    public static final DataKey<Boolean> USE_EMPTY_IMPLICIT_AS_SPAN_DELIMITER = new DataKey<Boolean>("USE_EMPTY_IMPLICIT_AS_SPAN_DELIMITER", false);

    private AttributesExtension() {
    }

    public static AttributesExtension create() {
        return new AttributesExtension();
    }

    @Override
    public void parserOptions(MutableDataHolder options) {
        if (options.contains(FENCED_CODE_INFO_ATTRIBUTES) && options.get(FENCED_CODE_INFO_ATTRIBUTES).booleanValue() && !options.contains(FENCED_CODE_ADD_ATTRIBUTES)) {
            options.set(FENCED_CODE_ADD_ATTRIBUTES, FencedCodeAddType.ADD_TO_PRE);
        }
    }

    @Override
    public void extend(Parser.Builder parserBuilder) {
        parserBuilder.postProcessorFactory(new AttributesNodePostProcessor.Factory());
        parserBuilder.customInlineParserExtensionFactory(new AttributesInlineParserExtension.Factory());
    }

    @Override
    public void extend(Formatter.Builder builder) {
        builder.nodeFormatterFactory(new AttributesNodeFormatter.Factory());
    }

    @Override
    public void rendererOptions(MutableDataHolder options) {
    }

    @Override
    public void extend(HtmlRenderer.Builder rendererBuilder, String rendererType) {
        if (ASSIGN_TEXT_ATTRIBUTES.getFrom(rendererBuilder).booleanValue()) {
            rendererBuilder.nodeRendererFactory(new AttributesNodeRenderer.Factory());
        }
        rendererBuilder.attributeProviderFactory(new AttributesAttributeProvider.Factory());
    }

    @Override
    public void extend(RendererBuilder rendererBuilder, String rendererType) {
        rendererBuilder.attributeProviderFactory(new AttributesAttributeProvider.Factory());
    }
}

