/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference;

import com.vladsch.flexmark.ext.enumerated.reference.CompoundEnumeratedReferenceRendering;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedOrdinalRenderer;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBase;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRendering;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRepository;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.ArrayList;
import java.util.HashMap;

public class EnumeratedReferences {
    public static final String EMPTY_TYPE = "";
    public static final int[] EMPTY_ORDINALS = new int[0];
    private final EnumeratedReferenceRepository referenceRepository;
    private final HashMap<String, Integer> enumerationCounters;
    private final HashMap<String, int[]> enumeratedReferenceOrdinals;

    public EnumeratedReferences(DataHolder options) {
        this.referenceRepository = EnumeratedReferenceExtension.ENUMERATED_REFERENCES.getFrom(options);
        this.enumerationCounters = new HashMap();
        this.enumeratedReferenceOrdinals = new HashMap();
    }

    public void add(String text) {
        String type = EnumeratedReferenceRepository.getType(text);
        String[] types = type.split(":");
        int[] ordinals = new int[types.length];
        StringBuilder nestedType = new StringBuilder();
        int iMax = types.length;
        for (int i = 0; i < iMax; ++i) {
            int ordinal;
            String typeText = types[i];
            nestedType.append(typeText);
            String nestedTypeKey = nestedType.toString();
            if (i < iMax - 1) {
                Integer ordinalInt = this.enumerationCounters.get(nestedTypeKey);
                int typeOrdinal = ordinalInt == null ? 0 : ordinalInt;
                nestedType.append(':').append(typeOrdinal).append(':');
                ordinals[i] = typeOrdinal;
                continue;
            }
            if (!this.enumerationCounters.containsKey(nestedTypeKey)) {
                this.enumerationCounters.put(nestedTypeKey, 1);
                ordinal = 1;
            } else {
                ordinal = this.enumerationCounters.get(nestedTypeKey) + 1;
                this.enumerationCounters.put(nestedTypeKey, ordinal);
            }
            ordinals[i] = ordinal;
        }
        this.enumeratedReferenceOrdinals.put(text, ordinals);
    }

    @Deprecated
    public int getOrdinal(String text) {
        int[] ordinals = this.enumeratedReferenceOrdinals.get(text);
        return ordinals == null ? 0 : ordinals[ordinals.length - 1];
    }

    @Deprecated
    public Node getFormatNode(String text) {
        String type = EnumeratedReferenceRepository.getType(text);
        return (Node)this.referenceRepository.get(type);
    }

    public EnumeratedReferenceRendering[] getEnumeratedReferenceOrdinals(String text) {
        String type = EnumeratedReferenceRepository.getType(text);
        String[] types = type.split(":");
        EnumeratedReferenceRendering[] renderings = new EnumeratedReferenceRendering[types.length];
        int[] ordinals = this.enumeratedReferenceOrdinals.get(text);
        if (ordinals == null) {
            ordinals = EMPTY_ORDINALS;
        }
        int iMax = types.length;
        for (int i = 0; i < iMax; ++i) {
            String typeText = types[i];
            EnumeratedReferenceBlock referenceFormat = (EnumeratedReferenceBlock)this.referenceRepository.get(typeText);
            int ordinal = i < ordinals.length ? ordinals[i] : 0;
            renderings[i] = new EnumeratedReferenceRendering(referenceFormat, typeText, ordinal);
        }
        return renderings;
    }

    public void renderReferenceOrdinals(String text, EnumeratedOrdinalRenderer renderer) {
        EnumeratedReferenceRendering[] renderings = this.getEnumeratedReferenceOrdinals(text);
        EnumeratedReferences.renderReferenceOrdinals(renderings, renderer);
    }

    public static void renderReferenceOrdinals(EnumeratedReferenceRendering[] renderings, final EnumeratedOrdinalRenderer renderer) {
        renderer.startRendering(renderings);
        final ArrayList<CompoundEnumeratedReferenceRendering> compoundReferences = new ArrayList<CompoundEnumeratedReferenceRendering>();
        EnumeratedReferenceRendering lastRendering = renderings[renderings.length - 1];
        for (EnumeratedReferenceRendering rendering : renderings) {
            int ordinal = rendering.referenceOrdinal;
            String defaultText = rendering.referenceType;
            boolean needSeparator = false;
            if (rendering != lastRendering) {
                if (rendering.referenceFormat != null) {
                    Node lastChild;
                    for (lastChild = rendering.referenceFormat.getLastChild(); lastChild != null && !(lastChild instanceof EnumeratedReferenceBase); lastChild = lastChild.getLastChild()) {
                    }
                    needSeparator = lastChild instanceof EnumeratedReferenceBase && ((EnumeratedReferenceBase)lastChild).getText().isEmpty();
                } else {
                    needSeparator = true;
                }
            }
            compoundReferences.add(new CompoundEnumeratedReferenceRendering(ordinal, rendering.referenceFormat, defaultText, needSeparator));
        }
        final int iMax = compoundReferences.size() - 1;
        Runnable wasRunnable = renderer.getEnumOrdinalRunnable();
        renderer.setEnumOrdinalRunnable(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < iMax; ++i) {
                    CompoundEnumeratedReferenceRendering rendering = (CompoundEnumeratedReferenceRendering)compoundReferences.get(i);
                    Runnable wasRunnable = renderer.getEnumOrdinalRunnable();
                    renderer.setEnumOrdinalRunnable(null);
                    renderer.render(rendering.ordinal, rendering.referenceFormat, rendering.defaultText, rendering.needSeparator);
                    renderer.setEnumOrdinalRunnable(wasRunnable);
                }
            }
        });
        CompoundEnumeratedReferenceRendering rendering = (CompoundEnumeratedReferenceRendering)compoundReferences.get(iMax);
        renderer.render(rendering.ordinal, rendering.referenceFormat, rendering.defaultText, rendering.needSeparator);
        renderer.setEnumOrdinalRunnable(wasRunnable);
        renderer.endRendering();
    }
}

