/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.jekyll.tag.internal;

import com.vladsch.flexmark.ext.jekyll.tag.JekyllTag;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagExtension;
import com.vladsch.flexmark.ext.jekyll.tag.internal.JekyllTagParsing;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.parser.LightInlineParser;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;

public class JekyllTagInlineParserExtension
implements InlineParserExtension {
    private final JekyllTagParsing parsing;
    private final boolean listIncludesOnly;

    public JekyllTagInlineParserExtension(LightInlineParser lightInlineParser) {
        this.parsing = new JekyllTagParsing(lightInlineParser.getParsing());
        this.listIncludesOnly = JekyllTagExtension.LIST_INCLUDES_ONLY.getFrom(lightInlineParser.getDocument());
    }

    @Override
    public void finalizeDocument(InlineParser inlineParser) {
    }

    @Override
    public void finalizeBlock(InlineParser inlineParser) {
    }

    @Override
    public boolean parse(LightInlineParser inlineParser) {
        if (inlineParser.peek(1) == '%' && (inlineParser.peek(2) == ' ' || inlineParser.peek(2) == '\t')) {
            BasedSequence input = inlineParser.getInput();
            Matcher matcher = inlineParser.matcher(this.parsing.MACRO_TAG);
            if (matcher != null) {
                BasedSequence tag = (BasedSequence)input.subSequence(matcher.start(), matcher.end());
                BasedSequence tagName = (BasedSequence)input.subSequence(matcher.start(1), matcher.end(1));
                BasedSequence parameters = (BasedSequence)((BasedSequence)input.subSequence(matcher.end(1), matcher.end() - 2)).trim();
                JekyllTag macro = new JekyllTag((BasedSequence)tag.subSequence(0, 2), tagName, parameters, (BasedSequence)tag.endSequence(2));
                macro.setCharsFromContent();
                if (!this.listIncludesOnly || tagName.equals("include")) {
                    List<JekyllTag> tagList = JekyllTagExtension.TAG_LIST.getFrom(inlineParser.getDocument());
                    tagList.add(macro);
                }
                inlineParser.flushTextNode();
                inlineParser.getBlock().appendChild(macro);
                return true;
            }
        }
        return false;
    }

    public static class Factory
    implements InlineParserExtensionFactory {
        @Override
        public Set<Class<? extends InlineParserExtensionFactory>> getAfterDependents() {
            return null;
        }

        @Override
        public CharSequence getCharacters() {
            return "{";
        }

        @Override
        public Set<Class<? extends InlineParserExtensionFactory>> getBeforeDependents() {
            return null;
        }

        @Override
        public InlineParserExtension apply(LightInlineParser lightInlineParser) {
            return new JekyllTagInlineParserExtension(lightInlineParser);
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

